/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.tiles;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Streams;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.servers.Server;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.gwc.GWC;
import org.geoserver.ogcapi.v1.tiles.TilesTestSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class ApiTest
extends TilesTestSupport {
    @Test
    public void testApiJson() throws Exception {
        MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/tiles/v1/openapi", 200);
        MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.startsWith((String)"application/vnd.oai.openapi+json;version=3.0"));
        String json = response.getContentAsString();
        LOGGER.log(Level.INFO, json);
        ObjectMapper mapper = Json.mapper();
        OpenAPI api = (OpenAPI)mapper.readValue(json, OpenAPI.class);
        this.validateApi(api);
    }

    @Test
    public void testApiHTML() throws Exception {
        MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/tiles/v1/openapi?f=text/html", 200);
        Assert.assertEquals((Object)"text/html", (Object)response.getContentType());
        String html = response.getContentAsString();
        LOGGER.info(html);
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<link rel=\"icon\" type=\"image/png\" href=\"http://localhost:8080/geoserver/swagger-ui/favicon-32x32.png\" sizes=\"32x32\" />"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<link rel=\"icon\" type=\"image/png\" href=\"http://localhost:8080/geoserver/swagger-ui/favicon-16x16.png\" sizes=\"16x16\" />"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<script src=\"http://localhost:8080/geoserver/swagger-ui/swagger-ui-bundle.js\">"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<script src=\"http://localhost:8080/geoserver/swagger-ui/swagger-ui-standalone-preset.js\">"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<script src=\"http://localhost:8080/geoserver/webresources/ogcapi/api.js\">"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<input type=\"hidden\" id=\"apiLocation\" value=\"http://localhost:8080/geoserver/ogc/tiles/v1/openapi?f=application%2Fvnd.oai.openapi%2Bjson%3Bversion%3D3.0\"/>"));
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.not((Matcher)CoreMatchers.containsString((String)"<script>")));
    }

    @Test
    public void testApiYaml() throws Exception {
        String yaml = this.getAsString("ogc/tiles/v1/openapi?f=application/yaml");
        LOGGER.log(Level.INFO, yaml);
        ObjectMapper mapper = Yaml.mapper();
        OpenAPI api = (OpenAPI)mapper.readValue(yaml, OpenAPI.class);
        this.validateApi(api);
    }

    @Test
    public void testYamlAsAcceptsHeader() throws Exception {
        MockHttpServletRequest request = this.createRequest("ogc/tiles/v1/openapi");
        request.setMethod("GET");
        request.setContent(new byte[0]);
        request.addHeader("Accept", (Object)"foo/bar, application/yaml, text/html");
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.startsWith((String)"application/yaml"));
        String yaml = this.string(new ByteArrayInputStream(response.getContentAsString().getBytes()));
        ObjectMapper mapper = Yaml.mapper();
        OpenAPI api = (OpenAPI)mapper.readValue(yaml, OpenAPI.class);
        this.validateApi(api);
    }

    private void validateApi(OpenAPI api) {
        List servers = api.getServers();
        MatcherAssert.assertThat((Object)servers, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((Server)servers.get(0)).getUrl(), (Matcher)CoreMatchers.equalTo((Object)"http://localhost:8080/geoserver/ogc/tiles/v1"));
        Assert.assertEquals((Object)"1.0.0", (Object)api.getInfo().getVersion());
        Paths paths = api.getPaths();
        PathItem landing = (PathItem)paths.get((Object)"/");
        Assert.assertNotNull((Object)landing);
        MatcherAssert.assertThat((Object)landing.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getLandingPage"));
        PathItem conformance = (PathItem)paths.get((Object)"/conformance");
        Assert.assertNotNull((Object)conformance);
        MatcherAssert.assertThat((Object)conformance.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getConformanceClasses"));
        PathItem collections = (PathItem)paths.get((Object)"/collections");
        Assert.assertNotNull((Object)collections);
        MatcherAssert.assertThat((Object)collections.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getCollections"));
        PathItem collection = (PathItem)paths.get((Object)"/collections/{collectionId}");
        Assert.assertNotNull((Object)collection);
        MatcherAssert.assertThat((Object)collection.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"describeCollection"));
        Parameter collectionId = (Parameter)api.getComponents().getParameters().get("collectionId");
        List expectedCollectionIds = Streams.stream((Iterable)((GWC)applicationContext.getBean(GWC.class)).getTileLayers()).map(tl -> tl.getName()).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)collectionId.getSchema().getEnum(), (Matcher)CoreMatchers.equalTo(expectedCollectionIds));
        Parameter mapCollectionId = (Parameter)api.getComponents().getParameters().get("mapCollectionId");
        List<String> expectedMapCollectionIds = ApiTest.getCollectionsForMimeType("image/");
        MatcherAssert.assertThat((Object)mapCollectionId.getSchema().getEnum(), (Matcher)CoreMatchers.equalTo(expectedMapCollectionIds));
        Parameter vectorCollectionId = (Parameter)api.getComponents().getParameters().get("vectorCollectionId");
        List<String> expectedVectorCollectionIds = ApiTest.getCollectionsForMimeType("application/vnd.mapbox-vector");
        MatcherAssert.assertThat((Object)vectorCollectionId.getSchema().getEnum(), (Matcher)CoreMatchers.equalTo(expectedVectorCollectionIds));
    }

    private static List<String> getCollectionsForMimeType(String prefix) {
        return Streams.stream((Iterable)((GWC)applicationContext.getBean(GWC.class)).getTileLayers()).filter(tl -> tl.getMimeTypes().stream().anyMatch(m -> m.getMimeType().startsWith(prefix))).map(tl -> tl.getName()).collect(Collectors.toList());
    }

    @Test
    public void testWorkspaceQualifiedAPI() throws Exception {
        MockHttpServletRequest request = this.createRequest("cdf/ogc/tiles/v1/openapi");
        request.setMethod("GET");
        request.setContent(new byte[0]);
        request.addHeader("Accept", (Object)"foo/bar, application/yaml, text/html");
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/yaml", (Object)response.getContentType());
        String yaml = this.string(new ByteArrayInputStream(response.getContentAsString().getBytes()));
        ObjectMapper mapper = Yaml.mapper();
        OpenAPI api = (OpenAPI)mapper.readValue(yaml, OpenAPI.class);
        Map params = api.getComponents().getParameters();
        Parameter collectionId = (Parameter)params.get("collectionId");
        List collectionIdValues = collectionId.getSchema().getEnum();
        MatcherAssert.assertThat((Object)collectionIdValues, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Other", "Inserts", "Nulls", "Fifteen", "Locks", "Seven", "Updates", "Deletes"}));
    }
}

