/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.tiles;

import com.google.common.collect.Streams;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.JsonContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ogcapi.APIDispatcher;
import org.geoserver.ogcapi.v1.tiles.TiledCollectionDocument;
import org.geoserver.ogcapi.v1.tiles.TilesTestSupport;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geowebcache.layer.TileLayer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletResponse;

public class CollectionsTest
extends TilesTestSupport {
    public static final String BASIC_POLYGONS_TITLE = "Basic polygons";
    public static final String BASIC_POLYGONS_DESCRIPTION = "I love basic polygons!";

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        FeatureTypeInfo basicPolygons = this.getCatalog().getFeatureTypeByName(this.getLayerId(MockData.BASIC_POLYGONS));
        basicPolygons.setTitle(BASIC_POLYGONS_TITLE);
        basicPolygons.setAbstract(BASIC_POLYGONS_DESCRIPTION);
        this.getCatalog().save((ResourceInfo)basicPolygons);
    }

    @Test
    public void testCollectionsJson() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/tiles/v1/collections", 200);
        this.testCollectionsJson(json, MediaType.APPLICATION_JSON);
    }

    private void testCollectionsJson(DocumentContext json, MediaType defaultFormat) throws Exception {
        int expected = this.getGWC().getTileLayerNames().size();
        Assert.assertEquals((long)expected, (long)((Integer)json.read("collections.length()", Integer.class, new Predicate[0])).intValue());
        List formats = ((APIDispatcher)GeoServerExtensions.bean(APIDispatcher.class, (ApplicationContext)applicationContext)).getProducibleMediaTypes(TiledCollectionDocument.class, true);
        MatcherAssert.assertThat((Object)formats.size(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)((Integer)json.read("collections[0].links.length()", Integer.class, new Predicate[0]))));
        for (MediaType format : formats) {
            List items = (List)json.read("collections[0].links[?(@.type=='" + format + "')]", List.class, new Predicate[0]);
            Map item = (Map)items.get(0);
            if (defaultFormat.equals((Object)format)) {
                Assert.assertEquals((Object)"self", item.get("rel"));
                continue;
            }
            Assert.assertEquals((Object)"alternate", item.get("rel"));
        }
    }

    @Test
    public void testCollectionsWorkspaceSpecificJson() throws Exception {
        DocumentContext json = this.getAsJSONPath("cdf/ogc/tiles/v1/collections", 200);
        long expected = Streams.stream((Iterable)this.getGWC().getTileLayers()).filter(tl -> tl.getName().startsWith("cdf:")).count();
        Assert.assertEquals((long)expected, (long)((Integer)json.read("collections.length()", Integer.class, new Predicate[0])).intValue());
        MatcherAssert.assertThat((Object)((Collection)json.read("collections[?(@.id=='Deletes')]", new Predicate[0])), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)((Collection)json.read("collections[?(@.id=='cdf__Deletes')]", new Predicate[0])), (Matcher)Matchers.empty());
        String deleteHrefPath = "collections[?(@.id=='Deletes')].links[?(@.rel=='self' && @.type=='application/json')].href";
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/cdf/ogc/tiles/v1/collections/Deletes?f=application%2Fjson", (Object)((JSONArray)json.read("collections[?(@.id=='Deletes')].links[?(@.rel=='self' && @.type=='application/json')].href", new Predicate[0])).get(0));
    }

    @Test
    @Ignore
    public void testCollectionsXML() throws Exception {
        org.w3c.dom.Document dom = this.getAsDOM("ogc/tiles/v1/collections?f=application/xml");
        this.print(dom);
    }

    @Test
    public void testCollectionsYaml() throws Exception {
        String yaml = this.getAsString("ogc/tiles/v1/collections/?f=application/yaml");
        JsonContext json = this.convertYamlToJsonPath(yaml);
        this.testCollectionsJson((DocumentContext)json, MediaType.parseMediaType((String)"application/yaml"));
    }

    @Test
    public void testCollectionsHTML() throws Exception {
        Document document = this.getAsJSoup("ogc/tiles/v1/collections?f=html");
        for (TileLayer tl : this.getGWC().getTileLayers()) {
            String htmlId = tl.getName().replace(":", "__");
            Assert.assertNotNull((Object)document.select("#html_" + htmlId + "_link"));
            Assert.assertEquals((Object)("http://localhost:8080/geoserver/ogc/tiles/v1/collections/" + ResponseUtils.urlEncode((String)tl.getName(), (char[])new char[0]) + "?f=text%2Fhtml"), (Object)document.select("#html_" + htmlId + "_link").attr("href"));
        }
        FeatureTypeInfo basicPolygons = this.getCatalog().getFeatureTypeByName(this.getLayerId(MockData.BASIC_POLYGONS));
        String basicPolygonsName = basicPolygons.prefixedName().replace(":", "__");
        Assert.assertEquals((Object)BASIC_POLYGONS_TITLE, (Object)document.select("#" + basicPolygonsName + "_title").text());
        Assert.assertEquals((Object)BASIC_POLYGONS_DESCRIPTION, (Object)document.select("#" + basicPolygonsName + "_description").text());
    }

    @Test
    public void testVersionHeader() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("ogc/tiles/v1/collections/?f=application/yaml");
        Assert.assertTrue((boolean)this.headerHasValue(response, "API-Version", "1.0.0"));
    }
}

