/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.tiles;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import org.geoserver.ogcapi.v1.tiles.TilesTestSupport;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Test;

public class ConformanceTest
extends TilesTestSupport {
    @Test
    public void testConformanceJson() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/tiles/v1/conformance", 200);
        this.checkConformance(json);
    }

    private void checkConformance(DocumentContext json) {
        Assert.assertEquals((long)2L, (long)((Integer)json.read("$.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)11L, (long)((Integer)json.read("$.conformsTo.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-common-1/1.0/conf/core", (Object)json.read("$.conformsTo[0]", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-common-2/1.0/conf/collections", (Object)json.read("$.conformsTo[1]", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-tiles-1/1.0/conf/core", (Object)json.read("$.conformsTo[2]", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-tiles-1/1.0/conf/tileset", (Object)json.read("$.conformsTo[3]", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-tiles-1/1.0/conf/tilesets", (Object)json.read("$.conformsTo[4]", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-tiles-1/1.0/conf/tilesets-list", (Object)json.read("$.conformsTo[5]", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-tiles-1/1.0/conf/geodata-tilesets", (Object)json.read("$.conformsTo[6]", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-tiles-1/1.0/conf/info", (Object)json.read("$.conformsTo[7]", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-tiles-1/1.0/conf/tmxs", (Object)json.read("$.conformsTo[8]", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"http://www.opengis.net/spec/tilematrixset/1.0/conf/tilematrixset", (Object)json.read("$.conformsTo[9]", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"http://www.opengis.net/spec/tilematrixset/1.0/conf/json-tilematrixset", (Object)json.read("$.conformsTo[10]", String.class, new Predicate[0]));
    }

    @Test
    public void testCollectionsYaml() throws Exception {
        String yaml = this.getAsString("ogc/tiles/v1/conformance/?f=application/yaml");
        this.checkConformance((DocumentContext)this.convertYamlToJsonPath(yaml));
    }

    @Test
    public void testConformanceHTML() throws Exception {
        Document document = this.getAsJSoup("ogc/tiles/v1/conformance?f=text/html");
        Assert.assertEquals((Object)"GeoServer OGC API Tiles Conformance", (Object)document.select("#title").text());
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-common-1/1.0/conf/core", (Object)document.select("#content li:eq(0)").text());
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-common-2/1.0/conf/collections", (Object)document.select("#content li:eq(1)").text());
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-tiles-1/1.0/conf/core", (Object)document.select("#content li:eq(2)").text());
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-tiles-1/1.0/conf/tileset", (Object)document.select("#content li:eq(3)").text());
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-tiles-1/1.0/conf/info", (Object)document.select("#content li:eq(7)").text());
    }
}

