/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.tiles;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import org.geoserver.data.test.MockData;
import org.geoserver.ogcapi.v1.tiles.TilesTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class GetStylesTest
extends TilesTestSupport {
    @Test
    public void testMapLinks() throws Exception {
        String lakesId = this.getLayerId(MockData.LAKES);
        DocumentContext json = this.getAsJSONPath("ogc/tiles/v1/collections/" + lakesId + "/styles", 200);
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/tiles/v1/collections/cite:Lakes/styles/map/tiles?f=application%2Fjson", (Object)this.readSingle(json, "styles[0].links[?(@.rel=='http://www.opengis.net/def/rel/ogc/1.0/tilesets-map' && @.type=='application/json')].href"));
    }

    @Test
    public void testOnlyDataLinks() throws Exception {
        String forestsId = this.getLayerId(MockData.FORESTS);
        DocumentContext json = this.getAsJSONPath("ogc/tiles/v1/collections/" + forestsId + "/styles", 200);
        Assert.assertEquals((long)0L, (long)((List)json.read("styles[*].links[?(@.rel=='http://www.opengis.net/def/rel/ogc/1.0/tilesets-map')]", List.class, new Predicate[0])).size());
    }
}

