/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.tiles;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import no.ecc.vectortile.VectorTileDecoder;
import org.apache.commons.io.FileUtils;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ogcapi.v1.tiles.TilesTestSupport;
import org.geotools.image.test.ImageAssert;
import org.geowebcache.mime.ApplicationMime;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class GetTileTest
extends TilesTestSupport {
    @Before
    public void cleanup() throws Exception {
        SystemTestData testData = (SystemTestData)this.getTestData();
        for (File f : new File(testData.getDataDirectoryRoot(), "gwc").listFiles()) {
            if (!f.isDirectory()) continue;
            FileUtils.deleteQuietly((File)f);
        }
    }

    @Test
    public void testPngIntegration() throws Exception {
        String layerId = this.getLayerId(MockData.BASIC_POLYGONS);
        MockHttpServletResponse sr = this.getAsServletResponse("ogc/tiles/v1/collections/" + layerId + "/styles/BasicPolygons/map/tiles/EPSG:4326/EPSG:4326:0/0/0?f=image%2Fpng");
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)sr.getContentType());
        Assert.assertEquals((String)"Content-disposition", (Object)"inline; filename=\"BasicPolygons_0_0_0.png\"", (Object)sr.getHeader("Content-disposition"));
        this.checkRootTileHeaders(sr, "cite:BasicPolygons");
    }

    public void checkRootTileHeaders(MockHttpServletResponse sr, String layerName) throws IOException {
        Assert.assertEquals((Object)"EPSG:4326", (Object)sr.getHeader("geowebcache-gridset"));
        Assert.assertEquals((Object)"EPSG:4326", (Object)sr.getHeader("geowebcache-crs"));
        Assert.assertEquals((Object)"[0, 0, 0]", (Object)sr.getHeader("geowebcache-tile-index"));
        Assert.assertEquals((Object)"-180.0,-90.0,0.0,90.0", (Object)sr.getHeader("geowebcache-tile-bounds"));
        Assert.assertEquals((Object)layerName, (Object)sr.getHeader("geowebcache-layer"));
        Assert.assertEquals((Object)"MISS", (Object)sr.getHeader("geowebcache-cache-result"));
        Assert.assertEquals((Object)"no-cache, no-store, must-revalidate", (Object)sr.getHeader("Cache-Control"));
        Assert.assertNotNull((Object)sr.getHeader("ETag"));
        Assert.assertNotNull((Object)sr.getHeader("Last-Modified"));
        this.assertValidPNGResponse(sr);
    }

    @Test
    public void testPngIntegrationWorkspaceSpecific() throws Exception {
        String layerId = MockData.BASIC_POLYGONS.getLocalPart();
        MockHttpServletResponse sr = this.getAsServletResponse(MockData.BASIC_POLYGONS.getPrefix() + "/ogc/tiles/v1/collections/" + layerId + "/map/tiles/EPSG:4326/EPSG:4326:0/0/0?f=image%2Fpng");
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)sr.getContentType());
        this.checkRootTileHeaders(sr, "BasicPolygons");
    }

    @Test
    public void testPngMissHit() throws Exception {
        String layerId = this.getLayerId(MockData.BASIC_POLYGONS);
        String path = "ogc/tiles/v1/collections/" + layerId + "/styles/BasicPolygons/map/tiles/EPSG:4326/EPSG:4326:0/0/0?f=image%2Fpng";
        MockHttpServletResponse sr1 = this.getAsServletResponse(path);
        Assert.assertEquals((long)200L, (long)sr1.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)sr1.getContentType());
        Assert.assertEquals((Object)"MISS", (Object)sr1.getHeader("geowebcache-cache-result"));
        this.assertValidPNGResponse(sr1);
        MockHttpServletResponse sr2 = this.getAsServletResponse(path);
        Assert.assertEquals((long)200L, (long)sr2.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)sr2.getContentType());
        Assert.assertEquals((Object)"HIT", (Object)sr2.getHeader("geowebcache-cache-result"));
        this.assertValidPNGResponse(sr2);
    }

    @Test
    public void testEtagIfNoneMatch() throws Exception {
        String layerId = this.getLayerId(MockData.BASIC_POLYGONS);
        String path = "ogc/tiles/v1/collections/" + layerId + "/styles/BasicPolygons/map/tiles/EPSG:4326/EPSG:4326:0/0/0?f=image%2Fpng";
        MockHttpServletResponse sr1 = this.getAsServletResponse(path);
        Assert.assertEquals((long)200L, (long)sr1.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)sr1.getContentType());
        Assert.assertEquals((Object)"MISS", (Object)sr1.getHeader("geowebcache-cache-result"));
        this.assertValidPNGResponse(sr1);
        String eTag = sr1.getHeader("ETag");
        Assert.assertNotNull((Object)eTag);
        MockHttpServletRequest request = this.createRequest(path);
        request.setMethod("GET");
        request.addHeader("If-None-Match", (Object)eTag);
        MockHttpServletResponse sr2 = this.dispatch((HttpServletRequest)request);
        Assert.assertEquals((long)HttpStatus.NOT_MODIFIED.value(), (long)sr2.getStatus());
    }

    public void assertValidPNGResponse(MockHttpServletResponse sr) throws IOException {
        BufferedImage tile = ImageIO.read(new ByteArrayInputStream(sr.getContentAsByteArray()));
        Assert.assertNotNull((Object)tile);
    }

    @Test
    public void testPngOnRawTilesIntegration() throws Exception {
        String layerId = this.getLayerId(MockData.BASIC_POLYGONS);
        MockHttpServletResponse sr = this.getAsServletResponse("ogc/tiles/v1/collections/" + layerId + "/tiles/EPSG:4326/EPSG:4326:0/0/0?f=image%2Fpng");
        Assert.assertEquals((long)400L, (long)sr.getStatus());
    }

    @Test
    public void testMapxboNotEnabled() throws Exception {
        String layerId = this.getLayerId(MockData.BASIC_POLYGONS);
        MockHttpServletResponse sr = this.getAsServletResponse("ogc/tiles/v1/collections/" + layerId + "/tiles/EPSG:4326/EPSG:4326:0/0/0?f=application/vnd.mapbox-vector-tile");
        Assert.assertEquals((long)400L, (long)sr.getStatus());
    }

    @Test
    public void testMapboxTile() throws Exception {
        String layerId = this.getLayerId(MockData.ROAD_SEGMENTS);
        MockHttpServletResponse sr = this.getAsServletResponse("ogc/tiles/v1/collections/" + layerId + "/tiles/EPSG:900913/EPSG:900913:10/511/512?f=application/vnd.mapbox-vector-tile");
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)"application/vnd.mapbox-vector-tile", (Object)sr.getContentType());
        this.checkGwcHeaders(layerId, sr);
        VectorTileDecoder.FeatureIterable features = new VectorTileDecoder().decode(sr.getContentAsByteArray());
        Assert.assertEquals((long)5L, (long)features.asList().size());
    }

    @Test
    public void testJsonTile() throws Exception {
        String layerId = this.getLayerId(MockData.ROAD_SEGMENTS);
        MockHttpServletResponse sr = this.getAsServletResponse("ogc/tiles/v1/collections/" + layerId + "/tiles/EPSG:900913/EPSG:900913:10/511/512?f=" + ApplicationMime.geojson.getFormat());
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)ApplicationMime.json.getFormat(), (Object)sr.getContentType());
        this.checkGwcHeaders(layerId, sr);
        DocumentContext json = this.getAsJSONPath(sr);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.read("type", new Predicate[0]));
    }

    @Test
    public void testPng8Tile() throws Exception {
        String layerId = this.getLayerId(MockData.ROAD_SEGMENTS);
        MockHttpServletResponse sr = this.getAsServletResponse("ogc/tiles/v1/collections/" + layerId + "/styles/RoadSegments/map/tiles/EPSG:900913/EPSG:900913:15/16383/16384?f=image/png8");
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)sr.getContentType());
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(sr.getContentAsByteArray()));
        this.assertNotBlank("testPng8Tile", image, null);
        File expectedFile = new File("src/test/resources/org/geoserver/ogcapi/v1/tiles/rs_full.png");
        ImageAssert.assertEquals((File)expectedFile, (RenderedImage)image, (int)100);
    }

    @Test
    public void testCacheableFilteredPNGTile() throws Exception {
        String layerId = this.getLayerId(MockData.ROAD_SEGMENTS);
        String request = "ogc/tiles/v1/collections/" + layerId + "/map/tiles/EPSG:900913/EPSG:900913:15/16383/16384?f=image/png&filter=NAME='Route 5'&filter-lang=cql-text";
        MockHttpServletResponse sr = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)sr.getContentType());
        Assert.assertEquals((Object)"MISS", (Object)sr.getHeader("geowebcache-cache-result"));
        Assert.assertNull((Object)sr.getHeader("geowebcache-miss-reason"));
        sr = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)sr.getContentType());
        Assert.assertEquals((Object)"HIT", (Object)sr.getHeader("geowebcache-cache-result"));
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(sr.getContentAsByteArray()));
        this.assertNotBlank("testPng8Tile", image, null);
        File expectedFile = new File("src/test/resources/org/geoserver/ogcapi/v1/tiles/rs_filtered.png");
        ImageAssert.assertEquals((File)expectedFile, (RenderedImage)image, (int)100);
    }

    @Test
    public void testNonCacheableFilteredPNGTile() throws Exception {
        String layerId = this.getLayerId(MockData.STREAMS);
        String request = "ogc/tiles/v1/collections/" + layerId + "/map/tiles/EPSG:900913/EPSG:900913:15/16384/16384?f=image/png";
        BufferedImage fullImage = this.getAsImage(request, "image/png");
        File expectedFile = new File("src/test/resources/org/geoserver/ogcapi/v1/tiles/streams_full.png");
        ImageAssert.assertEquals((File)expectedFile, (RenderedImage)fullImage, (int)100);
        MockHttpServletResponse resp = this.getAsServletResponse(request + "&filter=NAME='Cam Stream'&filter-lang=cql-text");
        Assert.assertEquals((Object)"image/png", (Object)resp.getContentType());
        Assert.assertEquals((Object)"MISS", (Object)resp.getHeader("geowebcache-cache-result"));
        Assert.assertEquals((Object)"CQL_FILTER filter parameter not cached or not condition not matched", (Object)resp.getHeader("geowebcache-miss-reason"));
        try (ByteArrayInputStream is = this.getBinaryInputStream(resp);){
            BufferedImage filteredImage = ImageIO.read(is);
            File expectedFilteredFile = new File("src/test/resources/org/geoserver/ogcapi/v1/tiles/streams_filterd.png");
            ImageAssert.assertEquals((File)expectedFilteredFile, (RenderedImage)filteredImage, (int)100);
        }
    }

    @Test
    public void testEmtpyMVTTile() throws Exception {
        String request = "wms?service=WMS&version=1.1.0&request=GetMap&layers=" + this.getLayerId(MockData.ROAD_SEGMENTS) + "&styles=&bbox=-1,-1,1,1&width=768&height=330&srs=EPSG:4326&CQL_FILTER=1=0&format=application/vnd.mapbox-vector-tile";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/vnd.mapbox-vector-tile", (Object)response.getContentType());
        byte[] responseBytes = response.getContentAsByteArray();
        VectorTileDecoder decoder = new VectorTileDecoder();
        List featuresList = decoder.decode(responseBytes).asList();
        Assert.assertEquals((long)0L, (long)featuresList.size());
        String layerId = this.getLayerId(MockData.ROAD_SEGMENTS);
        MockHttpServletResponse sr = this.getAsServletResponse("ogc/tiles/v1/collections/" + layerId + "/tiles/EPSG:900913/EPSG:900913:10/511/512?f=application/vnd.mapbox-vector-tile&filter=1=0&filter-lang=cql-text");
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)"application/vnd.mapbox-vector-tile", (Object)sr.getContentType());
        this.checkGwcHeaders(layerId, sr);
        VectorTileDecoder.FeatureIterable features = new VectorTileDecoder().decode(sr.getContentAsByteArray());
        Assert.assertEquals((long)0L, (long)features.asList().size());
    }

    public void checkGwcHeaders(String layerId, MockHttpServletResponse sr) {
        Assert.assertEquals((Object)"EPSG:900913", (Object)sr.getHeader("geowebcache-gridset"));
        Assert.assertEquals((Object)"EPSG:900913", (Object)sr.getHeader("geowebcache-crs"));
        Assert.assertEquals((Object)"[512, 512, 10]", (Object)sr.getHeader("geowebcache-tile-index"));
        Assert.assertEquals((Object)"0.0,0.0,39135.7584765628,39135.7584765628", (Object)sr.getHeader("geowebcache-tile-bounds"));
        Assert.assertEquals((Object)layerId, (Object)sr.getHeader("geowebcache-layer"));
        Assert.assertEquals((Object)"no-cache, no-store, must-revalidate", (Object)sr.getHeader("Cache-Control"));
        Assert.assertNotNull((Object)sr.getHeader("ETag"));
        Assert.assertNotNull((Object)sr.getHeader("Last-Modified"));
    }

    @Test
    public void testTileOutOfRange() throws Exception {
        String layerId = this.getLayerId(MockData.ROAD_SEGMENTS);
        MockHttpServletResponse sr = this.getAsServletResponse("ogc/tiles/v1/collections/" + layerId + "/tiles/EPSG:900913/EPSG:900913:10/0/0?f=application/vnd.mapbox-vector-tile");
        Assert.assertEquals((long)404L, (long)sr.getStatus());
    }

    @Test
    public void testNatureGroupMVT() throws Exception {
        MockHttpServletResponse sr = this.getAsServletResponse("ogc/tiles/v1/collections/nature/tiles/EPSG:900913/EPSG:900913:10/511/512?f=application/vnd.mapbox-vector-tile");
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)"application/vnd.mapbox-vector-tile", (Object)sr.getContentType());
        this.checkGwcHeaders("nature", sr);
        VectorTileDecoder.FeatureIterable features = new VectorTileDecoder().decode(sr.getContentAsByteArray());
        MatcherAssert.assertThat((Object)features.getLayerNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Lakes", "Forests"}));
        Assert.assertEquals((long)2L, (long)features.asList().size());
    }

    @Test
    public void testNatureGroupPNG() throws Exception {
        BufferedImage image = this.getAsImage("ogc/tiles/v1/collections/nature/map/tiles/EPSG:900913/EPSG:900913:16/32768/32768?f=image/png", "image/png");
        File expected = new File("src/test/resources/org/geoserver/ogcapi/v1/tiles/nature_tile_16.png");
        ImageAssert.assertEquals((File)expected, (RenderedImage)image, (int)120);
    }

    @Test
    public void testStyleGroupMVT() throws Exception {
        MockHttpServletResponse sr = this.getAsServletResponse("ogc/tiles/v1/collections/BasicStyleGroup/tiles/EPSG:900913/EPSG:900913:10/511/512?f=application/vnd.mapbox-vector-tile");
        Assert.assertEquals((long)200L, (long)sr.getStatus());
        Assert.assertEquals((Object)"application/vnd.mapbox-vector-tile", (Object)sr.getContentType());
        this.checkGwcHeaders("BasicStyleGroup", sr);
        VectorTileDecoder.FeatureIterable features = new VectorTileDecoder().decode(sr.getContentAsByteArray());
        MatcherAssert.assertThat((Object)features.getLayerNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"BasicPolygons", "Lakes"}));
        Assert.assertEquals((long)2L, (long)features.asList().size());
    }

    @Test
    public void testStyleGroupPNG() throws Exception {
        BufferedImage image = this.getAsImage("ogc/tiles/v1/collections/BasicStyleGroup/styles/BasicStyleGroupStyle/map/tiles/EPSG:900913/EPSG:900913:16/32768/32768?f=image/png", "image/png");
        File expected = new File("src/test/resources/org/geoserver/ogcapi/v1/tiles/styleGrup_tile_16.png");
        ImageAssert.assertEquals((File)expected, (RenderedImage)image, (int)100);
    }

    @Test
    public void testStyleGroupInvalidStyleName() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/tiles/v1/collections/BasicStyleGroup/styles/_/map/tiles/EPSG:900913/EPSG:900913:16/32768/32768?f=image/png", 400);
        Assert.assertEquals((Object)"InvalidParameterValue", (Object)json.read("type", new Predicate[0]));
        MatcherAssert.assertThat((Object)((String)json.read("title", new Predicate[0])), (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)"Invalid style name"), CoreMatchers.containsString((String)"BasicStyleGroupStyle")}));
    }
}

