/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.tiles;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import org.geoserver.data.test.MockData;
import org.geoserver.ogcapi.v1.tiles.TilesTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class QueryablesTest
extends TilesTestSupport {
    @Test
    public void queryablesOnCoverage() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/tiles/v1/collections/" + this.getLayerId(MockData.TASMANIA_BM) + "/queryables", 404);
        Assert.assertEquals((Object)"Collection 'wcs:BlueMarble' cannot be filtered, no queryables available", (Object)json.read("title", new Predicate[0]));
    }

    @Test
    public void queryablesOnGroup() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/tiles/v1/collections/nature/queryables", 404);
        Assert.assertEquals((Object)"Collection 'nature' cannot be filtered, no queryables available", (Object)json.read("title", new Predicate[0]));
    }

    @Test
    public void queryablesOnRoadSegments() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/tiles/v1/collections/" + this.getLayerId(MockData.ROAD_SEGMENTS) + "/queryables", 200);
        Assert.assertEquals((Object)"geometry-multilinestring", (Object)json.read("properties.the_geom.format", new Predicate[0]));
        Assert.assertEquals((Object)"string", (Object)json.read("properties.FID.type", new Predicate[0]));
        Assert.assertEquals((Object)"string", (Object)json.read("properties.NAME.type", new Predicate[0]));
    }
}

