/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.tiles;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.ogcapi.APIException;
import org.geoserver.ogcapi.AbstractCollectionDocument;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.CollectionExtents;
import org.geoserver.ogcapi.LinksBuilder;
import org.geoserver.ogcapi.Queryables;
import org.geoserver.ogcapi.StyleDocument;
import org.geoserver.ogcapi.v1.tiles.StylesDocument;
import org.geoserver.ogcapi.v1.tiles.TilesDocument;
import org.geoserver.ogcapi.v1.tiles.TilesService;
import org.geoserver.wms.WMS;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.TileLayer;
import org.springframework.http.HttpStatus;

@JsonPropertyOrder(value={"id", "title", "description", "extent", "links", "styles"})
public class TiledCollectionDocument
extends AbstractCollectionDocument<TileLayer> {
    static final Logger LOGGER = Logging.getLogger(TiledCollectionDocument.class);
    public static final String REL_TILESETS_MAP = "http://www.opengis.net/def/rel/ogc/1.0/tilesets-map";
    public static final String REL_TILESETS_VECTOR = "http://www.opengis.net/def/rel/ogc/1.0/tilesets-vector";
    WMS wms;
    TileLayer layer;
    List<StyleDocument> styles = new ArrayList<StyleDocument>();
    boolean dataTiles;
    boolean mapTiles;
    boolean queryable;

    public TiledCollectionDocument(WMS wms, TileLayer tileLayer, boolean summary) throws FactoryException, TransformException {
        super((Object)tileLayer);
        this.layer = tileLayer;
        String string = this.id = tileLayer instanceof GeoServerTileLayer ? ((GeoServerTileLayer)tileLayer).getContextualName() : tileLayer.getName();
        if (tileLayer instanceof GeoServerTileLayer) {
            PublishedInfo published = ((GeoServerTileLayer)tileLayer).getPublishedInfo();
            this.setTitle(published.getTitle());
            this.setDescription(published.getAbstract());
            this.extent = this.getExtentsFromPublished(published);
        } else {
            this.extent = this.getExtentFromGridsets(tileLayer);
        }
        this.addSelfLinks("ogc/tiles/v1/collections/" + this.id);
        List tileTypes = tileLayer.getMimeTypes();
        this.dataTiles = tileTypes.stream().anyMatch(mt -> mt.isVector());
        if (this.dataTiles) {
            new LinksBuilder(TilesDocument.class, "ogc/tiles/v1/collections/").segment(this.id, true).segment("tiles").title("Tiles metadata as ").rel(REL_TILESETS_VECTOR).classification("tilesets-vector").add((AbstractDocument)this);
        }
        this.mapTiles = tileTypes.stream().anyMatch(mt -> !mt.isVector());
        if (this.mapTiles) {
            new LinksBuilder(TilesDocument.class, "ogc/tiles/v1/collections/").segment(this.id, true).segment("map/tiles").title("Map tiles metadata as ").rel(REL_TILESETS_MAP).classification("tilesets-maps").add((AbstractDocument)this);
        }
        if (!summary) {
            new LinksBuilder(StylesDocument.class, "ogc/tiles/v1/collections/").segment(this.id, true).segment("/styles").title("Styles for this layer as ").rel("styles").add((AbstractDocument)this);
            if (tileLayer instanceof GeoServerTileLayer) {
                PublishedInfo published = ((GeoServerTileLayer)tileLayer).getPublishedInfo();
                if (published instanceof LayerInfo) {
                    LayerInfo layerInfo = (LayerInfo)published;
                    LinkedHashSet<StyleInfo> stylesInfo = new LinkedHashSet<StyleInfo>(Arrays.asList(layerInfo.getDefaultStyle()));
                    stylesInfo.addAll(layerInfo.getStyles());
                    stylesInfo.forEach(style -> this.styles.add(new StyleDocument(style)));
                } else {
                    LayerGroupInfo group = (LayerGroupInfo)published;
                    if (group != null && TilesService.isStyleGroup(group)) {
                        StyleDocument styleDocument = new StyleDocument((StyleInfo)group.getStyles().get(0));
                        this.styles.add(styleDocument);
                    } else {
                        this.styles.add(new StyleDocument("_", "The layer default style"));
                    }
                }
            } else {
                String style2 = tileLayer.getStyles();
                if (style2 != null) {
                    this.styles.add(new StyleDocument(style2, "The layer default style"));
                } else {
                    this.styles.add(new StyleDocument("_", "The layer default style"));
                }
            }
            if (TilesService.supportsFiltering(tileLayer)) {
                this.queryable = true;
                new LinksBuilder(Queryables.class, "ogc/tiles/v1/collections/").segment(this.id, true).segment("/queryables").title("Collection queryables as ").rel("queryables").add((AbstractDocument)this);
            }
        }
    }

    private CollectionExtents getExtentFromGridsets(TileLayer tileLayer) throws FactoryException, TransformException {
        Set srsSet = this.layer.getGridSubsets().stream().map(gs -> tileLayer.getGridSubset(gs).getSRS().toString()).collect(Collectors.toSet());
        if (srsSet.isEmpty()) {
            throw new APIException("NoApplicableCode", "Could not compute the extent for layer " + tileLayer.getName() + ", no gridsets are configured", HttpStatus.INTERNAL_SERVER_ERROR);
        }
        if (srsSet.contains("EPSG:4326")) {
            GridSubset subset = this.layer.getGridSubsetForSRS(SRS.getEPSG4326());
            return this.getExtentsFromGridSubset(subset);
        }
        String srs = (String)srsSet.iterator().next();
        try {
            GridSubset subset = this.layer.getGridSubsetForSRS(SRS.getSRS((String)srs));
            return this.getExtentsFromGridSubset(subset);
        }
        catch (GeoWebCacheException ex) {
            throw new APIException("NoApplicableCode", "Could not convert " + srs + " value: " + ex.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private CollectionExtents getExtentsFromGridSubset(GridSubset subset) throws FactoryException, TransformException {
        BoundingBox bbox = subset.getOriginalExtent();
        ReferencedEnvelope re = new ReferencedEnvelope(bbox.getMinX(), bbox.getMaxX(), bbox.getMinY(), bbox.getMaxY(), CRS.decode((String)subset.getSRS().toString(), (boolean)true));
        if (!CRS.equalsIgnoreMetadata((Object)re.getCoordinateReferenceSystem(), (Object)DefaultGeographicCRS.WGS84)) {
            re = re.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
        }
        return new CollectionExtents(re);
    }

    private CollectionExtents getExtentsFromPublished(PublishedInfo published) {
        try {
            ReferencedEnvelope bbox = null;
            if (published instanceof LayerInfo) {
                bbox = ((LayerInfo)published).getResource().getLatLonBoundingBox();
            } else if (published instanceof LayerGroupInfo && !CRS.equalsIgnoreMetadata((Object)(bbox = ((LayerGroupInfo)published).getBounds()), (Object)DefaultGeographicCRS.WGS84)) {
                bbox = bbox.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
            }
            if (bbox != null) {
                return new CollectionExtents(bbox);
            }
        }
        catch (FactoryException | TransformException e) {
            throw new APIException("InternalError", "Failed to reproject native bounds to WGS84", HttpStatus.INTERNAL_SERVER_ERROR, e);
        }
        return null;
    }

    public List<StyleDocument> getStyles() {
        return this.styles;
    }

    public boolean isDataTiles() {
        return this.dataTiles;
    }

    public boolean isMapTiles() {
        return this.mapTiles;
    }

    @JsonIgnore
    public boolean isQueryable() {
        return this.queryable;
    }
}

