/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.tiles;

import com.google.common.base.Predicates;
import com.google.common.collect.Streams;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.catalog.PublishedType;
import org.geoserver.config.ServiceInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.ogcapi.OpenAPIBuilder;
import org.geoserver.ogcapi.v1.tiles.TiledCollectionsDocument;
import org.geoserver.ogcapi.v1.tiles.TilesService;
import org.geoserver.ogcapi.v1.tiles.TilesServiceInfo;
import org.geotools.util.logging.Logging;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;

public class TilesAPIBuilder
extends OpenAPIBuilder<TilesServiceInfo> {
    private static final Logger LOGGER = Logging.getLogger(TilesAPIBuilder.class);
    private final GWC gwc;

    public TilesAPIBuilder(GWC gwc) {
        super(TilesServiceInfo.class, "openapi.yaml", "Tiles API", TilesService.class);
        this.gwc = gwc;
    }

    public OpenAPI build(TilesServiceInfo service) throws IOException {
        OpenAPI api = super.build((ServiceInfo)service);
        this.declareGetResponseFormats(api, "/collections", TiledCollectionsDocument.class);
        this.declareGetResponseFormats(api, "/collections/{collectionId}", TiledCollectionsDocument.class);
        api.externalDocs(new ExternalDocumentation().description("Tiles specification").url("https://ogcapi.ogc.org/tiles/"));
        Set formats = Arrays.stream(PublishedType.values()).map(t -> GWC.getAdvertisedCachedFormats((PublishedType)t)).flatMap(Collection::stream).collect(Collectors.toSet());
        Set<String> rasterFormats = formats.stream().filter(f -> TilesAPIBuilder.isRasterFormat(f)).collect(Collectors.toSet());
        Set<String> vectorFormats = formats.stream().filter(f -> TilesAPIBuilder.isVectorFormat(f)).collect(Collectors.toSet());
        Map parameters = api.getComponents().getParameters();
        Parameter mapTileFormats = (Parameter)parameters.get("f-map-tile");
        List mapTileFormatsEnum = mapTileFormats.getSchema().getEnum();
        mapTileFormatsEnum.clear();
        mapTileFormatsEnum.addAll(rasterFormats);
        Parameter vectorTileFormats = (Parameter)parameters.get("f-vector-tile");
        List vectorTileFormatsEnum = vectorTileFormats.getSchema().getEnum();
        vectorTileFormatsEnum.clear();
        vectorTileFormatsEnum.addAll(vectorFormats);
        ((Parameter)parameters.get("collectionId")).getSchema().setEnum(this.getCollectionIds((Predicate<TileLayer>)Predicates.alwaysTrue()));
        ((Parameter)parameters.get("mapCollectionId")).getSchema().setEnum(this.getCollectionIds(TilesAPIBuilder.getPredicateForFormats(rasterFormats)));
        ((Parameter)parameters.get("vectorCollectionId")).getSchema().setEnum(this.getCollectionIds(TilesAPIBuilder.getPredicateForFormats(vectorFormats)));
        return api;
    }

    private static Predicate<TileLayer> getPredicateForFormats(Set<String> rasterFormats) {
        return t -> t.getMimeTypes().stream().map(m -> m.getMimeType()).anyMatch(m -> rasterFormats.contains(m));
    }

    private List<String> getCollectionIds(Predicate<TileLayer> filter) {
        return Streams.stream((Iterable)this.gwc.getTileLayers()).filter(filter).map(tl -> tl instanceof GeoServerTileLayer ? ((GeoServerTileLayer)tl).getContextualName() : tl.getName()).collect(Collectors.toList());
    }

    private static boolean isRasterFormat(String f) {
        try {
            return !MimeType.createFromFormat((String)f).isVector();
        }
        catch (MimeException e) {
            LOGGER.log(Level.FINE, "Error checking if format is raster", e);
            return false;
        }
    }

    private static boolean isVectorFormat(String f) {
        try {
            return MimeType.createFromFormat((String)f).isVector();
        }
        catch (MimeException e) {
            LOGGER.log(Level.FINE, "Error checking if format is raster", e);
            return false;
        }
    }
}

