/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.tiles;

import io.swagger.v3.oas.models.OpenAPI;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.ogcapi.APIException;
import org.geoserver.ogcapi.APIFilterParser;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.APIService;
import org.geoserver.ogcapi.ConformanceDocument;
import org.geoserver.ogcapi.HTMLResponseBody;
import org.geoserver.ogcapi.InvalidParameterValueException;
import org.geoserver.ogcapi.Queryables;
import org.geoserver.ogcapi.QueryablesBuilder;
import org.geoserver.ogcapi.ResourceNotFoundException;
import org.geoserver.ogcapi.v1.tiles.StylesDocument;
import org.geoserver.ogcapi.v1.tiles.TileJSONBuilder;
import org.geoserver.ogcapi.v1.tiles.TileMatrixSetDocument;
import org.geoserver.ogcapi.v1.tiles.TileMatrixSets;
import org.geoserver.ogcapi.v1.tiles.TiledCollectionDocument;
import org.geoserver.ogcapi.v1.tiles.TiledCollectionsDocument;
import org.geoserver.ogcapi.v1.tiles.TilesAPIBuilder;
import org.geoserver.ogcapi.v1.tiles.TilesDocument;
import org.geoserver.ogcapi.v1.tiles.TilesLandingPage;
import org.geoserver.ogcapi.v1.tiles.TilesServiceInfo;
import org.geoserver.ogcapi.v1.tiles.Tileset;
import org.geoserver.ogcapi.v1.tiles.VolatileGeoServerTileLayer;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wms.WMS;
import org.geotools.api.filter.Filter;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.parameters.ParameterException;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.meta.TileJSON;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.TileObject;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@APIService(service="Tiles", version="1.0.0", landingPage="ogc/tiles/v1", serviceClass=TilesServiceInfo.class)
@RequestMapping(path={"ogc/tiles/v1"})
public class TilesService {
    static final Logger LOGGER = Logging.getLogger(TilesService.class);
    public static final String CC_TILE_CORE = "http://www.opengis.net/spec/ogcapi-tiles-1/1.0/conf/core";
    public static final String CC_TILESET = "http://www.opengis.net/spec/ogcapi-tiles-1/1.0/conf/tileset";
    public static final String CC_INFO = "http://www.opengis.net/spec/ogcapi-tiles-1/1.0/conf/info";
    public static final String CC_TILESETS = "http://www.opengis.net/spec/ogcapi-tiles-1/1.0/conf/tilesets";
    public static final String CC_GEODATA_TILESET_LIST = "http://www.opengis.net/spec/ogcapi-tiles-1/1.0/conf/tilesets-list";
    public static final String CC_GEODATA_TILESETS = "http://www.opengis.net/spec/ogcapi-tiles-1/1.0/conf/geodata-tilesets";
    public static final String CC_TILES_TILE_MATRIX_SET = "http://www.opengis.net/spec/ogcapi-tiles-1/1.0/conf/tmxs";
    public static final String CC_TILE_MATRIX_SET = "http://www.opengis.net/spec/tilematrixset/1.0/conf/tilematrixset";
    public static final String CC_TILE_MATRIX_SET_JSON = "http://www.opengis.net/spec/tilematrixset/1.0/conf/json-tilematrixset";
    private static final String DISPLAY_NAME = "OGC API Tiles";
    private final GeoServer geoServer;
    private final GWC gwc;
    private final WMS wms;
    private final StorageBroker storageBroker;
    private final APIFilterParser filterParser;

    public TilesService(GeoServer geoServer, WMS wms, GWC gwc, StorageBroker storageBroker, APIFilterParser filterParser) {
        this.geoServer = geoServer;
        this.gwc = gwc;
        this.wms = wms;
        this.storageBroker = storageBroker;
        this.filterParser = filterParser;
    }

    @GetMapping(name="getLandingPage")
    @ResponseBody
    @HTMLResponseBody(templateName="landingPage.ftl", fileName="landingPage.html")
    public TilesLandingPage getLandingPage() {
        TilesServiceInfo service = this.getService();
        return new TilesLandingPage(service.getTitle() == null ? "Tiles server" : service.getTitle(), service.getAbstract() == null ? "" : service.getAbstract());
    }

    public TilesServiceInfo getService() {
        return (TilesServiceInfo)this.geoServer.getService(TilesServiceInfo.class);
    }

    public TilesServiceInfo getServiceInfo() {
        return this.getService();
    }

    @GetMapping(path={"openapi", "openapi.json", "openapi.yaml"}, name="getApi", produces={"application/vnd.oai.openapi+json;version=3.0", "application/yaml", "text/xml"})
    @ResponseBody
    @HTMLResponseBody(templateName="api.ftl", fileName="api.html")
    public OpenAPI api() throws IOException {
        return new TilesAPIBuilder(this.gwc).build(this.getService());
    }

    @GetMapping(path={"conformance"}, name="getConformanceDeclaration")
    @ResponseBody
    @HTMLResponseBody(templateName="conformance.ftl", fileName="conformance.html")
    public ConformanceDocument conformance() {
        List<String> classes = Arrays.asList("http://www.opengis.net/spec/ogcapi-common-1/1.0/conf/core", "http://www.opengis.net/spec/ogcapi-common-2/1.0/conf/collections", CC_TILE_CORE, CC_TILESET, CC_TILESETS, CC_GEODATA_TILESET_LIST, CC_GEODATA_TILESETS, CC_INFO, CC_TILES_TILE_MATRIX_SET, CC_TILE_MATRIX_SET, CC_TILE_MATRIX_SET_JSON);
        return new ConformanceDocument(DISPLAY_NAME, classes);
    }

    @GetMapping(path={"tileMatrixSets"}, name="getTileMatrixSets")
    @ResponseBody
    @HTMLResponseBody(templateName="tileMatrixSets.ftl", fileName="tileMatrixSets.html")
    public TileMatrixSets getTileMatrixSets() {
        return new TileMatrixSets(this.gwc);
    }

    @GetMapping(path={"tileMatrixSets/{tileMatrixSetId}"}, name="getTileMatrixSet")
    @ResponseBody
    @HTMLResponseBody(templateName="tileMatrixSet.ftl", fileName="tileMatrixSet.html")
    public TileMatrixSetDocument getTileMatrixSet(@PathVariable(name="tileMatrixSetId") String tileMatrixSetId) {
        GridSet gridSet = this.gwc.getGridSetBroker().get(tileMatrixSetId);
        if (gridSet == null) {
            throw new ResourceNotFoundException("Tile matrix set " + tileMatrixSetId + " not recognized");
        }
        return new TileMatrixSetDocument(gridSet, false);
    }

    @GetMapping(path={"collections"}, name="getCollections")
    @ResponseBody
    @HTMLResponseBody(templateName="collections.ftl", fileName="collections.html")
    public TiledCollectionsDocument getCollections() {
        return new TiledCollectionsDocument(this.geoServer, this.wms, this.gwc);
    }

    @GetMapping(path={"collections/{collectionId}/styles"}, name="getCollectionStyles")
    @ResponseBody
    @HTMLResponseBody(templateName="styles.ftl", fileName="styles.html")
    public StylesDocument getCollectionStyles(@PathVariable(name="collectionId") String collectionId) throws FactoryException, TransformException, IOException {
        TileLayer tileLayer = this.getTileLayer(collectionId);
        StylesDocument styles = new StylesDocument(tileLayer);
        return styles;
    }

    @GetMapping(path={"collections/{collectionId}/tiles"}, name="describeTilesets")
    @ResponseBody
    @HTMLResponseBody(templateName="tiles.ftl", fileName="tiles.html")
    public TilesDocument describeTilesets(@PathVariable(name="collectionId") String collectionId) throws FactoryException, TransformException, IOException {
        TileLayer tileLayer = this.getTileLayer(collectionId);
        TilesDocument tiles = new TilesDocument(this.wms, tileLayer, Tileset.DataType.vector);
        return tiles;
    }

    @GetMapping(path={"collections/{collectionId}/tiles/{tileMatrixId}"}, name="describeTileset")
    @ResponseBody
    @HTMLResponseBody(templateName="tileset.ftl", fileName="tileset.html")
    public Tileset describeTileset(@PathVariable(name="collectionId") String collectionId, @PathVariable(name="tileMatrixId") String tileMatrixId) throws FactoryException, TransformException, IOException {
        TileLayer tileLayer = this.getTileLayer(collectionId);
        Tileset tiles = new Tileset(this.wms, tileLayer, Tileset.DataType.vector, tileMatrixId, true);
        return tiles;
    }

    @GetMapping(path={"collections/{collectionId}/map/tiles"}, name="describeDefaultMapTilesets")
    @ResponseBody
    @HTMLResponseBody(templateName="tiles.ftl", fileName="tiles.html")
    public TilesDocument describeDefaultMapTilesets(@PathVariable(name="collectionId") String collectionId) throws FactoryException, TransformException, IOException {
        return this.describeStyledMapTilesets(collectionId, null);
    }

    @GetMapping(path={"collections/{collectionId}/styles/{styleId}/map/tiles"}, name="describeStyledMapTilesets")
    @ResponseBody
    @HTMLResponseBody(templateName="tiles-style.ftl", fileName="tiles.html")
    public TilesDocument describeStyledMapTilesets(@PathVariable(name="collectionId") String collectionId, @PathVariable(name="styleId") String styleId) throws FactoryException, TransformException, IOException {
        TileLayer tileLayer = this.getTileLayer(collectionId);
        TilesDocument tiles = new TilesDocument(this.wms, tileLayer, Tileset.DataType.map, styleId);
        return tiles;
    }

    @GetMapping(path={"collections/{collectionId}/map/tiles/{tileMatrixId}"}, name="describeMapTileset")
    @ResponseBody
    @HTMLResponseBody(templateName="tileset.ftl", fileName="tileset.html")
    public Tileset describeMapTileset(@PathVariable(name="collectionId") String collectionId, @PathVariable(name="tileMatrixId") String tileMatrixId) throws FactoryException, TransformException, IOException {
        TileLayer tileLayer = this.getTileLayer(collectionId);
        Tileset tiles = new Tileset(this.wms, tileLayer, Tileset.DataType.map, tileMatrixId, true);
        return tiles;
    }

    @GetMapping(path={"collections/{collectionId}/styles/{styleId}/map/tiles/{tileMatrixId}"}, name="describeMapTileset")
    @ResponseBody
    @HTMLResponseBody(templateName="tileset-style.ftl", fileName="tileset.html")
    public Tileset describeStyledMapTileset(@PathVariable(name="collectionId") String collectionId, @PathVariable(name="styleId") String styleId, @PathVariable(name="tileMatrixId") String tileMatrixId) throws FactoryException, TransformException, IOException {
        TileLayer tileLayer = this.getTileLayer(collectionId);
        Tileset tiles = new Tileset(this.wms, tileLayer, Tileset.DataType.map, tileMatrixId, styleId, true);
        return tiles;
    }

    private TileLayer getTileLayer(String collectionId) {
        try {
            return this.gwc.getTileLayerByName(collectionId);
        }
        catch (IllegalArgumentException e) {
            throw new ResourceNotFoundException("Tiled collection " + collectionId + " not found", (Throwable)e);
        }
    }

    @GetMapping(path={"collections/{collectionId}"}, name="describeCollection")
    @ResponseBody
    @HTMLResponseBody(templateName="collection.ftl", fileName="collection.html")
    public TiledCollectionDocument collection(@PathVariable(name="collectionId") String collectionId) throws FactoryException, TransformException, IOException {
        TileLayer tileLayer = this.getTileLayer(collectionId);
        TiledCollectionDocument collection = new TiledCollectionDocument(this.wms, tileLayer, false);
        return collection;
    }

    @GetMapping(path={"/collections/{collectionId}/tiles/{tileMatrixSetId}/{tileMatrix}/{tileRow}/{tileCol}"}, name="getTile")
    @ResponseBody
    public ResponseEntity<byte[]> getRawTile(@PathVariable(name="collectionId") String collectionId, @PathVariable(name="tileMatrixSetId") String tileMatrixSetId, @PathVariable(name="tileMatrix") String tileMatrix, @PathVariable(name="tileRow") long tileRow, @PathVariable(name="tileCol") long tileCol, @RequestParam(name="filter", required=false) String filter, @RequestParam(name="filter-lang", required=false) String filterLanguage) throws GeoWebCacheException, IOException, NoSuchAlgorithmException {
        return this.getTileInternal(collectionId, tileMatrixSetId, tileMatrix, tileRow, tileCol, null, filter, filterLanguage, false);
    }

    @GetMapping(path={"/collections/{collectionId}/styles/{styleId}/map/tiles/{tileMatrixSetId}/{tileMatrix}/{tileRow}/{tileCol}"}, name="getStyledMapTile")
    @ResponseBody
    public ResponseEntity<byte[]> getStyledMapTile(@PathVariable(name="collectionId") String collectionId, @PathVariable(name="tileMatrixSetId") String tileMatrixSetId, @PathVariable(name="tileMatrix") String tileMatrix, @PathVariable(name="tileRow") long tileRow, @PathVariable(name="tileCol") long tileCol, @PathVariable(name="styleId") String styleId, @RequestParam(name="filter", required=false) String filter, @RequestParam(name="filter-lang", required=false) String filterLanguage) throws GeoWebCacheException, IOException, NoSuchAlgorithmException {
        return this.getTileInternal(collectionId, tileMatrixSetId, tileMatrix, tileRow, tileCol, styleId, filter, filterLanguage, true);
    }

    @GetMapping(path={"/collections/{collectionId}/map/tiles/{tileMatrixSetId}/{tileMatrix}/{tileRow}/{tileCol}"}, name="getDefaultMapTile")
    @ResponseBody
    public ResponseEntity<byte[]> getDefaultMapTileTile(@PathVariable(name="collectionId") String collectionId, @PathVariable(name="tileMatrixSetId") String tileMatrixSetId, @PathVariable(name="tileMatrix") String tileMatrix, @PathVariable(name="tileRow") long tileRow, @PathVariable(name="tileCol") long tileCol, @RequestParam(name="filter", required=false) String filter, @RequestParam(name="filter-lang", required=false) String filterLanguage) throws GeoWebCacheException, IOException, NoSuchAlgorithmException {
        return this.getTileInternal(collectionId, tileMatrixSetId, tileMatrix, tileRow, tileCol, null, filter, filterLanguage, true);
    }

    ResponseEntity<byte[]> getTileInternal(String collectionId, String tileMatrixSetId, String tileMatrix, long tileRow, long tileCol, String styleId, String filterSpec, String filterLanguage, boolean renderedTile) throws GeoWebCacheException, IOException, NoSuchAlgorithmException {
        byte[] tileBytes;
        boolean tileIsCacheable;
        TileLayer tileLayer = this.getTileLayer(collectionId);
        if (styleId != null) {
            TilesService.validateStyle(tileLayer, styleId);
            if (TilesService.isLayerGroup(tileLayer)) {
                styleId = null;
            }
        }
        MimeType requestedFormat = TilesService.getRequestedFormat(tileLayer, renderedTile, APIRequestInfo.get().getRequestedMediaTypes());
        long[] tileIndex = this.getTileIndex(tileMatrixSetId, tileMatrix, tileRow, tileCol, tileLayer);
        String name = TilesService.getTileLayerId(tileLayer);
        Filter filter = this.filterParser.parse(filterSpec, filterLanguage);
        String cqlSpecification = this.toCQLSpecification(tileLayer, filter);
        ConveyorTile tile = new ConveyorTile(this.storageBroker, name, tileMatrixSetId, tileIndex, requestedFormat, this.filterParameters(styleId, cqlSpecification), null, null);
        boolean bl = tileIsCacheable = filterSpec == null || this.supportsCQLFilter(tileLayer, filterSpec);
        if (tileIsCacheable) {
            tile = tileLayer.getTile(tile);
        } else {
            if (!(tileLayer instanceof GeoServerTileLayer)) {
                throw new InvalidParameterValueException("Filter is not supported on this layer");
            }
            VolatileGeoServerTileLayer volatileLayer = new VolatileGeoServerTileLayer((GeoServerTileLayer)tileLayer);
            volatileLayer.getTile(tile);
            TileObject so = tile.getStorageObject();
            if (so != null) {
                so.setCreated(System.currentTimeMillis());
            }
        }
        if (tile == null) {
            HttpHeaders headers = new HttpHeaders();
            headers.add("geowebcache-cache-result", Conveyor.CacheResult.MISS.toString());
            headers.add("geowebcache-miss-reason", "unknown");
            return new ResponseEntity((MultiValueMap)headers, HttpStatus.NOT_FOUND);
        }
        Resource mapContents = tile.getBlob();
        if (mapContents instanceof ByteArrayResource) {
            tileBytes = ((ByteArrayResource)mapContents).getContents();
        } else {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            mapContents.transferTo(Channels.newChannel(out));
            tileBytes = out.toByteArray();
        }
        HttpServletRequest httpRequest = APIRequestInfo.get().getRequest();
        String ifNoneMatch = httpRequest.getHeader("If-None-Match");
        String etag = this.getETag(tileBytes);
        if (etag.equals(ifNoneMatch)) {
            LOGGER.finer("ETag matches, returning 304");
            return new ResponseEntity(HttpStatus.NOT_MODIFIED);
        }
        LOGGER.finer("No matching ETag, returning cached tile");
        LinkedHashMap<String, String> tmpHeaders = new LinkedHashMap<String, String>();
        GWC.setCacheControlHeaders(tmpHeaders, (TileLayer)tileLayer, (int)((int)tileIndex[2]));
        GWC.setConditionalGetHeaders(tmpHeaders, (ConveyorTile)tile, (String)etag, (String)httpRequest.getHeader("If-Modified-Since"));
        GWC.setCacheMetadataHeaders(tmpHeaders, (ConveyorTile)tile, (TileLayer)tileLayer);
        tmpHeaders.put("geowebcache-layer", tileLayer instanceof GeoServerTileLayer ? ((GeoServerTileLayer)tileLayer).getContextualName() : tileLayer.getName());
        if (filterSpec != null && !tileIsCacheable) {
            tmpHeaders.put("geowebcache-cache-result", Conveyor.CacheResult.MISS.toString());
            tmpHeaders.put("geowebcache-miss-reason", "CQL_FILTER filter parameter not cached or not condition not matched");
        }
        HttpHeaders headers = new HttpHeaders();
        tmpHeaders.forEach((k, v) -> headers.add(k, v));
        headers.add("Content-Type", tile.getMimeType().getMimeType());
        String disposition = requestedFormat.isInlinePreferred() ? "inline" : "attachment";
        headers.add("Content-Disposition", disposition + "; filename=\"" + this.getTileFileName(tileMatrixSetId, tileMatrix, tileRow, tileCol, tileLayer, tile) + "\"");
        return new ResponseEntity((Object)tileBytes, (MultiValueMap)headers, HttpStatus.OK);
    }

    static String getTileLayerId(TileLayer tileLayer) {
        return tileLayer instanceof GeoServerTileLayer ? ((GeoServerTileLayer)tileLayer).getContextualName() : tileLayer.getName();
    }

    private String getETag(byte[] tileBytes) throws NoSuchAlgorithmException {
        if (tileBytes == null) {
            return "EMPTY_TILE";
        }
        return GWC.getETag((byte[])tileBytes);
    }

    private String toCQLSpecification(TileLayer tileLayer, Filter filter) {
        if (filter == null) {
            return null;
        }
        String cqlSpec = ECQL.toCQL((Filter)filter);
        return tileLayer.getParameterFilters().stream().filter(pf -> pf.getKey().equalsIgnoreCase("CQL_FILTER") && pf.applies(cqlSpec)).map(pf -> {
            try {
                return pf.apply(cqlSpec);
            }
            catch (ParameterException e) {
                throw new RuntimeException("Tested before if it was applicable, this exception should not happen", e);
            }
        }).findFirst().orElse(cqlSpec);
    }

    private boolean supportsCQLFilter(TileLayer tileLayer, String cqlSpec) {
        return tileLayer.getParameterFilters().stream().anyMatch(pf -> pf.getKey().equalsIgnoreCase("CQL_FILTER") && pf.applies(cqlSpec));
    }

    public static void validateStyle(TileLayer tileLayer, String styleId) {
        if (styleId.equalsIgnoreCase(tileLayer.getStyles())) {
            return;
        }
        if (TilesService.isLayerGroup(tileLayer)) {
            String name = TilesService.getLayerGroupStyleName(tileLayer);
            if (!styleId.equals(name)) {
                throw new InvalidParameterValueException("Invalid style name, please check the collection description for valid style names: " + name);
            }
        } else {
            Optional<ParameterFilter> styles = tileLayer.getParameterFilters().stream().filter(pf -> "styles".equalsIgnoreCase(pf.getKey())).findFirst();
            if (!styles.isPresent() || !styles.get().applies(styleId)) {
                throw new InvalidParameterValueException("Invalid style name, please check the collection description for valid style names: " + tileLayer.getStyles());
            }
        }
    }

    static boolean isLayerGroup(TileLayer tileLayer) {
        if (tileLayer instanceof GeoServerTileLayer) {
            return ((GeoServerTileLayer)tileLayer).getPublishedInfo() instanceof LayerGroupInfo;
        }
        return false;
    }

    static boolean isStyleGroup(LayerGroupInfo lg) {
        if (lg.getRootLayer() != null) {
            return false;
        }
        return lg.getStyles().size() == 1 && lg.getStyles().get(0) != null && lg.getLayers().stream().allMatch(l -> l == null);
    }

    static String getLayerGroupStyleName(TileLayer tileLayer) {
        LayerGroupInfo group = (LayerGroupInfo)((GeoServerTileLayer)tileLayer).getPublishedInfo();
        if (TilesService.isStyleGroup(group)) {
            return ((StyleInfo)group.getStyles().get(0)).getName();
        }
        return "_";
    }

    public static GridSubset getGridSubset(TileLayer tileLayer, String tileMatrixSetId) {
        GridSubset gridSubset = tileLayer.getGridSubset(tileMatrixSetId);
        if (gridSubset == null) {
            throw new InvalidParameterValueException("Invalid tileMatrixSetId " + tileMatrixSetId);
        }
        return gridSubset;
    }

    private Map<String, String> filterParameters(String styleId, String cqlSpec) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (styleId != null) {
            params.put("styles", styleId);
        }
        if (cqlSpec != null) {
            params.put("cql_filter", cqlSpec);
        }
        return params;
    }

    public String getTileFileName(String tileMatrixSetId, String tileMatrix, long tileRow, long tileCol, TileLayer tileLayer, ConveyorTile tile) {
        String layerName = tileLayer instanceof GeoServerTileLayer ? ((GeoServerTileLayer)tileLayer).getSimpleName() : tileLayer.getName();
        return layerName + "_" + this.getExternalZIndex(tileMatrixSetId, tileMatrix, tileLayer) + "_" + tileRow + "_" + tileCol + "." + tile.getMimeType().getFileExtension();
    }

    private long[] getTileIndex(String tileMatrixSetId, String tileMatrix, long tileRow, long tileCol, TileLayer tileLayer) {
        GridSubset gridSubset = tileLayer.getGridSubset(tileMatrixSetId);
        if (gridSubset == null) {
            throw new InvalidParameterValueException("Invalid tileMatrixSetId " + tileMatrixSetId);
        }
        long z = gridSubset.getGridIndex(tileMatrix);
        if (z < 0L) {
            throw new InvalidParameterValueException("Unknown tileMatrix " + tileMatrix);
        }
        long tilesHigh = gridSubset.getNumTilesHigh((int)z);
        long y = tilesHigh - tileRow - 1L;
        long x = tileCol;
        long[] gridCov = gridSubset.getCoverage((int)z);
        if (x < gridCov[0] || x > gridCov[2]) {
            throw new APIException("NotFound", "Column " + x + " is out of range, min: " + gridCov[0] + " max:" + gridCov[2], HttpStatus.NOT_FOUND);
        }
        if (y < gridCov[1] || y > gridCov[3]) {
            long minRow = tilesHigh - gridCov[3] - 1L;
            long maxRow = tilesHigh - gridCov[1] - 1L;
            throw new APIException("NotFound", "Row " + tileRow + " is out of range, min: " + minRow + " max:" + maxRow, HttpStatus.NOT_FOUND);
        }
        return new long[]{x, y, z};
    }

    private long getExternalZIndex(String tileMatrixSetId, String tileMatrix, TileLayer tileLayer) {
        GridSubset gridSubset = tileLayer.getGridSubset(tileMatrixSetId);
        return gridSubset.getGridIndex(tileMatrix);
    }

    public static MimeType getRequestedFormat(TileLayer tileLayer, boolean renderedTile, List<MediaType> requestedTypes) {
        Map layerTypes = tileLayer.getMimeTypes().stream().filter(mt -> renderedTile ? !mt.isVector() : mt.isVector()).collect(Collectors.toMap(mt -> MediaType.parseMediaType((String)mt.getFormat()), mt -> mt, (a, b) -> a, LinkedHashMap::new));
        if (layerTypes.isEmpty()) {
            throw new InvalidParameterValueException("The layer does not seem to have any cached format suitable for this type of resource, check the resource is listed among the tiled collection links");
        }
        if (requestedTypes == null || requestedTypes.isEmpty()) {
            return (MimeType)layerTypes.values().iterator().next();
        }
        for (MediaType requestedType : requestedTypes) {
            for (Map.Entry layerType : layerTypes.entrySet()) {
                if (!requestedType.equals(layerType.getKey())) continue;
                return (MimeType)layerType.getValue();
            }
        }
        throw new APIException("InvalidParameterValue", "Could not find a tile media type matching the requested resource (either invalid format, or not supported on this resource)", HttpStatus.BAD_REQUEST);
    }

    @GetMapping(path={"collections/{collectionId}/queryables"}, name="getQueryables")
    @ResponseBody
    @HTMLResponseBody(templateName="queryables.ftl", fileName="queryables.html")
    public Queryables queryables(@PathVariable(name="collectionId") String collectionId) throws IOException {
        TileLayer tileLayer = this.getTileLayer(collectionId);
        if (!TilesService.supportsFiltering(tileLayer)) {
            throw new ResourceNotFoundException("Collection '" + collectionId + "' cannot be filtered, no queryables available");
        }
        FeatureTypeInfo ft = (FeatureTypeInfo)((LayerInfo)((GeoServerTileLayer)tileLayer).getPublishedInfo()).getResource();
        String id = ResponseUtils.buildURL((String)APIRequestInfo.get().getBaseURL(), (String)("ogc/tiles/v1/collections/" + ResponseUtils.urlEncode((String)collectionId, (char[])new char[0]) + "/queryables"), null, (URLMangler.URLType)URLMangler.URLType.RESOURCE);
        return new QueryablesBuilder(id).forType(ft).build();
    }

    public static boolean supportsFiltering(TileLayer tileLayer) {
        return tileLayer instanceof GeoServerTileLayer && ((GeoServerTileLayer)tileLayer).getPublishedInfo() instanceof LayerInfo && ((LayerInfo)((GeoServerTileLayer)tileLayer).getPublishedInfo()).getResource() instanceof FeatureTypeInfo;
    }

    @GetMapping(path={"/collections/{collectionId}/map/tiles/{tileMatrixSetId}/metadata"}, name="getTilesMetadata")
    @ResponseBody
    public TileJSON getTileJSON(@PathVariable(name="collectionId") String collectionId, @PathVariable(name="tileMatrixSetId") String tileMatrixSetId, @RequestParam(name="tileFormat") String format) throws FactoryException, TransformException, NoSuchAlgorithmException, GeoWebCacheException, IOException {
        return this.getTileJSONInternal(collectionId, null, format, tileMatrixSetId);
    }

    @GetMapping(path={"/collections/{collectionId}/styles/{styleId}/map/tiles/{tileMatrixSetId}/metadata"}, name="getTilesMetadata")
    @ResponseBody
    public TileJSON getTileJSON(@PathVariable(name="collectionId") String collectionId, @PathVariable(name="styleId") String styleId, @PathVariable(name="tileMatrixSetId") String tileMatrixSetId, @RequestParam(name="tileFormat") String format) throws FactoryException, TransformException, NoSuchAlgorithmException, GeoWebCacheException, IOException {
        return this.getTileJSONInternal(collectionId, styleId, format, tileMatrixSetId);
    }

    @GetMapping(path={"/collections/{collectionId}/tiles/{tileMatrixSetId}/metadata"}, name="getTilesMetadata")
    @ResponseBody
    public TileJSON getTileJSON(@PathVariable(name="collectionId") String collectionId, @PathVariable(name="tileMatrixSetId") String tileMatrixSetId) throws FactoryException, TransformException, NoSuchAlgorithmException, GeoWebCacheException, IOException {
        return this.getTileJSONInternal(collectionId, null, "application/vnd.mapbox-vector-tile", tileMatrixSetId);
    }

    private TileJSON getTileJSONInternal(String collectionId, String styleId, String tileFormat, String tileMatrixSetId) throws GeoWebCacheException, IOException, NoSuchAlgorithmException, TransformException, FactoryException {
        TileLayer tileLayer = this.getTileLayer(collectionId);
        if (styleId != null) {
            TilesService.validateStyle(tileLayer, styleId);
        }
        return new TileJSONBuilder(collectionId, tileFormat, tileMatrixSetId, tileLayer).style(styleId).build();
    }
}

