/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.schemalessfeatures.data;

import java.io.IOException;
import java.util.List;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.ServiceInfo;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.geotools.filter.FilterCapabilities;

public abstract class ComplexContentDataAccess
implements DataAccess<FeatureType, Feature> {
    FilterCapabilities filterCapabilities = this.createFilterCapabilities();
    protected String namespaceURI;
    private List<Name> typeNames;

    protected abstract FilterCapabilities createFilterCapabilities();

    public ServiceInfo getInfo() {
        return null;
    }

    public void createSchema(FeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("Not a supported operation");
    }

    public void updateSchema(Name typeName, FeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("Not a supported operation");
    }

    public void removeSchema(Name typeName) throws IOException {
        throw new UnsupportedOperationException("Not a supported operation");
    }

    public List<Name> getNames() throws IOException {
        if (this.typeNames == null) {
            this.typeNames = this.createTypeNames();
        }
        return this.typeNames;
    }

    public FeatureType getSchema(Name name) throws IOException {
        return this.getFeatureSource(name).getSchema();
    }

    public FilterCapabilities getFilterCapabilities() {
        return this.filterCapabilities;
    }

    public void setNamespaceURI(String uri) {
        this.namespaceURI = uri;
    }

    protected abstract List<Name> createTypeNames();

    protected final Name name(String typeName) {
        return new NameImpl(this.namespaceURI, typeName);
    }
}

