/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.schemalessfeatures.type;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.geoserver.schemalessfeatures.type.DynamicComplexType;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.util.InternationalString;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeTypeImpl;

public class DynamicComplexTypeImpl
extends AttributeTypeImpl
implements DynamicComplexType {
    private final Map<Name, PropertyDescriptor> propertyMap;

    public DynamicComplexTypeImpl(Name name, Collection<PropertyDescriptor> properties, boolean identified, boolean isAbstract, List<Filter> restrictions, AttributeType superType, InternationalString description) {
        super(name, Collection.class, identified, isAbstract, restrictions, superType, description);
        LinkedHashMap<Name, PropertyDescriptor> localPropertyMap = new LinkedHashMap<Name, PropertyDescriptor>();
        for (PropertyDescriptor pd : properties) {
            if (pd == null) {
                throw new NullPointerException("PropertyDescriptor is null - did you request a property that does not exist?");
            }
            localPropertyMap.put(pd.getName(), pd);
        }
        this.propertyMap = localPropertyMap;
    }

    public Class<Collection<Property>> getBinding() {
        return super.getBinding();
    }

    public Collection<PropertyDescriptor> getDescriptors() {
        return this.propertyMap.values();
    }

    public PropertyDescriptor getDescriptor(Name name) {
        PropertyDescriptor propertyDescriptor = this.propertyMap.get(name);
        if (propertyDescriptor == null) {
            propertyDescriptor = this.getDescriptorByLocalPart(name.getLocalPart());
        }
        return propertyDescriptor;
    }

    public PropertyDescriptor getDescriptor(String name) {
        PropertyDescriptor result = this.getDescriptor((Name)new NameImpl(name));
        if (result == null && (result = this.getDescriptor((Name)new NameImpl(this.getName().getNamespaceURI(), name))) == null) {
            this.getDescriptorByLocalPart(name);
        }
        return result;
    }

    private PropertyDescriptor getDescriptorByLocalPart(String localPart) {
        for (PropertyDescriptor pd : this.propertyMap.values()) {
            if (!pd.getName().getLocalPart().equals(localPart)) continue;
            return pd;
        }
        return null;
    }

    public boolean isInline() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        DynamicComplexTypeImpl other = (DynamicComplexTypeImpl)o;
        return !this.propertyMap.equals(other.propertyMap);
    }

    @Override
    public void addPropertyDescriptor(PropertyDescriptor descriptor) {
        if (!this.propertyMap.containsValue(descriptor)) {
            this.propertyMap.put(descriptor.getName(), descriptor);
        }
    }

    @Override
    public void removePropertyDescriptor(PropertyDescriptor descriptor) {
        if (this.propertyMap.containsValue(descriptor)) {
            this.propertyMap.remove(descriptor.getName());
        }
    }
}

