/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.schemalessfeatures.data;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.geoserver.schemalessfeatures.data.ComplexFeatureIterator;
import org.geoserver.schemalessfeatures.data.ComplexFeatureSource;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.Query;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.DataUtilities;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;

public class ComplexFeatureCollection
implements FeatureCollection<FeatureType, Feature> {
    protected ComplexFeatureSource featureSource;
    protected Query query;

    public ComplexFeatureCollection(Query q, ComplexFeatureSource source) {
        this.query = q;
        this.featureSource = source;
    }

    public FeatureIterator<Feature> features() {
        return new ComplexFeatureIterator(this.featureSource.getReader(this.query));
    }

    public FeatureType getSchema() {
        return this.featureSource.getSchema();
    }

    public String getID() {
        return null;
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        DataUtilities.visit((FeatureCollection)this, (FeatureVisitor)visitor, (ProgressListener)progress);
    }

    public FeatureCollection<FeatureType, Feature> subCollection(Filter filter) {
        Query query = new Query();
        query.setFilter(filter);
        query = DataUtilities.mixQueries((Query)this.query, (Query)query, null);
        return new ComplexFeatureCollection(query, this.featureSource);
    }

    public FeatureCollection<FeatureType, Feature> sort(SortBy order) {
        Query query = new Query();
        query.setSortBy(new SortBy[]{order});
        query = DataUtilities.mixQueries((Query)this.query, (Query)query, null);
        return new ComplexFeatureCollection(query, this.featureSource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReferencedEnvelope getBounds() {
        FeatureReader<FeatureType, Feature> reader = null;
        try {
            ReferencedEnvelope referencedEnvelope;
            ReferencedEnvelope result = this.featureSource.getBounds(this.query);
            if (result != null) {
                ReferencedEnvelope referencedEnvelope2 = result;
                return referencedEnvelope2;
            }
            Query q = new Query(this.query);
            FeatureType schema = this.getSchema();
            GeometryDescriptor geometry = schema.getGeometryDescriptor();
            if (geometry != null) {
                q.setPropertyNames(new String[]{geometry.getLocalName()});
            }
            reader = this.featureSource.getReader(q);
            while (reader.hasNext()) {
                Feature f = reader.next();
                ReferencedEnvelope featureBounds = ReferencedEnvelope.reference((Bounds)f.getBounds());
                if (result == null) {
                    result = featureBounds;
                    continue;
                }
                if (featureBounds == null) continue;
                result.expandToInclude((Envelope)featureBounds);
            }
            if (result != null) {
                referencedEnvelope = result;
                return referencedEnvelope;
            }
            referencedEnvelope = ReferencedEnvelope.create((CoordinateReferenceSystem)this.getSchema().getCoordinateReferenceSystem());
            return referencedEnvelope;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        try (FeatureIterator<Feature> e = null;){
            e = this.features();
            if (o == null) {
                while (e.hasNext()) {
                    if (e.next() != null) continue;
                    boolean bl = true;
                    return bl;
                }
            } else {
                while (e.hasNext()) {
                    if (!o.equals(e.next())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection<?> o) {
        Iterator<?> e = o.iterator();
        try {
            while (e.hasNext()) {
                if (this.contains(e.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (e instanceof FeatureIterator) {
                ((FeatureIterator)e).close();
            }
        }
    }

    public boolean isEmpty() {
        return false;
    }

    public int size() {
        try {
            return this.featureSource.getCount(this.query);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get the collection size. Exception is " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        ArrayList<Feature> array = new ArrayList<Feature>();
        try (FeatureIterator<Feature> e = null;){
            e = this.features();
            while (e.hasNext()) {
                array.add(e.next());
            }
            Object[] objectArray = array.toArray(new Feature[array.size()]);
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <O> O[] toArray(O[] array) {
        int size = this.size();
        if (array.length < size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        }
        try (FeatureIterator<Feature> it = this.features();){
            O[] result = array;
            for (int i = 0; it.hasNext() && i < size; ++i) {
                result[i] = it.next();
            }
            if (array.length > size) {
                array[size] = null;
            }
            Object[] objectArray = array;
            return objectArray;
        }
    }
}

