/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.dggs;

import java.io.Serializable;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.api.feature.type.Name;
import org.geotools.dggs.gstore.DGGSGeometryStoreFactory;
import org.geotools.feature.NameImpl;
import org.junit.Assert;
import org.junit.Test;

public class DGGSIntegrationTest
extends GeoServerSystemTestSupport {
    public static final String TYPENAME = "h3-geometry";

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(catalog);
        DataStoreInfo ds = cb.buildDataStore("h3");
        ds.getConnectionParameters().put(DGGSGeometryStoreFactory.DGGS_FACTORY_ID.key, "H3");
        catalog.add((StoreInfo)ds);
        cb.setStore((StoreInfo)ds);
        FeatureTypeInfo ft = cb.buildFeatureType((Name)new NameImpl(catalog.getDefaultNamespace().getURI(), "H3"));
        ft.setName(TYPENAME);
        ft.getMetadata().put("dggs.minResolution", (Serializable)((Object)"0"));
        ft.getMetadata().put("dggs.maxResolution", (Serializable)((Object)"3"));
        catalog.add((ResourceInfo)ft);
        LayerInfo layer = cb.buildLayer(ft);
        catalog.add(layer);
    }

    @Test
    public void testGetFeatureInfo() throws Exception {
        String url = "wms?service=WMS&version=1.1.0&request=GetFeatureInfo&layers=h3-geometry&styles=&bbox=-180.0,-90.0,180.0,90.0&width=200&height=100&srs=EPSG:4326&format=image/png&info_format=application/json&query_layers=h3-geometry&x=100&y=50";
        JSONObject json = (JSONObject)this.getAsJSON(url);
        this.print((JSON)json);
        Assert.assertEquals((Object)"FeatureCollection", (Object)json.getString("type"));
        JSONArray features = json.getJSONArray("features");
        Assert.assertEquals((long)1L, (long)features.size());
        JSONObject feature = features.getJSONObject(0);
        Assert.assertEquals((Object)"Feature", (Object)feature.getString("type"));
        JSONObject properties = feature.getJSONObject("properties");
        Assert.assertEquals((Object)"0", (Object)properties.getString("resolution"));
        Assert.assertEquals((Object)"8083fffffffffff", (Object)properties.getString("zoneId"));
        Assert.assertEquals((Object)"hexagon", (Object)properties.getString("shape"));
    }
}

