/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.publish.dggs;

import java.io.Serializable;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.resource.ResourceConfigurationPage;
import org.geoserver.web.publish.dggs.DGGSConfigPanel;
import org.geotools.api.feature.type.Name;
import org.geotools.dggs.gstore.DGGSGeometryStoreFactory;
import org.geotools.feature.NameImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DGGSConfigPanelTest
extends GeoServerWicketTestSupport {
    public static final String PUBLISHED_INFO = "publishedinfo";

    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        CatalogBuilder builder = new CatalogBuilder(catalog);
        DataStoreInfo dggs = builder.buildDataStore("dggs");
        dggs.setType("DGGS Geometry Store");
        dggs.getConnectionParameters().put(DGGSGeometryStoreFactory.DGGS_FACTORY_ID.key, "H3");
        catalog.add((StoreInfo)dggs);
        builder.setStore((StoreInfo)dggs);
        FeatureTypeInfo fti = builder.buildFeatureType((Name)new NameImpl("H3"));
        builder.setupBounds((ResourceInfo)fti);
        LayerInfo li = builder.buildLayer(fti);
        catalog.add((ResourceInfo)fti);
        catalog.add(li);
        testData.addVectorLayer(MockData.PONDS, this.getCatalog());
    }

    @Before
    public void resetConfiguration() throws Exception {
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName("H3");
        fti.getMetadata().remove((Object)"dggs.resOffset");
        fti.getMetadata().remove((Object)"dggs.minResolution");
        fti.getMetadata().remove((Object)"dggs.maxResolution");
        this.getCatalog().save((ResourceInfo)fti);
    }

    private String openDGGSPanel() {
        this.login();
        tester.startPage((Page)new ResourceConfigurationPage(MockData.DEFAULT_PREFIX, "H3"));
        tester.assertNoErrorMessage();
        tester.clickLink("publishedinfo:tabs:tabs-container:tabs:1:link");
        tester.assertNoErrorMessage();
        Form form = (Form)tester.getComponentFromLastRenderedPage(PUBLISHED_INFO);
        String configPanelPath = this.getComponentPath((WebMarkupContainer)form, DGGSConfigPanel.class);
        Assert.assertNotNull((Object)configPanelPath);
        String baseFormPath = configPanelPath.substring(PUBLISHED_INFO.length() + 1);
        return baseFormPath;
    }

    @Test
    public void testPanelSave() {
        String baseFormPath = this.openDGGSPanel();
        FormTester formTester = tester.newFormTester(PUBLISHED_INFO);
        formTester.setValue(baseFormPath + ":resolutionOffset", "1");
        formTester.setValue(baseFormPath + ":minResolution", "2");
        formTester.setValue(baseFormPath + ":maxResolution", "5");
        formTester.submit();
        tester.clickLink("publishedinfo:save");
        tester.assertNoErrorMessage();
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName("H3");
        DGGSConfigPanelTest.assertIntegerMetadataKey(fti, "dggs.resOffset", 1);
        DGGSConfigPanelTest.assertIntegerMetadataKey(fti, "dggs.minResolution", 2);
        DGGSConfigPanelTest.assertIntegerMetadataKey(fti, "dggs.maxResolution", 5);
    }

    private static void assertIntegerMetadataKey(FeatureTypeInfo fti, String key, int expectedValue) {
        Assert.assertEquals((Object)expectedValue, (Object)fti.getMetadata().get(key, Integer.class));
    }

    @Test
    public void testPanelNonDGGS() {
        this.login();
        tester.startPage((Page)new ResourceConfigurationPage(MockData.PONDS.getPrefix(), MockData.PONDS.getLocalPart()));
        tester.assertNoErrorMessage();
        tester.clickLink("publishedinfo:tabs:tabs-container:tabs:1:link");
        tester.assertNoErrorMessage();
        Form form = (Form)tester.getComponentFromLastRenderedPage(PUBLISHED_INFO);
        String configPanelPath = this.getComponentPath((WebMarkupContainer)form, DGGSConfigPanel.class);
        Assert.assertNull((Object)configPanelPath);
    }

    @Test
    public void testMinMaxIndividualValidation() {
        String baseFormPath = this.openDGGSPanel();
        FormTester formTester = tester.newFormTester(PUBLISHED_INFO);
        formTester.setValue(baseFormPath + ":minResolution", "-1");
        formTester.setValue(baseFormPath + ":maxResolution", "25");
        formTester.submit();
        tester.assertErrorMessages(new Serializable[]{"The value of 'Minimum resolution in layer' must be at least 0.", "The value of 'Maximum resolution in layer' must be at most 15."});
    }

    @Test
    public void testMinMaxConsistencyValidation() {
        String baseFormPath = this.openDGGSPanel();
        FormTester formTester = tester.newFormTester(PUBLISHED_INFO);
        formTester.setValue(baseFormPath + ":minResolution", "6");
        formTester.setValue(baseFormPath + ":maxResolution", "2");
        formTester.submit();
        tester.assertErrorMessages(new Serializable[]{"DGGS minimum layer resolution but be less or equal than the maximum resolution."});
    }
}

