/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.complex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.complex.FeatureTypeConverter;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.xml.sax.helpers.NamespaceSupport;

public class ComplexToSimpleFeatureCollection
implements SimpleFeatureCollection {
    private static final Logger LOGGER = Logging.getLogger(ComplexToSimpleFeatureCollection.class);
    private final Map<String, String> rulesMap;
    private final FeatureCollection<FeatureType, Feature> delegate;
    private final NamespaceSupport namespaceSupport;
    private final SimpleFeatureType featureType;

    public ComplexToSimpleFeatureCollection(Map<String, String> rulesMap, FeatureCollection<FeatureType, Feature> featureCollection, NamespaceSupport namespaceSupport) {
        this.rulesMap = new HashMap<String, String>(Objects.requireNonNull(rulesMap));
        this.delegate = Objects.requireNonNull(featureCollection);
        this.namespaceSupport = Objects.requireNonNull(namespaceSupport);
        this.featureType = Objects.requireNonNull(this.buildConvertedType());
        LOGGER.fine(() -> "Converted feature type: " + this.featureType);
    }

    protected SimpleFeatureType buildConvertedType() {
        FeatureTypeConverter converter = new FeatureTypeConverter(this.delegate.getSchema(), this.rulesMap, this.namespaceSupport);
        return converter.produceSimpleType();
    }

    public SimpleFeatureType getSchema() {
        return this.featureType;
    }

    public SimpleFeatureIterator features() {
        return new ComplexToSimpleFeatureIterator((FeatureIterator<Feature>)this.delegate.features());
    }

    public SimpleFeatureCollection subCollection(Filter filter) {
        return null;
    }

    public SimpleFeatureCollection sort(SortBy order) {
        return null;
    }

    public String getID() {
        return this.delegate.getID();
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        DataUtilities.visit((FeatureCollection)this, (FeatureVisitor)visitor, (ProgressListener)progress);
    }

    public ReferencedEnvelope getBounds() {
        return this.delegate.getBounds();
    }

    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    public boolean containsAll(Collection<?> o) {
        return this.delegate.containsAll(o);
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public int size() {
        return this.delegate.size();
    }

    public Object[] toArray() {
        return this.getFeaturesList().toArray();
    }

    public <O> O[] toArray(O[] a) {
        return this.getFeaturesList().toArray(a);
    }

    private List<SimpleFeature> getFeaturesList() {
        try (SimpleFeatureIterator featureIterator = this.features();){
            ArrayList<SimpleFeature> featuresList = new ArrayList<SimpleFeature>();
            while (featureIterator.hasNext()) {
                featuresList.add((SimpleFeature)featureIterator.next());
            }
            ArrayList<SimpleFeature> arrayList = featuresList;
            return arrayList;
        }
    }

    class ComplexToSimpleFeatureIterator
    implements SimpleFeatureIterator {
        private FeatureIterator<Feature> delegate;

        public ComplexToSimpleFeatureIterator(FeatureIterator<Feature> delegate) {
            this.delegate = delegate;
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public SimpleFeature next() throws NoSuchElementException {
            SimpleFeature simpleFeature = this.convert(this.delegate.next());
            LOGGER.log(Level.FINE, "Converted simple feature: {0}", simpleFeature);
            return simpleFeature;
        }

        private SimpleFeature convert(Feature feature) {
            SimpleFeatureBuilder builder = new SimpleFeatureBuilder(ComplexToSimpleFeatureCollection.this.featureType);
            for (PropertyDescriptor descriptor : ComplexToSimpleFeatureCollection.this.featureType.getDescriptors()) {
                Name name = descriptor.getName();
                Object attributeValue = this.getComplexAttributeValue(name, feature);
                builder.set(name, attributeValue);
            }
            return builder.buildFeature(feature.getIdentifier().getID());
        }

        private Object getComplexAttributeValue(Name name, Feature feature) {
            String simpleName = name.getLocalPart();
            String attrPath = ComplexToSimpleFeatureCollection.this.rulesMap.get(simpleName);
            if (attrPath != null) {
                AttributeExpressionImpl expression = new AttributeExpressionImpl(attrPath, ComplexToSimpleFeatureCollection.this.namespaceSupport);
                return expression.evaluate((Object)feature);
            }
            Optional<Property> propertyOpt = feature.getProperties().stream().filter(prop -> simpleName.equals(prop.getName().getLocalPart())).findFirst();
            if (propertyOpt.isPresent()) {
                return propertyOpt.get().getValue();
            }
            return null;
        }

        public void close() {
            this.delegate.close();
        }
    }
}

