/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.DefaultIdMockData;
import org.geoserver.test.GeoPackageUtil;
import org.junit.Test;
import org.w3c.dom.Document;

public class DefaultIdTest
extends AbstractAppSchemaTestSupport {
    private static String ID_PREFIX;

    @Override
    protected DefaultIdMockData createTestData() {
        ID_PREFIX = "";
        if (System.getProperty("testDatabase") != null) {
            ID_PREFIX = "MAPPEDFEATURENOID.";
        }
        return new DefaultIdMockData();
    }

    @Test
    public void testGetFeature() {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=gsml:MappedFeature");
        LOGGER.info("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=gsml:MappedFeature Response:\n" + this.prettyString(doc));
        this.assertXpathCount(4, "//gsml:MappedFeature", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='" + ID_PREFIX + "1']", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='" + ID_PREFIX + "1']/gsml:specification/gsml:GeologicUnit", doc);
        this.assertXpathEvaluatesTo("gu.25699", "//gsml:MappedFeature[@gml:id='" + ID_PREFIX + "1']/gsml:specification/gsml:GeologicUnit/@gml:id", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='" + ID_PREFIX + "2']", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='" + ID_PREFIX + "2']/gsml:specification/gsml:GeologicUnit", doc);
        this.assertXpathEvaluatesTo("gu.25678", "//gsml:MappedFeature[@gml:id='" + ID_PREFIX + "2']/gsml:specification/gsml:GeologicUnit/@gml:id", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='" + ID_PREFIX + "3']", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='" + ID_PREFIX + "3']/gsml:specification", doc);
        this.assertXpathEvaluatesTo("#gu.25678", "//gsml:MappedFeature[@gml:id='" + ID_PREFIX + "3']/gsml:specification/@xlink:href", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='" + ID_PREFIX + "4']", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='" + ID_PREFIX + "4']/gsml:specification/gsml:GeologicUnit", doc);
        this.assertXpathEvaluatesTo("gu.25682", "//gsml:MappedFeature[@gml:id='" + ID_PREFIX + "4']/gsml:specification/gsml:GeologicUnit/@gml:id", doc);
    }

    @Test
    public void testGetFeatureWithFilter() {
        Document doc = !GeoPackageUtil.isGeopkgTest() ? this.getAsDOM("wfs?service=WFS&version=1.1.0&request=GetFeature&typename=gsml:MappedFeature&BBOX=-35,96,-12,118") : this.getAsDOM("wfs?service=WFS&version=1.1.0&request=GetFeature&typename=gsml:MappedFeature&BBOX=96,-35,118,-12");
        LOGGER.info("wfs?service=WFS&version=1.1.0&request=GetFeature&typename=gsml:MappedFeature&BBOX=-35,96,-12,118 response:\n" + this.prettyString(doc));
        this.assertXpathCount(2, "//gsml:MappedFeature", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='" + ID_PREFIX + "3']", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='" + ID_PREFIX + "3']/gsml:specification/gsml:GeologicUnit", doc);
        this.assertXpathEvaluatesTo("gu.25678", "//gsml:MappedFeature[@gml:id='" + ID_PREFIX + "3']/gsml:specification/gsml:GeologicUnit/@gml:id", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='" + ID_PREFIX + "4']", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='" + ID_PREFIX + "4']/gsml:specification/gsml:GeologicUnit", doc);
        this.assertXpathEvaluatesTo("gu.25682", "//gsml:MappedFeature[@gml:id='" + ID_PREFIX + "4']/gsml:specification/gsml:GeologicUnit/@gml:id", doc);
    }
}

