/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.util.HashMap;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.StationsMockData;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public final class IsolatedNamespacesWfsTest
extends AbstractAppSchemaTestSupport {
    private static final String STATIONS_1_PREFIX_GML31 = "st_1_gml31";
    private static final String MEASUREMENTS_1_PREFIX_GML31 = "ms_1_gml31";
    private static final String STATIONS_1_PREFIX_GML32 = "st_1_gml32";
    private static final String MEASUREMENTS_1_PREFIX_GML32 = "ms_1_gml32";
    private static final String STATIONS_2_PREFIX_GML31 = "st_2_gml31";
    private static final String MEASUREMENTS_2_PREFIX_GML31 = "ms_2_gml31";
    private static final String STATIONS_2_PREFIX_GML32 = "st_2_gml32";
    private static final String MEASUREMENTS_2_PREFIX_GML32 = "ms_2_gml32";
    private XpathEngine WFS11_XPATH_ENGINE;
    private XpathEngine WFS20_XPATH_ENGINE;

    @Before
    public void beforeTest() {
        this.WFS11_XPATH_ENGINE = StationsMockData.buildXpathEngine(this.getTestData().getNamespaces(), "wfs", "http://www.opengis.net/wfs", "gml", "http://www.opengis.net/gml");
        this.WFS20_XPATH_ENGINE = StationsMockData.buildXpathEngine(this.getTestData().getNamespaces(), "ows", "http://www.opengis.net/ows/1.1", "wfs", "http://www.opengis.net/wfs/2.0", "gml", "http://www.opengis.net/gml/3.2");
    }

    @Override
    protected StationsMockData createTestData() {
        return new MockData();
    }

    @Test
    public void testIsolatedWorkspacesWithFirstUseCaseWfs11() {
        Document document = this.getAsDOM("st_1_gml31/wfs?request=GetFeature&version=1.1.0&typename=st_1_gml31:Station_gml31");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_1_gml31:Station_gml31[@gml:id='st.1'][st_1_gml31:name='isolated_1_station1']");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_1_gml31:Station_gml31[@gml:id='st.1']/st_1_gml31:measurements/ms_1_gml31:Measurement_gml31[ms_1_gml31:name='isolated_1_temperature']");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_1_gml31:Station_gml31[@gml:id='st.1']/st_1_gml31:measurements/ms_1_gml31:Measurement_gml31[ms_1_gml31:name='isolated_1_wind']");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_1_gml31:Station_gml31[@gml:id='st.1']/st_1_gml31:location/gml:Point[gml:pos='1 -1']");
        document = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=st_1_gml31:Station_gml31");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/ows:ExceptionReport/ows:Exception[@exceptionCode='InvalidParameterValue']");
    }

    @Test
    public void testIsolatedWorkspacesWithFirstUseCaseWfs20() {
        Document document = this.getAsDOM("st_1_gml32/wfs?request=GetFeature&version=2.0&typename=st_1_gml32:Station_gml32");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_1_gml32:Station_gml32[@gml:id='st.1'][st_1_gml32:name='isolated_1_station1']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_1_gml32:Station_gml32[@gml:id='st.1']/st_1_gml32:measurements/ms_1_gml32:Measurement_gml32[ms_1_gml32:name='isolated_1_temperature']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_1_gml32:Station_gml32[@gml:id='st.1']/st_1_gml32:measurements/ms_1_gml32:Measurement_gml32[ms_1_gml32:name='isolated_1_wind']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_1_gml32:Station_gml32[@gml:id='st.1']/st_1_gml32:location/gml:Point[gml:pos='1 -1']");
        document = this.getAsDOM("wfs?request=GetFeature&version=2.0&typename=st_1_gml32:Station_gml32");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/ows:ExceptionReport/ows:Exception[@exceptionCode='InvalidParameterValue']");
    }

    @Test
    public void testIsolatedWorkspacesWithSecondUseCaseWfs11() {
        Document document = this.getAsDOM("st_2_gml31/wfs?request=GetFeature&version=1.1.0&typename=st_2_gml31:Station_gml31");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_2_gml31:Station_gml31[@gml:id='st.1'][st_2_gml31:name='isolated_2_station1']");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_2_gml31:Station_gml31[@gml:id='st.1']/st_2_gml31:measurements/ms_2_gml31:Measurement_gml31[ms_2_gml31:name='isolated_2_temperature']");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_2_gml31:Station_gml31[@gml:id='st.1']/st_2_gml31:measurements/ms_2_gml31:Measurement_gml31[ms_2_gml31:name='isolated_2_wind']");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_2_gml31:Station_gml31[@gml:id='st.1']/st_2_gml31:location/gml:Point[gml:pos='1 -1']");
        document = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=st_2_gml31:Station_gml31");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/ows:ExceptionReport/ows:Exception[@exceptionCode='InvalidParameterValue']");
    }

    @Test
    public void testIsolatedWorkspacesWithSecondUseCaseWfs20() {
        Document document = this.getAsDOM("st_2_gml32/wfs?request=GetFeature&version=2.0&typename=st_2_gml32:Station_gml32");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_2_gml32:Station_gml32[@gml:id='st.1'][st_2_gml32:name='isolated_2_station1']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_2_gml32:Station_gml32[@gml:id='st.1']/st_2_gml32:measurements/ms_2_gml32:Measurement_gml32[ms_2_gml32:name='isolated_2_temperature']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_2_gml32:Station_gml32[@gml:id='st.1']/st_2_gml32:measurements/ms_2_gml32:Measurement_gml32[ms_2_gml32:name='isolated_2_wind']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_2_gml32:Station_gml32[@gml:id='st.1']/st_2_gml32:location/gml:Point[gml:pos='1 -1']");
        document = this.getAsDOM("wfs?request=GetFeature&version=2.0&typename=st_2_gml32:Station_gml32");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/ows:ExceptionReport/ows:Exception[@exceptionCode='InvalidParameterValue']");
    }

    private void checkCount(XpathEngine xpathEngine, Document document, int expectedCount, String xpath) {
        try {
            MatcherAssert.assertThat((Object)xpathEngine.getMatchingNodes(xpath, document).getLength(), (Matcher)CoreMatchers.is((Object)expectedCount));
        }
        catch (Exception exception) {
            throw new RuntimeException("Error evaluating xpath.", exception);
        }
    }

    private static final class MockData
    extends StationsMockData {
        private MockData() {
        }

        @Override
        public void addContent() {
            HashMap<String, String> gml31Parameters = new HashMap<String, String>();
            gml31Parameters.put("GML_PREFIX", "gml31");
            gml31Parameters.put("GML_NAMESPACE", "http://www.opengis.net/gml");
            gml31Parameters.put("GML_LOCATION", "http://schemas.opengis.net/gml/3.1.1/base/gml.xsd");
            HashMap<String, String> gml32Parameters = new HashMap<String, String>();
            gml32Parameters.put("GML_PREFIX", "gml32");
            gml32Parameters.put("GML_NAMESPACE", "http://www.opengis.net/gml/3.2");
            gml32Parameters.put("GML_LOCATION", "http://schemas.opengis.net/gml/3.2.1/gml.xsd");
            this.putIsolatedNamespace(IsolatedNamespacesWfsTest.STATIONS_1_PREFIX_GML31, "http://www.stations_gml31.org/1.0");
            this.putIsolatedNamespace(IsolatedNamespacesWfsTest.MEASUREMENTS_1_PREFIX_GML31, "http://www.measurements_gml31.org/1.0");
            this.putIsolatedNamespace(IsolatedNamespacesWfsTest.STATIONS_1_PREFIX_GML32, "http://www.stations_gml32.org/1.0");
            this.putIsolatedNamespace(IsolatedNamespacesWfsTest.MEASUREMENTS_1_PREFIX_GML32, "http://www.measurements_gml32.org/1.0");
            gml31Parameters.put("USE_CASE", "1");
            gml32Parameters.put("USE_CASE", "1");
            this.addMeasurementFeatureType(IsolatedNamespacesWfsTest.MEASUREMENTS_1_PREFIX_GML31, "gml31", "measurements1", "isolatedNamespaces/measurements1.xml", gml31Parameters);
            this.addStationFeatureType(IsolatedNamespacesWfsTest.STATIONS_1_PREFIX_GML31, "gml31", "stations1", "isolatedNamespaces/stations1.xml", gml31Parameters);
            this.addMeasurementFeatureType(IsolatedNamespacesWfsTest.MEASUREMENTS_1_PREFIX_GML32, "gml32", "measurements1", "isolatedNamespaces/measurements1.xml", gml32Parameters);
            this.addStationFeatureType(IsolatedNamespacesWfsTest.STATIONS_1_PREFIX_GML32, "gml32", "stations1", "isolatedNamespaces/stations1.xml", gml32Parameters);
            this.putIsolatedNamespace(IsolatedNamespacesWfsTest.STATIONS_2_PREFIX_GML31, "http://www.stations_gml31.org/1.0");
            this.putIsolatedNamespace(IsolatedNamespacesWfsTest.MEASUREMENTS_2_PREFIX_GML31, "http://www.measurements_gml31.org/1.0");
            this.putIsolatedNamespace(IsolatedNamespacesWfsTest.STATIONS_2_PREFIX_GML32, "http://www.stations_gml32.org/1.0");
            this.putIsolatedNamespace(IsolatedNamespacesWfsTest.MEASUREMENTS_2_PREFIX_GML32, "http://www.measurements_gml32.org/1.0");
            gml31Parameters.put("USE_CASE", "2");
            gml32Parameters.put("USE_CASE", "2");
            this.addStationFeatureType(IsolatedNamespacesWfsTest.STATIONS_2_PREFIX_GML31, "gml31", "stations2", "isolatedNamespaces/stations2.xml", "measurements2", "isolatedNamespaces/measurements2.xml", gml31Parameters);
            this.addStationFeatureType(IsolatedNamespacesWfsTest.STATIONS_2_PREFIX_GML32, "gml32", "stations2", "isolatedNamespaces/stations2.xml", "measurements2", "isolatedNamespaces/measurements2.xml", gml32Parameters);
        }
    }
}

