/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.AliasStationsMockData;
import org.geoserver.test.StationsMockData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;

public final class LayersNamesAliasingTest
extends AbstractAppSchemaTestSupport {
    private XpathEngine WFS11_XPATH_ENGINE;
    private XpathEngine WFS20_XPATH_ENGINE;
    private static Path testFolderPath;

    @BeforeClass
    public static void prepare() throws IOException {
        testFolderPath = Files.createTempDirectory(Paths.get("target/test-classes", new String[0]), "layernames", new FileAttribute[0]);
        File srcDir = new File("target/test-classes/test-data/stations/layerNamesTest");
        File destDir = Paths.get(testFolderPath.toString(), "layerNamesTest").toFile();
        destDir.deleteOnExit();
        FileUtils.copyDirectory((File)srcDir, (File)destDir);
    }

    @Before
    public void beforeTest() {
        this.WFS11_XPATH_ENGINE = StationsMockData.buildXpathEngine(this.getBaseNamespaces(), "wfs", "http://www.opengis.net/wfs", "gml", "http://www.opengis.net/gml");
        this.WFS20_XPATH_ENGINE = StationsMockData.buildXpathEngine(this.getBaseNamespaces(), "wfs", "http://www.opengis.net/wfs/2.0", "gml", "http://www.opengis.net/gml/3.2");
    }

    @Override
    protected AliasStationsMockData createTestData() {
        return new AliasStationsMockData(){

            @Override
            protected Optional<String> extraStationFeatures() {
                String features = "\nst.2=st.2|station2|32154895|station2@stations.org|POINT(-1.0E-7 1.0E-7)";
                return Optional.of(features);
            }

            @Override
            protected Optional<String> extraMeasurementFeatures() {
                String features = "\nms.3=ms.3|wind|km/h|st.2";
                return Optional.of(features);
            }
        };
    }

    Map<String, String> getBaseNamespaces() {
        HashMap<String, String> nss = new HashMap<String, String>();
        nss.put("st_gml31", "http://www.stations_gml31.org/1.0");
        nss.put("ms_gml31", "http://www.measurements_gml31.org/1.0");
        nss.put("st_gml32", "http://www.stations_gml32.org/1.0");
        nss.put("ms_gml32", "http://www.measurements_gml32.org/1.0");
        return nss;
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo info = catalog.getFeatureTypeByName("st_gml31", "lyr_Station_gml31");
        info.setEnabled(true);
        info.setNativeName("Station_gml31");
        catalog.save((ResourceInfo)info);
        info = catalog.getFeatureTypeByName("st_gml32", "lyr_Station_gml32");
        info.setEnabled(true);
        info.setNativeName("Station_gml32");
        catalog.save((ResourceInfo)info);
    }

    @Test
    public void testAliasedNameWfsGetFeature11() throws Exception {
        Document document = this.getAsDOM("ows?service=wfs&request=GetFeature&version=1.1.0&typenames=st_gml31:lyr_Station_gml31");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 2, "//wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31");
    }

    @Test
    public void testAliasedNameWfsGetFeature20() throws Exception {
        Document document = this.getAsDOM("wfs?request=GetFeature&version=2.0.0&typeNames=st_gml32:lyr_Station_gml32");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 2, "//wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32");
    }

    @Test
    public void testAliasedNameWfsGetFeaturePost11() throws Exception {
        String xmlQuery = this.resourceToString("wfs110query.xml");
        Document document = this.postAsDOM("wfs", xmlQuery);
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "//wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31");
    }

    @Test
    public void testAliasedNameWfsGetFeaturePost20() throws Exception {
        String xmlQuery = this.resourceToString("wfs200query.xml");
        Document document = this.postAsDOM("wfs", xmlQuery);
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "//wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32");
    }

    @Test
    public void testLocalWorkspaceNoPrefixWfsGetFeature11() throws Exception {
        Document document = this.getAsDOM("st_gml31/wfs?request=GetFeature&version=1.1.0&typename=lyr_Station_gml31");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 2, "//wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31");
    }

    @Test
    public void testLocalWorkspaceNoPrefixWfsGetFeature20() throws Exception {
        Document document = this.getAsDOM("st_gml32/wfs?request=GetFeature&version=2.0.0&typeNames=lyr_Station_gml32");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 2, "//wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32");
    }

    @Test
    public void testLocalWorkspaceNoPrefixWfsGetFeaturePost11() throws Exception {
        String xmlQuery = this.resourceToString("wfs110queryNoPrefix.xml");
        Document document = this.postAsDOM("st_gml31/wfs", xmlQuery);
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "//wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31");
    }

    @Test
    public void testLocalWorkspaceNoPrefixWfsGetFeaturePost20() throws Exception {
        String xmlQuery = this.resourceToString("wfs200queryNoPrefix.xml");
        Document document = this.postAsDOM("st_gml32/wfs", xmlQuery);
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "//wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32");
    }

    @Test
    public void testDefaultCqlNameWfsGetFeature11() throws Exception {
        try {
            this.setCqlFilter("st_gml31", "lyr_Station_gml31", "st_gml31:Station_gml31.st_gml31:name='station2'");
            Document document = this.getAsDOM("ows?service=wfs&request=GetFeature&version=1.1.0&typenames=st_gml31:lyr_Station_gml31");
            this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "//wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31");
            this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "//wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id='st.2']");
        }
        finally {
            this.cleanCqlFilter("st_gml31", "lyr_Station_gml31");
        }
    }

    @Test
    public void testDefaultCqlWfsGetFeature20() throws Exception {
        try {
            this.setCqlFilter("st_gml32", "lyr_Station_gml32", "st_gml32:Station_gml32.st_gml32:name='station2'");
            Document document = this.getAsDOM("wfs?request=GetFeature&version=2.0.0&typeNames=st_gml32:lyr_Station_gml32");
            this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "//wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32");
            this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "//wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id='st.2']");
        }
        finally {
            this.cleanCqlFilter("st_gml32", "lyr_Station_gml32");
        }
    }

    private String resourceToString(String filename) throws IOException {
        return IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("test-data/stations/layerNamesTest/" + filename), (Charset)StandardCharsets.UTF_8);
    }

    private void checkCount(XpathEngine xpathEngine, Document document, int expectedCount, String xpath) {
        try {
            Assert.assertEquals((long)expectedCount, (long)xpathEngine.getMatchingNodes(xpath, document).getLength());
        }
        catch (Exception exception) {
            throw new RuntimeException("Error evaluating xpath.", exception);
        }
    }

    private void setCqlFilter(String namespace, String layerName, String cql) {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo info = catalog.getFeatureTypeByName(namespace, layerName);
        info.setCqlFilter(cql);
        catalog.save((ResourceInfo)info);
    }

    private void cleanCqlFilter(String namespace, String layerName) {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo info = catalog.getFeatureTypeByName(namespace, layerName);
        info.setCqlFilter(null);
        catalog.save((ResourceInfo)info);
    }
}

