/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.MappingNameMockData;
import org.junit.Test;
import org.w3c.dom.Document;

public class MappingNameTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected MappingNameMockData createTestData() {
        return new MappingNameMockData();
    }

    @Test
    public void testGetFeature() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typeName=gsml:MappedFeature");
        LOGGER.info("WFS GetFeature response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//wfs:FeatureCollection", doc);
        this.assertXpathEvaluatesTo("4", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(4, "//gsml:MappedFeature", doc);
        this.assertXpathEvaluatesTo("value01", "/wfs:FeatureCollection/gml:featureMember/gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:observationMethod/gsml:CGI_TermValue/gsml:value[@codeSpace='codespace01']", doc);
        this.assertXpathEvaluatesTo("value02", "/wfs:FeatureCollection/gml:featureMember//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:observationMethod/gsml:CGI_TermValue/gsml:value[@codeSpace='codespace02']", doc);
        this.assertXpathEvaluatesTo("value02", "/wfs:FeatureCollection/gml:featureMember//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:observationMethod/gsml:CGI_TermValue/gsml:value[@codeSpace='codespace02']", doc);
        this.assertXpathEvaluatesTo("value03", "/wfs:FeatureCollection/gml:featureMember//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gsml:observationMethod/gsml:CGI_TermValue/gsml:value[@codeSpace='codespace03']", doc);
    }
}

