/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.util.Collections;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.StationsMockData;
import org.junit.Test;
import org.w3c.dom.Document;

public class NoIdExpressionTest
extends AbstractAppSchemaTestSupport {
    private static final String STATIONS_PREFIX = "st";
    private static final String STATIONS_URI = "http://www.stations.org/1.0";

    @Override
    protected StationsMockData createTestData() {
        return new MockData();
    }

    @Test
    public void testGetFeatureSimpleFilter() {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=st:Station&maxFeatures=50&cql_filter=st:name = 'station1'");
        LOGGER.info("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=st:Station&maxFeatures=50&cql_filter=st:name = 'station1' Response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//st:Station", doc);
        this.assertXpathEvaluatesTo("station1", "//st:Station/st:name", doc);
    }

    @Test
    public void testGetFeatureNestedFilter() {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=st:Station&maxFeatures=50&startIndex=2");
        LOGGER.info("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=st:Station&maxFeatures=50&startIndex=1 Response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//st:Station", doc);
        this.assertXpathEvaluatesTo("station3", "//st:Station/st:name", doc);
    }

    @Test
    public void testGetFeatureStartIndex() {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=st:Station&maxFeatures=50&startIndex=2");
        LOGGER.info("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=st:Station&maxFeatures=50&startIndex=2 Response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//st:Station", doc);
        this.assertXpathEvaluatesTo("station3", "//st:Station/st:name", doc);
    }

    private static final class MockData
    extends StationsMockData {
        private MockData() {
        }

        @Override
        public void addContent() {
            this.putNamespace(NoIdExpressionTest.STATIONS_PREFIX, NoIdExpressionTest.STATIONS_URI);
            this.addAppSchemaFeatureType(NoIdExpressionTest.STATIONS_PREFIX, null, "Station", "/test-data/stations/noIdExpr/stations.xml", Collections.emptyMap(), "/test-data/stations/noIdExpr/stations.xsd", "/test-data/stations/noIdExpr/institutes.xml", "/test-data/stations/noIdExpr/persons.xml", "/test-data/stations/noIdExpr/stations.properties", "/test-data/stations/noIdExpr/institutes.properties", "/test-data/stations/noIdExpr/persons.properties");
        }
    }
}

