/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.regex.Matcher;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geoserver.test.onlineTest.setup.AppSchemaTestOracleSetup;
import org.geoserver.test.onlineTest.setup.AppSchemaTestPostgisSetup;
import org.geoserver.test.onlineTest.support.AbstractReferenceDataSetup;
import org.geoserver.util.IOUtils;
import org.geoserver.wfs.WFSInfo;
import org.geotools.appschema.resolver.xml.AppSchemaXSDRegistry;
import org.geotools.data.complex.AppSchemaDataAccessRegistry;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.xml.resolver.SchemaCache;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class RestconfigWfsTest
extends CatalogRESTTestSupport {
    private static final String WORKSPACE = "<workspace><name>gsml</name></workspace>";
    private static final String NAMESPACE = "<namespace><uri>urn:cgi:xmlns:CGI:GeoSciML:2.0</uri></namespace>";
    private static final String DATASTORE = "<dataStore><name>MappedFeature</name><enabled>true</enabled><workspace><name>gsml</name></workspace><type>Application Schema DataAccess</type><connectionParameters><entry key='dbtype'>app-schema</entry><entry key='url'>file:workspaces/gsml/MappedFeature/MappedFeature.xml</entry><entry key='namespace'>urn:cgi:xmlns:CGI:GeoSciML:2.0</entry></connectionParameters></dataStore>";
    private static final String FEATURETYPE = "<featureType><name>MappedFeature</name><nativeName>MappedFeature</nativeName><namespace><prefix>gsml</prefix></namespace><title>... TITLE ...</title><abstract>... ABSTRACT ...</abstract><srs>EPSG:4326</srs><latLonBoundingBox><minx>-180</minx><maxx>180</maxx><miny>-90</miny><maxy>90</maxy><crs>EPSG:4326</crs></latLonBoundingBox><projectionPolicy>REPROJECT_TO_DECLARED</projectionPolicy><enabled>true</enabled><metadata><entry key='kml.regionateFeatureLimit'>10</entry><entry key='indexingEnabled'>false</entry><entry key='cachingEnabled'>false</entry></metadata><store class='dataStore'><name>MappedFeature</name></store><maxFeatures>0</maxFeatures><numDecimals>0</numDecimals></featureType>";
    public static final String DS_PARAMETERS = "<parameters><Parameter><name>directory</name><value>file:./</value></Parameter></parameters>";
    public static final String MAPPING = "<as:AppSchemaDataAccess xmlns:as='http://www.geotools.org/app-schema'><namespaces><Namespace><prefix>gsml</prefix><uri>urn:cgi:xmlns:CGI:GeoSciML:2.0</uri></Namespace></namespaces><sourceDataStores><DataStore><id>datastore</id><parameters><Parameter><name>directory</name><value>file:./</value></Parameter></parameters></DataStore></sourceDataStores><targetTypes><FeatureType><schemaUri>http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd</schemaUri></FeatureType></targetTypes><typeMappings><FeatureTypeMapping><sourceDataStore>datastore</sourceDataStore><sourceType>MAPPEDFEATURE</sourceType><targetElement>gsml:MappedFeature</targetElement><attributeMappings><AttributeMapping><targetAttribute>gsml:shape</targetAttribute><sourceExpression><OCQL>SHAPE</OCQL></sourceExpression></AttributeMapping></attributeMappings></FeatureTypeMapping></typeMappings></as:AppSchemaDataAccess>";
    public static final String PROPERTIES = "_=SHAPE:Geometry:srid=4326\nmf.1=POINT(0 1)\nmf.2=POINT(2 3)\n";

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        WFSInfo wfs = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        wfs.setCanonicalSchemaLocation(true);
        wfs.setEncodeFeatureMember(true);
        this.getGeoServer().save((ServiceInfo)wfs);
        SchemaCache.disableAutomaticConfiguration();
    }

    protected void onTearDown(SystemTestData testData) throws Exception {
        super.onTearDown(testData);
        DataAccessRegistry.getInstance().disposeAndUnregisterAll();
        AppSchemaDataAccessRegistry.clearAppSchemaProperties();
        AppSchemaXSDRegistry.getInstance().dispose();
    }

    @Test
    public void testRestconfig() throws Exception {
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces", WORKSPACE, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        WorkspaceInfo ws = this.getCatalog().getWorkspaceByName("gsml");
        Assert.assertNotNull((Object)ws);
        response = this.putAsServletResponse("/rest/namespaces/gsml", NAMESPACE, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        NamespaceInfo ns = this.getCatalog().getNamespaceByPrefix("gsml");
        Assert.assertNotNull((Object)ns);
        Assert.assertEquals((Object)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (Object)ns.getURI());
        response = this.postAsServletResponse("/rest/workspaces/gsml/datastores", DATASTORE, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        DataStoreInfo ds = this.getCatalog().getDataStoreByName("gsml", "MappedFeature");
        Assert.assertNotNull((Object)ds);
        this.copyFiles();
        response = this.postAsServletResponse("/rest/workspaces/gsml/datastores/MappedFeature/featuretypes", FEATURETYPE, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        FeatureTypeInfo ft = this.getCatalog().getFeatureTypeByName("gsml", "MappedFeature");
        Assert.assertNotNull((Object)ft);
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature");
        LOGGER.info("WFS GetFeature&typename=gsml:MappedFeature response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        this.assertXpathCount(2, "//gsml:MappedFeature", doc);
    }

    private void copyFiles() throws Exception {
        File dir = new File(new File(new File(((SystemTestData)this.getTestData()).getDataDirectoryRoot(), "workspaces"), "gsml"), "MappedFeature");
        dir.mkdirs();
        File propertiesFile = new File(dir, "MAPPEDFEATURE.properties");
        IOUtils.copy((InputStream)new ByteArrayInputStream(PROPERTIES.getBytes(StandardCharsets.UTF_8)), (File)propertiesFile);
        String mapping = MAPPING;
        String onlineTestId = System.getProperty("testDatabase");
        if (onlineTestId != null) {
            AbstractReferenceDataSetup setup;
            onlineTestId = onlineTestId.trim().toLowerCase();
            HashMap<String, File> propertyFiles = new HashMap<String, File>();
            propertyFiles.put(propertiesFile.getName(), dir);
            if (onlineTestId.equals("oracle")) {
                mapping = mapping.replaceAll(DS_PARAMETERS, Matcher.quoteReplacement(AppSchemaTestOracleSetup.DB_PARAMS));
                setup = AppSchemaTestOracleSetup.getInstance(propertyFiles);
            } else {
                mapping = mapping.replaceAll(DS_PARAMETERS, Matcher.quoteReplacement(AppSchemaTestPostgisSetup.DB_PARAMS));
                setup = AppSchemaTestPostgisSetup.getInstance(propertyFiles);
            }
            setup.setUp();
            setup.tearDown();
        }
        IOUtils.copy((InputStream)new ByteArrayInputStream(mapping.getBytes(StandardCharsets.UTF_8)), (File)new File(dir, "MappedFeature.xml"));
    }

    private String prettyString(Document document) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.prettyPrint(document, output);
        return ((Object)output).toString();
    }

    private void prettyPrint(Document document, OutputStream output) {
        try {
            Transformer tx = TransformerFactory.newInstance().newTransformer();
            tx.setOutputProperty("indent", "yes");
            tx.transform(new DOMSource(document), new StreamResult(output));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void assertXpathCount(int count, String xpath, Document document) throws Exception {
        XpathEngine xpathEngine = XMLUnit.newXpathEngine();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("wfs", "http://www.opengis.net/wfs");
        namespaces.put("gsml", "urn:cgi:xmlns:CGI:GeoSciML:2.0");
        xpathEngine.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        Assert.assertEquals((long)count, (long)xpathEngine.getMatchingNodes(xpath, document).getLength());
    }
}

