/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.awt.RenderingHints;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.SRSMockData;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.JTS;
import org.geotools.gml.producer.CoordinateFormatter;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.w3c.dom.Document;

public class SRSWfsTest
extends AbstractAppSchemaTestSupport {
    final String EPSG_4326 = "urn:x-ogc:def:crs:EPSG:4326";
    final String EPSG_4283 = "urn:x-ogc:def:crs:EPSG:4283";
    final String DIMENSION = "2";

    @Override
    protected SRSMockData createTestData() {
        return new SRSMockData();
    }

    protected void setUpTestData(SystemTestData testData) throws Exception {
        System.setProperty("org.geotools.referencing.forceXY", "false");
        Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)false);
        Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_AXIS_ORDER_HONORING, (Object)"http");
        CRS.reset((String)"all");
        super.setUpTestData(testData);
    }

    @Override
    protected void onTearDown(SystemTestData testData) throws Exception {
        super.onTearDown(testData);
        System.clearProperty("org.geotools.referencing.forceXY");
        Hints.removeSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
        Hints.removeSystemDefault((RenderingHints.Key)Hints.FORCE_AXIS_ORDER_HONORING);
        CRS.reset((String)"all");
    }

    private boolean honorsCrsAxisOrder() {
        String onlineTestId = System.getProperty("testDatabase");
        return "geopkg".equals(onlineTestId) || "postgis".equals(onlineTestId);
    }

    @Test
    public void testGetFeatureContent() throws NoSuchAuthorityCodeException, FactoryException {
        String expectedPoint;
        String expectedLinearRing;
        String id = "1";
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
        Assert.assertEquals((Object)CRS.AxisOrder.NORTH_EAST, (Object)CRS.getAxisOrder((CoordinateReferenceSystem)crs));
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=ex:geomContainer&version=1.1.0");
        LOGGER.info("WFS GetFeature&typename=ex:geomContainer response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("2", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(2, "//ex:geomContainer", doc);
        this.assertXpathEvaluatesTo(id, "(//ex:geomContainer)[1]/@gml:id", doc);
        this.assertXpathEvaluatesTo("1.0", "(//ex:geomContainer)[1]/ex:length", doc);
        this.assertXpathEvaluatesTo("m", "(//ex:geomContainer)[1]/ex:length/@uom", doc);
        this.assertXpathEvaluatesTo("geom_" + id, "(//ex:geomContainer)[1]/ex:geom/gml:Polygon/@gml:id", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4283", "(//ex:geomContainer)[1]/ex:geom/gml:Polygon/@srsName", doc);
        this.assertXpathEvaluatesTo("2", "(//ex:geomContainer)[1]/ex:geom/gml:Polygon/@srsDimension", doc);
        this.assertXpathEvaluatesTo("shape_" + id, "(//ex:geomContainer)[1]/ex:shape/gml:LineString/@gml:id", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4283", "(//ex:geomContainer)[1]/ex:shape/gml:LineString/@srsName", doc);
        this.assertXpathEvaluatesTo("2", "(//ex:geomContainer)[1]/ex:shape/gml:LineString/@srsDimension", doc);
        this.assertXpathEvaluatesTo("nested_one_2", "(//ex:geomContainer)[1]/ex:nestedFeature[1]/ex:nestedGeom/@gml:id", doc);
        this.assertXpathEvaluatesTo("nested_one_geom_2", "(//ex:geomContainer)[1]/ex:nestedFeature[1]/ex:nestedGeom/ex:geom/gml:Point/@gml:id", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4283", "(//ex:geomContainer)[1]/ex:nestedFeature[1]/ex:nestedGeom/ex:geom/gml:Point/@srsName", doc);
        this.assertXpathEvaluatesTo("2", "(//ex:geomContainer)[1]/ex:nestedFeature[1]/ex:nestedGeom/ex:geom/gml:Point/@srsDimension", doc);
        this.assertXpathEvaluatesTo("nested_two_" + id, "(//ex:geomContainer)[1]/ex:nestedFeature[2]/ex:nestedGeom/@gml:id", doc);
        this.assertXpathEvaluatesTo("nested_two_geom_" + id, "(//ex:geomContainer)[1]/ex:nestedFeature[2]/ex:nestedGeom/ex:geom/gml:Polygon/@gml:id", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4283", "(//ex:geomContainer)[1]/ex:nestedFeature[2]/ex:nestedGeom/ex:geom/gml:Polygon/@srsName", doc);
        this.assertXpathEvaluatesTo("2", "(//ex:geomContainer)[1]/ex:nestedFeature[2]/ex:nestedGeom/ex:geom/gml:Polygon/@srsDimension", doc);
        if (this.honorsCrsAxisOrder()) {
            expectedLinearRing = "52.5 -1.2 52.6 -1.2 52.6 -1.1 52.5 -1.1 52.5 -1.2";
            expectedPoint = "31.29 42.58";
        } else {
            expectedLinearRing = "-1.2 52.5 -1.2 52.6 -1.1 52.6 -1.1 52.5 -1.2 52.5";
            expectedPoint = "42.58 31.29";
        }
        this.assertXpathEvaluatesTo(expectedLinearRing, "(//ex:geomContainer)[1]/ex:geom/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList", doc);
        this.assertXpathEvaluatesTo(expectedLinearRing, "(//ex:geomContainer)[1]/ex:shape/gml:LineString/gml:posList", doc);
        this.assertXpathEvaluatesTo(expectedPoint, "(//ex:geomContainer)[1]/ex:nestedFeature[1]/ex:nestedGeom/ex:geom/gml:Point/gml:pos", doc);
        this.assertXpathEvaluatesTo(expectedLinearRing, "(//ex:geomContainer)[1]/ex:nestedFeature[2]/ex:nestedGeom/ex:geom/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList", doc);
        id = "2";
        this.assertXpathEvaluatesTo(id, "(//ex:geomContainer)[2]/@gml:id", doc);
        this.assertXpathEvaluatesTo("1.0", "(//ex:geomContainer)[2]/ex:length", doc);
        this.assertXpathEvaluatesTo("m", "(//ex:geomContainer)[2]/ex:length/@uom", doc);
        this.assertXpathEvaluatesTo("geom_" + id, "(//ex:geomContainer)[2]/ex:geom/gml:Point/@gml:id", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4283", "(//ex:geomContainer)[2]/ex:geom/gml:Point/@srsName", doc);
        this.assertXpathEvaluatesTo("2", "(//ex:geomContainer)[2]/ex:geom/gml:Point/@srsDimension", doc);
        this.assertXpathEvaluatesTo("shape_" + id, "(//ex:geomContainer)[2]/ex:shape/gml:LineString/@gml:id", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4283", "(//ex:geomContainer)[2]/ex:shape/gml:LineString/@srsName", doc);
        this.assertXpathEvaluatesTo("2", "(//ex:geomContainer)[2]/ex:shape/gml:LineString/@srsDimension", doc);
        this.assertXpathEvaluatesTo("nested_one_1", "(//ex:geomContainer)[2]/ex:nestedFeature[1]/ex:nestedGeom/@gml:id", doc);
        this.assertXpathEvaluatesTo("nested_one_geom_1", "(//ex:geomContainer)[2]/ex:nestedFeature[1]/ex:nestedGeom/ex:geom/gml:Polygon/@gml:id", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4283", "(//ex:geomContainer)[2]/ex:nestedFeature[1]/ex:nestedGeom/ex:geom/gml:Polygon/@srsName", doc);
        this.assertXpathEvaluatesTo("2", "(//ex:geomContainer)[2]/ex:nestedFeature[1]/ex:nestedGeom/ex:geom/gml:Polygon/@srsDimension", doc);
        this.assertXpathEvaluatesTo("nested_two_" + id, "(//ex:geomContainer)[2]/ex:nestedFeature[2]/ex:nestedGeom/@gml:id", doc);
        this.assertXpathEvaluatesTo("nested_two_geom_" + id, "(//ex:geomContainer)[2]/ex:nestedFeature[2]/ex:nestedGeom/ex:geom/gml:Point/@gml:id", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4283", "(//ex:geomContainer)[2]/ex:nestedFeature[2]/ex:nestedGeom/ex:geom/gml:Point/@srsName", doc);
        this.assertXpathEvaluatesTo("2", "(//ex:geomContainer)[2]/ex:nestedFeature[2]/ex:nestedGeom/ex:geom/gml:Point/@srsDimension", doc);
        String expectedLineString = this.honorsCrsAxisOrder() ? "31.29 42.58 31.29 42.58" : "42.58 31.29 42.58 31.29";
        this.assertXpathEvaluatesTo(expectedPoint, "(//ex:geomContainer)[2]/ex:geom/gml:Point/gml:pos", doc);
        this.assertXpathEvaluatesTo(expectedLineString, "(//ex:geomContainer)[2]/ex:shape/gml:LineString/gml:posList", doc);
        this.assertXpathEvaluatesTo(expectedLinearRing, "(//ex:geomContainer)[2]/ex:nestedFeature[1]/ex:nestedGeom/ex:geom/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList", doc);
        this.assertXpathEvaluatesTo(expectedPoint, "(//ex:geomContainer)[2]/ex:nestedFeature[2]/ex:nestedGeom/ex:geom/gml:Point/gml:pos", doc);
    }

    @Test
    public void testReproject() throws NoSuchAuthorityCodeException, FactoryException, MismatchedDimensionException, TransformException {
        String targetPolygonCoords;
        Object targetPointCoord;
        if (this.honorsCrsAxisOrder()) {
            targetPointCoord = "31.29000003 42.58";
            targetPolygonCoords = "52.50000004 -1.2 52.60000004 -1.2 52.60000004 -1.1 52.50000004 -1.1 52.50000004 -1.2";
        } else {
            CoordinateReferenceSystem sourceCRS = CRS.decode((String)"urn:x-ogc:def:crs:EPSG:4283");
            CoordinateReferenceSystem targetCRS = CRS.decode((String)"urn:x-ogc:def:crs:EPSG:4326");
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
            GeometryFactory factory = new GeometryFactory();
            Polygon srcPolygon = factory.createPolygon(factory.createLinearRing(factory.getCoordinateSequenceFactory().create(new Coordinate[]{new Coordinate(-1.2, 52.5), new Coordinate(-1.2, 52.6), new Coordinate(-1.1, 52.6), new Coordinate(-1.1, 52.5), new Coordinate(-1.2, 52.5)})), null);
            Polygon targetPolygon = (Polygon)JTS.transform((Geometry)srcPolygon, (MathTransform)transform);
            StringBuffer polygonBuffer = new StringBuffer();
            CoordinateFormatter formatter = new CoordinateFormatter(8);
            for (Coordinate coord : targetPolygon.getCoordinates()) {
                formatter.format(coord.x, polygonBuffer).append(" ");
                formatter.format(coord.y, polygonBuffer).append(" ");
            }
            targetPolygonCoords = polygonBuffer.toString().trim();
            Point targetPoint = (Point)JTS.transform((Geometry)factory.createPoint(new Coordinate(42.58, 31.29)), (MathTransform)transform);
            targetPointCoord = formatter.format(targetPoint.getCoordinate().x) + " " + formatter.format(targetPoint.getCoordinate().y);
        }
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=ex:geomContainer&srsname=urn:x-ogc:def:crs:EPSG::4326");
        LOGGER.info("WFS GetFeature&typename=ex:geomContainer&srsname=urn:x-ogc:def:crs:EPSG::4326 response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("2", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(2, "//ex:geomContainer", doc);
        String id = "1";
        this.assertXpathEvaluatesTo(id, "(//ex:geomContainer)[1]/@gml:id", doc);
        this.assertXpathEvaluatesTo("1.0", "(//ex:geomContainer)[1]/ex:length", doc);
        this.assertXpathEvaluatesTo("m", "(//ex:geomContainer)[1]/ex:length/@uom", doc);
        this.assertXpathEvaluatesTo("geom_" + id, "(//ex:geomContainer)[1]/ex:geom/gml:Polygon/@gml:id", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4326", "//ex:geomContainer[1]/ex:geom/gml:Polygon/@srsName", doc);
        this.assertXpathEvaluatesTo("2", "(//ex:geomContainer)[1]/ex:geom/gml:Polygon/@srsDimension", doc);
        this.assertXpathEvaluatesTo("shape_" + id, "(//ex:geomContainer)[1]/ex:shape/gml:LineString/@gml:id", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4326", "(//ex:geomContainer)[1]/ex:shape/gml:LineString/@srsName", doc);
        this.assertXpathEvaluatesTo("2", "(//ex:geomContainer)[1]/ex:shape/gml:LineString/@srsDimension", doc);
        this.assertXpathEvaluatesTo("nested_one_2", "(//ex:geomContainer)[1]/ex:nestedFeature[1]/ex:nestedGeom/@gml:id", doc);
        this.assertXpathEvaluatesTo("nested_one_geom_2", "(//ex:geomContainer)[1]/ex:nestedFeature[1]/ex:nestedGeom/ex:geom/gml:Point/@gml:id", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4326", "(//ex:geomContainer)[1]/ex:nestedFeature[1]/ex:nestedGeom/ex:geom/gml:Point/@srsName", doc);
        this.assertXpathEvaluatesTo("2", "(//ex:geomContainer)[1]/ex:nestedFeature[1]/ex:nestedGeom/ex:geom/gml:Point/@srsDimension", doc);
        this.assertXpathEvaluatesTo("nested_two_" + id, "(//ex:geomContainer)[1]/ex:nestedFeature[2]/ex:nestedGeom/@gml:id", doc);
        this.assertXpathEvaluatesTo("nested_two_geom_" + id, "(//ex:geomContainer)[1]/ex:nestedFeature[2]/ex:nestedGeom/ex:geom/gml:Polygon/@gml:id", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4326", "(//ex:geomContainer)[1]/ex:nestedFeature[2]/ex:nestedGeom/ex:geom/gml:Polygon/@srsName", doc);
        this.assertXpathEvaluatesTo("2", "(//ex:geomContainer)[1]/ex:nestedFeature[2]/ex:nestedGeom/ex:geom/gml:Polygon/@srsDimension", doc);
        this.assertXpathEvaluatesTo(targetPolygonCoords, "(//ex:geomContainer)[1]/ex:geom/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList", doc);
        this.assertXpathEvaluatesTo(targetPolygonCoords, "(//ex:geomContainer)[1]/ex:shape/gml:LineString/gml:posList", doc);
        this.assertXpathEvaluatesTo(targetPolygonCoords, "(//ex:geomContainer)[1]/ex:nestedFeature[2]/ex:nestedGeom/ex:geom/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList", doc);
        this.assertXpathEvaluatesTo((String)targetPointCoord, "(//ex:geomContainer)[1]/ex:nestedFeature[1]/ex:nestedGeom/ex:geom/gml:Point/gml:pos", doc);
        id = "2";
        this.assertXpathEvaluatesTo(id, "(//ex:geomContainer)[2]/@gml:id", doc);
        this.assertXpathEvaluatesTo("1.0", "(//ex:geomContainer)[2]/ex:length", doc);
        this.assertXpathEvaluatesTo("m", "(//ex:geomContainer)[2]/ex:length/@uom", doc);
        this.assertXpathEvaluatesTo("geom_" + id, "(//ex:geomContainer)[2]/ex:geom/gml:Point/@gml:id", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4326", "(//ex:geomContainer)[2]/ex:geom/gml:Point/@srsName", doc);
        this.assertXpathEvaluatesTo("2", "(//ex:geomContainer)[2]/ex:geom/gml:Point/@srsDimension", doc);
        this.assertXpathEvaluatesTo("shape_" + id, "(//ex:geomContainer)[2]/ex:shape/gml:LineString/@gml:id", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4326", "(//ex:geomContainer)[2]/ex:shape/gml:LineString/@srsName", doc);
        this.assertXpathEvaluatesTo("2", "(//ex:geomContainer)[2]/ex:shape/gml:LineString/@srsDimension", doc);
        this.assertXpathEvaluatesTo("nested_one_1", "(//ex:geomContainer)[2]/ex:nestedFeature[1]/ex:nestedGeom/@gml:id", doc);
        this.assertXpathEvaluatesTo("nested_one_geom_1", "(//ex:geomContainer)[2]/ex:nestedFeature[1]/ex:nestedGeom/ex:geom/gml:Polygon/@gml:id", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4326", "(//ex:geomContainer)[2]/ex:nestedFeature[1]/ex:nestedGeom/ex:geom/gml:Polygon/@srsName", doc);
        this.assertXpathEvaluatesTo("2", "(//ex:geomContainer)[2]/ex:nestedFeature[1]/ex:nestedGeom/ex:geom/gml:Polygon/@srsDimension", doc);
        this.assertXpathEvaluatesTo("nested_two_" + id, "(//ex:geomContainer)[2]/ex:nestedFeature[2]/ex:nestedGeom/@gml:id", doc);
        this.assertXpathEvaluatesTo("nested_two_geom_" + id, "(//ex:geomContainer)[2]/ex:nestedFeature[2]/ex:nestedGeom/ex:geom/gml:Point/@gml:id", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4326", "(//ex:geomContainer)[2]/ex:nestedFeature[2]/ex:nestedGeom/ex:geom/gml:Point/@srsName", doc);
        this.assertXpathEvaluatesTo("2", "(//ex:geomContainer)[2]/ex:nestedFeature[2]/ex:nestedGeom/ex:geom/gml:Point/@srsDimension", doc);
        this.assertXpathEvaluatesTo((String)targetPointCoord, "(//ex:geomContainer)[2]/ex:geom/gml:Point/gml:pos", doc);
        this.assertXpathEvaluatesTo((String)targetPointCoord + " " + (String)targetPointCoord, "(//ex:geomContainer)[2]/ex:shape/gml:LineString/gml:posList", doc);
        this.assertXpathEvaluatesTo(targetPolygonCoords, "(//ex:geomContainer)[2]/ex:nestedFeature[1]/ex:nestedGeom/ex:geom/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList", doc);
        this.assertXpathEvaluatesTo((String)targetPointCoord, "(//ex:geomContainer)[2]/ex:nestedFeature[2]/ex:nestedGeom/ex:geom/gml:Point/gml:pos", doc);
    }

    @Test
    public void testFilters() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=ex:geomContainer&srsname=urn:x-ogc:def:crs:EPSG::4326&featureid=1");
        LOGGER.info("WFS GetFeature&typename=ex:geomContainer&srsname=urn:x-ogc:def:crs:EPSG::4326&featureid=1response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("1", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(1, "//ex:geomContainer", doc);
    }
}

