/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.StationsAppSchemaTestSupport;
import org.geoserver.test.StationsMockData;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.feature.type.Name;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.feature.NameImpl;
import org.geotools.jdbc.JDBCFeatureStore;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleOutputTest
extends StationsAppSchemaTestSupport {
    protected static final String STATIONS_PREFIX_GML31 = "st_gml31";
    protected static final String STATIONS_URI_GML31 = "http://www.stations_gml31.org/1.0";
    protected static final String MEASUREMENTS_PREFIX_GML31 = "ms_gml31";
    protected static final String MEASUREMENTS_URI_GML31 = "http://www.measurements_gml31.org/1.0";
    protected static final String STATIONS_PREFIX_GML32 = "st_gml32";
    protected static final String STATIONS_URI_GML32 = "http://www.stations_gml32.org/1.0";
    protected static final String MEASUREMENTS_PREFIX_GML32 = "ms_gml32";
    protected static final String MEASUREMENTS_URI_GML32 = "http://www.measurements_gml32.org/1.0";
    public static final String RULES_METADATAMAP_KEY = "ComplexToSimpleRules";
    protected final XpathEngine xpath = SimpleOutputTest.buildKmlXpathEngine();

    @Override
    protected StationsMockData createTestData() {
        return new MockData();
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        this.activateLayer(STATIONS_PREFIX_GML32, "Station_gml32");
        this.setupSimpleOutput(STATIONS_PREFIX_GML32, "Station_gml32");
        this.activateLayer(STATIONS_PREFIX_GML31, "Station_gml31");
        this.setupSimpleOutput(STATIONS_PREFIX_GML31, "Station_gml31");
    }

    @Test
    public void testCsvOutput() throws Exception {
        if (this.notJdbcBased()) {
            return;
        }
        String request = "st_gml32/wfs?request=GetFeature&version=2.0&typeNames=st_gml32:Station_gml32&outputFormat=csv";
        String result = this.getAsString(request);
        this.checkCsv(result);
    }

    @Test
    public void testCsvOutput31() throws Exception {
        if (this.notJdbcBased()) {
            return;
        }
        String request = "st_gml31/wfs?request=GetFeature&version=1.1.0&typeNames=st_gml31:Station_gml31&outputFormat=csv";
        String result = this.getAsString(request);
        this.checkCsv(result);
    }

    private void checkCsv(String result) {
        String[] lines = result.split("\\r?\\n");
        Assert.assertEquals((long)4L, (long)lines.length);
        Assert.assertEquals((Object)"FID,mail,name,codeNumber,captureDate,location", (Object)lines[0]);
        Assert.assertEquals((Object)"st.1,station1@stations.org,station1,12,2006-10-25,POINT (1 -1)", (Object)lines[1]);
        Assert.assertEquals((Object)"st.2,station2@stations.org,station2,28,2020-08-12,POINT (-3 -2)", (Object)lines[2]);
        Assert.assertEquals((Object)"st.3,station3@stations.org,station3,0,1998-12-04,POINT (0 0)", (Object)lines[3]);
    }

    @Test
    public void testKmlOutput() throws Exception {
        if (this.notJdbcBased()) {
            return;
        }
        String request = "st_gml32/wfs?request=GetFeature&version=2.0&typeNames=st_gml32:Station_gml32&outputFormat=application%2Fvnd.google-earth.kml%2Bxml";
        Document document = this.getAsDOM(request);
        this.checkKml(document);
    }

    @Test
    public void testKmlOutput31() throws Exception {
        if (this.notJdbcBased()) {
            return;
        }
        String request = "st_gml31/wfs?request=GetFeature&version=1.1.0&typeNames=st_gml31:Station_gml31&outputFormat=application%2Fvnd.google-earth.kml%2Bxml";
        Document document = this.getAsDOM(request);
        this.checkKml(document);
    }

    @Test
    public void testGMLOutput31() throws Exception {
        XpathEngine xpathEngine = XMLUnit.newXpathEngine();
        HashMap<String, String> finalNamespaces = new HashMap<String, String>();
        finalNamespaces.put("gml", "http://www.opengis.net/gml");
        finalNamespaces.put("wfs", "http://www.opengis.net/wfs");
        finalNamespaces.put(STATIONS_PREFIX_GML31, STATIONS_URI_GML31);
        xpathEngine.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(finalNamespaces));
        if (this.notJdbcBased()) {
            return;
        }
        String request = "st_gml31/wfs?request=GetFeature&version=1.1.0&typeNames=st_gml31:Station_gml31";
        Document document = this.getAsDOM(request);
        this.print(document);
        Element documentElement = document.getDocumentElement();
        Assert.assertEquals((Object)STATIONS_URI_GML31, (Object)documentElement.getAttribute("xmlns:st_gml31"));
        Assert.assertEquals((Object)MEASUREMENTS_URI_GML31, (Object)documentElement.getAttribute("xmlns:ms_gml31"));
        Assert.assertEquals((Object)"3", (Object)xpathEngine.evaluate("count(//wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31)", document));
    }

    private void checkKml(Document document) throws XpathException {
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//kml:Document/kml:Schema/kml:SimpleField[@name='mail'])", document));
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//kml:Document/kml:Schema/kml:SimpleField[@name='name'])", document));
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//kml:Document/kml:Schema/kml:SimpleField[@name='codeNumber'])", document));
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//kml:Document/kml:Schema/kml:SimpleField[@name='captureDate'])", document));
        String featureDataPath = "//kml:Document/kml:Folder/kml:Placemark[@id='st.1']/kml:ExtendedData/kml:SchemaData";
        Assert.assertEquals((Object)"station1@stations.org", (Object)this.xpath.evaluate(featureDataPath + "/kml:SimpleData[@name='mail']/text()", document));
        Assert.assertEquals((Object)"station1", (Object)this.xpath.evaluate(featureDataPath + "/kml:SimpleData[@name='name']/text()", document));
        Assert.assertEquals((Object)"station1@stations.org", (Object)this.xpath.evaluate(featureDataPath + "/kml:SimpleData[@name='mail']/text()", document));
        Assert.assertEquals((Object)"12", (Object)this.xpath.evaluate(featureDataPath + "/kml:SimpleData[@name='codeNumber']/text()", document));
        Assert.assertEquals((Object)"2006-10-25Z", (Object)this.xpath.evaluate(featureDataPath + "/kml:SimpleData[@name='captureDate']/text()", document));
    }

    private void setupSimpleOutput(String workspace, String layerName) {
        Catalog catalog = this.getCatalog();
        WorkspaceInfo workspaceInfo = catalog.getWorkspaceByName(workspace);
        String wsName = workspaceInfo.getName();
        NameImpl layerNameComplex = new NameImpl(workspace, layerName);
        LayerInfo layerInfo = catalog.getLayerByName((Name)layerNameComplex);
        MetadataMap metadataMap = layerInfo.getMetadata();
        HashMap<String, CallSite> rulesMap = new HashMap<String, CallSite>();
        rulesMap.put("mail", (CallSite)((Object)(wsName + ":contact/" + wsName + ":Contact/" + wsName + ":mail")));
        metadataMap.put(RULES_METADATAMAP_KEY, rulesMap);
        catalog.save(layerInfo);
    }

    private void activateLayer(String workspace, String layerName) {
        Catalog catalog = this.getCatalog();
        NameImpl layerNameComplex = new NameImpl(workspace, layerName);
        LayerInfo layerInfo = catalog.getLayerByName((Name)layerNameComplex);
        layerInfo.getResource().setSimpleConversionEnabled(true);
        catalog.save(layerInfo);
    }

    protected boolean notJdbcBased() throws Exception {
        NameImpl name;
        FeatureTypeInfo featureTypeInfo = this.getCatalog().getFeatureTypeByName("Station_gml31");
        DataAccess dataAccess = featureTypeInfo.getStore().getDataStore(null);
        AppSchemaDataAccess appSchemaDataAccess = (AppSchemaDataAccess)dataAccess;
        FeatureSource featureSource = appSchemaDataAccess.getMappingByName((Name)(name = new NameImpl(STATIONS_URI_GML31, "Station_gml31"))).getSource();
        return !(featureSource instanceof JDBCFeatureStore);
    }

    protected static XpathEngine buildKmlXpathEngine() {
        XpathEngine xpathEngine = XMLUnit.newXpathEngine();
        HashMap<String, String> finalNamespaces = new HashMap<String, String>();
        finalNamespaces.put("kml", "http://www.opengis.net/kml/2.2");
        finalNamespaces.put("", "http://www.opengis.net/kml/2.2");
        xpathEngine.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(finalNamespaces));
        return xpathEngine;
    }

    private static final class MockData
    extends StationsMockData {
        private MockData() {
        }

        @Override
        public void addContent() {
            this.putNamespace(SimpleOutputTest.STATIONS_PREFIX_GML31, SimpleOutputTest.STATIONS_URI_GML31);
            this.putNamespace(SimpleOutputTest.MEASUREMENTS_PREFIX_GML31, SimpleOutputTest.MEASUREMENTS_URI_GML31);
            this.putNamespace(SimpleOutputTest.STATIONS_PREFIX_GML32, SimpleOutputTest.STATIONS_URI_GML32);
            this.putNamespace(SimpleOutputTest.MEASUREMENTS_PREFIX_GML32, SimpleOutputTest.MEASUREMENTS_URI_GML32);
            HashMap<String, String> gml31Parameters = new HashMap<String, String>();
            gml31Parameters.put("GML_PREFIX", "gml31");
            gml31Parameters.put("GML_PREFIX_UPPER", "GML31");
            gml31Parameters.put("GML_NAMESPACE", "http://www.opengis.net/gml");
            gml31Parameters.put("GML_LOCATION", "http://schemas.opengis.net/gml/3.1.1/base/gml.xsd");
            this.addAppSchemaFeatureType(SimpleOutputTest.STATIONS_PREFIX_GML31, "gml31", "Station_gml31", "/test-data/stations/simpleOutput/stations.xml", gml31Parameters, "/test-data/stations/simpleOutput/stations.xsd", "/test-data/stations/simpleOutput/stations.properties", "/test-data/stations/simpleOutput/measurements.xml", "/test-data/stations/simpleOutput/measurements.xsd", "/test-data/stations/simpleOutput/measurements.properties", "/test-data/stations/simpleOutput/tags.properties");
            HashMap<String, String> gml32Parameters = new HashMap<String, String>();
            gml32Parameters.put("GML_PREFIX", "gml32");
            gml32Parameters.put("GML_PREFIX_UPPER", "GML32");
            gml32Parameters.put("GML_NAMESPACE", "http://www.opengis.net/gml/3.2");
            gml32Parameters.put("GML_LOCATION", "http://schemas.opengis.net/gml/3.2.1/gml.xsd");
            this.addAppSchemaFeatureType(SimpleOutputTest.STATIONS_PREFIX_GML32, "gml32", "Station_gml32", "/test-data/stations/simpleOutput/stations.xml", gml32Parameters, "/test-data/stations/simpleOutput/stations.xsd", "/test-data/stations/simpleOutput/stations.properties", "/test-data/stations/simpleOutput/measurements.xml", "/test-data/stations/simpleOutput/measurements.xsd", "/test-data/stations/simpleOutput/measurements.properties", "/test-data/stations/simpleOutput/tags.properties");
        }
    }
}

