/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.test.AbstractAppSchemaMockData;
import org.geoserver.test.NamespacesWfsTest;
import org.geoserver.util.IOUtils;
import org.geotools.util.logging.Logging;

public class StationsMockData
extends AbstractAppSchemaMockData {
    private static final Logger LOGGER = Logging.getLogger(StationsMockData.class);
    protected static final String STATIONS_PREFIX_GML31 = "st_gml31";
    protected static final String STATIONS_URI_GML31 = "http://www.stations_gml31.org/1.0";
    protected static final String MEASUREMENTS_PREFIX_GML31 = "ms_gml31";
    protected static final String MEASUREMENTS_URI_GML31 = "http://www.measurements_gml31.org/1.0";
    protected static final String STATIONS_PREFIX_GML32 = "st_gml32";
    protected static final String STATIONS_URI_GML32 = "http://www.stations_gml32.org/1.0";
    protected static final String MEASUREMENTS_PREFIX_GML32 = "ms_gml32";
    protected static final String MEASUREMENTS_URI_GML32 = "http://www.measurements_gml32.org/1.0";
    private File testRootDirectory;

    private static File createTestRootDirectory() {
        try {
            return IOUtils.createTempDirectory((String)"app-schema-stations");
        }
        catch (Exception exception) {
            throw new RuntimeException("Error creating temporary directory.", exception);
        }
    }

    public static XpathEngine buildXpathEngine(Map<String, String> baseNamespaces, String ... namespaces) {
        XpathEngine xpathEngine = XMLUnit.newXpathEngine();
        HashMap<String, String> finalNamespaces = new HashMap<String, String>();
        finalNamespaces.put("ows", "http://www.opengis.net/ows");
        finalNamespaces.put("ogc", "http://www.opengis.net/ogc");
        finalNamespaces.put("xs", "http://www.w3.org/2001/XMLSchema");
        finalNamespaces.put("xsd", "http://www.w3.org/2001/XMLSchema");
        finalNamespaces.put("xlink", "http://www.w3.org/1999/xlink");
        finalNamespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        finalNamespaces.putAll(baseNamespaces);
        if (namespaces.length % 2 != 0) {
            throw new RuntimeException("Invalid number of namespaces provided.");
        }
        for (int i = 0; i < namespaces.length; i += 2) {
            finalNamespaces.put(namespaces[i], namespaces[i + 1]);
        }
        xpathEngine.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(finalNamespaces));
        return xpathEngine;
    }

    public static Map<String, String> getGml31StandardParamaters() {
        HashMap<String, String> gml31Parameters = new HashMap<String, String>();
        gml31Parameters.put("GML_PREFIX", "gml31");
        gml31Parameters.put("GML_PREFIX_UPPER", "GML31");
        gml31Parameters.put("GML_NAMESPACE", "http://www.opengis.net/gml");
        gml31Parameters.put("GML_LOCATION", "http://schemas.opengis.net/gml/3.1.1/base/gml.xsd");
        return gml31Parameters;
    }

    public static Map<String, String> getGml32StandardParamaters() {
        HashMap<String, String> gml32Parameters = new HashMap<String, String>();
        gml32Parameters.put("GML_PREFIX", "gml32");
        gml32Parameters.put("GML_PREFIX_UPPER", "GML32");
        gml32Parameters.put("GML_NAMESPACE", "http://www.opengis.net/gml/3.2");
        gml32Parameters.put("GML_LOCATION", "http://schemas.opengis.net/gml/3.2.1/gml.xsd");
        return gml32Parameters;
    }

    @Override
    public void addContent() {
        this.putNamespace(STATIONS_PREFIX_GML31, STATIONS_URI_GML31);
        this.putNamespace(MEASUREMENTS_PREFIX_GML31, MEASUREMENTS_URI_GML31);
        this.putNamespace(STATIONS_PREFIX_GML32, STATIONS_URI_GML32);
        this.putNamespace(MEASUREMENTS_PREFIX_GML32, MEASUREMENTS_URI_GML32);
        HashMap<String, String> gml31Parameters = new HashMap<String, String>();
        gml31Parameters.put("GML_PREFIX", "gml31");
        gml31Parameters.put("GML_NAMESPACE", "http://www.opengis.net/gml");
        gml31Parameters.put("GML_LOCATION", "http://schemas.opengis.net/gml/3.1.1/base/gml.xsd");
        this.addMeasurementFeatureType(MEASUREMENTS_PREFIX_GML31, "gml31", "measurements", "base/measurements.xml", gml31Parameters);
        this.addStationFeatureType(STATIONS_PREFIX_GML31, "gml31", "stations", "base/stations.xml", gml31Parameters);
        HashMap<String, String> gml32Parameters = new HashMap<String, String>();
        gml32Parameters.put("GML_PREFIX", "gml32");
        gml32Parameters.put("GML_NAMESPACE", "http://www.opengis.net/gml/3.2");
        gml32Parameters.put("GML_LOCATION", "http://schemas.opengis.net/gml/3.2.1/gml.xsd");
        this.addMeasurementFeatureType(MEASUREMENTS_PREFIX_GML32, "gml32", "measurements", "base/measurements.xml", gml32Parameters);
        this.addStationFeatureType(STATIONS_PREFIX_GML32, "gml32", "stations", "base/stations.xml", gml32Parameters);
    }

    protected static void substituteParameters(String resourceName, Map<String, String> parameters, File newFile) {
        String resourceContent = StationsMockData.resourceToString(resourceName);
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            resourceContent = resourceContent.replace(String.format("${%s}", parameter.getKey()), parameter.getValue());
        }
        try {
            Files.write(newFile.toPath(), resourceContent.getBytes(), new OpenOption[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("Error writing content to file '%s'.", newFile.getAbsolutePath()), exception);
        }
    }

    protected static String resourceToString(String resourceName) {
        String string;
        block8: {
            InputStream input = NamespacesWfsTest.class.getResourceAsStream(resourceName);
            try {
                string = IOUtils.toString((InputStream)input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new RuntimeException(String.format("Error reading resource '%s' content.", resourceName), exception);
                }
            }
            input.close();
        }
        return string;
    }

    protected void addMeasurementFeatureType(String namespacePrefix, String gmlPrefix, String mappingsName, String mappingsPath, Map<String, String> parameters) {
        File gmlDirectory = this.getDirectoryForGmlPrefix(gmlPrefix);
        gmlDirectory.mkdirs();
        File measurementsMappings = new File(gmlDirectory, String.format("%s_%s.xml", mappingsName, gmlPrefix));
        File measurementsProperties = new File(gmlDirectory, String.format("measurements_%s.properties", gmlPrefix));
        File measurementsSchema = new File(gmlDirectory, String.format("measurements_%s.xsd", gmlPrefix));
        StationsMockData.substituteParameters("/test-data/stations/" + mappingsPath, parameters, measurementsMappings);
        StationsMockData.substituteParameters("/test-data/stations/base/measurements.properties", parameters, measurementsProperties);
        StationsMockData.substituteParameters("/test-data/stations/base/measurements.xsd", parameters, measurementsSchema);
        this.addMeasurementFeatures(measurementsProperties);
        this.addFeatureType(namespacePrefix, String.format("Measurement_%s", gmlPrefix), measurementsMappings.getAbsolutePath(), measurementsProperties.getAbsolutePath(), measurementsSchema.getAbsolutePath());
    }

    protected void addStationFeatureType(String namespacePrefix, String gmlPrefix, String mappingsName, String mappingsPath, Map<String, String> parameters) {
        File gmlDirectory = this.getDirectoryForGmlPrefix(gmlPrefix);
        gmlDirectory.mkdirs();
        File stationsMappings = new File(gmlDirectory, String.format("%s_%s.xml", mappingsName, gmlPrefix));
        File stationsProperties = new File(gmlDirectory, String.format("stations_%s.properties", gmlPrefix));
        File stationsSchema = new File(gmlDirectory, String.format("stations_%s.xsd", gmlPrefix));
        File measurementsSchema = new File(gmlDirectory, String.format("measurements_%s.xsd", gmlPrefix));
        StationsMockData.substituteParameters("/test-data/stations/" + mappingsPath, parameters, stationsMappings);
        StationsMockData.substituteParameters("/test-data/stations/base/stations.properties", parameters, stationsProperties);
        StationsMockData.substituteParameters("/test-data/stations/base/stations.xsd", parameters, stationsSchema);
        StationsMockData.substituteParameters("/test-data/stations/base/measurements.xsd", parameters, measurementsSchema);
        this.addStationFeatures(stationsProperties);
        this.addFeatureType(namespacePrefix, String.format("Station_%s", gmlPrefix), stationsMappings.getAbsolutePath(), stationsProperties.getAbsolutePath(), stationsSchema.getAbsolutePath(), measurementsSchema.getAbsolutePath());
    }

    protected void addStationFeatureType(String namespacePrefix, String gmlPrefix, String stationsMappingsName, String stationsMappingsPath, String measurementsMappingsName, String measurementsMappingsPath, Map<String, String> parameters) {
        File gmlDirectory = this.getDirectoryForGmlPrefix(gmlPrefix);
        gmlDirectory.mkdirs();
        File stationsMappings = new File(gmlDirectory, String.format("%s_%s.xml", stationsMappingsName, gmlPrefix));
        File measurementsMappings = new File(gmlDirectory, String.format("%s_%s.xml", measurementsMappingsName, gmlPrefix));
        File stationsProperties = new File(gmlDirectory, String.format("stations_%s.properties", gmlPrefix));
        File stationsSchema = new File(gmlDirectory, String.format("stations_%s.xsd", gmlPrefix));
        File measurementsProperties = new File(gmlDirectory, String.format("measurements_%s.properties", gmlPrefix));
        File measurementsSchema = new File(gmlDirectory, String.format("measurements_%s.xsd", gmlPrefix));
        StationsMockData.substituteParameters("/test-data/stations/" + stationsMappingsPath, parameters, stationsMappings);
        StationsMockData.substituteParameters("/test-data/stations/" + measurementsMappingsPath, parameters, measurementsMappings);
        StationsMockData.substituteParameters("/test-data/stations/base/stations.properties", parameters, stationsProperties);
        StationsMockData.substituteParameters("/test-data/stations/base/stations.xsd", parameters, stationsSchema);
        StationsMockData.substituteParameters("/test-data/stations/base/measurements.xsd", parameters, measurementsSchema);
        this.addStationFeatures(stationsProperties);
        this.addFeatureType(namespacePrefix, String.format("Station_%s", gmlPrefix), stationsMappings.getAbsolutePath(), stationsProperties.getAbsolutePath(), stationsSchema.getAbsolutePath(), measurementsSchema.getAbsolutePath(), measurementsMappings.getAbsolutePath(), measurementsProperties.getAbsolutePath());
    }

    protected void addAppSchemaFeatureType(String namespacePrefix, String gmlPrefix, String typeName, String mappingsFileResource, Map<String, String> parameters, String ... otherResources) {
        File gmlDirectory = this.getDirectoryForGmlPrefix(gmlPrefix);
        gmlDirectory.mkdirs();
        File targetMappingsFile = this.getTargetFile(mappingsFileResource, gmlPrefix, gmlDirectory);
        StationsMockData.substituteParameters(mappingsFileResource, parameters, targetMappingsFile);
        String[] otherResourcesFiles = new String[otherResources.length + 1];
        otherResourcesFiles[0] = targetMappingsFile.getAbsolutePath();
        for (int i = 0; i < otherResources.length; ++i) {
            File targetFile = this.getTargetFile(otherResources[i], gmlPrefix, gmlDirectory);
            StationsMockData.substituteParameters(otherResources[i], parameters, targetFile);
            otherResourcesFiles[i + 1] = targetFile.getAbsolutePath();
        }
        this.addFeatureType(namespacePrefix, typeName, targetMappingsFile.getAbsolutePath(), otherResourcesFiles);
    }

    private File getTargetFile(String resource, String gmlPrefix, File gmlDirectory) {
        int index = resource.lastIndexOf("/");
        if (index < 0) {
            throw new RuntimeException(String.format("Invalid resource '%s'.", resource));
        }
        String name = resource.substring(index + 1);
        if ((index = name.lastIndexOf(".")) < 0) {
            throw new RuntimeException(String.format("Invalid resource name '%s' of resource '%s'.", name, resource));
        }
        String extension = name.substring(index);
        name = name.substring(0, index);
        if (gmlPrefix == null || gmlPrefix.isEmpty()) {
            return new File(gmlDirectory, name + extension);
        }
        return new File(gmlDirectory, name + "_" + gmlPrefix + extension);
    }

    protected synchronized File getDirectoryForGmlPrefix(String gmlPrefix) {
        if (this.testRootDirectory == null) {
            this.testRootDirectory = StationsMockData.createTestRootDirectory();
        }
        if (gmlPrefix == null || gmlPrefix.isEmpty()) {
            return this.testRootDirectory;
        }
        return new File(this.testRootDirectory, gmlPrefix);
    }

    private void addTextToFile(File file, String content) {
        try (BufferedWriter output = new BufferedWriter(new FileWriter(file, true));){
            output.append(content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void addStationFeatures(File file) {
        this.extraStationFeatures().ifPresent(content -> this.addTextToFile(file, (String)content));
    }

    protected void addMeasurementFeatures(File file) {
        this.extraMeasurementFeatures().ifPresent(content -> this.addTextToFile(file, (String)content));
    }

    protected Optional<String> extraStationFeatures() {
        return Optional.empty();
    }

    protected Optional<String> extraMeasurementFeatures() {
        return Optional.empty();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        try {
            IOUtils.delete((File)this.testRootDirectory);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, String.format("Error removing tests root directory '%s'.", this.testRootDirectory.getAbsolutePath()), exception);
        }
    }
}

