/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.WmsSupportMockData;
import org.geotools.image.test.ImageAssert;
import org.geotools.util.URLs;
import org.junit.Test;
import org.w3c.dom.Document;

public class WmsGetMapTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected WmsSupportMockData createTestData() {
        WmsSupportMockData mockData = new WmsSupportMockData();
        mockData.addStyle("Default", "styles/Default.sld");
        mockData.addStyle("outcropcharacter", "styles/outcropcharacter.sld");
        mockData.addStyle("positionalaccuracy", "styles/positionalaccuracy.sld");
        mockData.addStyle("occurrencecount", "styles/attributeCountTest.sld");
        return mockData;
    }

    @Test
    public void testGetMapOutcropCharacter() throws Exception {
        try (InputStream is = this.getBinary("wms?request=GetMap&SRS=EPSG:4326&layers=gsml:MappedFeature&styles=outcropcharacter&BBOX=-2,52,0,54&X=0&Y=0&width=20&height=20&FORMAT=image/png");){
            BufferedImage imageBuffer = ImageIO.read(is);
            this.assertNotBlank("app-schema test getmap outcrop character", imageBuffer, Color.WHITE);
            ImageAssert.assertEquals((File)URLs.urlToFile((URL)((Object)((Object)this)).getClass().getResource("/test-data/img/outcrop.png")), (RenderedImage)imageBuffer, (int)10);
        }
    }

    @Test
    public void testGetMapOutcropCharacterReprojection() throws Exception {
        try (InputStream is = this.getBinary("wms?request=GetMap&SRS=EPSG:3857&layers=gsml:MappedFeature&styles=outcropcharacter&BBOX=-222638.981586547,6800125.45439731,0,7170156.29399995&X=0&Y=0&width=20&height=20&FORMAT=image/png");){
            BufferedImage imageBuffer = ImageIO.read(is);
            this.assertNotBlank("app-schema test getmap outcrop character", imageBuffer, Color.WHITE);
            ImageAssert.assertEquals((File)URLs.urlToFile((URL)((Object)((Object)this)).getClass().getResource("/test-data/img/outcrop_3857.png")), (RenderedImage)imageBuffer, (int)10);
        }
    }

    @Test
    public void testGetMapPositionalAccuracy() throws Exception {
        try (InputStream is = this.getBinary("wms?request=GetMap&SRS=EPSG:4326&layers=gsml:MappedFeature&styles=positionalaccuracy&BBOX=-2,52,0,54&X=0&Y=0&width=20&height=20&FORMAT=image/png");){
            BufferedImage imageBuffer = ImageIO.read(is);
            this.assertNotBlank("app-schema test getmap positional accuracy", imageBuffer, Color.WHITE);
            ImageAssert.assertEquals((File)URLs.urlToFile((URL)((Object)((Object)this)).getClass().getResource("/test-data/img/posacc.png")), (RenderedImage)imageBuffer, (int)10);
        }
    }

    @Test
    public void testGetMapAfterWFS() throws Exception {
        Document doc = this.getAsDOM("wfs?version=1.1.0&request=getFeature&typeName=gsml:MappedFeature&maxFeatures=1");
        LOGGER.info(this.prettyString(doc));
        try (InputStream is = this.getBinary("wms?request=GetMap&SRS=EPSG:4326&layers=gsml:MappedFeature&styles=outcropcharacter&BBOX=-2,52,0,54&X=0&Y=0&width=20&height=20&FORMAT=image/png");){
            BufferedImage imageBuffer = ImageIO.read(is);
            this.assertNotBlank("app-schema test getmap outcrop character", imageBuffer, Color.WHITE);
            ImageAssert.assertEquals((File)URLs.urlToFile((URL)((Object)((Object)this)).getClass().getResource("/test-data/img/outcrop.png")), (RenderedImage)imageBuffer, (int)10);
        }
    }

    @Test
    public void testGetMapWithCount() throws Exception {
        Document doc = this.getAsDOM("wfs?version=1.1.0&request=getFeature&typeName=gsml:MappedFeature");
        LOGGER.info(this.prettyString(doc));
        try (InputStream is = this.getBinary("wms?request=GetMap&SRS=EPSG:4326&layers=gsml:MappedFeature&styles=occurrencecount&BBOX=-2,52,0,54&X=0&Y=0&width=20&height=20&FORMAT=image/png");){
            BufferedImage imageBuffer = ImageIO.read(is);
            this.assertNotBlank("app-schema test getmap outcrop character", imageBuffer, Color.WHITE);
            ImageAssert.assertEquals((File)URLs.urlToFile((URL)((Object)((Object)this)).getClass().getResource("/test-data/img/occurrence.png")), (RenderedImage)imageBuffer, (int)10);
        }
    }
}

