/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test.onlineTest.setup;

import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.geoserver.test.onlineTest.support.AbstractReferenceDataSetup;
import org.geoserver.test.onlineTest.support.DatabaseUtil;
import org.geotools.geopkg.GeoPkgDataStoreFactory;
import org.geotools.jdbc.JDBCDataStoreFactory;

public class ReferenceDataGeopackageSetup
extends AbstractReferenceDataSetup {
    private final String versiontbl = "data_version";
    private InputStream script = ((Object)((Object)this)).getClass().getResourceAsStream("/RefDataSet/Postgis_Data_ref_set.sql");
    private final double scriptVersion = 1.0;

    @Override
    public JDBCDataStoreFactory createDataStoreFactory() {
        return new GeoPkgDataStoreFactory();
    }

    protected void runSqlInsertScript() throws Exception {
        DatabaseUtil du = new DatabaseUtil();
        List<String> sqls = du.splitPostgisSQLScript(this.script);
        sqls.add("set search_path = public;");
        this.run(du.rebuildAsSingle(sqls));
        this.setDataVersion(1.0);
    }

    private void setDataVersion(double version) throws Exception {
        this.run("DROP TABLE IF EXISTS public.data_version");
        this.run("CREATE TABLE public.data_version (name character varying(100) NOT NULL, version double precision,insert_date timestamp without time zone);");
        this.run("insert into public.data_version(name,version,insert_date) values('Data reference set'," + version + ",current_timestamp)");
    }

    @Override
    public String getDatabaseID() {
        return "geopkg";
    }

    @Override
    public void setUp() throws Exception {
        this.runSqlInsertScript();
    }

    @Override
    protected Properties createExampleFixture() {
        Properties fixture = new Properties();
        fixture.put("password", "MyPassword");
        fixture.put("passwd", "MyPassword");
        fixture.put("user", "user");
        fixture.put("port", "5432");
        fixture.put("url", "jdbc:postgresql://MyHost/MyDatabase");
        fixture.put("host", "MyHost");
        fixture.put("database", "MyDatabase");
        fixture.put("driver", "org.postgresql.Driver");
        fixture.put("dbtype", "postgisng");
        return fixture;
    }
}

