/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test.onlineTest.support;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.geoserver.test.onlineTest.support.DatabaseUtil;
import org.geoserver.test.onlineTest.support.GSFixtureUtilitiesDelegate;
import org.geotools.api.feature.type.GeometryType;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.JDBCTestSetup;
import org.geotools.referencing.CRS;

public abstract class AbstractReferenceDataSetup
extends JDBCTestSetup {
    public static final String ONLINE_TEST_PROFILE = "onlineTestProfile";
    protected String geopkgDir;
    protected Logger LOGGER = Logger.getLogger(AbstractReferenceDataSetup.class);
    protected static Map<String, Boolean> found = new HashMap<String, Boolean>();

    public abstract JDBCDataStoreFactory createDataStoreFactory();

    public abstract void setUp() throws Exception;

    protected abstract Properties createExampleFixture();

    public void setUpData() throws Exception {
        super.setUpData();
    }

    public void initializeDatabase() throws Exception {
        super.initializeDatabase();
    }

    public abstract String getDatabaseID();

    protected Map<String, Boolean> getOnlineMap() {
        return found;
    }

    protected void configureFixture() {
        if (this.fixture == null) {
            String fixtureId = this.getDatabaseID();
            if (fixtureId == null) {
                return;
            }
            try {
                File fixtureFile;
                Boolean exists;
                File base = GSFixtureUtilitiesDelegate.getFixtureDirectory();
                String profile = System.getProperty(ONLINE_TEST_PROFILE);
                if (profile != null && !"".equals(profile)) {
                    base = new File(base, profile);
                }
                if ((exists = found.get((fixtureFile = GSFixtureUtilitiesDelegate.getFixtureFile(base, fixtureId)).getCanonicalPath())) == null || exists.booleanValue()) {
                    if (fixtureFile.exists()) {
                        this.fixture = GSFixtureUtilitiesDelegate.loadProperties(fixtureFile);
                        if (fixtureId.equals("geopkg")) {
                            this.fixture.setProperty("url", this.fixture.getProperty("url").substring(0, 11) + this.geopkgDir.substring(4));
                        }
                        found.put(fixtureFile.getCanonicalPath(), true);
                        System.setProperty("app-schema.properties", fixtureFile.getPath());
                    } else {
                        File exFixtureFile;
                        Properties exampleFixture;
                        if (profile == null && (exampleFixture = this.createExampleFixture()) != null && !(exFixtureFile = new File(fixtureFile.getAbsolutePath() + ".example")).exists()) {
                            this.createExampleFixture(exFixtureFile, exampleFixture);
                        }
                        found.put(fixtureFile.getCanonicalPath(), false);
                    }
                }
                if (this.fixture == null && exists == null) {
                    GSFixtureUtilitiesDelegate.printSkipNotice(fixtureId, fixtureFile);
                }
            }
            catch (Exception e) {
                this.LOGGER.log((Priority)Level.ERROR, (Object)"", (Throwable)e);
            }
        }
    }

    protected void createExampleFixture(File exFixtureFile, Properties exampleFixture) {
        try {
            exFixtureFile.getParentFile().mkdirs();
            exFixtureFile.createNewFile();
            try (FileOutputStream fout = new FileOutputStream(exFixtureFile);){
                exampleFixture.store(fout, "This is an example fixture. Update the values and remove the .example suffix to enable the test");
                fout.flush();
            }
            this.LOGGER.info((Object)("Wrote example fixture file to " + exFixtureFile));
        }
        catch (IOException ioe) {
            this.LOGGER.log((Priority)Level.WARN, (Object)("Unable to write out example fixture " + exFixtureFile), (Throwable)ioe);
        }
    }

    public void run(String input, boolean replaceNewLine) throws Exception {
        if (replaceNewLine) {
            this.run(input);
        } else {
            super.run(input);
        }
    }

    public void run(String input) throws Exception {
        super.run(input.replaceAll(DatabaseUtil.NEWLINE, " "));
    }

    protected int getSrid(GeometryType type) {
        int srid = -1;
        CoordinateReferenceSystem crs = type.getCoordinateReferenceSystem();
        if (crs != null) {
            try {
                srid = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true);
            }
            catch (FactoryException e) {
                this.LOGGER.warn((Object)"Exception occurred when looking up srid! CRS will be ignored.");
            }
        }
        return srid;
    }

    protected Properties getFixture() {
        return this.fixture;
    }
}

