/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.FeatureChainingMockData;
import org.geoserver.util.IOUtils;
import org.geoserver.wfs.WFSInfo;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.util.ProgressListener;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.appschema.jdbc.NestedFilterToSQL;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.AppSchemaDataAccessRegistry;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.complex.filter.ComplexFilterSplitter;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.data.util.NullProgressListener;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.util.URLs;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class FeatureChainingWfsTest
extends AbstractAppSchemaTestSupport {
    public static final String GETFEATURE_ATTRIBUTES = "service=\"WFS\" version=\"1.1.0\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\"";

    @Override
    protected FeatureChainingMockData createTestData() {
        return new FeatureChainingMockData();
    }

    private File getDataDir() {
        return this.getTestData().getDataDirectoryRoot();
    }

    private File getExSchemaOne() {
        return this.findFile("featureTypes/ex_FirstParentFeature/simpleContent.xsd", this.getDataDir());
    }

    private String getExSchemaOneLocation() {
        return URLs.fileToUrl((File)this.getExSchemaOne()).toString();
    }

    private File getExSchemaTwo() {
        return this.findFile("featureTypes/ex_SecondParentFeature/simpleContent.xsd", this.getDataDir());
    }

    private String getExSchemaTwoLocation() {
        return URLs.fileToUrl((File)this.getExSchemaTwo()).toString();
    }

    private File getExSchemaThree() {
        return this.findFile("featureTypes/ex_ParentFeature/NonValidNestedGML.xsd", this.getDataDir());
    }

    private String getExSchemaThreeLocation() {
        return URLs.fileToUrl((File)this.getExSchemaThree()).toString();
    }

    @Test
    public void testExSchemas() {
        Assert.assertNotNull((Object)this.getExSchemaOne());
        Assert.assertTrue((boolean)this.getExSchemaOne().exists());
        Assert.assertNotNull((Object)this.getExSchemaTwo());
        Assert.assertTrue((boolean)this.getExSchemaTwo().exists());
    }

    @Test
    public void testGetCapabilities() {
        Document doc = this.getAsDOM("wfs?request=GetCapabilities&version=1.1.0");
        LOGGER.info("WFS GetCapabilities response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"wfs:WFS_Capabilities", (Object)doc.getDocumentElement().getNodeName());
        String schemaLocation = this.evaluate("wfs:WFS_Capabilities/@xsi:schemaLocation", doc);
        String location = "http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd";
        Assert.assertEquals((Object)location, (Object)schemaLocation);
        this.assertXpathCount(6, "//wfs:FeatureType", doc);
        ArrayList<String> featureTypeNames = new ArrayList<String>(6);
        featureTypeNames.add(this.evaluate("//wfs:FeatureType[1]/wfs:Name", doc));
        featureTypeNames.add(this.evaluate("//wfs:FeatureType[2]/wfs:Name", doc));
        featureTypeNames.add(this.evaluate("//wfs:FeatureType[3]/wfs:Name", doc));
        featureTypeNames.add(this.evaluate("//wfs:FeatureType[4]/wfs:Name", doc));
        featureTypeNames.add(this.evaluate("//wfs:FeatureType[5]/wfs:Name", doc));
        featureTypeNames.add(this.evaluate("//wfs:FeatureType[6]/wfs:Name", doc));
        Assert.assertTrue((boolean)featureTypeNames.contains("gsml:MappedFeature"));
        Assert.assertTrue((boolean)featureTypeNames.contains("gsml:GeologicUnit"));
        Assert.assertTrue((boolean)featureTypeNames.contains("ex:FirstParentFeature"));
        Assert.assertTrue((boolean)featureTypeNames.contains("ex:SecondParentFeature"));
        Assert.assertTrue((boolean)featureTypeNames.contains("ex:ParentFeature"));
        Assert.assertTrue((boolean)featureTypeNames.contains("om:Observation"));
    }

    @Test
    public void testDescribeFeatureTypeMappedFeature() {
        Document doc = this.getAsDOM("wfs?request=DescribeFeatureType&version=1.1.0&typename=gsml:MappedFeature");
        LOGGER.info("WFS DescribeFeatureType, typename=gsml:MappedFeature response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
        this.assertXpathEvaluatesTo("urn:cgi:xmlns:CGI:GeoSciML:2.0", "//@targetNamespace", doc);
        this.assertXpathCount(1, "//xsd:include", doc);
        this.assertXpathCount(0, "//xsd:import", doc);
        this.assertXpathEvaluatesTo("http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd", "//xsd:include/@schemaLocation", doc);
        this.assertXpathCount(0, "//xsd:complexType", doc);
        this.assertXpathCount(0, "//xsd:element", doc);
    }

    @Test
    public void testDescribeFeatureTypeGeologicUnit() {
        Document doc = this.getAsDOM("wfs?request=DescribeFeatureType&version=1.1.0&typename=gsml:GeologicUnit");
        LOGGER.info("WFS DescribeFeatureType, typename=gsml:GeologicUnit response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
        this.assertXpathEvaluatesTo("urn:cgi:xmlns:CGI:GeoSciML:2.0", "//@targetNamespace", doc);
        this.assertXpathCount(1, "//xsd:include", doc);
        this.assertXpathCount(0, "//xsd:import", doc);
        this.assertXpathEvaluatesTo("http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd", "//xsd:include/@schemaLocation", doc);
        this.assertXpathCount(0, "//xsd:complexType", doc);
        this.assertXpathCount(0, "//xsd:element", doc);
    }

    @Test
    public void testDescribeFeatureTypeTwoSchemasSameNamespace() {
        Document doc = this.getAsDOM("wfs?request=DescribeFeatureType&version=1.1.0&typeName=ex:FirstParentFeature,ex:SecondParentFeature");
        LOGGER.info("WFS DescribeFeatureType, typename=ex:FirstParentFeature,ex:SecondParentFeature response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("http://example.com", "//@targetNamespace", doc);
        this.assertXpathCount(1, "//xsd:include", doc);
        this.assertXpathCount(0, "//xsd:import", doc);
        String schemaLocation = this.evaluate("//xsd:include/@schemaLocation", doc);
        if (!schemaLocation.equals(this.getExSchemaOneLocation())) {
            Assert.assertEquals((Object)this.getExSchemaTwoLocation(), (Object)schemaLocation);
        }
        this.assertXpathCount(0, "//xsd:complexType", doc);
        this.assertXpathCount(0, "//xsd:element", doc);
    }

    @Test
    public void testDescribeFeatureTypeObservation() {
        Document doc = this.getAsDOM("wfs?request=DescribeFeatureType&version=1.1.0&typename=om:Observation");
        LOGGER.info("WFS DescribeFeatureType, typename=om:Observation response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
        this.assertXpathEvaluatesTo("http://www.opengis.net/om/1.0", "//@targetNamespace", doc);
        this.assertXpathCount(1, "//xsd:include", doc);
        this.assertXpathCount(1, "//xsd:import", doc);
        this.assertXpathEvaluatesTo("urn:cgi:xmlns:CGI:GeoSciML:2.0", "//xsd:import/@namespace", doc);
        this.assertXpathEvaluatesTo("http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd", "//xsd:import/@schemaLocation", doc);
        this.assertXpathEvaluatesTo("http://schemas.opengis.net/om/1.0.0/observation.xsd", "//xsd:include/@schemaLocation", doc);
        this.assertXpathCount(0, "//xsd:complexType", doc);
        this.assertXpathCount(0, "//xsd:element", doc);
    }

    @Test
    public void testDescribeFeatureTypeMixedNamespaces() {
        Document doc = this.getAsDOM("wfs?request=DescribeFeatureType&version=1.1.0&typeName=gsml:MappedFeature,ex:FirstParentFeature");
        LOGGER.info("WFS DescribeFeatureType, typename=gsml:MappedFeature,ex:FirstParentFeature response:\n" + this.prettyString(doc));
        this.checkGsmlExDescribeFeatureType(doc);
    }

    @Test
    public void testDescribeFeatureTypeManyTypes() {
        Document doc = this.getAsDOM("wfs?request=DescribeFeatureType&version=1.1.0&typeName=gsml:MappedFeature,gsml:GeologicUnit,ex:FirstParentFeature,ex:SecondParentFeature");
        LOGGER.info("WFS DescribeFeatureType, typename=gsml:MappedFeature,gsml:GeologicUnit,ex:FirstParentFeature,ex:SecondParentFeature response:\n" + this.prettyString(doc));
        this.checkGsmlExDescribeFeatureType(doc);
    }

    private void checkGsmlExDescribeFeatureType(Document doc) {
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
        this.assertXpathEvaluatesTo("urn:cgi:xmlns:CGI:GeoSciML:2.0", "//@targetNamespace", doc);
        this.assertXpathCount(1, "//xsd:include", doc);
        this.assertXpathCount(1, "//xsd:import", doc);
        this.assertXpathEvaluatesTo("http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd", "//xsd:include/@schemaLocation", doc);
        this.assertXpathEvaluatesTo("http://example.com", "//xsd:import/@namespace", doc);
        String schemaLocation = this.evaluate("//xsd:import/@schemaLocation", doc);
        Assert.assertTrue((schemaLocation.equals(this.getExSchemaOneLocation()) || schemaLocation.equals(this.getExSchemaTwoLocation()) ? 1 : 0) != 0);
        this.assertXpathCount(0, "//xsd:complexType", doc);
        this.assertXpathCount(0, "//xsd:element", doc);
    }

    @Test
    public void testDescribeFeatureTypeNoTypes() {
        Document doc = this.getAsDOM("wfs?request=DescribeFeatureType&version=1.1.0");
        LOGGER.info("WFS DescribeFeatureType response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
        String targetNamespace = this.evaluate("//@targetNamespace", doc);
        Assert.assertFalse((boolean)targetNamespace.isEmpty());
        int numberOfImports = this.getMatchingNodes("//xsd:import", doc).getLength();
        int numberOfIncludes = this.getMatchingNodes("//xsd:include", doc).getLength();
        ArrayList<String> namespaces = new ArrayList<String>();
        namespaces.add("urn:cgi:xmlns:CGI:GeoSciML:2.0");
        namespaces.add("http://www.opengis.net/om/1.0");
        namespaces.add("http://example.com");
        if (targetNamespace.equals("http://example.com")) {
            Assert.assertEquals((long)2L, (long)numberOfImports);
            Assert.assertEquals((long)3L, (long)numberOfIncludes);
            Set<String> expectedExSchemaLocations = Set.of(this.getExSchemaOneLocation(), this.getExSchemaTwoLocation(), this.getExSchemaThreeLocation());
            Assert.assertEquals((long)numberOfIncludes, (long)expectedExSchemaLocations.size());
            HashSet<String> foundExSchemaLocations = new HashSet<String>();
            for (int i = 1; i <= numberOfIncludes; ++i) {
                foundExSchemaLocations.add(this.evaluate("//xsd:include[" + i + "]/@schemaLocation", doc));
            }
            Assert.assertEquals(expectedExSchemaLocations, foundExSchemaLocations);
            namespaces.remove("http://example.com");
        } else {
            Assert.assertEquals((long)2L, (long)numberOfImports);
            Assert.assertEquals((long)1L, (long)numberOfIncludes);
            String schemaLocation = "//xsd:include[1]/@schemaLocation";
            if (targetNamespace.equals("urn:cgi:xmlns:CGI:GeoSciML:2.0")) {
                this.assertXpathEvaluatesTo("http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd", schemaLocation, doc);
                namespaces.remove("urn:cgi:xmlns:CGI:GeoSciML:2.0");
            } else {
                Assert.assertEquals((Object)"http://www.opengis.net/om/1.0", (Object)targetNamespace);
                this.assertXpathEvaluatesTo("http://schemas.opengis.net/om/1.0.0/observation.xsd", schemaLocation, doc);
                namespaces.remove("http://www.opengis.net/om/1.0");
            }
        }
        for (int i = 1; i <= numberOfImports; ++i) {
            String namespace = this.evaluate("//xsd:import[" + i + "]/@namespace", doc);
            String schemaLocation = "//xsd:import[" + i + "]/@schemaLocation";
            if (namespace.equals("urn:cgi:xmlns:CGI:GeoSciML:2.0")) {
                this.assertXpathEvaluatesTo("http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd", schemaLocation, doc);
                namespaces.remove("urn:cgi:xmlns:CGI:GeoSciML:2.0");
                continue;
            }
            if (namespace.equals("http://example.com")) {
                String loc = this.evaluate(schemaLocation, doc);
                Assert.assertTrue((loc.equals(this.getExSchemaOneLocation()) || loc.equals(this.getExSchemaTwoLocation()) || loc.equals(this.getExSchemaThreeLocation()) ? 1 : 0) != 0);
                namespaces.remove("http://example.com");
                continue;
            }
            Assert.assertEquals((Object)"http://www.opengis.net/om/1.0", (Object)namespace);
            this.assertXpathEvaluatesTo("http://schemas.opengis.net/om/1.0.0/observation.xsd", schemaLocation, doc);
            namespaces.remove("http://www.opengis.net/om/1.0");
        }
        Assert.assertTrue((boolean)namespaces.isEmpty());
        this.assertXpathCount(0, "//xsd:complexType", doc);
        this.assertXpathCount(0, "//xsd:element", doc);
    }

    @Test
    public void testDescribeFeatureTypeNoWfsSchemaImport() {
        Document doc = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=DescribeFeatureType&typenames=gsml:GeologicUnit");
        this.assertXpathCount(0, "//xsd:import", doc);
        this.assertXpathCount(1, "//xsd:include", doc);
        this.assertImportNotExists(doc, "http://www.opengis.net/wfs");
        this.assertIncludeExists(doc, "http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd");
        doc = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=DescribeFeatureType&typenames=gsml:GeologicUnit,gsml:MappedFeature");
        this.assertXpathCount(0, "//xsd:import", doc);
        this.assertXpathCount(0, "//xsd:import[@namespace='http://www.opengis.net/wfs']", doc);
        this.assertImportNotExists(doc, "http://www.opengis.net/wfs");
        this.assertIncludeExists(doc, "http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd");
        doc = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=DescribeFeatureType&typenames=gsml:GeologicUnit,ex:FirstParentFeature");
        this.assertXpathEvaluatesTo("urn:cgi:xmlns:CGI:GeoSciML:2.0", "//@targetNamespace", doc);
        this.assertXpathCount(1, "//xsd:import", doc);
        this.assertXpathCount(1, "//xsd:include", doc);
        this.assertImportNotExists(doc, "http://www.opengis.net/wfs");
        this.assertIncludeExists(doc, "http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd");
        this.assertImportExists(doc, "http://example.com");
        this.assertXpathEvaluatesTo(this.getExSchemaOneLocation(), "//xsd:import/@schemaLocation", doc);
        doc = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=DescribeFeatureType&typenames=ex:FirstParentFeature,gsml:GeologicUnit");
        this.assertXpathEvaluatesTo("http://example.com", "//@targetNamespace", doc);
        this.assertXpathCount(1, "//xsd:import", doc);
        this.assertXpathCount(1, "//xsd:include", doc);
        this.assertImportNotExists(doc, "http://www.opengis.net/wfs");
        this.assertIncludeExists(doc, this.getExSchemaOneLocation());
        this.assertImportExists(doc, "urn:cgi:xmlns:CGI:GeoSciML:2.0");
        this.assertXpathEvaluatesTo("http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd", "//xsd:import/@schemaLocation", doc);
    }

    @Test
    public void testGetFeatureGML() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature");
        LOGGER.info("WFS GetFeature&typename=gsml:MappedFeature response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        doc = this.getAsDOM("wfs?request=GetFeature&typename=gsml:CompositionPart");
        LOGGER.info("WFS GetFeature&typename=gsml:CompositionPart response, exception expected:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)doc.getDocumentElement().getNodeName());
    }

    @Test
    public void testGetFeatureJSON() throws Exception {
        JSON json = this.getAsJSON("wfs?request=GetFeature&version=1.1.0&typename=gsml:GeologicUnit&outputFormat=application/json&featureId=gu.25678");
        this.print(json);
        JSONObject properties = this.getFeaturePropertiesById(json, "gu.25678");
        Assert.assertNotNull((Object)properties);
        JSONArray colors = properties.getJSONArray("exposureColor");
        Assert.assertNotNull((Object)colors);
        JSONObject color = colors.getJSONObject(0);
        Assert.assertFalse((boolean)color.has("type"));
        Assert.assertFalse((boolean)color.has("geometry"));
        Assert.assertFalse((boolean)color.has("properties"));
        color = color.getJSONObject("value");
        MatcherAssert.assertThat((Object)color.getString("value"), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.is((Object)"Blue"), CoreMatchers.is((Object)"Yellow")}));
        MatcherAssert.assertThat((Object)color.getString("@codeSpace"), (Matcher)CoreMatchers.is((Object)"some:uri"));
    }

    @Test
    public void testGetFeatureValid() {
        String path = "wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature";
        String newline = System.getProperty("line.separator");
        Document doc = this.getAsDOM(path);
        LOGGER.info("Response for " + path + " :" + newline + this.prettyString(doc));
        this.validateGet(path);
    }

    @Test
    public void testGetFeatureEncodeIfEmpty() {
        String path = "wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature&featureID=mf5";
        String newline = System.getProperty("line.separator");
        Document doc = this.getAsDOM(path);
        this.assertXpathCount(1, "//gsml:specification", doc);
        LOGGER.info("Response for " + path + " :" + newline + this.prettyString(doc));
    }

    @Test
    public void testGetFeatureWithMappingName() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:GeologicUnit");
        LOGGER.info("WFS GetFeature&typename=gsml:GeologicUnit response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        this.assertXpathEvaluatesTo("3", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(3, "//gsml:GeologicUnit", doc);
    }

    @Test
    public void testComplexTypeWithSimpleContentGML() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=ex:FirstParentFeature");
        LOGGER.info("WFS GetFeature&typename=ex:FirstParentFeature response:\n" + this.prettyString(doc));
        this.assertXpathCount(5, "//ex:FirstParentFeature", doc);
        this.assertXpathCount(2, "//ex:FirstParentFeature[@gml:id='cc.1']/ex:nestedFeature", doc);
        this.assertXpathEvaluatesTo("string_one", "//ex:FirstParentFeature[@gml:id='cc.1']/ex:nestedFeature[1]/ex:SimpleContent/ex:someAttribute", doc);
        this.assertXpathEvaluatesTo("string_two", "//ex:FirstParentFeature[@gml:id='cc.1']/ex:nestedFeature[2]/ex:SimpleContent/ex:someAttribute", doc);
        this.assertXpathCount(0, "//ex:FirstParentFeature[@gml:id='cc.1']/ex:nestedFeature[2]/ex:SimpleContent/FEATURE_LINK", doc);
        this.assertXpathCount(0, "//ex:FirstParentFeature[@gml:id='cc.2']/ex:nestedFeature", doc);
        doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=ex:SecondParentFeature");
        LOGGER.info("WFS GetFeature&typename=ex:SecondParentFeature response:\n" + this.prettyString(doc));
        this.assertXpathCount(5, "//ex:SecondParentFeature", doc);
        this.assertXpathCount(0, "//ex:SecondParentFeature[@gml:id='cc.1']/ex:nestedFeature", doc);
        this.assertXpathCount(3, "//ex:SecondParentFeature[@gml:id='cc.2']/ex:nestedFeature", doc);
        this.assertXpathEvaluatesTo("string_one", "//ex:SecondParentFeature[@gml:id='cc.2']/ex:nestedFeature[1]/ex:SimpleContent/ex:someAttribute", doc);
        this.assertXpathEvaluatesTo("string_two", "//ex:SecondParentFeature[@gml:id='cc.2']/ex:nestedFeature[2]/ex:SimpleContent/ex:someAttribute", doc);
        this.assertXpathEvaluatesTo("string_three", "//ex:SecondParentFeature[@gml:id='cc.2']/ex:nestedFeature[3]/ex:SimpleContent/ex:someAttribute", doc);
    }

    @Test
    public void testComplexTypeWithSimpleContentJSON() throws Exception {
        this.testJsonRequest("ex:FirstParentFeature", "/test-data/FirstParentFeature.json");
    }

    @Test
    public void testGetFeatureContent() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature&featureID=mf1,mf2,mf3,mf4");
        LOGGER.info("WFS GetFeature&typename=gsml:MappedFeature response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("4", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(4, "//gsml:MappedFeature", doc);
        this.checkSchemaLocation(doc);
        String id = "mf1";
        this.assertXpathEvaluatesTo(id, "(//gsml:MappedFeature)[1]/@gml:id", doc);
        this.checkMf1Content(id, doc);
        id = "mf2";
        this.assertXpathEvaluatesTo(id, "(//gsml:MappedFeature)[2]/@gml:id", doc);
        this.checkMf2Content(id, doc);
        id = "mf3";
        this.assertXpathEvaluatesTo(id, "(//gsml:MappedFeature)[3]/@gml:id", doc);
        this.checkMf3Content(id, doc);
        id = "mf4";
        this.assertXpathEvaluatesTo(id, "(//gsml:MappedFeature)[4]/@gml:id", doc);
        this.checkMf4Content(id, doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gu.25678']", doc);
    }

    private void checkSchemaLocation(Document doc) {
        String schemaLocation = this.evaluate("/wfs:FeatureCollection/@xsi:schemaLocation", doc);
        String gsmlLocation = "urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd";
        String wfsLocation = "http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd";
        if (schemaLocation.startsWith("urn:cgi:xmlns:CGI:GeoSciML:2.0")) {
            Assert.assertEquals((Object)(gsmlLocation + " " + wfsLocation), (Object)schemaLocation);
        } else {
            Assert.assertEquals((Object)(wfsLocation + " " + gsmlLocation), (Object)schemaLocation);
        }
    }

    private void checkMf1Content(String id, Document doc) {
        this.assertXpathEvaluatesTo("GUNTHORPE FORMATION", "//gsml:MappedFeature[@gml:id='" + id + "']/gml:name", doc);
        this.assertXpathEvaluatesTo("200.0", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:positionalAccuracy/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:uom:UCUM:m", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:positionalAccuracy/gsml:CGI_NumericValue/gsml:principalValue/@uom", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4326", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:shape/gml:Polygon/@srsName", doc);
        this.assertXpathEvaluatesTo("52.5 -1.2 52.6 -1.2 52.6 -1.1 52.5 -1.1 52.5 -1.2", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:shape//gml:posList", doc);
        this.assertXpathEvaluatesTo("gu.25699", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/@gml:id", doc);
        this.assertXpathEvaluatesTo("Olivine basalt, tuff, microgabbro, minor sedimentary rocks", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:description", doc);
        this.assertXpathCount(2, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name", doc);
        this.assertXpathEvaluatesTo("Yaugher Volcanic Group", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name[@codeSpace='urn:ietf:rfc:2141']", doc);
        ArrayList<String> names = new ArrayList<String>();
        names.add("Yaugher Volcanic Group");
        names.add("-Py");
        String name = this.evaluate("//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name[1]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        name = this.evaluate("//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name[2]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        Assert.assertTrue((boolean)names.isEmpty());
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/FEATURE_LINK", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:occurrence", doc);
        this.assertXpathEvaluatesTo("", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:occurrence[1]", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:MappedFeature:mf1", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:occurrence/@xlink:href", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:exposureColor", doc);
        this.assertXpathEvaluatesTo("Blue", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:exposureColor/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("some:uri", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:exposureColor/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:exposureColor/gsml:CGI_TermValue/FEATURE_LINK", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:outcropCharacter", doc);
        this.assertXpathEvaluatesTo("x", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:outcropCharacter/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:outcropCharacter/gsml:CGI_TermValue/FEATURE_LINK", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition", doc);
        this.assertXpathEvaluatesTo("nonexistent", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:proportion/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("fictitious component", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:role", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:role/FEATURE_LINK", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:lithology", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:lithology/FEATURE_LINK", doc);
    }

    private void checkMf2Content(String id, Document doc) {
        this.assertXpathEvaluatesTo("MERCIA MUDSTONE GROUP", "//gsml:MappedFeature[@gml:id='" + id + "']/gml:name", doc);
        this.assertXpathEvaluatesTo("100.0", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:positionalAccuracy/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:uom:UCUM:m", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:positionalAccuracy/gsml:CGI_NumericValue/gsml:principalValue/@uom", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4326", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:shape/gml:Polygon/@srsName", doc);
        this.assertXpathEvaluatesTo("52.5 -1.3 52.6 -1.3 52.6 -1.2 52.5 -1.2 52.5 -1.3", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:shape//gml:posList", doc);
        this.assertXpathEvaluatesTo("gu.25678", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/@gml:id", doc);
        this.assertXpathCount(3, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name", doc);
        HashMap<String, String> names = new HashMap<String, String>();
        names.put("Yaugher Volcanic Group 1", "urn:ietf:rfc:2141");
        names.put("Yaugher Volcanic Group 2", "urn:ietf:rfc:2141");
        names.put("-Py", "");
        String name = this.evaluate("//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name[1]", doc);
        Assert.assertTrue((boolean)names.containsKey(name));
        this.assertXpathEvaluatesTo((String)names.get(name), "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name[1]/@codeSpace", doc);
        names.remove(name);
        name = this.evaluate("//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name[2]", doc);
        Assert.assertTrue((boolean)names.containsKey(name));
        this.assertXpathEvaluatesTo((String)names.get(name), "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name[2]/@codeSpace", doc);
        names.remove(name);
        name = this.evaluate("//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name[3]", doc);
        Assert.assertTrue((boolean)names.containsKey(name));
        this.assertXpathEvaluatesTo((String)names.get(name), "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name[3]/@codeSpace", doc);
        names.remove(name);
        Assert.assertTrue((boolean)names.isEmpty());
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/FEATURE_LINK", doc);
        this.assertXpathCount(2, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:occurrence", doc);
        this.assertXpathEvaluatesTo("", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:occurrence[1]", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:MappedFeature:mf2", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:occurrence[1]/@xlink:href", doc);
        this.assertXpathEvaluatesTo("", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:occurrence[2]", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:MappedFeature:mf3", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:occurrence[2]/@xlink:href", doc);
        this.assertXpathEvaluatesTo("Olivine basalt, tuff, microgabbro, minor sedimentary rocks", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:description", doc);
        this.assertXpathCount(2, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:exposureColor", doc);
        this.assertXpathEvaluatesTo("Blue", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:exposureColor[1]/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("some:uri", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:exposureColor[1]/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("Yellow", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:exposureColor[2]/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("some:uri", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:exposureColor[2]/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:exposureColor/gsml:CGI_TermValue/FEATURE_LINK", doc);
        this.assertXpathCount(2, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:outcropCharacter", doc);
        this.assertXpathEvaluatesTo("x", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:outcropCharacter[1]/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("y", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:outcropCharacter[2]/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:outcropCharacter/gsml:CGI_TermValue/FEATURE_LINK", doc);
        this.assertXpathCount(2, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition", doc);
        this.assertXpathEvaluatesTo("significant", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition[1]/gsml:CompositionPart/gsml:proportion/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("interbedded component", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit[@gml:id='gu.25678']/gsml:composition[1]/gsml:CompositionPart/gsml:role", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition[1]/gsml:CompositionPart/gsml:role/FEATURE_LINK", doc);
        this.assertXpathEvaluatesTo("minor", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition[2]/gsml:CompositionPart/gsml:proportion/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("interbedded component", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition[2]/gsml:CompositionPart/gsml:role", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition[2]/gsml:CompositionPart/gsml:role/FEATURE_LINK", doc);
        this.assertXpathCount(2, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:lithology", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:lithology/FEATURE_LINK", doc);
    }

    private void checkMf3Content(String id, Document doc) {
        this.assertXpathEvaluatesTo("CLIFTON FORMATION", "//gsml:MappedFeature[@gml:id='" + id + "']/gml:name", doc);
        this.assertXpathEvaluatesTo("150.0", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:positionalAccuracy/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:uom:UCUM:m", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:positionalAccuracy/gsml:CGI_NumericValue/gsml:principalValue/@uom", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4326", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:shape/gml:Polygon/@srsName", doc);
        this.assertXpathEvaluatesTo("52.5 -1.2 52.6 -1.2 52.6 -1.1 52.5 -1.1 52.5 -1.2", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:shape//gml:posList", doc);
        this.assertXpathEvaluatesTo("#gu.25678", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/@xlink:href", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit", doc);
    }

    private void checkMf4Content(String id, Document doc) {
        this.assertXpathEvaluatesTo("MURRADUC BASALT", "//gsml:MappedFeature[@gml:id='" + id + "']/gml:name", doc);
        this.assertXpathEvaluatesTo("120.0", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:positionalAccuracy/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:uom:UCUM:m", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:positionalAccuracy/gsml:CGI_NumericValue/gsml:principalValue/@uom", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4326", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:shape/gml:Polygon/@srsName", doc);
        this.assertXpathEvaluatesTo("52.5 -1.3 52.6 -1.3 52.6 -1.2 52.5 -1.2 52.5 -1.3", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:shape//gml:posList", doc);
        this.assertXpathEvaluatesTo("gu.25682", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/@gml:id", doc);
        this.assertXpathEvaluatesTo("Olivine basalt", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:description", doc);
        this.assertXpathCount(2, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name", doc);
        this.assertXpathEvaluatesTo("New Group", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name[@codeSpace='urn:ietf:rfc:2141']", doc);
        ArrayList<String> names = new ArrayList<String>();
        names.add("New Group");
        names.add("-Xy");
        String name = this.evaluate("//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name[1]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        name = this.evaluate("//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name[2]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        Assert.assertTrue((boolean)names.isEmpty());
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/FEATURE_LINK", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:occurrence", doc);
        this.assertXpathEvaluatesTo("", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:occurrence[1]", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:MappedFeature:mf4", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:occurrence/@xlink:href", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:exposureColor", doc);
        this.assertXpathEvaluatesTo("some:uri", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:exposureColor/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathEvaluatesTo("Red", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:exposureColor/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:exposureColor/gsml:CGI_TermValue/FEATURE_LINK", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:outcropCharacter", doc);
        this.assertXpathEvaluatesTo("z", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:outcropCharacter/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:outcropCharacter/gsml:CGI_TermValue/FEATURE_LINK", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition", doc);
        this.assertXpathEvaluatesTo("significant", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:proportion/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("interbedded component", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:role", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:role/FEATURE_LINK", doc);
        this.assertXpathCount(2, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:lithology", doc);
        this.assertXpathEvaluatesTo("cc.1", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:lithology[1]/gsml:ControlledConcept/@gml:id", doc);
        this.assertXpathCount(3, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:lithology[1]/gsml:ControlledConcept/gml:name", doc);
        names = new ArrayList();
        names.add("name_a");
        names.add("name_b");
        names.add("name_c");
        name = this.evaluate("//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:lithology[1]/gsml:ControlledConcept/gml:name[1]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        name = this.evaluate("//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:lithology[1]/gsml:ControlledConcept/gml:name[2]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        name = this.evaluate("//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:lithology[1]/gsml:ControlledConcept/gml:name[3]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:lithology[1]/FEATURE_LINK", doc);
        this.assertXpathEvaluatesTo("cc.2", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:lithology[2]//gsml:ControlledConcept/@gml:id", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:lithology[2]/gsml:ControlledConcept/gml:name", doc);
        this.assertXpathEvaluatesTo("name_2", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:lithology[2]/gsml:ControlledConcept/gml:name", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:lithology[2]/FEATURE_LINK", doc);
    }

    private void checkGetMf4Only(String xml) {
        Document doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        this.assertXpathEvaluatesTo("1", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature", doc);
        String id = "mf4";
        this.assertXpathEvaluatesTo(id, "//gsml:MappedFeature[1]/@gml:id", doc);
        this.assertXpathEvaluatesTo("MURRADUC BASALT", "//gsml:MappedFeature[@gml:id='" + id + "']/gml:name", doc);
        this.assertXpathEvaluatesTo("gu.25682", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/@gml:id", doc);
    }

    @Test
    public void testGetFeaturePropertyFilter() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\">    <wfs:Query typeName=\"gsml:MappedFeature\">        <ogc:Filter>            <ogc:PropertyIsEqualTo>                <ogc:PropertyName>gml:name</ogc:PropertyName>                <ogc:Literal>MURRADUC BASALT</ogc:Literal>            </ogc:PropertyIsEqualTo>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        this.validate(xml);
        this.checkGetMf4Only(xml);
    }

    @Test
    public void testGetFeatureWithFeatureIdFilter() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\">    <wfs:Query typeName=\"gsml:MappedFeature\">        <ogc:Filter>            <ogc:FeatureId fid=\"mf4\"/>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        this.validate(xml);
        this.checkGetMf4Only(xml);
    }

    @Test
    public void testGetFeatureWithGmlObjectIdFilter() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\">    <wfs:Query typeName=\"gsml:MappedFeature\">        <ogc:Filter>            <ogc:GmlObjectId gml:id=\"mf4\"/>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        this.validate(xml);
        this.checkGetMf4Only(xml);
    }

    @Test
    public void testAnyTypeAndAnyElementGML() {
        String OBSERVATION_ID_PREFIX = "observation:";
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=om:Observation&featureID=observation:mf1,observation:mf2,observation:mf3,observation:mf4");
        LOGGER.info("WFS GetFeature&typename=om:Observation response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("4", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(4, "//om:Observation", doc);
        String id = "mf1";
        this.assertXpathEvaluatesTo("observation:" + id, "(//om:Observation)[1]/@gml:id", doc);
        this.assertXpathEvaluatesTo("651.0", "(//om:Observation)[1]/om:metadata/gsml:CGI_NumericValue/gsml:principalValue", doc);
        Node resultQuality = doc.getElementsByTagName("om:resultQuality").item(0);
        Node geologicUnit = resultQuality.getFirstChild();
        Assert.assertEquals((Object)"gu.25699", (Object)geologicUnit.getAttributes().getNamedItem("gml:id").getNodeValue());
        this.assertXpathEvaluatesTo("", "(//om:Observation)[1]/om:result/text()", doc);
        this.assertXpathEvaluatesTo(id, "(//om:Observation)[1]/om:result/gsml:MappedFeature/@gml:id", doc);
        id = "mf2";
        this.assertXpathEvaluatesTo("observation:" + id, "(//om:Observation)[2]/@gml:id", doc);
        this.assertXpathEvaluatesTo("269.0", "(//om:Observation)[2]/om:metadata/gsml:CGI_NumericValue/gsml:principalValue", doc);
        resultQuality = doc.getElementsByTagName("om:resultQuality").item(1);
        geologicUnit = resultQuality.getFirstChild();
        Assert.assertEquals((Object)"gu.25678", (Object)geologicUnit.getAttributes().getNamedItem("gml:id").getNodeValue());
        this.assertXpathEvaluatesTo("", "(//om:Observation)[2]/om:result/text()", doc);
        this.assertXpathEvaluatesTo(id, "(//om:Observation)[2]/om:result/gsml:MappedFeature/@gml:id", doc);
        id = "mf3";
        this.assertXpathEvaluatesTo("observation:" + id, "(//om:Observation)[3]/@gml:id", doc);
        this.assertXpathEvaluatesTo("123.0", "(//om:Observation)[3]/om:metadata/gsml:CGI_NumericValue/gsml:principalValue", doc);
        resultQuality = doc.getElementsByTagName("om:resultQuality").item(2);
        Assert.assertEquals((Object)"#gu.25678", (Object)resultQuality.getAttributes().getNamedItem("xlink:href").getNodeValue());
        this.assertXpathEvaluatesTo("", "(//om:Observation)[3]/om:result/text()", doc);
        this.assertXpathEvaluatesTo(id, "(//om:Observation)[3]/om:result/gsml:MappedFeature/@gml:id", doc);
        id = "mf4";
        this.assertXpathEvaluatesTo("observation:" + id, "(//om:Observation)[4]/@gml:id", doc);
        this.assertXpathEvaluatesTo("456.0", "(//om:Observation)[4]/om:metadata/gsml:CGI_NumericValue/gsml:principalValue", doc);
        resultQuality = doc.getElementsByTagName("om:resultQuality").item(3);
        geologicUnit = resultQuality.getFirstChild();
        Assert.assertEquals((Object)"gu.25682", (Object)geologicUnit.getAttributes().getNamedItem("gml:id").getNodeValue());
        this.assertXpathEvaluatesTo("", "(//om:Observation)[4]/om:result/text()", doc);
        this.assertXpathEvaluatesTo(id, "(//om:Observation)[4]/om:result/gsml:MappedFeature/@gml:id", doc);
    }

    @Test
    public void testFilteringXlinkHref() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\">    <wfs:Query typeName=\"gsml:MappedFeature\">        <ogc:Filter>            <ogc:PropertyIsEqualTo>                <ogc:PropertyName>gsml:specification/gsml:GeologicUnit/gml:name</ogc:PropertyName>                <ogc:Literal>Yaugher Volcanic Group</ogc:Literal>            </ogc:PropertyIsEqualTo>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        this.validate(xml);
        Document doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        this.assertXpathEvaluatesTo("1", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature", doc);
        this.assertXpathEvaluatesTo("mf1", "//gsml:MappedFeature/@gml:id", doc);
    }

    @Test
    public void testFilteringNestedMultiValuedAttribute() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\">    <wfs:Query typeName=\"gsml:MappedFeature\">        <ogc:Filter>            <ogc:PropertyIsEqualTo>                <ogc:Literal>Yaugher Volcanic Group 2</ogc:Literal>                <ogc:PropertyName>gsml:specification/gsml:GeologicUnit/gml:name</ogc:PropertyName>            </ogc:PropertyIsEqualTo>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        this.validate(xml);
        Document doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        this.assertXpathEvaluatesTo("2", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(2, "//gsml:MappedFeature", doc);
        this.assertXpathEvaluatesTo("mf2", "(//gsml:MappedFeature)[1]/@gml:id", doc);
        this.assertXpathEvaluatesTo("mf3", "(//gsml:MappedFeature)[2]/@gml:id", doc);
        xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\">    <wfs:Query typeName=\"gsml:MappedFeature\">        <ogc:Filter>            <ogc:PropertyIsLike wildCard=\"*\" singleChar=\"#\" escapeChar=\"!\">                <ogc:PropertyName>gsml:specification/gsml:GeologicUnit/gml:name</ogc:PropertyName>                <ogc:Literal>Yaugher Volcanic Group*</ogc:Literal>            </ogc:PropertyIsLike>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        this.validate(xml);
        doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        this.assertXpathEvaluatesTo("3", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(3, "//gsml:MappedFeature", doc);
        this.assertXpathEvaluatesTo("mf1", "(//gsml:MappedFeature)[1]/@gml:id", doc);
        this.assertXpathEvaluatesTo("mf2", "(//gsml:MappedFeature)[2]/@gml:id", doc);
        this.assertXpathEvaluatesTo("mf3", "(//gsml:MappedFeature)[3]/@gml:id", doc);
    }

    @Test
    public void testFilterAnd() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\"><wfs:Query typeName=\"gsml:MappedFeature\">    <ogc:Filter>        <ogc:And>            <ogc:PropertyIsEqualTo>                <ogc:Literal>significant</ogc:Literal>                <ogc:PropertyName>gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:proportion/gsml:CGI_TermValue/gsml:value</ogc:PropertyName>            </ogc:PropertyIsEqualTo>            <ogc:PropertyIsEqualTo>                 <ogc:Literal>New Group</ogc:Literal>                 <ogc:PropertyName>gsml:specification/gsml:GeologicUnit/gml:name</ogc:PropertyName>            </ogc:PropertyIsEqualTo>        </ogc:And>    </ogc:Filter></wfs:Query> </wfs:GetFeature>";
        this.validate(xml);
        Document doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        this.assertXpathEvaluatesTo("1", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature", doc);
        this.assertXpathEvaluatesTo("mf4", "//gsml:MappedFeature/@gml:id", doc);
    }

    @Test
    public void testDenormalisedFeaturesCount() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:GeologicUnit&maxFeatures=3");
        LOGGER.info("WFS GetFeature&typename=gsml:GeologicUnit&maxFeatures=3 response:\n" + this.prettyString(doc));
        this.assertXpathCount(3, "//gsml:GeologicUnit", doc);
        String id = "gu.25678";
        this.assertXpathEvaluatesTo(id, "(//gsml:GeologicUnit)[1]/@gml:id", doc);
        id = "gu.25682";
        this.assertXpathEvaluatesTo(id, "(//gsml:GeologicUnit)[2]/@gml:id", doc);
        id = "gu.25699";
        this.assertXpathEvaluatesTo(id, "(//gsml:GeologicUnit)[3]/@gml:id", doc);
    }

    @Test
    @Ignore
    public void testEncodeFeatureMember() throws Exception {
        WFSInfo wfs = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        boolean encodeFeatureMember = wfs.isEncodeFeatureMember();
        wfs.setEncodeFeatureMember(true);
        this.getGeoServer().save((ServiceInfo)wfs);
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature,gsml:GeologicUnit");
        LOGGER.info("WFS GetFeature&typename=gsml:MappedFeature,gsml:GeologicUnit response:\n" + this.prettyString(doc));
        this.checkSchemaLocation(doc);
        this.assertXpathEvaluatesTo("8", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(5, "//gsml:MappedFeature", doc);
        Assert.assertEquals((long)8L, (long)doc.getElementsByTagName("gml:featureMember").getLength());
        Assert.assertEquals((long)0L, (long)doc.getElementsByTagName("gml:featureMembers").getLength());
        String id = "mf1";
        this.checkMf1Content(id, doc);
        id = "mf2";
        this.checkMf2Content(id, doc);
        id = "mf3";
        this.checkMf3Content(id, doc);
        id = "mf4";
        this.checkMf4Content(id, doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gu.25699']", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gu.25678']", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gu.25682']", doc);
        this.assertXpathCount(1, "//gml:featureMember[@xlink:href='#gu.25699']", doc);
        this.assertXpathCount(1, "//gml:featureMember[@xlink:href='#gu.25678']", doc);
        this.assertXpathCount(1, "//gml:featureMember[@xlink:href='#gu.25682']", doc);
        wfs = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        wfs.setEncodeFeatureMember(encodeFeatureMember);
        this.getGeoServer().save((ServiceInfo)wfs);
    }

    @Test
    public void testEncodeFeatureMembersGML() throws Exception {
        WFSInfo wfs = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        boolean encodeFeatureMember = wfs.isEncodeFeatureMember();
        wfs.setEncodeFeatureMember(false);
        this.getGeoServer().save((ServiceInfo)wfs);
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature,gsml:GeologicUnit");
        LOGGER.info("WFS GetFeature&typename=gsml:MappedFeature,gsml:GeologicUnit response:\n" + this.prettyString(doc));
        this.checkSchemaLocation(doc);
        this.assertXpathEvaluatesTo("8", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(5, "//gsml:MappedFeature", doc);
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagName("gml:featureMembers").getLength());
        Assert.assertEquals((long)0L, (long)doc.getElementsByTagName("gml:featureMember").getLength());
        String id = "mf1";
        this.checkMf1Content(id, doc);
        id = "mf2";
        this.checkMf2Content(id, doc);
        id = "mf3";
        this.checkMf3Content(id, doc);
        id = "mf4";
        this.checkMf4Content(id, doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gu.25699']", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gu.25678']", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gu.25682']", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@xlink:href='#gu.25699']", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@xlink:href='#gu.25678']", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@xlink:href='#gu.25682']", doc);
        wfs = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        wfs.setEncodeFeatureMember(encodeFeatureMember);
        this.getGeoServer().save((ServiceInfo)wfs);
    }

    @Test
    public void testNestedFilterEncoding() throws FilterToSQLException, IOException {
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName("gsml", "MappedFeature");
        FeatureSource fs = ftInfo.getFeatureSource((ProgressListener)new NullProgressListener(), null);
        AppSchemaDataAccess da = (AppSchemaDataAccess)fs.getDataStore();
        FeatureTypeMapping rootMapping = da.getMappingByNameOrElement(ftInfo.getQualifiedName());
        Assume.assumeTrue((boolean)this.shouldTestNestedFiltersEncoding(rootMapping));
        JDBCDataStore store = (JDBCDataStore)rootMapping.getSource().getDataStore();
        NestedFilterToSQL nestedFilterToSQL = this.createNestedFilterEncoder(rootMapping);
        FilterFactoryImplNamespaceAware ff = new FilterFactoryImplNamespaceAware();
        ff.setNamepaceContext(rootMapping.getNamespaces());
        And and = ff.and((Filter)ff.equals((Expression)ff.property("gsml:specification/gsml:GeologicUnit/gml:name"), (Expression)ff.literal((Object)"New Group")), (Filter)ff.equals((Expression)ff.property("gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:proportion/gsml:CGI_TermValue/gsml:value"), (Expression)ff.literal((Object)"significant")));
        ComplexFilterSplitter splitter = new ComplexFilterSplitter(store.getFilterCapabilities(), rootMapping);
        splitter.visit(and, null);
        Filter preFilter = splitter.getFilterPre();
        Filter postFilter = splitter.getFilterPost();
        Assert.assertEquals((Object)and, (Object)preFilter);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)postFilter);
        Filter unrolled = AppSchemaDataAccess.unrollFilter((Filter)and, (FeatureTypeMapping)rootMapping);
        Assert.assertTrue((boolean)NestedFilterToSQL.isNestedFilter((Filter)unrolled));
        String encodedFilter = nestedFilterToSQL.encodeToString(unrolled);
        Assert.assertTrue((boolean)encodedFilter.matches("^\\(EXISTS.*AND EXISTS.*\\)$"));
        this.assertContainsFeatures(fs.getFeatures((Filter)and), "mf4");
        PropertyIsLike like = ff.like((Expression)ff.property("gsml:specification/gsml:GeologicUnit/gml:description"), "*sedimentary*");
        ComplexFilterSplitter splitterLike = new ComplexFilterSplitter(store.getFilterCapabilities(), rootMapping);
        splitterLike.visit(like, null);
        preFilter = splitterLike.getFilterPre();
        postFilter = splitterLike.getFilterPost();
        Assert.assertEquals((Object)like, (Object)preFilter);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)postFilter);
        unrolled = AppSchemaDataAccess.unrollFilter((Filter)like, (FeatureTypeMapping)rootMapping);
        Assert.assertTrue((boolean)NestedFilterToSQL.isNestedFilter((Filter)unrolled));
        encodedFilter = nestedFilterToSQL.encodeToString(unrolled);
        Assert.assertTrue((boolean)encodedFilter.contains("EXISTS"));
        this.assertContainsFeatures(fs.getFeatures((Filter)like), "mf1", "mf2", "mf3");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNestedFilterEncodingDisabled() throws IOException, FilterToSQLException {
        AppSchemaDataAccessRegistry.getAppSchemaProperties().setProperty(AppSchemaDataAccessConfigurator.PROPERTY_ENCODE_NESTED_FILTERS, "false");
        try {
            Assert.assertFalse((boolean)AppSchemaDataAccessConfigurator.shouldEncodeNestedFilters());
            FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName("gsml", "MappedFeature");
            FeatureSource fs = ftInfo.getFeatureSource((ProgressListener)new NullProgressListener(), null);
            AppSchemaDataAccess da = (AppSchemaDataAccess)fs.getDataStore();
            FeatureTypeMapping rootMapping = da.getMappingByNameOrElement(ftInfo.getQualifiedName());
            Assume.assumeTrue((boolean)(rootMapping.getSource().getDataStore() instanceof JDBCDataStore));
            JDBCDataStore store = (JDBCDataStore)rootMapping.getSource().getDataStore();
            FilterFactoryImplNamespaceAware ff = new FilterFactoryImplNamespaceAware();
            ff.setNamepaceContext(rootMapping.getNamespaces());
            PropertyIsLike like = ff.like((Expression)ff.property("gsml:specification/gsml:GeologicUnit/gml:description"), "*sedimentary*");
            ComplexFilterSplitter splitterLike = new ComplexFilterSplitter(store.getFilterCapabilities(), rootMapping);
            splitterLike.visit(like, null);
            Filter preFilter = splitterLike.getFilterPre();
            Filter postFilter = splitterLike.getFilterPost();
            Assert.assertEquals((Object)Filter.INCLUDE, (Object)preFilter);
            Assert.assertEquals((Object)like, (Object)postFilter);
            Filter unrolled = AppSchemaDataAccess.unrollFilter((Filter)like, (FeatureTypeMapping)rootMapping);
            Assert.assertTrue((boolean)NestedFilterToSQL.isNestedFilter((Filter)unrolled));
            this.assertContainsFeatures(fs.getFeatures((Filter)like), "mf1", "mf2", "mf3");
        }
        finally {
            AppSchemaDataAccessRegistry.getAppSchemaProperties().setProperty(AppSchemaDataAccessConfigurator.PROPERTY_ENCODE_NESTED_FILTERS, "true");
        }
    }

    @Test
    public void testNonValidNestedGML() throws Exception {
        Document result = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=ex:ParentFeature");
        this.assertXpathCount(3, "//ex:ParentFeature", result);
        this.assertXpathCount(9, "//ex:ParentFeature/ex:nestedFeature", result);
        this.assertXpathCount(9, "//ex:ParentFeature/ex:nestedFeature/ex:nestedValue", result);
        this.assertXpathCount(1, "//ex:ParentFeature[@gml:id='sc.1']/ex:parentValue[text()='string_one']", result);
        this.assertXpathCount(1, "//ex:ParentFeature[@gml:id='sc.1']/ex:nestedFeature/ex:nestedValue[text()='1GRAV']", result);
        this.assertXpathCount(1, "//ex:ParentFeature[@gml:id='sc.1']/ex:nestedFeature/ex:nestedValue[text()='1TILL']", result);
        this.assertXpathCount(1, "//ex:ParentFeature[@gml:id='sc.1']/ex:nestedFeature/ex:nestedValue[text()='6ALLU']", result);
        this.assertXpathCount(1, "//ex:ParentFeature[@gml:id='sc.2']/ex:parentValue[text()='string_two']", result);
        this.assertXpathCount(1, "//ex:ParentFeature[@gml:id='sc.2']/ex:nestedFeature/ex:nestedValue[text()='1GRAV']", result);
        this.assertXpathCount(1, "//ex:ParentFeature[@gml:id='sc.2']/ex:nestedFeature/ex:nestedValue[text()='1TILL']", result);
        this.assertXpathCount(1, "//ex:ParentFeature[@gml:id='sc.2']/ex:nestedFeature/ex:nestedValue[text()='6ALLU']", result);
        this.assertXpathCount(1, "//ex:ParentFeature[@gml:id='sc.3']/ex:parentValue[text()='string_three']", result);
        this.assertXpathCount(1, "//ex:ParentFeature[@gml:id='sc.3']/ex:nestedFeature/ex:nestedValue[text()='1GRAV']", result);
        this.assertXpathCount(1, "//ex:ParentFeature[@gml:id='sc.3']/ex:nestedFeature/ex:nestedValue[text()='1TILL']", result);
        this.assertXpathCount(1, "//ex:ParentFeature[@gml:id='sc.3']/ex:nestedFeature/ex:nestedValue[text()='6ALLU']", result);
    }

    @Test
    public void testNonValidNestedJSON() throws Exception {
        this.testJsonRequest("ex:ParentFeature", "/test-data/ParentFeature.json");
    }

    private void testJsonRequest(String featureType, String expectResultPath) throws Exception {
        String request = String.format("wfs?request=GetFeature&version=1.1.0&typename=%s&outputFormat=application/json", featureType);
        JSON result = this.getAsJSON(request);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.instanceOf(JSONObject.class));
        JSONObject resultJson = (JSONObject)result;
        JSONObject expectedJson = this.readJsonObject(expectResultPath);
        resultJson.remove("timeStamp");
        MatcherAssert.assertThat((Object)resultJson, (Matcher)CoreMatchers.is((Object)expectedJson));
    }

    private JSONObject readJsonObject(String resourcePath) throws Exception {
        try (InputStream input = ((Object)((Object)this)).getClass().getResourceAsStream(resourcePath);){
            MatcherAssert.assertThat((Object)input, (Matcher)CoreMatchers.notNullValue());
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)input, (OutputStream)output);
            String jsonText = new String(output.toByteArray());
            JSONObject jSONObject = JSONObject.fromObject((Object)jsonText);
            return jSONObject;
        }
    }

    private void assertImportExists(Document doc, String ns) {
        this.assertXpathCount(1, "//xsd:import[@namespace='" + ns + "']", doc);
    }

    private void assertImportNotExists(Document doc, String ns) {
        this.assertXpathCount(0, "//xsd:import[@namespace='" + ns + "']", doc);
    }

    private void assertIncludeExists(Document doc, String schemaLocation) {
        this.assertXpathCount(1, "//xsd:include[@schemaLocation='" + schemaLocation + "']", doc);
    }
}

