/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.MeasureTypeBindingTestMockData;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MeasureTypeBindingTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected MeasureTypeBindingTestMockData createTestData() {
        return new MeasureTypeBindingTestMockData();
    }

    @Test
    public void testMeasureTypeBindingWithoutUOM() {
        String path = "wfs?request=GetFeature&version=1.1.0&typename=ex:PolymorphicFeature";
        Document doc = this.getAsDOM(path);
        LOGGER.info("WFS GetFeature&typename=ex:PolymorphicFeature response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//ex:PolymorphicFeature", doc);
        Node feature = doc.getElementsByTagName("ex:PolymorphicFeature").item(0);
        Assert.assertEquals((Object)"ex:PolymorphicFeature", (Object)feature.getNodeName());
        this.assertXpathEvaluatesTo("f1", "//ex:PolymorphicFeature/@gml:id", doc);
        Node firstValue = feature.getFirstChild();
        Assert.assertEquals((Object)"ex:firstValue", (Object)firstValue.getNodeName());
        Node cgi_numericValue = firstValue.getFirstChild();
        Assert.assertEquals((Object)"gsml:CGI_NumericValue", (Object)cgi_numericValue.getNodeName());
        Assert.assertEquals((Object)"1.0", (Object)cgi_numericValue.getFirstChild().getFirstChild().getNodeValue());
        Node secondValue = firstValue.getNextSibling();
        Assert.assertEquals((Object)"ex:secondValue", (Object)secondValue.getNodeName());
        cgi_numericValue = secondValue.getFirstChild();
        Assert.assertEquals((Object)"gsml:CGI_NumericValue", (Object)cgi_numericValue.getNodeName());
        Assert.assertEquals((Object)"1.0", (Object)cgi_numericValue.getFirstChild().getFirstChild().getNodeValue());
        Node thirdValue = secondValue.getNextSibling();
        Assert.assertEquals((Object)"ex:thirdValue", (Object)thirdValue.getNodeName());
        cgi_numericValue = thirdValue.getFirstChild();
        Assert.assertEquals((Object)"gsml:CGI_NumericValue", (Object)cgi_numericValue.getNodeName());
        Assert.assertEquals((Object)"1.0", (Object)cgi_numericValue.getFirstChild().getFirstChild().getNodeValue());
        Node fourthValue = thirdValue.getNextSibling();
        Assert.assertEquals((Object)"ex:fourthValue", (Object)fourthValue.getNodeName());
        cgi_numericValue = fourthValue.getFirstChild();
        Assert.assertEquals((Object)"gsml:CGI_NumericValue", (Object)cgi_numericValue.getNodeName());
        Assert.assertEquals((Object)"1.0", (Object)cgi_numericValue.getFirstChild().getFirstChild().getNodeValue());
    }
}

