/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.StationsMockData;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.util.ProgressListener;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.appschema.jdbc.NestedFilterToSQL;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.filter.ComplexFilterSplitter;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.data.util.NullProgressListener;
import org.geotools.feature.NameImpl;
import org.geotools.jdbc.JDBCDataStore;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class NestedGeometryFilterEncodingTest
extends AbstractAppSchemaTestSupport {
    private static final String GML32_PREFIX = "gml32";
    private static final String STATION_FEATURE = "st_gml32:StationWithMeasurements_gml32";
    private static final Name STATION_FEATURE_NAME = new NameImpl("http://www.stations_gml32.org/1.0", "StationWithMeasurements_gml32");
    private static final String STATION_NESTED_GEOM = "st_gml32:measurements/ms_gml32:Measurement_gml32/ms_gml32:sampledArea/ms_gml32:SampledArea/ms_gml32:geometry";
    private static final String STATION_NONEXISTENT_NESTED_GEOM = "st_gml32:measurements/ms_gml32:Measurement_gml32/ms_gml32:sampledArea/ms_gml32:SampledArea/ms_gml32:not_there_geometry";
    private static final String STATION_WRONG_NESTED_GEOM = "st_gml32:measurements/ms_gml32:Measurement_gml32/ms_gml32:sampledArea/ms_gml32:SampledArea/ms_gml32:code";
    AppSchemaDataAccess dataAccess;
    private FeatureTypeMapping rootMapping;
    private FilterFactory ff;
    private WKTReader wktReader = new WKTReader();

    @Override
    protected StationsMockData createTestData() {
        return new MockData();
    }

    @Before
    public void setUpTest() throws IOException {
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(STATION_FEATURE);
        FeatureSource fs = ftInfo.getFeatureSource((ProgressListener)new NullProgressListener(), null);
        this.dataAccess = (AppSchemaDataAccess)fs.getDataStore();
        this.rootMapping = this.dataAccess.getMappingByNameOrElement(ftInfo.getQualifiedName());
        Assert.assertNotNull((Object)this.rootMapping);
        this.ff = new FilterFactoryImplNamespaceAware(this.rootMapping.getNamespaces());
    }

    @Test
    public void testNestedBBOXFilterEncoding() throws FilterToSQLException, IOException {
        Assume.assumeTrue((boolean)this.shouldTestNestedFiltersEncoding(this.rootMapping));
        PropertyName nestedGeom = this.ff.property(STATION_NESTED_GEOM);
        BBOX bbox = this.ff.bbox((Expression)nestedGeom, -4.0, 2.5, 0.0, 4.0, "EPSG:4326");
        this.checkPostPreFilterSplitting((Filter)bbox);
        this.checkFilterEncoding((Filter)bbox);
        this.checkFeatures((Filter)bbox, "2");
    }

    @Test
    public void testNestedContainsFilterEncoding() throws FilterToSQLException, IOException, ParseException {
        Assume.assumeTrue((boolean)this.shouldTestNestedFiltersEncoding(this.rootMapping));
        PropertyName nestedGeom = this.ff.property(STATION_NESTED_GEOM);
        Polygon contained = (Polygon)this.wktReader.read("POLYGON((-1.5 -1.5, -1.5 1.5, 0 1.5, 0 -1.5, -1.5 -1.5))");
        Contains contains = this.ff.contains((Expression)nestedGeom, (Expression)this.ff.literal((Object)contained));
        this.checkPostPreFilterSplitting((Filter)contains);
        this.checkFilterEncoding((Filter)contains);
        this.checkFeatures((Filter)contains, "1");
    }

    @Test
    public void testNestedTouchesFilterEncoding() throws FilterToSQLException, IOException, ParseException {
        Assume.assumeTrue((boolean)this.shouldTestNestedFiltersEncoding(this.rootMapping));
        PropertyName nestedGeom = this.ff.property(STATION_NESTED_GEOM);
        Polygon touching = (Polygon)this.wktReader.read("POLYGON((-5 -2, -5 0, -4 0, -4 -2, -5 -2))");
        Touches touches = this.ff.touches((Expression)nestedGeom, (Expression)this.ff.literal((Object)touching));
        this.checkPostPreFilterSplitting((Filter)touches);
        this.checkFilterEncoding((Filter)touches);
        this.checkFeatures((Filter)touches, "3");
    }

    @Test
    public void testNestedIntersectsFilterEncoding() throws FilterToSQLException, IOException, ParseException {
        Assume.assumeTrue((boolean)this.shouldTestNestedFiltersEncoding(this.rootMapping));
        PropertyName nestedGeom = this.ff.property(STATION_NESTED_GEOM);
        Polygon intersecting = (Polygon)this.wktReader.read("POLYGON((0 0, -4 4, 0 4, 0 0))");
        Intersects intersects = this.ff.intersects((Expression)nestedGeom, (Expression)this.ff.literal((Object)intersecting));
        this.checkPostPreFilterSplitting((Filter)intersects);
        this.checkFilterEncoding((Filter)intersects);
        this.checkFeatures((Filter)intersects, "1", "2");
    }

    @Test
    public void testNestedOverlapsFilterEncoding() throws FilterToSQLException, IOException, ParseException {
        Assume.assumeTrue((boolean)this.shouldTestNestedFiltersEncoding(this.rootMapping));
        PropertyName nestedGeom = this.ff.property(STATION_NESTED_GEOM);
        Polygon intersecting = (Polygon)this.wktReader.read("POLYGON((-4 3, -2 4.5, -2.5 2, -3.5 2, -4 3))");
        Overlaps overlaps = this.ff.overlaps((Expression)nestedGeom, (Expression)this.ff.literal((Object)intersecting));
        this.checkPostPreFilterSplitting((Filter)overlaps);
        this.checkFilterEncoding((Filter)overlaps);
        this.checkFeatures((Filter)overlaps, "2");
    }

    @Test
    public void testNestedWithinFilterEncoding() throws Exception {
        Assume.assumeTrue((boolean)this.shouldTestNestedFiltersEncoding(this.rootMapping));
        PropertyName nestedGeom = this.ff.property(STATION_NESTED_GEOM);
        Polygon container = (Polygon)this.wktReader.read("POLYGON((-4 -3, -4 3, -1 3, -1 -3, -4 -3))");
        Within within = this.ff.within((Expression)nestedGeom, (Expression)this.ff.literal((Object)container));
        this.checkPostPreFilterSplitting((Filter)within);
        this.checkFilterEncoding((Filter)within);
        this.checkFeatures((Filter)within, "2", "3");
    }

    @Test
    public void testNestedCrossesFilterEncoding() throws Exception {
        Assume.assumeTrue((boolean)this.shouldTestNestedFiltersEncoding(this.rootMapping));
        PropertyName nestedGeom = this.ff.property(STATION_NESTED_GEOM);
        LineString container = (LineString)this.wktReader.read("LINESTRING(-5.5 -5, -5 -3, -3 -2)");
        Crosses crosses = this.ff.crosses((Expression)this.ff.literal((Object)container), (Expression)nestedGeom);
        this.checkPostPreFilterSplitting((Filter)crosses);
        this.checkFilterEncoding((Filter)crosses);
        this.checkFeatures((Filter)crosses, "3");
    }

    @Test
    public void testNestedDisjointFilterEncoding() throws Exception {
        Assume.assumeTrue((boolean)this.shouldTestNestedFiltersEncoding(this.rootMapping));
        PropertyName nestedGeom = this.ff.property(STATION_NESTED_GEOM);
        Polygon poly = (Polygon)this.wktReader.read("POLYGON((-5 -4, -5 -2, -3 -2, -3 -4, -5 -4))");
        Disjoint disjoint = this.ff.disjoint((Expression)this.ff.literal((Object)poly), (Expression)nestedGeom);
        this.checkPostPreFilterSplitting((Filter)disjoint);
        this.checkFilterEncoding((Filter)disjoint);
        this.checkFeatures((Filter)disjoint, "1", "2");
    }

    @Test
    public void testNestedEqualsFilterEncoding() throws Exception {
        Assume.assumeTrue((boolean)this.shouldTestNestedFiltersEncoding(this.rootMapping));
        PropertyName nestedGeom = this.ff.property(STATION_NESTED_GEOM);
        Polygon st1 = (Polygon)this.wktReader.read("POLYGON((-2 2, 0 2, 0 -2, -2 -2, -2 2))");
        Equals equal = this.ff.equal((Expression)this.ff.literal((Object)st1), (Expression)nestedGeom);
        this.checkPostPreFilterSplitting((Filter)equal);
        this.checkFilterEncoding((Filter)equal);
        this.checkFeatures((Filter)equal, "1");
    }

    @Test
    public void testNestedBeyondFilterEncoding() throws Exception {
        Assume.assumeTrue((boolean)this.shouldTestNestedFiltersEncoding(this.rootMapping));
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
        String units = crs.getCoordinateSystem().getAxis(0).getUnit().toString();
        PropertyName nestedGeom = this.ff.property(STATION_NESTED_GEOM);
        Polygon beyondSt2 = (Polygon)this.wktReader.read("POLYGON((-5 -4, -5 -2.5, -2 -2.5, -2 -4, -5 -4))");
        Beyond beyond = this.ff.beyond((Expression)nestedGeom, (Expression)this.ff.literal((Object)beyondSt2), 1.0, units);
        this.checkPostPreFilterSplitting((Filter)beyond);
        this.checkFilterEncoding((Filter)beyond);
        this.checkFeatures((Filter)beyond, "1", "2");
    }

    @Test
    public void testNestedDWithinFilterEncoding() throws Exception {
        Assume.assumeTrue((boolean)this.shouldTestNestedFiltersEncoding(this.rootMapping));
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
        String units = crs.getCoordinateSystem().getAxis(0).getUnit().toString();
        PropertyName nestedGeom = this.ff.property(STATION_NESTED_GEOM);
        Polygon dwithinSt2 = (Polygon)this.wktReader.read("POLYGON((-5 -4, -5 -2.5, -2 -2.5, -2 -4, -5 -4))");
        DWithin dwithin = this.ff.dwithin((Expression)nestedGeom, (Expression)this.ff.literal((Object)dwithinSt2), 1.0, units);
        this.checkPostPreFilterSplitting((Filter)dwithin);
        this.checkFilterEncoding((Filter)dwithin);
        this.checkFeatures((Filter)dwithin, "3");
    }

    @Test
    public void testNesteGeometryFilterOnNonExistentProperty() throws Exception {
        Assume.assumeTrue((boolean)this.shouldTestNestedFiltersEncoding(this.rootMapping));
        PropertyName nestedGeom = this.ff.property(STATION_NONEXISTENT_NESTED_GEOM);
        Polygon intersecting = (Polygon)this.wktReader.read("POLYGON((0 0, -4 4, 0 4, 0 0))");
        Intersects intersects = this.ff.intersects((Expression)nestedGeom, (Expression)this.ff.literal((Object)intersecting));
        try {
            this.checkPostPreFilterSplitting((Filter)intersects);
            Assert.fail((String)"Expected IllegalArgumentException to be thrown, but none was thrown instead");
        }
        catch (IllegalArgumentException iae) {
            String errorMessage = iae.getMessage();
            Assert.assertTrue((boolean)errorMessage.contains("not_there_geometry"));
            Assert.assertTrue((boolean)errorMessage.contains("not found in type"));
        }
        catch (Exception other) {
            Assert.fail((String)("Expected IllegalArgumentException to be thrown, but " + other.getClass().getName() + " was thrown instead"));
        }
    }

    @Test
    public void testNesteGeometryFilterOnNonGeometryProperty() throws Exception {
        Assume.assumeTrue((boolean)this.shouldTestNestedFiltersEncoding(this.rootMapping));
        PropertyName nestedGeom = this.ff.property(STATION_WRONG_NESTED_GEOM);
        BBOX bbox = this.ff.bbox((Expression)nestedGeom, -4.0, 2.5, 0.0, 4.0, "EPSG:4326");
        try {
            this.checkPostPreFilterSplitting((Filter)bbox);
            Assert.fail((String)"Expected IllegalArgumentException to be thrown, but none was thrown instead");
        }
        catch (IllegalArgumentException iae) {
            String errorMessage = iae.getMessage();
            Assert.assertTrue((boolean)errorMessage.contains("code"));
            Assert.assertTrue((boolean)errorMessage.contains("AttributeDescriptor"));
            Assert.assertTrue((boolean)errorMessage.contains("should be of type"));
            Assert.assertTrue((boolean)errorMessage.contains("GeometryDescriptor"));
        }
        catch (Exception other) {
            Assert.fail((String)("Expected IllegalArgumentException to be thrown, but " + other.getClass().getName() + " was thrown instead"));
        }
    }

    CoordinateReferenceSystem getCoordinateReferenceSystem() throws IOException {
        return this.dataAccess.getSchema(STATION_FEATURE_NAME).getGeometryDescriptor().getCoordinateReferenceSystem();
    }

    private void checkPostPreFilterSplitting(Filter filter) {
        JDBCDataStore store = (JDBCDataStore)this.rootMapping.getSource().getDataStore();
        ComplexFilterSplitter splitter = new ComplexFilterSplitter(store.getFilterCapabilities(), this.rootMapping);
        filter.accept((FilterVisitor)splitter, null);
        Filter preFilter = splitter.getFilterPre();
        Filter postFilter = splitter.getFilterPost();
        Assert.assertEquals((Object)filter, (Object)preFilter);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)postFilter);
    }

    private void checkFilterEncoding(Filter filter) throws FilterToSQLException {
        Filter unrolled = AppSchemaDataAccess.unrollFilter((Filter)filter, (FeatureTypeMapping)this.rootMapping);
        Assert.assertTrue((boolean)NestedFilterToSQL.isNestedFilter((Filter)unrolled));
        NestedFilterToSQL nestedFilterToSQL = this.createNestedFilterEncoder(this.rootMapping);
        String encodedFilter = nestedFilterToSQL.encodeToString(unrolled);
        Assert.assertTrue((boolean)encodedFilter.contains("EXISTS"));
    }

    private void checkFeatures(Filter filter, String ... fids) throws IOException {
        FeatureSource fs = this.dataAccess.getFeatureSource(STATION_FEATURE_NAME);
        this.assertContainsFeatures(fs.getFeatures(filter), fids);
    }

    private static final class MockData
    extends StationsMockData {
        private MockData() {
        }

        @Override
        public void addContent() {
            this.putNamespace("st_gml32", "http://www.stations_gml32.org/1.0");
            this.putNamespace("ms_gml32", "http://www.measurements_gml32.org/1.0");
            HashMap<String, String> gml32Parameters = new HashMap<String, String>();
            gml32Parameters.put("GML_PREFIX", NestedGeometryFilterEncodingTest.GML32_PREFIX);
            gml32Parameters.put("GML_NAMESPACE", "http://www.opengis.net/gml/3.2");
            gml32Parameters.put("GML_LOCATION", "http://schemas.opengis.net/gml/3.2.1/gml.xsd");
            this.addStationFeatureType("st_gml32", NestedGeometryFilterEncodingTest.GML32_PREFIX, "StationWithMeasurements", "stations", "defaultGeometry/stations2.xml", "measurements", "defaultGeometry/measurements.xml", gml32Parameters);
            this.addMeasurementFeatureType("ms_gml32", NestedGeometryFilterEncodingTest.GML32_PREFIX, "measurements", "defaultGeometry/measurements.xml", gml32Parameters);
        }

        protected void addStationFeatureType(String namespacePrefix, String gmlPrefix, String stationsFeatureType, String stationsMappingsName, String stationsMappingsPath, String measurementsMappingsName, String measurementsMappingsPath, Map<String, String> parameters) {
            File gmlDirectory = this.getDirectoryForGmlPrefix(gmlPrefix);
            gmlDirectory.mkdirs();
            File stationsMappings = new File(gmlDirectory, String.format("%s_%s.xml", stationsMappingsName, gmlPrefix));
            File stationsProperties = new File(gmlDirectory, String.format("stations_%s.properties", gmlPrefix));
            File stationsSchema = new File(gmlDirectory, String.format("stations_%s.xsd", gmlPrefix));
            File measurementsSchema = new File(gmlDirectory, String.format("measurements_%s.xsd", gmlPrefix));
            MockData.substituteParameters("/test-data/stations/" + stationsMappingsPath, parameters, stationsMappings);
            MockData.substituteParameters("/test-data/stations/defaultGeometry/stations.properties", parameters, stationsProperties);
            MockData.substituteParameters("/test-data/stations/defaultGeometry/stations.xsd", parameters, stationsSchema);
            MockData.substituteParameters("/test-data/stations/defaultGeometry/measurements.xsd", parameters, measurementsSchema);
            this.addFeatureType(namespacePrefix, String.format("%s_%s", stationsFeatureType, gmlPrefix), stationsMappings.getAbsolutePath(), stationsProperties.getAbsolutePath(), stationsSchema.getAbsolutePath(), measurementsSchema.getAbsolutePath());
        }

        @Override
        protected void addMeasurementFeatureType(String namespacePrefix, String gmlPrefix, String mappingsName, String mappingsPath, Map<String, String> parameters) {
            File gmlDirectory = this.getDirectoryForGmlPrefix(gmlPrefix);
            gmlDirectory.mkdirs();
            File measurementsMappings = new File(gmlDirectory, String.format("%s_%s.xml", mappingsName, gmlPrefix));
            File measurementsProperties = new File(gmlDirectory, String.format("measurements_%s.properties", gmlPrefix));
            File measurementsSchema = new File(gmlDirectory, String.format("measurements_%s.xsd", gmlPrefix));
            MockData.substituteParameters("/test-data/stations/" + mappingsPath, parameters, measurementsMappings);
            MockData.substituteParameters("/test-data/stations/defaultGeometry/measurements.properties", parameters, measurementsProperties);
            MockData.substituteParameters("/test-data/stations/defaultGeometry/measurements.xsd", parameters, measurementsSchema);
            this.addFeatureType(namespacePrefix, String.format("Measurement_%s", gmlPrefix), measurementsMappings.getAbsolutePath(), measurementsProperties.getAbsolutePath(), measurementsSchema.getAbsolutePath());
        }
    }
}

