/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.CSVOutputFormatTest;
import org.geoserver.test.FeatureGML32MockData;
import org.geoserver.test.GeoPackageUtil;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.image.test.ImageAssert;
import org.geotools.util.URLs;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PagingTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected FeatureGML32MockData createTestData() {
        FeatureGML32MockData mockData = new FeatureGML32MockData();
        mockData.addStyle("namefilter", "styles/mappedfeaturebyname.sld");
        return mockData;
    }

    private void checkMf1Values(Document doc) {
        this.assertXpathEvaluatesTo("GUNTHORPE FORMATION", "//gsml:MappedFeature[@gml:id='mf1']/gml:name", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:crs:EPSG::4326", "//gsml:MappedFeature[@gml:id='mf1']/gsml:shape/gml:Polygon/@srsName", doc);
        this.assertXpathEvaluatesTo("52.5 -1.2 52.6 -1.2 52.6 -1.1 52.5 -1.1 52.5 -1.2", "//gsml:MappedFeature[@gml:id='mf1']/gsml:shape//gml:posList", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:CGI:EarthNaturalSurface", "//gsml:MappedFeature[@gml:id=\"mf1\"]/gsml:samplingFrame/@xlink:href", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='mf1']/gsml:specification/gsml:GeologicUnit", doc);
        this.assertXpathEvaluatesTo("gu.25699", "//gsml:MappedFeature[@gml:id='mf1']/gsml:specification/gsml:GeologicUnit/@gml:id", doc);
        this.assertXpathEvaluatesTo("Olivine basalt, tuff, microgabbro, minor sedimentary rocks", "//gsml:MappedFeature[@gml:id='mf1']/gsml:specification/gsml:GeologicUnit/gml:description", doc);
        this.assertXpathCount(2, "//gsml:MappedFeature[@gml:id='mf1']/gsml:specification/gsml:GeologicUnit/gml:name", doc);
        this.assertXpathEvaluatesTo("Yaugher Volcanic Group", "//gsml:MappedFeature[@gml:id='mf1']/gsml:specification/gsml:GeologicUnit/gml:name[@codeSpace='urn:ietf:rfc:2141']", doc);
        ArrayList<String> names = new ArrayList<String>();
        names.add("Yaugher Volcanic Group");
        names.add("-Py");
        String name = this.evaluate("//gsml:MappedFeature[@gml:id='mf1']/gsml:specification/gsml:GeologicUnit/gml:name[1]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        name = this.evaluate("//gsml:MappedFeature[@gml:id='mf1']/gsml:specification/gsml:GeologicUnit/gml:name[2]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        Assert.assertTrue((boolean)names.isEmpty());
        this.assertXpathEvaluatesTo("instance", "//gsml:MappedFeature[@gml:id='mf1']/gsml:specification/gsml:GeologicUnit/gsml:purpose", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::unknown", "//gsml:MappedFeature[@gml:id='mf1']/gsml:specification/gsml:GeologicUnit/gsml:geologicUnitType/@xlink:href", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='mf1']/gsml:specification/gsml:GeologicUnit/gsml:occurrence", doc);
        this.assertXpathEvaluatesTo("", "//gsml:MappedFeature[@gml:id='mf1']/gsml:specification/gsml:GeologicUnit/gsml:occurrence", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:MappedFeature:mf1", "//gsml:MappedFeature[@gml:id='mf1']/gsml:specification/gsml:GeologicUnit/gsml:occurrence/@xlink:href", doc);
    }

    private void checkMf2Values(Document doc) {
        this.assertXpathEvaluatesTo("MERCIA MUDSTONE GROUP", "//gsml:MappedFeature[@gml:id='mf2']/gml:name", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:crs:EPSG::4326", "//gsml:MappedFeature[@gml:id='mf2']/gsml:shape/gml:Polygon/@srsName", doc);
        this.assertXpathEvaluatesTo("52.5 -1.3 52.6 -1.3 52.6 -1.2 52.5 -1.2 52.5 -1.3", "//gsml:MappedFeature[@gml:id='mf2']/gsml:shape//gml:posList", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:CGI:EarthNaturalSurface", "//gsml:MappedFeature[@gml:id=\"mf2\"]/gsml:samplingFrame/@xlink:href", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='mf2']/gsml:specification/gsml:GeologicUnit", doc);
        this.assertXpathEvaluatesTo("gu.25678", "//gsml:MappedFeature[@gml:id='mf2']/gsml:specification/gsml:GeologicUnit/@gml:id", doc);
        this.assertXpathEvaluatesTo("Olivine basalt, tuff, microgabbro, minor sedimentary rocks", "//gsml:MappedFeature[@gml:id='mf2']/gsml:specification/gsml:GeologicUnit/gml:description", doc);
        this.assertXpathCount(3, "//gsml:MappedFeature[@gml:id='mf2']/gsml:specification/gsml:GeologicUnit/gml:name", doc);
        ArrayList<String> names = new ArrayList<String>();
        names.add("Yaugher Volcanic Group 1");
        names.add("Yaugher Volcanic Group 2");
        names.add("-Py");
        String name = this.evaluate("//gsml:MappedFeature[@gml:id='mf2']/gsml:specification/gsml:GeologicUnit/gml:name[1]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        name = this.evaluate("//gsml:MappedFeature[@gml:id='mf2']/gsml:specification/gsml:GeologicUnit/gml:name[2]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        name = this.evaluate("//gsml:MappedFeature[@gml:id='mf2']/gsml:specification/gsml:GeologicUnit/gml:name[3]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        Assert.assertTrue((boolean)names.isEmpty());
        this.assertXpathEvaluatesTo("instance", "//gsml:MappedFeature[@gml:id='mf2']/gsml:specification/gsml:GeologicUnit/gsml:purpose", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::unknown", "//gsml:MappedFeature[@gml:id='mf2']/gsml:specification/gsml:GeologicUnit/gsml:geologicUnitType/@xlink:href", doc);
        this.assertXpathCount(2, "//gsml:MappedFeature[@gml:id='mf2']/gsml:specification/gsml:GeologicUnit/gsml:occurrence", doc);
        this.assertXpathEvaluatesTo("", "//gsml:MappedFeature[@gml:id='mf2']/gsml:specification/gsml:GeologicUnit/gsml:occurrence", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:MappedFeature:mf2", "//gsml:MappedFeature[@gml:id='mf2']/gsml:specification/gsml:GeologicUnit/gsml:occurrence[1]/@xlink:href", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:MappedFeature:mf3", "//gsml:MappedFeature[@gml:id='mf2']/gsml:specification/gsml:GeologicUnit/gsml:occurrence[2]/@xlink:href", doc);
    }

    private void checkMf3Values(Document doc) {
        this.assertXpathEvaluatesTo("CLIFTON FORMATION", "//gsml:MappedFeature[@gml:id='mf3']/gml:name", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:crs:EPSG::4326", "//gsml:MappedFeature[@gml:id='mf3']/gsml:shape/gml:Polygon/@srsName", doc);
        this.assertXpathEvaluatesTo("52.5 -1.2 52.6 -1.2 52.6 -1.1 52.5 -1.1 52.5 -1.2", "//gsml:MappedFeature[@gml:id='mf3']/gsml:shape//gml:posList", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:CGI:EarthNaturalSurface", "//gsml:MappedFeature[@gml:id=\"mf3\"]/gsml:samplingFrame/@xlink:href", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='mf3']/gsml:specification/gsml:GeologicUnit", doc);
        this.assertXpathEvaluatesTo("gu.25678", "//gsml:MappedFeature[@gml:id='mf3']/gsml:specification/gsml:GeologicUnit/@gml:id", doc);
        this.assertXpathEvaluatesTo("Olivine basalt, tuff, microgabbro, minor sedimentary rocks", "//gsml:MappedFeature[@gml:id='mf3']/gsml:specification/gsml:GeologicUnit/gml:description", doc);
        this.assertXpathCount(3, "//gsml:MappedFeature[@gml:id='mf3']/gsml:specification/gsml:GeologicUnit/gml:name", doc);
        ArrayList<String> names = new ArrayList<String>();
        names.add("Yaugher Volcanic Group 1");
        names.add("Yaugher Volcanic Group 2");
        names.add("-Py");
        String name = this.evaluate("//gsml:MappedFeature[@gml:id='mf3']/gsml:specification/gsml:GeologicUnit/gml:name[1]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        name = this.evaluate("//gsml:MappedFeature[@gml:id='mf3']/gsml:specification/gsml:GeologicUnit/gml:name[2]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        name = this.evaluate("//gsml:MappedFeature[@gml:id='mf3']/gsml:specification/gsml:GeologicUnit/gml:name[3]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        Assert.assertTrue((boolean)names.isEmpty());
        this.assertXpathEvaluatesTo("instance", "//gsml:MappedFeature[@gml:id='mf3']/gsml:specification/gsml:GeologicUnit/gsml:purpose", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::unknown", "//gsml:MappedFeature[@gml:id='mf3']/gsml:specification/gsml:GeologicUnit/gsml:geologicUnitType/@xlink:href", doc);
        this.assertXpathCount(2, "//gsml:MappedFeature[@gml:id='mf3']/gsml:specification/gsml:GeologicUnit/gsml:occurrence", doc);
        this.assertXpathEvaluatesTo("", "//gsml:MappedFeature[@gml:id='mf3']/gsml:specification/gsml:GeologicUnit/gsml:occurrence", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:MappedFeature:mf2", "//gsml:MappedFeature[@gml:id='mf3']/gsml:specification/gsml:GeologicUnit/gsml:occurrence[1]/@xlink:href", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:MappedFeature:mf3", "//gsml:MappedFeature[@gml:id='mf3']/gsml:specification/gsml:GeologicUnit/gsml:occurrence[2]/@xlink:href", doc);
    }

    private void checkMf4Values(Document doc, String epsgId) throws NoSuchAuthorityCodeException, FactoryException, MismatchedDimensionException, TransformException {
        this.assertXpathEvaluatesTo("MURRADUC BASALT", "//gsml:MappedFeature[@gml:id='mf4']/gml:name", doc);
        String srsName = "urn:ogc:def:crs:EPSG::" + (epsgId == null ? "4326" : epsgId);
        this.assertXpathEvaluatesTo(srsName, "//gsml:MappedFeature[@gml:id='mf4']/gsml:shape/gml:Polygon/@srsName", doc);
        if (epsgId == null) {
            this.assertXpathEvaluatesTo("52.5 -1.3 52.6 -1.3 52.6 -1.2 52.5 -1.2 52.5 -1.3", "//gsml:MappedFeature[@gml:id='mf4']/gsml:shape//gml:posList", doc);
        }
        this.assertXpathEvaluatesTo("urn:cgi:feature:CGI:EarthNaturalSurface", "//gsml:MappedFeature[@gml:id=\"mf4\"]/gsml:samplingFrame/@xlink:href", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='mf4']/gsml:specification/gsml:GeologicUnit", doc);
        this.assertXpathEvaluatesTo("gu.25682", "//gsml:MappedFeature[@gml:id='mf4']/gsml:specification/gsml:GeologicUnit/@gml:id", doc);
        this.assertXpathEvaluatesTo("Olivine basalt", "//gsml:MappedFeature[@gml:id='mf4']/gsml:specification/gsml:GeologicUnit/gml:description", doc);
        this.assertXpathCount(2, "//gsml:MappedFeature[@gml:id='mf4']/gsml:specification/gsml:GeologicUnit/gml:name", doc);
        this.assertXpathEvaluatesTo("New Group", "//gsml:MappedFeature[@gml:id='mf4']/gsml:specification/gsml:GeologicUnit/gml:name[@codeSpace='urn:ietf:rfc:2141']", doc);
        ArrayList<String> names = new ArrayList<String>();
        names.add("New Group");
        names.add("-Xy");
        String name = this.evaluate("//gsml:MappedFeature[@gml:id='mf4']/gsml:specification/gsml:GeologicUnit/gml:name[1]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        name = this.evaluate("//gsml:MappedFeature[@gml:id='mf4']/gsml:specification/gsml:GeologicUnit/gml:name[2]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        Assert.assertTrue((boolean)names.isEmpty());
        this.assertXpathEvaluatesTo("instance", "//gsml:MappedFeature[@gml:id='mf4']/gsml:specification/gsml:GeologicUnit/gsml:purpose", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::unknown", "//gsml:MappedFeature[@gml:id='mf4']/gsml:specification/gsml:GeologicUnit/gsml:geologicUnitType/@xlink:href", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='mf4']/gsml:specification/gsml:GeologicUnit/gsml:occurrence", doc);
        this.assertXpathEvaluatesTo("", "//gsml:MappedFeature[@gml:id='mf4']/gsml:specification/gsml:GeologicUnit/gsml:occurrence", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:MappedFeature:mf4", "//gsml:MappedFeature[@gml:id='mf4']/gsml:specification/gsml:GeologicUnit/gsml:occurrence/@xlink:href", doc);
    }

    @Test
    public void testWfs110GetFeature() throws MismatchedDimensionException, NoSuchAuthorityCodeException, FactoryException, TransformException {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature&outputFormat=gml32&maxFeatures=2&startIndex=2");
        LOGGER.info("WFS GetFeature&typename=gsml:MappedFeature response:\n" + this.prettyString(doc));
        this.assertXpathCount(2, "//gsml:MappedFeature", doc);
        Node firstNode = doc.getElementsByTagName("gsml:MappedFeature").item(0);
        Assert.assertEquals((Object)"mf3", (Object)firstNode.getAttributes().getNamedItem("gml:id").getNodeValue());
        this.checkMf3Values(doc);
        Node secondNode = doc.getElementsByTagName("gsml:MappedFeature").item(1);
        Assert.assertEquals((Object)"mf4", (Object)secondNode.getAttributes().getNamedItem("gml:id").getNodeValue());
        this.checkMf4Values(doc, null);
    }

    @Test
    public void testWfs200GetFeature() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=2.0.0&typeNames=gsml:MappedFeature&count=1&startIndex=1");
        LOGGER.info("WFS GetFeature&typeNames=gsml:MappedFeature response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//gsml:MappedFeature", doc);
        this.assertXpathEvaluatesTo("mf2", "//gsml:MappedFeature/@gml:id", doc);
        this.checkMf2Values(doc);
    }

    @Test
    public void testGetFeatureDenormalised() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=2.0.0&typeNames=gsml:GeologicUnit&featureID=gu.25682");
        LOGGER.info("WFS GetFeature&typeNames=gsml:GeologicUnit response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//gsml:GeologicUnit", doc);
        this.assertXpathEvaluatesTo("gu.25682", "//gsml:GeologicUnit/@gml:id", doc);
        this.assertXpathEvaluatesTo("Olivine basalt", "//gsml:GeologicUnit/gml:description", doc);
        this.assertXpathCount(2, "//gsml:GeologicUnit/gml:name", doc);
        this.assertXpathEvaluatesTo("New Group", "//gsml:GeologicUnit/gml:name[@codeSpace='urn:ietf:rfc:2141']", doc);
        ArrayList<String> names = new ArrayList<String>();
        names.add("New Group");
        names.add("-Xy");
        String name = this.evaluate("//gsml:GeologicUnit/gml:name[1]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        name = this.evaluate("//gsml:GeologicUnit/gml:name[2]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        Assert.assertTrue((boolean)names.isEmpty());
        this.assertXpathEvaluatesTo("instance", "//gsml:GeologicUnit/gsml:purpose", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::unknown", "//gsml:GeologicUnit/gsml:geologicUnitType/@xlink:href", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit/gsml:occurrence", doc);
        this.assertXpathEvaluatesTo("", "//gsml:GeologicUnit/gsml:occurrence", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:MappedFeature:mf4", "//gsml:GeologicUnit/gsml:occurrence/@xlink:href", doc);
    }

    @Test
    public void testGetFeatureSortBy() throws MismatchedDimensionException, NoSuchAuthorityCodeException, FactoryException, TransformException {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature&outputFormat=gml32&maxFeatures=2&startIndex=2&featureID=mf1,mf2,mf3,mf4&sortBy=gsml:specification");
        LOGGER.info("WFS GetFeature&typename=gsml:MappedFeature response:\n" + this.prettyString(doc));
        this.assertXpathCount(2, "//gsml:MappedFeature", doc);
        Node firstNode = doc.getElementsByTagName("gsml:MappedFeature").item(0);
        Assert.assertEquals((Object)"mf4", (Object)firstNode.getAttributes().getNamedItem("gml:id").getNodeValue());
        this.checkMf4Values(doc, null);
        Node secondNode = doc.getElementsByTagName("gsml:MappedFeature").item(1);
        Assert.assertEquals((Object)"mf1", (Object)secondNode.getAttributes().getNamedItem("gml:id").getNodeValue());
        this.checkMf1Values(doc);
    }

    @Test
    public void testGetFeatureSortByDenormalised() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:GeologicUnit&outputFormat=gml32&maxFeatures=2&startIndex=0&sortBy=gml:name");
        LOGGER.info("WFS GetFeature&typename=gsml:GeologicUnit response:\n" + this.prettyString(doc));
        this.assertXpathCount(2, "//gsml:GeologicUnit", doc);
        Node firstNode = doc.getElementsByTagName("gsml:GeologicUnit").item(0);
        Assert.assertEquals((Object)"gu.25682", (Object)firstNode.getAttributes().getNamedItem("gml:id").getNodeValue());
        this.assertXpathEvaluatesTo("Olivine basalt", "//gsml:GeologicUnit[@gml:id='gu.25682']/gml:description", doc);
        this.assertXpathCount(2, "//gsml:GeologicUnit[@gml:id='gu.25682']/gml:name", doc);
        this.assertXpathEvaluatesTo("New Group", "//gsml:GeologicUnit[@gml:id='gu.25682']/gml:name[@codeSpace='urn:ietf:rfc:2141']", doc);
        ArrayList<String> names = new ArrayList<String>();
        names.add("New Group");
        names.add("-Xy");
        String name = this.evaluate("//gsml:GeologicUnit[@gml:id='gu.25682']/gml:name[1]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        name = this.evaluate("//gsml:GeologicUnit[@gml:id='gu.25682']/gml:name[2]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        Assert.assertTrue((boolean)names.isEmpty());
        this.assertXpathEvaluatesTo("instance", "//gsml:GeologicUnit[@gml:id='gu.25682']/gsml:purpose", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::unknown", "//gsml:GeologicUnit[@gml:id='gu.25682']/gsml:geologicUnitType/@xlink:href", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gu.25682']/gsml:occurrence", doc);
        this.assertXpathEvaluatesTo("", "//gsml:GeologicUnit[@gml:id='gu.25682']/gsml:occurrence", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:MappedFeature:mf4", "//gsml:GeologicUnit[@gml:id='gu.25682']/gsml:occurrence/@xlink:href", doc);
        Node secondNode = doc.getElementsByTagName("gsml:GeologicUnit").item(1);
        Assert.assertEquals((Object)"gu.25699", (Object)secondNode.getAttributes().getNamedItem("gml:id").getNodeValue());
        this.assertXpathEvaluatesTo("Olivine basalt, tuff, microgabbro, minor sedimentary rocks", "//gsml:GeologicUnit[@gml:id='gu.25699']/gml:description", doc);
        this.assertXpathCount(2, "//gsml:GeologicUnit[@gml:id='gu.25699']/gml:name", doc);
        this.assertXpathEvaluatesTo("Yaugher Volcanic Group", "//gsml:GeologicUnit[@gml:id='gu.25699']/gml:name[@codeSpace='urn:ietf:rfc:2141']", doc);
        names.add("Yaugher Volcanic Group");
        names.add("-Py");
        name = this.evaluate("//gsml:GeologicUnit[@gml:id='gu.25699']/gml:name[1]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        name = this.evaluate("//gsml:GeologicUnit[@gml:id='gu.25699']/gml:name[2]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        Assert.assertTrue((boolean)names.isEmpty());
        this.assertXpathEvaluatesTo("instance", "//gsml:GeologicUnit[@gml:id='gu.25699']/gsml:purpose", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::unknown", "//gsml:GeologicUnit[@gml:id='gu.25699']/gsml:geologicUnitType/@xlink:href", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gu.25699']/gsml:occurrence", doc);
        this.assertXpathEvaluatesTo("", "//gsml:GeologicUnit[@gml:id='gu.25699']/gsml:occurrence", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:MappedFeature:mf1", "//gsml:GeologicUnit[@gml:id='gu.25699']/gsml:occurrence/@xlink:href", doc);
    }

    @Test
    public void testGetFeatureReproject() throws MismatchedDimensionException, NoSuchAuthorityCodeException, FactoryException, TransformException {
        Document doc;
        if (!GeoPackageUtil.isGeopkgTest()) {
            doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature&outputFormat=gml32&srsName=urn:ogc:def:crs:EPSG::4283&bbox=52.5,-1.3,52.51,-1.29&startIndex=1");
            LOGGER.info("WFS GetFeature&typename=gsml:MappedFeature response:\n" + this.prettyString(doc));
        } else {
            doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature&outputFormat=gml32&srsName=urn:ogc:def:crs:EPSG::4283&bbox=-1.3,52.5,-1.29,52.51&startIndex=1");
        }
        this.assertXpathCount(1, "//gsml:MappedFeature", doc);
        this.assertXpathEvaluatesTo("mf4", "//gsml:MappedFeature/@gml:id", doc);
        this.checkMf4Values(doc, "4283");
    }

    @Test
    public void testGetFeatureWithFilter() throws MismatchedDimensionException, NoSuchAuthorityCodeException, FactoryException, TransformException {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml/3.2\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML-Core:3.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\" outputFormat=\"gml32\" startIndex=\"1\" >    <wfs:Query typeName=\"gsml:MappedFeature\">        <ogc:Filter>            <ogc:PropertyIsLike wildCard=\"*\" singleChar=\"#\" escapeChar=\"!\">                <ogc:Literal>M*</ogc:Literal>                <ogc:PropertyName>gml:name</ogc:PropertyName>            </ogc:PropertyIsLike>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//gsml:MappedFeature", doc);
        this.assertXpathEvaluatesTo("mf4", "//gsml:MappedFeature/@gml:id", doc);
        this.checkMf4Values(doc, null);
        xml = "<wfs:GetFeature service=\"WFS\" version=\"2.0.0\" xmlns:fes=\"http://www.opengis.net/fes/2.0\" xmlns:wfs=\"http://www.opengis.net/wfs/2.0\" xmlns:gml=\"http://www.opengis.net/gml/3.2\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML-Core:3.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs/2.0 http://schemas.opengis.net/wfs/2.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\" startIndex=\"0\" count=\"1\" >    <wfs:Query typeNames=\"gsml:GeologicUnit\">        <fes:Filter>            <fes:PropertyIsEqualTo>                <fes:Literal>-Py</fes:Literal>                <fes:ValueReference>gml:name</fes:ValueReference>            </fes:PropertyIsEqualTo>        </fes:Filter>    </wfs:Query> </wfs:GetFeature>";
        this.validate(xml);
        doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//gsml:GeologicUnit", doc);
        this.assertXpathEvaluatesTo("gu.25678", "//gsml:GeologicUnit/@gml:id", doc);
        this.assertXpathEvaluatesTo("Olivine basalt, tuff, microgabbro, minor sedimentary rocks", "//gsml:GeologicUnit/gml:description", doc);
        this.assertXpathCount(3, "//gsml:GeologicUnit/gml:name", doc);
        ArrayList<String> names = new ArrayList<String>();
        names.add("Yaugher Volcanic Group 1");
        names.add("Yaugher Volcanic Group 2");
        names.add("-Py");
        String name = this.evaluate("//gsml:GeologicUnit/gml:name[1]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        name = this.evaluate("//gsml:GeologicUnit/gml:name[2]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        name = this.evaluate("//gsml:GeologicUnit/gml:name[3]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        Assert.assertTrue((boolean)names.isEmpty());
        this.assertXpathEvaluatesTo("instance", "//gsml:GeologicUnit/gsml:purpose", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::unknown", "//gsml:GeologicUnit/gsml:geologicUnitType/@xlink:href", doc);
        this.assertXpathCount(2, "//gsml:GeologicUnit/gsml:occurrence", doc);
        this.assertXpathEvaluatesTo("", "//gsml:GeologicUnit/gsml:occurrence", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:MappedFeature:mf2", "//gsml:GeologicUnit/gsml:occurrence[1]/@xlink:href", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:MappedFeature:mf3", "//gsml:GeologicUnit/gsml:occurrence[2]/@xlink:href", doc);
    }

    @Test
    public void testGetFeatureWithNestedFilter() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml/3.2\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML-Core:3.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\" outputFormat=\"gml32\" startIndex=\"1\" >    <wfs:Query typeName=\"gsml:MappedFeature\">        <ogc:Filter>            <ogc:PropertyIsEqualTo>                <ogc:Literal>Yaugher Volcanic Group 2</ogc:Literal>                <ogc:PropertyName>gsml:specification/gsml:GeologicUnit/gml:name</ogc:PropertyName>            </ogc:PropertyIsEqualTo>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//gsml:MappedFeature", doc);
        this.assertXpathEvaluatesTo("mf3", "//gsml:MappedFeature/@gml:id", doc);
        this.checkMf3Values(doc);
        xml = "<wfs:GetFeature service=\"WFS\" version=\"2.0.0\" xmlns:fes=\"http://www.opengis.net/fes/2.0\" xmlns:wfs=\"http://www.opengis.net/wfs/2.0\" xmlns:gml=\"http://www.opengis.net/gml/3.2\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML-Core:3.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs/2.0 http://schemas.opengis.net/wfs/2.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\" startIndex=\"0\" count=\"1\" >    <wfs:Query typeNames=\"gsml:MappedFeature\">        <fes:Filter>            <fes:PropertyIsEqualTo>                <fes:Literal>Yaugher Volcanic Group 2</fes:Literal>                <fes:ValueReference>gsml:specification/gsml:GeologicUnit/gml:name</fes:ValueReference>            </fes:PropertyIsEqualTo>        </fes:Filter>    </wfs:Query> </wfs:GetFeature>";
        this.validate(xml);
        doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//gsml:MappedFeature", doc);
        this.assertXpathEvaluatesTo("mf2", "//gsml:MappedFeature/@gml:id", doc);
        this.checkMf2Values(doc);
        xml = "<wfs:GetFeature service=\"WFS\" version=\"2.0.0\" xmlns:fes=\"http://www.opengis.net/fes/2.0\" xmlns:wfs=\"http://www.opengis.net/wfs/2.0\" xmlns:gml=\"http://www.opengis.net/gml/3.2\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML-Core:3.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs/2.0 http://schemas.opengis.net/wfs/2.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\" >    <wfs:Query typeNames=\"gsml:MappedFeature\">        <fes:Filter>            <fes:PropertyIsEqualTo>                <fes:Literal>urn:cgi:feature:MappedFeature:mf3</fes:Literal>                <fes:ValueReference>gsml:specification/gsml:GeologicUnit/gsml:occurrence/@xlink:href</fes:ValueReference>            </fes:PropertyIsEqualTo>        </fes:Filter>    </wfs:Query> </wfs:GetFeature>";
        this.validate(xml);
        doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        this.assertXpathCount(2, "//gsml:MappedFeature", doc);
        Node firstNode = doc.getElementsByTagName("gsml:MappedFeature").item(0);
        Assert.assertEquals((Object)"mf2", (Object)firstNode.getAttributes().getNamedItem("gml:id").getNodeValue());
        this.checkMf2Values(doc);
        Node secondNode = doc.getElementsByTagName("gsml:MappedFeature").item(1);
        Assert.assertEquals((Object)"mf3", (Object)secondNode.getAttributes().getNamedItem("gml:id").getNodeValue());
        this.assertXpathEvaluatesTo("CLIFTON FORMATION", "//gsml:MappedFeature[@gml:id='mf3']/gml:name", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:crs:EPSG::4326", "//gsml:MappedFeature[@gml:id='mf3']/gsml:shape/gml:Polygon/@srsName", doc);
        this.assertXpathEvaluatesTo("52.5 -1.2 52.6 -1.2 52.6 -1.1 52.5 -1.1 52.5 -1.2", "//gsml:MappedFeature[@gml:id='mf3']/gsml:shape//gml:posList", doc);
        this.assertXpathEvaluatesTo("urn:cgi:feature:CGI:EarthNaturalSurface", "//gsml:MappedFeature[@gml:id=\"mf3\"]/gsml:samplingFrame/@xlink:href", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='mf3']/gsml:specification", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='mf3']/gsml:specification/gsml:GeologicUnit", doc);
        this.assertXpathEvaluatesTo("#gu.25678", "//gsml:MappedFeature[@gml:id='mf3']/gsml:specification/@xlink:href", doc);
        xml = "<wfs:GetFeature service=\"WFS\" version=\"2.0.0\" xmlns:fes=\"http://www.opengis.net/fes/2.0\" xmlns:wfs=\"http://www.opengis.net/wfs/2.0\" xmlns:gml=\"http://www.opengis.net/gml/3.2\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML-Core:3.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs/2.0 http://schemas.opengis.net/wfs/2.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\" startIndex=\"1\" count=\"1\" >    <wfs:Query typeNames=\"gsml:MappedFeature\">        <fes:Filter>            <fes:PropertyIsEqualTo>                <fes:Literal>urn:cgi:feature:MappedFeature:mf3</fes:Literal>                <fes:ValueReference>gsml:specification/gsml:GeologicUnit/gsml:occurrence/@xlink:href</fes:ValueReference>            </fes:PropertyIsEqualTo>        </fes:Filter>    </wfs:Query> </wfs:GetFeature>";
        this.validate(xml);
        doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//gsml:MappedFeature", doc);
        this.assertXpathEvaluatesTo("mf3", "//gsml:MappedFeature/@gml:id", doc);
        this.checkMf3Values(doc);
    }

    @Test
    public void testGetFeatureWithCSVFormat() throws Exception {
        MockHttpServletResponse resp = this.getAsServletResponse("wfs?request=GetFeature&version=2.0.0&typeNames=gsml:MappedFeature&count=1&startIndex=1&outputFormat=csv");
        Assert.assertEquals((Object)"text/csv", (Object)this.getBaseMimeType(resp.getContentType()));
        Assert.assertEquals((Object)"attachment; filename=MappedFeature.csv", (Object)resp.getHeader("Content-Disposition"));
        List<String[]> lines = CSVOutputFormatTest.readLines(resp.getContentAsString());
        Assert.assertEquals((long)2L, (long)lines.size());
        Assert.assertEquals((Object)"mf2", (Object)lines.get(1)[0]);
    }

    @Test
    public void testGetMap() throws IOException {
        if (GeoPackageUtil.isGeopkgTest()) {
            return;
        }
        try (InputStream is = this.getBinary("wms?request=GetMap&SRS=EPSG:4326&layers=gsml:MappedFeature&styles=namefilter&BBOX=-2,52,0,54&X=0&Y=0&width=20&height=20&FORMAT=image/png&startIndex=1");){
            BufferedImage imageBuffer = ImageIO.read(is);
            this.assertNotBlank("app-schema test getmap", imageBuffer, Color.WHITE);
            ImageAssert.assertEquals((File)URLs.urlToFile((URL)((Object)((Object)this)).getClass().getResource("/test-data/img/mappedfeature.png")), (RenderedImage)imageBuffer, (int)10);
        }
    }
}

