/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.io.IOException;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.PolymorphismMockData;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.util.ProgressListener;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.appschema.jdbc.NestedFilterToSQL;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.filter.ComplexFilterSplitter;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.data.util.NullProgressListener;
import org.geotools.jdbc.JDBCDataStore;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.w3c.dom.Document;

public class PolymorphismWfsTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected PolymorphismMockData createTestData() {
        return new PolymorphismMockData();
    }

    @Test
    public void testPolymorphism() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=ex:PolymorphicFeature");
        LOGGER.info("WFS GetFeature&typename=ex:PolymorphicFeature response:\n" + this.prettyString(doc));
        this.assertXpathCount(6, "//ex:PolymorphicFeature", doc);
        this.checkPolymorphicFeatureChaining(doc);
        this.checkPolymorphismOnly(doc);
        this.checkFeatureChainingOnly(doc);
        this.checkXlinkHrefValues(doc);
        this.checkAnyType(doc);
    }

    @Test
    public void testFirstValueFilters() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ex=\"http://example.com\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" >    <wfs:Query typeName=\"ex:PolymorphicFeature\">        <ogc:Filter>            <ogc:PropertyIsEqualTo>                <ogc:PropertyName>ex:firstValue/gsml:CGI_NumericValue/gsml:principalValue</ogc:PropertyName>                <ogc:Literal>1.0</ogc:Literal>            </ogc:PropertyIsEqualTo>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("1", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature", doc);
        this.assertXpathEvaluatesTo("f1", "//ex:PolymorphicFeature/@gml:id", doc);
        this.assertXpathEvaluatesTo("1.0", "//ex:PolymorphicFeature[@gml:id='f1']/ex:firstValue/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("m", "//ex:PolymorphicFeature[@gml:id='f1']/ex:firstValue/gsml:CGI_NumericValue/gsml:principalValue/@uom", doc);
    }

    @Test
    public void testSecondValueFilters() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ex=\"http://example.com\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" >    <wfs:Query typeName=\"ex:PolymorphicFeature\">        <ogc:Filter>            <ogc:PropertyIsEqualTo>                <ogc:PropertyName>ex:secondValue/gsml:CGI_NumericValue/gsml:principalValue/@uom</ogc:PropertyName>                <ogc:Literal>m</ogc:Literal>            </ogc:PropertyIsEqualTo>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("2", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(2, "//ex:PolymorphicFeature", doc);
        this.assertXpathEvaluatesTo("f1", "(//ex:PolymorphicFeature)[1]/@gml:id", doc);
        this.assertXpathEvaluatesTo("1.0", "//ex:PolymorphicFeature[@gml:id='f1']/ex:secondValue/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("m", "//ex:PolymorphicFeature[@gml:id='f1']/ex:secondValue/gsml:CGI_NumericValue/gsml:principalValue/@uom", doc);
        this.assertXpathEvaluatesTo("f3", "(//ex:PolymorphicFeature)[2]/@gml:id", doc);
        this.assertXpathEvaluatesTo("0.0", "//ex:PolymorphicFeature[@gml:id='f3']/ex:secondValue/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("m", "//ex:PolymorphicFeature[@gml:id='f3']/ex:secondValue/gsml:CGI_NumericValue/gsml:principalValue/@uom", doc);
    }

    @Test
    public void testAnyTypeFilters() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ex=\"http://example.com\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" >    <wfs:Query typeName=\"ex:PolymorphicFeature\">        <ogc:Filter>            <ogc:PropertyIsEqualTo>                <ogc:PropertyName>ex:anyValue/gsml:CGI_TermValue/gsml:value</ogc:PropertyName>                <ogc:Literal>0</ogc:Literal>            </ogc:PropertyIsEqualTo>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("2", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(2, "//ex:PolymorphicFeature", doc);
        this.assertXpathEvaluatesTo("f2", "(//ex:PolymorphicFeature)[1]/@gml:id", doc);
        this.assertXpathEvaluatesTo("0", "//ex:PolymorphicFeature[@gml:id='f2']/ex:anyValue/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("f5", "(//ex:PolymorphicFeature)[2]/@gml:id", doc);
        this.assertXpathEvaluatesTo("0", "//ex:PolymorphicFeature[@gml:id='f5']/ex:anyValue/gsml:CGI_TermValue/gsml:value", doc);
    }

    @Test
    public void testMappingNameFilters() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ex=\"http://example.com\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" >    <wfs:Query typeName=\"ex:PolymorphicFeature\">        <ogc:Filter>            <ogc:PropertyIsEqualTo>                <ogc:PropertyName>ex:thirdValue/gsml:CGI_NumericValue/gsml:principalValue</ogc:PropertyName>                <ogc:Literal>1.0</ogc:Literal>            </ogc:PropertyIsEqualTo>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("2", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(2, "//ex:PolymorphicFeature", doc);
        this.assertXpathEvaluatesTo("f1", "(//ex:PolymorphicFeature)[1]/@gml:id", doc);
        this.assertXpathEvaluatesTo("1.0", "//ex:PolymorphicFeature[@gml:id='f1']/ex:thirdValue/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("m", "//ex:PolymorphicFeature[@gml:id='f1']/ex:thirdValue/gsml:CGI_NumericValue/gsml:principalValue/@uom", doc);
        this.assertXpathEvaluatesTo("f4", "(//ex:PolymorphicFeature)[2]/@gml:id", doc);
        this.assertXpathEvaluatesTo("1.0", "//ex:PolymorphicFeature[@gml:id='f4']/ex:thirdValue/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("m", "//ex:PolymorphicFeature[@gml:id='f4']/ex:thirdValue/gsml:CGI_NumericValue/gsml:principalValue/@uom", doc);
    }

    private void checkPolymorphicFeatureChaining(Document doc) {
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f1']/ex:firstValue", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f1']/ex:firstValue/gsml:CGI_NumericValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f1']/ex:firstValue/gsml:CGI_TermValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f1']/ex:firstValue/gsml:CGI_TermValue", doc);
        this.assertXpathEvaluatesTo("1.0", "//ex:PolymorphicFeature[@gml:id='f1']/ex:firstValue/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("m", "//ex:PolymorphicFeature[@gml:id='f1']/ex:firstValue/gsml:CGI_NumericValue/gsml:principalValue/@uom", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f2']/ex:firstValue", doc);
        this.assertXpathEvaluatesTo("urn:value::x", "//ex:PolymorphicFeature[@gml:id='f2']/ex:firstValue/@xlink:href", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f2']/ex:firstValue/gsml:CGI_NumericValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f3']/ex:firstValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f4']/ex:firstValue", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f5']/ex:firstValue", doc);
        this.assertXpathEvaluatesTo("urn:value::y", "//ex:PolymorphicFeature[@gml:id='f5']/ex:firstValue/@xlink:href", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f5']/ex:firstValue/gsml:CGI_NumericValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f6']/ex:firstValue", doc);
    }

    private void checkPolymorphismOnly(Document doc) {
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f1']/ex:secondValue", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f1']/ex:secondValue/gsml:CGI_NumericValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f1']/ex:secondValue/gsml:CGI_TermValue", doc);
        this.assertXpathEvaluatesTo("1.0", "//ex:PolymorphicFeature[@gml:id='f1']/ex:secondValue/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("m", "//ex:PolymorphicFeature[@gml:id='f1']/ex:secondValue/gsml:CGI_NumericValue/gsml:principalValue/@uom", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f2']/ex:secondValue", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f2']/ex:secondValue/gsml:CGI_TermValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f2']/ex:secondValue/gsml:CGI_NumericValue", doc);
        this.assertXpathEvaluatesTo("0", "//ex:PolymorphicFeature[@gml:id='f2']/ex:secondValue/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("approximate", "//ex:PolymorphicFeature[@gml:id='f2']/ex:secondValue/gsml:CGI_TermValue/@gsml:qualifier", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f3']/ex:secondValue", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f3']/ex:secondValue/gsml:CGI_NumericValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f3']/ex:secondValue/gsml:CGI_TermValue", doc);
        this.assertXpathEvaluatesTo("0.0", "//ex:PolymorphicFeature[@gml:id='f3']/ex:secondValue/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("m", "//ex:PolymorphicFeature[@gml:id='f3']/ex:secondValue/gsml:CGI_NumericValue/gsml:principalValue/@uom", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f4']/ex:secondValue", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f5']/ex:secondValue", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f5']/ex:secondValue/gsml:CGI_TermValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f5']/ex:secondValue/gsml:CGI_NumericValue", doc);
        this.assertXpathEvaluatesTo("0", "//ex:PolymorphicFeature[@gml:id='f5']/ex:secondValue/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("approximate", "//ex:PolymorphicFeature[@gml:id='f5']/ex:secondValue/gsml:CGI_TermValue/@gsml:qualifier", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f6']/ex:secondValue", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f6']/ex:secondValue/gsml:CGI_TermValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f6']/ex:secondValue/gsml:CGI_NumericValue", doc);
        this.assertXpathEvaluatesTo("1000", "//ex:PolymorphicFeature[@gml:id='f6']/ex:secondValue/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("approximate", "//ex:PolymorphicFeature[@gml:id='f6']/ex:secondValue/gsml:CGI_TermValue/@gsml:qualifier", doc);
    }

    private void checkFeatureChainingOnly(Document doc) {
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f1']/ex:thirdValue", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f1']/ex:thirdValue/gsml:CGI_NumericValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f1']/ex:thirdValue/gsml:CGI_TermValue", doc);
        this.assertXpathEvaluatesTo("1.0", "//ex:PolymorphicFeature[@gml:id='f1']/ex:thirdValue/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("m", "//ex:PolymorphicFeature[@gml:id='f1']/ex:thirdValue/gsml:CGI_NumericValue/gsml:principalValue/@uom", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f2']/ex:thirdValue", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f2']/ex:thirdValue/gsml:CGI_TermValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f2']/ex:thirdValue/gsml:CGI_NumericValue", doc);
        this.assertXpathEvaluatesTo("x", "//ex:PolymorphicFeature[@gml:id='f2']/ex:thirdValue/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("some:uri", "//ex:PolymorphicFeature[@gml:id='f2']/ex:thirdValue/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f3']/ex:thirdValue", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f3']/ex:thirdValue/gsml:CGI_TermValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f3']/ex:thirdValue/gsml:CGI_NumericValue", doc);
        this.assertXpathEvaluatesTo("y", "//ex:PolymorphicFeature[@gml:id='f3']/ex:thirdValue/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("some:uri", "//ex:PolymorphicFeature[@gml:id='f3']/ex:thirdValue/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f4']/ex:thirdValue", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f4']/ex:thirdValue/gsml:CGI_NumericValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f4']/ex:thirdValue/gsml:CGI_TermValue", doc);
        this.assertXpathEvaluatesTo("1.0", "//ex:PolymorphicFeature[@gml:id='f4']/ex:thirdValue/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("m", "//ex:PolymorphicFeature[@gml:id='f4']/ex:thirdValue/gsml:CGI_NumericValue/gsml:principalValue/@uom", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f5']/ex:thirdValue", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f5']/ex:thirdValue/gsml:CGI_TermValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f5']/ex:thirdValue/gsml:CGI_NumericValue", doc);
        this.assertXpathEvaluatesTo("y", "//ex:PolymorphicFeature[@gml:id='f5']/ex:thirdValue/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("some:uri", "//ex:PolymorphicFeature[@gml:id='f5']/ex:thirdValue/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f6']/ex:thirdValue", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f6']/ex:thirdValue/gsml:CGI_NumericValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f6']/ex:thirdValue/gsml:CGI_TermValue", doc);
        this.assertXpathEvaluatesTo("1000.0", "//ex:PolymorphicFeature[@gml:id='f6']/ex:thirdValue/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("m", "//ex:PolymorphicFeature[@gml:id='f6']/ex:thirdValue/gsml:CGI_NumericValue/gsml:principalValue/@uom", doc);
    }

    private void checkXlinkHrefValues(Document doc) {
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f1']/ex:fourthValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f1']/ex:fourthValue/ex:firstParentFeature", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::missing", "//ex:PolymorphicFeature[@gml:id='f1']/ex:fourthValue/@xlink:href", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f1']/ex:fifthValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f1']/ex:fifthValue/ex:firstParentFeature", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::missing", "//ex:PolymorphicFeature[@gml:id='f1']/ex:fifthValue/@xlink:href", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f2']/ex:fourthValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f2']/ex:fourthValue/ex:firstParentFeature", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::missing", "//ex:PolymorphicFeature[@gml:id='f2']/ex:fourthValue/@xlink:href", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f2']/ex:fifthValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f2']/ex:fifthValue/ex:firstParentFeature", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::missing", "//ex:PolymorphicFeature[@gml:id='f2']/ex:fifthValue/@xlink:href", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f3']/ex:fourthValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f3']/ex:fourthValue/ex:firstParentFeature", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::missing", "//ex:PolymorphicFeature[@gml:id='f3']/ex:fourthValue/@xlink:href", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f3']/ex:fifthValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f3']/ex:fifthValue/ex:firstParentFeature", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::missing", "//ex:PolymorphicFeature[@gml:id='f3']/ex:fifthValue/@xlink:href", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f4']/ex:fourthValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f4']/ex:fourthValue/ex:firstParentFeature", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::missing", "//ex:PolymorphicFeature[@gml:id='f4']/ex:fourthValue/@xlink:href", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f4']/ex:fifthValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f4']/ex:fifthValue/ex:firstParentFeature", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::missing", "//ex:PolymorphicFeature[@gml:id='f4']/ex:fifthValue/@xlink:href", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f5']/ex:fourthValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f5']/ex:fourthValue/ex:firstParentFeature", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::missing", "//ex:PolymorphicFeature[@gml:id='f5']/ex:fourthValue/@xlink:href", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f5']/ex:fifthValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f5']/ex:fifthValue/ex:firstParentFeature", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::missing", "//ex:PolymorphicFeature[@gml:id='f5']/ex:fifthValue/@xlink:href", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f6']/ex:fourthValue", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f6']/ex:fourthValue/gsml:CGI_NumericValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f6']/ex:fourthValue/gsml:CGI_TermValue", doc);
        this.assertXpathEvaluatesTo("1000.0", "//ex:PolymorphicFeature[@gml:id='f6']/ex:fourthValue/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("m", "//ex:PolymorphicFeature[@gml:id='f6']/ex:fourthValue/gsml:CGI_NumericValue/gsml:principalValue/@uom", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f6']/ex:fifthValue", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f6']/ex:fifthValue/gsml:CGI_NumericValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f6']/ex:fifthValue/gsml:CGI_TermValue", doc);
        this.assertXpathEvaluatesTo("1000.0", "//ex:PolymorphicFeature[@gml:id='f6']/ex:fifthValue/gsml:CGI_NumericValue/gsml:principalValue", doc);
        this.assertXpathEvaluatesTo("m", "//ex:PolymorphicFeature[@gml:id='f6']/ex:fifthValue/gsml:CGI_NumericValue/gsml:principalValue/@uom", doc);
    }

    private void checkAnyType(Document doc) {
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f1']/ex:anyValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f1']/ex:anyValue/gsml:CGI_TermValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f1']/ex:anyValue/gsml:CGI_NumericValue", doc);
        this.assertXpathEvaluatesTo("urn:numeric-value::1", "//ex:PolymorphicFeature[@gml:id='f1']/ex:anyValue/@xlink:href", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f2']/ex:anyValue", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f2']/ex:anyValue/gsml:CGI_TermValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f2']/ex:anyValue/gsml:CGI_NumericValue", doc);
        this.assertXpathEvaluatesTo("0", "//ex:PolymorphicFeature[@gml:id='f2']/ex:anyValue/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("approximate", "//ex:PolymorphicFeature[@gml:id='f2']/ex:anyValue/gsml:CGI_TermValue/@gsml:qualifier", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f3']/ex:anyValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f3']/ex:anyValue/gsml:CGI_TermValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f3']/ex:anyValue/gsml:CGI_NumericValue", doc);
        this.assertXpathEvaluatesTo("urn:numeric-value::0", "//ex:PolymorphicFeature[@gml:id='f3']/ex:anyValue/@xlink:href", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f4']/ex:anyValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f4']/ex:anyValue/gsml:CGI_TermValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f4']/ex:anyValue/gsml:CGI_NumericValue", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::missing", "//ex:PolymorphicFeature[@gml:id='f4']/ex:anyValue/@xlink:href", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f5']/ex:anyValue", doc);
        this.assertXpathCount(1, "//ex:PolymorphicFeature[@gml:id='f5']/ex:anyValue/gsml:CGI_TermValue", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f5']/ex:anyValue/gsml:CGI_NumericValue", doc);
        this.assertXpathEvaluatesTo("0", "//ex:PolymorphicFeature[@gml:id='f5']/ex:anyValue/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("approximate", "//ex:PolymorphicFeature[@gml:id='f5']/ex:anyValue/gsml:CGI_TermValue/@gsml:qualifier", doc);
        this.assertXpathCount(0, "//ex:PolymorphicFeature[@gml:id='f6']/ex:anyValue", doc);
    }

    @Test
    public void testNestedFilterEncoding() throws FilterToSQLException, IOException {
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName("ex", "PolymorphicFeature");
        FeatureSource fs = ftInfo.getFeatureSource((ProgressListener)new NullProgressListener(), null);
        AppSchemaDataAccess da = (AppSchemaDataAccess)fs.getDataStore();
        FeatureTypeMapping rootMapping = da.getMappingByNameOrElement(ftInfo.getQualifiedName());
        Assume.assumeTrue((boolean)this.shouldTestNestedFiltersEncoding(rootMapping));
        JDBCDataStore store = (JDBCDataStore)rootMapping.getSource().getDataStore();
        FilterFactoryImplNamespaceAware ff = new FilterFactoryImplNamespaceAware();
        ff.setNamepaceContext(rootMapping.getNamespaces());
        PropertyIsEqualTo equalsFirstValue = ff.equals((Expression)ff.property("ex:firstValue/gsml:CGI_NumericValue/gsml:principalValue"), (Expression)ff.literal(1.0));
        ComplexFilterSplitter splitterFirstValueFilter = new ComplexFilterSplitter(store.getFilterCapabilities(), rootMapping);
        splitterFirstValueFilter.visit(equalsFirstValue, null);
        Filter preFilter = splitterFirstValueFilter.getFilterPre();
        Filter postFilter = splitterFirstValueFilter.getFilterPost();
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)preFilter);
        Assert.assertEquals((Object)equalsFirstValue, (Object)postFilter);
        Filter unrolled = AppSchemaDataAccess.unrollFilter((Filter)equalsFirstValue, (FeatureTypeMapping)rootMapping);
        Assert.assertTrue((boolean)NestedFilterToSQL.isNestedFilter((Filter)unrolled));
        this.assertContainsFeatures(fs.getFeatures((Filter)equalsFirstValue), "f1");
        PropertyIsEqualTo equalsSecondValue = ff.equals((Expression)ff.property("ex:secondValue/gsml:CGI_NumericValue/gsml:principalValue/@uom"), (Expression)ff.literal((Object)"m"));
        ComplexFilterSplitter splitterSecondValue = new ComplexFilterSplitter(store.getFilterCapabilities(), rootMapping);
        splitterSecondValue.visit(equalsSecondValue, null);
        preFilter = splitterSecondValue.getFilterPre();
        postFilter = splitterSecondValue.getFilterPost();
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)preFilter);
        Assert.assertEquals((Object)equalsSecondValue, (Object)postFilter);
        unrolled = AppSchemaDataAccess.unrollFilter((Filter)equalsSecondValue, (FeatureTypeMapping)rootMapping);
        Assert.assertTrue((boolean)NestedFilterToSQL.isNestedFilter((Filter)unrolled));
        this.assertContainsFeatures(fs.getFeatures((Filter)equalsSecondValue), "f1", "f3");
        PropertyIsEqualTo equalsThirdValue = ff.equals((Expression)ff.property("ex:thirdValue/gsml:CGI_NumericValue/gsml:principalValue"), (Expression)ff.literal(1.0));
        ComplexFilterSplitter splitterThirdValueFilter = new ComplexFilterSplitter(store.getFilterCapabilities(), rootMapping);
        splitterThirdValueFilter.visit(equalsThirdValue, null);
        preFilter = splitterThirdValueFilter.getFilterPre();
        postFilter = splitterThirdValueFilter.getFilterPost();
        Assert.assertEquals((Object)equalsThirdValue, (Object)preFilter);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)postFilter);
        unrolled = AppSchemaDataAccess.unrollFilter((Filter)equalsThirdValue, (FeatureTypeMapping)rootMapping);
        Assert.assertTrue((boolean)NestedFilterToSQL.isNestedFilter((Filter)unrolled));
        NestedFilterToSQL nestedFilterEncoder = this.createNestedFilterEncoder(rootMapping);
        String encodedFilter = nestedFilterEncoder.encodeToString(unrolled);
        Assert.assertTrue((boolean)encodedFilter.contains("EXISTS"));
        this.assertContainsFeatures(fs.getFeatures((Filter)equalsThirdValue), "f1", "f4");
    }
}

