/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.PropertySelectionMockData;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class PropertySelectionTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected PropertySelectionMockData createTestData() {
        return new PropertySelectionMockData();
    }

    @Test
    public void testGetFeature() {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=gsml:MappedFeature&propertyname=gml:description");
        LOGGER.info("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=gsml:MappedFeature&propertyname=gml:description Response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gml:description", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:shape", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:positionalAccuracy/gsml:CGI_NumericValue", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:specification/gsml:GeologicUnit", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:metadata", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gml:name", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:specification/gsml:GeologicUnit/gml:name", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:specification/gsml:GeologicUnit/gml:description", doc);
    }

    @Test
    public void testGetFeatureFeatureChaining() {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=GetFeature&typename=gsml:MappedFeature&propertyname=gsml:specification/gsml:GeologicUnit/gml:description");
        LOGGER.info("wfs?service=WFS&version=1.1.0&request=GetFeature&typename=gsml:MappedFeature&propertyname=gsml:specification/gsml:GeologicUnit/gml:description response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:specification/gsml:GeologicUnit/gml:description", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:shape", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:positionalAccuracy/gsml:CGI_NumericValue", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:specification/gsml:GeologicUnit", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:metadata", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gml:name", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:specification/gsml:GeologicUnit/gml:name", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gml:description", doc);
    }

    @Test
    public void testGetFeatureClientProperty() {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=gsml:MappedFeature&propertyname=gsml:metadata");
        LOGGER.info("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=gsml:MappedFeature&propertyname=gsml:metadata response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("zzzgu.25699", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:metadata/@xlink:href", doc);
    }

    @Test
    public void testGetFeatureInvalidName() {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=gsml:MappedFeature&propertyname=gml:name");
        LOGGER.info("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=gsml:MappedFeature&propertyname=gml:name response:\n" + this.prettyString(doc));
        Assert.assertTrue((boolean)this.evaluate("//ows:ExceptionText", doc).contains("Could not find working property accessor for attribute (DOESNT_EXIST)"));
    }

    @Test
    public void testPostGetFeature() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" ><wfs:Query typeName=\"gsml:MappedFeature\"><ogc:PropertyName>gml:description</ogc:PropertyName> <ogc:PropertyName>gsml:specification/gsml:GeologicUnit/gml:name</ogc:PropertyName> </wfs:Query></wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS GetFeature POST response:\n" + this.prettyString(doc));
        this.assertXpathCount(2, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:specification/gsml:GeologicUnit/gml:name", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gml:description", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:shape", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:positionalAccuracy/gsml:CGI_NumericValue", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:specification/gsml:GeologicUnit", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:metadata", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gml:name", doc);
    }

    @Test
    public void testSameNameDiffNamespace1() {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=ex:MyTestFeature&propertyname=ex:name");
        LOGGER.info("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=ex:MyTestFeature&propertyname=ex:name response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//ex:MyTestFeature[@gml:id='f1']/ex:name", doc);
        this.assertXpathCount(0, "//ex:MyTestFeature[@gml:id='f1']/gml:name", doc);
    }

    @Test
    public void testSameNameDiffNamespace2() {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=ex:MyTestFeature&propertyname=gml:name");
        LOGGER.info("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=ex:MyTestFeature&propertyname=gml:name response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//ex:MyTestFeature[@gml:id='f1']/gml:name", doc);
        this.assertXpathCount(0, "//ex:MyTestFeature[@gml:id='f1']/ex:name", doc);
    }

    @Test
    public void testSameNameDiffNamespace3() {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=ex:MyTestFeature");
        LOGGER.info("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=ex:MyTestFeature response:\n" + this.prettyString(doc));
    }
}

