/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.TestResourceAccessManager;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.decorators.ReadOnlyDataAccess;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.FeatureChainingMockData;
import org.geotools.api.data.DataAccess;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.complex.expression.FeaturePropertyAccessorFactory;
import org.geotools.data.util.NullProgressListener;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.helpers.NamespaceSupport;

public class SecuredFeatureChainingTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected FeatureChainingMockData createTestData() {
        return new FeatureChainingMockData();
    }

    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add("classpath:/test-data/ResourceAccessManagerContext.xml");
    }

    protected List<javax.servlet.Filter> getFilters() {
        return Collections.singletonList((javax.servlet.Filter)GeoServerExtensions.bean((String)"filterChainProxy"));
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        this.addUser("cite_readfilter", "cite", null, Arrays.asList("ROLE_DUMMY"));
        this.addUser("cite_readatts", "cite", null, Arrays.asList("ROLE_DUMMY"));
        NamespaceSupport ns = new NamespaceSupport();
        Map<String, String> nsMap = ((FeatureChainingMockData)testData).getNamespaces();
        Iterator<Map.Entry<String, String>> iterator = nsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> o;
            Map.Entry<String, String> entry = o = iterator.next();
            String prefix = entry.getKey();
            String namespace = entry.getValue();
            ns.declarePrefix(prefix, namespace);
        }
        Hints hints = new Hints();
        hints.put((Object)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)ns);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)hints);
        TestResourceAccessManager tam = (TestResourceAccessManager)applicationContext.getBean("testResourceAccessManager");
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo gu = catalog.getFeatureTypeByName("gsml:GeologicUnit");
        PropertyIsEqualTo f = ff.equal((Expression)new AttributeExpressionImpl("gsml:purpose", ns), (Expression)ff.literal((Object)"instance"), false);
        tam.putLimits("cite_readfilter", (CatalogInfo)gu, (AccessLimits)new VectorAccessLimits(CatalogMode.HIDE, null, (Filter)f, null, null));
        List<PropertyName> readAtts = Arrays.asList(ff.property("gsml:composition"), ff.property("gsml:outcropCharacter"));
        tam.putLimits("cite_readatts", (CatalogInfo)gu, (AccessLimits)new VectorAccessLimits(CatalogMode.HIDE, readAtts, (Filter)f, null, null));
    }

    @Test
    public void testDenormalisedFeaturesCount() {
        this.setRequestAuth("cite_readatts", "cite");
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:GeologicUnit&maxFeatures=3&resultType=hits");
        LOGGER.info("WFS GetFeature&typename=gsml:GeologicUnit&maxFeatures=3 response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("3", "//wfs:FeatureCollection/@numberOfFeatures", doc);
    }

    @Test
    public void testSecureFeatureContent() {
        this.setRequestAuth("cite_readatts", "cite");
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:GeologicUnit&maxFeatures=3");
        LOGGER.info("WFS GetFeature&typename=gsml:GeologicUnit&maxFeatures=3 response:\n" + this.prettyString(doc));
        this.assertXpathCount(3, "//gsml:GeologicUnit", doc);
        this.assertXpathCount(0, "//gsml:GeologicUnit[@gml:id='gu.25699']/gsml:exposureColor", doc);
        this.assertXpathCount(0, "//gsml:GeologicUnit[@gml:id='gu.25678']/gsml:exposureColor", doc);
        this.assertXpathCount(0, "//gsml:GeologicUnit[@gml:id='gu.25682']/gsml:exposureColor", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gu.25699']/gsml:composition", doc);
        this.assertXpathCount(2, "//gsml:GeologicUnit[@gml:id='gu.25678']/gsml:composition", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gu.25682']/gsml:composition", doc);
    }

    @Test
    public void testSecuredDataStoreInfo() throws IOException {
        this.login("cite_readatts", "cite", new String[]{"ROLE_DUMMY"});
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName("gsml:GeologicUnit");
        Assert.assertNotNull((Object)ftInfo);
        DataAccess dataAccess = ftInfo.getStore().getDataStore((ProgressListener)new NullProgressListener());
        Assert.assertNotNull((Object)dataAccess);
        Assert.assertTrue((boolean)(dataAccess instanceof ReadOnlyDataAccess));
    }
}

