/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.StationsMockData;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.w3c.dom.Document;

public abstract class StationsAppSchemaTestSupport
extends AbstractAppSchemaTestSupport {
    protected final Map<String, String> GML31_PARAMETERS = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, String>("GML_PREFIX", "gml31"), new AbstractMap.SimpleEntry<String, String>("GML_NAMESPACE", "http://www.opengis.net/gml"), new AbstractMap.SimpleEntry<String, String>("GML_LOCATION", "http://schemas.opengis.net/gml/3.1.1/base/gml.xsd")).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue())));
    protected final Map<String, String> GML32_PARAMETERS = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, String>("GML_PREFIX", "gml32"), new AbstractMap.SimpleEntry<String, String>("GML_NAMESPACE", "http://www.opengis.net/gml/3.2"), new AbstractMap.SimpleEntry<String, String>("GML_LOCATION", "http://schemas.opengis.net/gml/3.2.1/gml.xsd")).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue())));
    protected XpathEngine WFS11_XPATH_ENGINE;
    protected XpathEngine WFS20_XPATH_ENGINE;

    @Before
    public void beforeTest() {
        this.WFS11_XPATH_ENGINE = StationsMockData.buildXpathEngine(this.getTestData().getNamespaces(), "wfs", "http://www.opengis.net/wfs", "gml", "http://www.opengis.net/gml");
        this.WFS20_XPATH_ENGINE = StationsMockData.buildXpathEngine(this.getTestData().getNamespaces(), "wfs", "http://www.opengis.net/wfs/2.0", "gml", "http://www.opengis.net/gml/3.2");
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
    }

    @Override
    protected StationsMockData createTestData() {
        return new StationsMockData();
    }

    protected void checkCount(XpathEngine xpathEngine, Document document, int expectedCount, String xpath) {
        try {
            MatcherAssert.assertThat((Object)xpathEngine.getMatchingNodes(xpath, document).getLength(), (Matcher)CoreMatchers.is((Object)expectedCount));
        }
        catch (Exception exception) {
            throw new RuntimeException("Error evaluating xpath: " + xpath, exception);
        }
    }
}

