/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import org.geoserver.test.TimeSeriesInlineMockData;
import org.geoserver.test.TimeSeriesWfsTest;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class TimeSeriesInlineWfsTest
extends TimeSeriesWfsTest {
    @Override
    protected TimeSeriesInlineMockData createTestData() {
        return new TimeSeriesInlineMockData();
    }

    @Test
    public void testTimePositionSubset() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" outputFormat=\"gml32\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml/3.2\" xmlns:csml=\"http://ndg.nerc.ac.uk/csml\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd\"><wfs:Query typeName=\"csml:PointSeriesFeature\">    <ogc:Filter>        <ogc:PropertyIsBetween>             <ogc:PropertyName>csml:PointSeriesFeature/csml:value/csml:PointSeriesCoverage/csml:pointSeriesDomain/csml:TimeSeries/csml:timePositionList</ogc:PropertyName>             <ogc:LowerBoundary><ogc:Literal>1949-05-01</ogc:Literal></ogc:LowerBoundary>             <ogc:UpperBoundary><ogc:Literal>1949-09-01</ogc:Literal></ogc:UpperBoundary>        </ogc:PropertyIsBetween>    </ogc:Filter></wfs:Query> </wfs:GetFeature>";
        this.validate(xml);
        Document doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        this.assertXpathEvaluatesTo("1", "/wfs:FeatureCollection/@numberReturned", doc);
        this.assertXpathCount(1, "//csml:PointSeriesFeature", doc);
        this.checkPointFeatureTwo(doc);
        this.assertXpathEvaluatesTo("1949-05-01 1949-06-01 1949-07-01 1949-08-01 1949-09-01", "//csml:PointSeriesFeature[@gml:id='ID2']/csml:value/csml:PointSeriesCoverage/csml:pointSeriesDomain/csml:TimeSeries/csml:timePositionList", doc);
        this.assertXpathEvaluatesTo("16.2 17.1 22.0 25.1 23.9", "//csml:PointSeriesFeature[@gml:id='ID2']/csml:value/csml:PointSeriesCoverage/gml:rangeSet/gml:ValueArray/gml:valueComponent/gml:QuantityList", doc);
    }

    @Override
    @Test
    public void testQuantityListSubset() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" outputFormat=\"gml32\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml/3.2\" xmlns:csml=\"http://ndg.nerc.ac.uk/csml\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd\"><wfs:Query typeName=\"csml:PointSeriesFeature\">    <ogc:Filter>        <ogc:PropertyIsLike wildCard=\"*\" singleChar=\"#\" escapeChar=\"\\\">            <ogc:PropertyName>csml:PointSeriesFeature/csml:value/csml:PointSeriesCoverage/gml:rangeSet/gml:ValueArray/gml:valueComponent/gml:QuantityList</ogc:PropertyName>            <ogc:Literal>*16.2*</ogc:Literal>        </ogc:PropertyIsLike>    </ogc:Filter></wfs:Query> </wfs:GetFeature>";
        this.validate(xml);
        Document doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        this.assertXpathEvaluatesTo("1", "/wfs:FeatureCollection/@numberReturned", doc);
        this.assertXpathCount(1, "//csml:PointSeriesFeature", doc);
        this.checkPointFeatureTwo(doc);
        this.assertXpathEvaluatesTo("16.2", "//csml:PointSeriesFeature[@gml:id='ID2']/csml:value/csml:PointSeriesCoverage/gml:rangeSet/gml:ValueArray/gml:valueComponent/gml:QuantityList", doc);
        this.assertXpathEvaluatesTo("1949-05-01", "//csml:PointSeriesFeature[@gml:id='ID2']/csml:value/csml:PointSeriesCoverage/csml:pointSeriesDomain/csml:TimeSeries/csml:timePositionList", doc);
    }
}

