/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.util.HashMap;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.StationsMockData;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.feature.type.Name;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.feature.NameImpl;
import org.geotools.jdbc.JDBCFeatureStore;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class UnboundedSequenceMultiValuesTest
extends AbstractAppSchemaTestSupport {
    private static final String TEST_RESOURCES_FOLDER = "/test-data/stations/unboundedSequence/";
    private XpathEngine WFS11_XPATH_ENGINE;
    private XpathEngine WFS20_XPATH_ENGINE;

    @Before
    public void beforeTest() {
        this.WFS11_XPATH_ENGINE = StationsMockData.buildXpathEngine(this.getTestData().getNamespaces(), "ows", "http://www.opengis.net/ows", "wfs", "http://www.opengis.net/wfs", "gml", "http://www.opengis.net/gml");
        this.WFS20_XPATH_ENGINE = StationsMockData.buildXpathEngine(this.getTestData().getNamespaces(), "ows", "http://www.opengis.net/ows/1.1", "wfs", "http://www.opengis.net/wfs/2.0", "gml", "http://www.opengis.net/gml/3.2");
    }

    @Override
    protected StationsMockData createTestData() {
        return new MockData();
    }

    @Test
    public void testGetAllNormalizedMultiValuesWfs() throws Exception {
        if (this.notJdbcBased()) {
            return;
        }
        Document document = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=st_gml31:Station_gml31");
        this.checkStationGml31(document);
        document = this.getAsDOM("wfs?request=GetFeature&version=2.0.0&typename=st_gml32:Station_gml32");
        this.checkStationGml32(document);
    }

    @Test
    public void testFilterMultiValuesWfs() throws Exception {
        if (this.notJdbcBased()) {
            return;
        }
        String filter = "<wfs:GetFeature service=\"WFS\" version=\"2.0.0\"\n    xmlns:fes=\"http://www.opengis.net/fes/2.0\"\n    xmlns:st_gml32=\"http://www.stations_gml32.org/1.0\"\n    xmlns:wfs=\"http://www.opengis.net/wfs/2.0\">\n    <wfs:Query typeNames=\"st_gml32:Station_gml32\">\n        <fes:Filter>\n            <fes:PropertyIsEqualTo>\n                <fes:ValueReference>st_gml32:Station_gml32/st_gml32:maintainer/st_gml32:name\n                </fes:ValueReference>\n                <fes:Literal>mnt_c</fes:Literal>\n            </fes:PropertyIsEqualTo>\n        </fes:Filter>\n    </wfs:Query>\n</wfs:GetFeature>";
        Document document = this.postAsDOM("wfs", filter);
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id='st.2']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 3, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32/st_gml32:maintainer/st_gml32:name");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32/st_gml32:maintainer/st_gml32:name[text()='mnt_c']");
        filter = this.readResource("/test-data/stations/unboundedSequence/requests/station_mainainer_filter_wfs11.xml");
        document = this.postAsDOM("wfs", filter);
        String stationXpath = "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31";
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id='st.2']");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 3, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31/st_gml31:maintainer/st_gml31:name");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31/st_gml31:maintainer/st_gml31:name[text()='mnt_c']");
    }

    private void checkStationGml31(Document document) {
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 3, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 2, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id='st.1']/st_gml31:maintainer/st_gml31:level");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id='st.1']/st_gml31:maintainer/st_gml31:level[text()='71']");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id='st.1']/st_gml31:maintainer/st_gml31:level[@xs:nil='true']");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 2, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id='st.1']/st_gml31:maintainer/st_gml31:name");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id='st.1']/st_gml31:maintainer/st_gml31:name[text()='mnt_a']");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id='st.1']/st_gml31:maintainer/st_gml31:name[text()='mnt_b']");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 2, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id='st.1']/st_gml31:maintainer/st_gml31:classType");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id='st.1']/st_gml31:maintainer/st_gml31:classType[text()='st_1_mnt_a']");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id='st.1']/st_gml31:maintainer/st_gml31:classType[text()='st_1_mnt_b']");
    }

    private void checkStationGml32(Document document) {
        String stationsXpath = "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32";
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 3, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 2, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id='st.1']/st_gml32:maintainer/st_gml32:level");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id='st.1']/st_gml32:maintainer/st_gml32:level[text()='71']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id='st.1']/st_gml32:maintainer/st_gml32:level[@xs:nil='true']");
    }

    private void checkCount(XpathEngine xpathEngine, Document document, int expectedCount, String xpath) {
        try {
            MatcherAssert.assertThat((Object)xpathEngine.getMatchingNodes(xpath, document).getLength(), (Matcher)CoreMatchers.is((Object)expectedCount));
        }
        catch (Exception exception) {
            throw new RuntimeException("Error evaluating xpath.", exception);
        }
    }

    private boolean notJdbcBased() throws Exception {
        NameImpl name;
        FeatureTypeInfo featureTypeInfo = this.getCatalog().getFeatureTypeByName("Station_gml31");
        DataAccess dataAccess = featureTypeInfo.getStore().getDataStore(null);
        AppSchemaDataAccess appSchemaDataAccess = (AppSchemaDataAccess)dataAccess;
        FeatureSource featureSource = appSchemaDataAccess.getMappingByName((Name)(name = new NameImpl("http://www.stations_gml31.org/1.0", "Station_gml31"))).getSource();
        return !(featureSource instanceof JDBCFeatureStore);
    }

    private static final class MockData
    extends StationsMockData {
        private MockData() {
        }

        @Override
        public void addContent() {
            this.putNamespace("st_gml31", "http://www.stations_gml31.org/1.0");
            this.putNamespace("ms_gml31", "http://www.measurements_gml31.org/1.0");
            this.putNamespace("st_gml32", "http://www.stations_gml32.org/1.0");
            this.putNamespace("ms_gml32", "http://www.measurements_gml32.org/1.0");
            HashMap<String, String> gml31Parameters = new HashMap<String, String>();
            gml31Parameters.put("GML_PREFIX", "gml31");
            gml31Parameters.put("GML_PREFIX_UPPER", "GML31");
            gml31Parameters.put("GML_NAMESPACE", "http://www.opengis.net/gml");
            gml31Parameters.put("GML_LOCATION", "http://schemas.opengis.net/gml/3.1.1/base/gml.xsd");
            this.addAppSchemaFeatureType("st_gml31", "gml31", "Station_gml31", "/test-data/stations/unboundedSequence/stations.xml", gml31Parameters, "/test-data/stations/unboundedSequence/stations.xsd", "/test-data/stations/unboundedSequence/stations.properties", "/test-data/stations/unboundedSequence/measurements.xml", "/test-data/stations/unboundedSequence/measurements.xsd", "/test-data/stations/unboundedSequence/measurements.properties", "/test-data/stations/unboundedSequence/maintainers.properties", "/test-data/stations/unboundedSequence/tags.properties");
            HashMap<String, String> gml32Parameters = new HashMap<String, String>();
            gml32Parameters.put("GML_PREFIX", "gml32");
            gml32Parameters.put("GML_PREFIX_UPPER", "GML32");
            gml32Parameters.put("GML_NAMESPACE", "http://www.opengis.net/gml/3.2");
            gml32Parameters.put("GML_LOCATION", "http://schemas.opengis.net/gml/3.2.1/gml.xsd");
            this.addAppSchemaFeatureType("st_gml32", "gml32", "Station_gml32", "/test-data/stations/unboundedSequence/stations.xml", gml32Parameters, "/test-data/stations/unboundedSequence/stations.xsd", "/test-data/stations/unboundedSequence/stations.properties", "/test-data/stations/unboundedSequence/measurements.xml", "/test-data/stations/unboundedSequence/measurements.xsd", "/test-data/stations/unboundedSequence/measurements.properties", "/test-data/stations/unboundedSequence/maintainers.properties", "/test-data/stations/unboundedSequence/tags.properties");
        }
    }
}

