/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.ValidationTestMockData;
import org.junit.Test;
import org.w3c.dom.Document;

public class ValidationTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected ValidationTestMockData createTestData() {
        return new ValidationTestMockData();
    }

    @Test
    public void testAttributeMinOccur0() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:GeologicUnit");
        LOGGER.info("WFS GetFeature&typename=gsml:GeologicUnit response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.gu.1']/gml:name", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.gu.2']/gml:name", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.gu.3']/gml:name", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.gu.1']/gsml:bodyMorphology/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("myBody1", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.gu.1']/gsml:bodyMorphology/gsml:CGI_TermValue/gsml:value[@codeSpace='myBodyCodespace1']", doc);
        this.assertXpathEvaluatesTo("compositionName", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.gu.1']/gsml:composition/gsml:CompositionPart/gsml:lithology[1]/gsml:ControlledConcept/gml:name", doc);
        this.assertXpathEvaluatesTo("myBody1", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.gu.1']/gsml:composition/gsml:CompositionPart/gsml:lithology[2]/gsml:ControlledConcept/gml:name", doc);
        this.assertXpathEvaluatesTo("myBody1", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.gu.1']/gsml:rank[@codeSpace='myBodyCodespace1']", doc);
        this.assertXpathCount(0, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.gu.2']/gsml:bodyMorphology/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("compositionName", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.gu.2']/gsml:composition/gsml:CompositionPart/gsml:lithology[1]/gsml:ControlledConcept/gml:name", doc);
        this.assertXpathCount(0, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.gu.2']/gsml:composition/gsml:CompositionPart/gsml:lithology[2]/gsml:ControlledConcept/gml:name", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.gu.2']/gsml:rank[@codeSpace='myBodyCodespace2']", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.gu.3']/gsml:bodyMorphology/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("myBody3", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.gu.3']/gsml:bodyMorphology/gsml:CGI_TermValue/gsml:value[@codeSpace='myBodyCodespace3']", doc);
        this.assertXpathEvaluatesTo("compositionName", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.gu.3']/gsml:composition/gsml:CompositionPart/gsml:lithology[1]/gsml:ControlledConcept/gml:name", doc);
        this.assertXpathEvaluatesTo("myBody3", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.gu.3']/gsml:composition/gsml:CompositionPart/gsml:lithology[2]/gsml:ControlledConcept/gml:name", doc);
        this.assertXpathEvaluatesTo("myBody3", "//gsml:GeologicUnit[@gml:id='gsml.geologicunit.gu.3']/gsml:rank[@codeSpace='myBodyCodespace3']", doc);
    }

    @Test
    public void testSimpleContentInteger() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=er:Commodity");
        LOGGER.info("WFS GetFeature&typename=er:Commodity response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//er:Commodity[@gml:id='er.commodity.gu.1']/gml:name", doc);
        this.assertXpathCount(1, "//er:Commodity[@gml:id='er.commodity.gu.1']/er:commodityRank", doc);
        this.assertXpathEvaluatesTo("myName1", "//er:Commodity[@gml:id='er.commodity.gu.1']/gml:name", doc);
        this.assertXpathEvaluatesTo("1", "//er:Commodity[@gml:id='er.commodity.gu.1']/er:commodityRank", doc);
        this.assertXpathCount(1, "//er:Commodity[@gml:id='er.commodity.gu.2']/gml:name", doc);
        this.assertXpathCount(0, "//er:Commodity[@gml:id='er.commodity.gu.2']/er:commodityRank", doc);
        this.assertXpathEvaluatesTo("myName2", "//er:Commodity[@gml:id='er.commodity.gu.2']/gml:name", doc);
        this.assertXpathCount(1, "//er:Commodity[@gml:id='er.commodity.gu.3']/gml:name", doc);
        this.assertXpathCount(1, "//er:Commodity[@gml:id='er.commodity.gu.3']/er:commodityRank", doc);
        this.assertXpathEvaluatesTo("myName3", "//er:Commodity[@gml:id='er.commodity.gu.3']/gml:name", doc);
        this.assertXpathEvaluatesTo("3", "//er:Commodity[@gml:id='er.commodity.gu.3']/er:commodityRank", doc);
    }

    @Test
    public void testAttributeMinOccur1() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature");
        LOGGER.info("WFS GetFeature&typename=gsml:gsml:MappedFeature response:\n" + this.prettyString(doc));
        this.assertXpathCount(3, "//gsml:MappedFeature", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.gu.1']", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.gu.1']/gsml:observationMethod", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.gu.1']/gsml:observationMethod/gsml:CGI_TermValue", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.gu.2']", doc);
        this.assertXpathEvaluatesTo("observation2", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.gu.2']/gsml:observationMethod/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.gu.3']", doc);
        this.assertXpathEvaluatesTo("observation3", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.gu.3']/gsml:observationMethod/gsml:CGI_TermValue/gsml:value", doc);
    }
}

