/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test.onlineTest;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.geoserver.test.onlineTest.support.AbstractDataReferenceWfsTest;
import org.geotools.image.test.ImageAssert;
import org.geotools.util.URLs;
import org.junit.Test;
import org.w3c.dom.Document;

public abstract class DataReferenceWmsOnlineTest
extends AbstractDataReferenceWfsTest {
    @Test
    public void testGetMapSimpleLithology() throws Exception {
        try (InputStream is = this.getBinary("wms?request=GetMap&SRS=EPSG:4326&layers=gsml:MappedFeature&styles=simplelithology&BBOX=140,-38,145,-35&width=500&height=500&FORMAT=image/png");){
            BufferedImage imageBuffer = ImageIO.read(is);
            this.assertNotBlank("app-schema test getmap simple lithology", imageBuffer, Color.WHITE);
            ImageAssert.assertEquals((File)URLs.urlToFile((URL)((Object)((Object)this)).getClass().getResource("/test-data/img/datareference_simplelithology.png")), (RenderedImage)imageBuffer, (int)250);
        }
    }

    @Test
    public void testGetMapStratChart() throws Exception {
        try (InputStream is = this.getBinary("wms?request=GetMap&SRS=EPSG:4326&layers=gsml:MappedFeature&styles=stratchart&BBOX=140,-38,150,-35&width=500&height=500&FORMAT=image/png");){
            BufferedImage imageBuffer = ImageIO.read(is);
            this.assertNotBlank("app-schema test getmap stratchart", imageBuffer, Color.WHITE);
            ImageAssert.assertEquals((File)URLs.urlToFile((URL)((Object)((Object)this)).getClass().getResource("/test-data/img/datareference_stratchart.png")), (RenderedImage)imageBuffer, (int)250);
        }
    }

    @Test
    public void testGetMapAfterWFS() throws Exception {
        Document doc = this.getAsDOM("wfs?request=getFeature&version=1.1.0&typeName=gsml:MappedFeature&maxFeatures=1");
        LOGGER.info(this.prettyString(doc));
        try (InputStream is = this.getBinary("wms?request=GetMap&SRS=EPSG:4326&layers=gsml:MappedFeature&styles=stratchart&BBOX=140,-38,150,-35&width=500&height=500&FORMAT=image/png");){
            BufferedImage imageBuffer = ImageIO.read(is);
            this.assertNotBlank("app-schema test getmap outcrop character", imageBuffer, Color.WHITE);
            ImageAssert.assertEquals((File)URLs.urlToFile((URL)((Object)((Object)this)).getClass().getResource("/test-data/img/datareference_stratchart.png")), (RenderedImage)imageBuffer, (int)250);
        }
    }
}

