/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test.onlineTest.support;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatabaseUtil {
    public static final String NEWLINE = System.getProperty("line.separator");

    public List<String> splitPostgisSQLScript(InputStream inputStream) throws Exception {
        ArrayList<String> arrayList;
        if (inputStream == null) {
            throw new IllegalArgumentException("PostGIS SQL Script is null, check resource reference");
        }
        StringBuilder contents = new StringBuilder();
        ArrayList<String> statements = new ArrayList<String>();
        try (BufferedReader input = new BufferedReader(new InputStreamReader(new DataInputStream(inputStream)));){
            String line = null;
            PostgisIgnoreOperator pio = new PostgisIgnoreOperator();
            while ((line = input.readLine()) != null) {
                String trimedLine = line.trim();
                if (trimedLine.startsWith("--") || trimedLine.equals("")) continue;
                for (String opr : pio.getOperators()) {
                    if (DatabaseUtil.countMatches(trimedLine, opr) % 2 != 1) continue;
                    pio.setReverseStatus(opr);
                }
                contents.append(trimedLine + NEWLINE);
                if (!trimedLine.endsWith(";") || !pio.isAllClosed()) continue;
                statements.add(contents.toString());
                pio.reset();
                contents.setLength(0);
            }
            arrayList = statements;
        }
        return arrayList;
    }

    public static int countMatches(String str, String sub) {
        if (str.length() == 0 || sub.length() == 0) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    public String rebuildAsSingle(List<String> sqls) {
        StringBuilder sb = new StringBuilder();
        for (String sql : sqls) {
            sb.append(sql).append("\n");
        }
        return sb.toString();
    }

    public List<String> splitOracleSQLScript(InputStream inputStream) throws Exception {
        ArrayList<String> arrayList;
        StringBuilder contents = new StringBuilder();
        ArrayList<String> statements = new ArrayList<String>();
        try (BufferedReader input = new BufferedReader(new InputStreamReader(new DataInputStream(inputStream)));){
            String line = null;
            String suffix = null;
            boolean start = true;
            while ((line = input.readLine()) != null) {
                String trimedLine = line.trim();
                if (trimedLine.startsWith("--") || trimedLine.equals("")) continue;
                if (start) {
                    boolean match = false;
                    for (OracleScriptRule ps : OracleScriptRule.values()) {
                        if (!trimedLine.startsWith(ps.getPrefix())) continue;
                        match = true;
                        suffix = ps.getSuffix();
                        start = trimedLine.endsWith(suffix);
                        contents.append(trimedLine + NEWLINE);
                        if (!start) break;
                        statements.add(contents.toString().trim().substring(0, contents.toString().trim().length() - 1));
                        contents.setLength(0);
                        suffix = null;
                        break;
                    }
                    if (match) continue;
                    throw new Exception("Can't match " + trimedLine);
                }
                if (trimedLine.endsWith(suffix)) {
                    trimedLine = trimedLine.trim().substring(0, trimedLine.length() - 1);
                    contents.append(trimedLine);
                    statements.add(contents.toString());
                    contents.setLength(0);
                    start = true;
                    suffix = null;
                    continue;
                }
                contents.append(trimedLine + NEWLINE);
            }
            arrayList = statements;
        }
        return arrayList;
    }

    private static enum OracleScriptRule {
        INSERT("Insert", ");"),
        CREATE_OR_REPLACE_PROCEDURE("CREATE OR REPLACE PROCEDURE", "/"),
        CALL("CALL", ";"),
        DELETE("DELETE", ";"),
        CREATE_TABLE("CREATE TABLE", ";"),
        CREATE_OR_REPLACE_FORCE_VIEW("CREATE OR REPLACE FORCE VIEW", ";"),
        REM("REM", ";"),
        CREATE_INDEX("CREATE INDEX", ";"),
        DECLARE("declare", "/"),
        COMMIT("COMMIT", ";"),
        ALTER("ALTER TABLE", ");");

        private String prefix;
        private String suffix;

        private OracleScriptRule(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }

    private class PostgisIgnoreOperator {
        public final String[] operators = new String[]{"$$", "$_$", "'"};
        Map<String, Boolean> open = new HashMap<String, Boolean>();

        PostgisIgnoreOperator() {
            for (String s : this.operators) {
                this.open.put(s, Boolean.FALSE);
            }
        }

        public String[] getOperators() {
            return this.operators;
        }

        public boolean getOperatorStatus(String key) {
            return this.open.get(key);
        }

        public void setOperatorStatus(String key, boolean value) {
            this.open.put(key, value);
        }

        public void setReverseStatus(String key) {
            this.open.put(key, this.open.get(key) == false);
        }

        public boolean isAllClosed() {
            for (boolean opn : this.open.values()) {
                if (!opn) continue;
                return false;
            }
            return true;
        }

        public void reset() {
            for (String s : this.operators) {
                this.setOperatorStatus(s, false);
            }
        }
    }
}

