/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import org.geoserver.test.AbstractAppSchemaMockData;
import org.geoserver.test.StationsMockData;
import org.locationtech.jts.geom.Envelope;

public class AliasStationsMockData
extends StationsMockData {
    private String layerNamePrefix;

    @Override
    public void addContent() {
        this.setLayerNamePrefix("lyr");
        super.addContent();
    }

    private String getLayerName(String typeName) {
        if (this.layerNamePrefix != null) {
            return this.layerNamePrefix + "_" + typeName;
        }
        return typeName;
    }

    @Override
    public void addFeatureType(String namespacePrefix, String typeName, String mappingFileName, String ... supportFileNames) {
        File featureTypeDir = this.getFeatureTypeDir(this.featureTypesBaseDir, namespacePrefix, typeName);
        String dataStoreName = this.getDataStoreName(namespacePrefix, typeName);
        try {
            this.writeInfoFileInternal(namespacePrefix, typeName, featureTypeDir, dataStoreName);
            this.copyMappingAndSupportFiles(namespacePrefix, typeName, mappingFileName, supportFileNames);
            this.addDataStore(dataStoreName, namespacePrefix, AbstractAppSchemaMockData.buildAppSchemaDatastoreParams(namespacePrefix, typeName, this.getFileNamePart(mappingFileName), this.featureTypesBaseDir, dataStoreName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeInfoFileInternal(String namespacePrefix, String typeName, File featureTypeDir, String dataStoreName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("style", "Default");
        params.put("srsHandling", 2);
        params.put("alias", null);
        Integer srs = 4326;
        params.put("srs", srs);
        try {
            featureTypeDir.mkdir();
            File info = new File(featureTypeDir, "info.xml");
            info.delete();
            info.createNewFile();
            try (FileWriter writer = new FileWriter(info);){
                String style;
                writer.write("<featureType datastore=\"" + dataStoreName + "\">");
                writer.write("<name>" + this.getLayerName(typeName) + "</name>");
                writer.write("<nativeName>" + typeName + "</nativeName>");
                if (params.get("alias") != null) {
                    writer.write("<alias>" + params.get("alias") + "</alias>");
                }
                writer.write("<SRS>" + params.get("srs") + "</SRS>");
                writer.write("<SRSHandling>" + params.get("srsHandling") + "</SRSHandling>");
                writer.write("<title>" + typeName + "</title>");
                writer.write("<abstract>abstract about " + typeName + "</abstract>");
                writer.write("<numDecimals value=\"8\"/>");
                writer.write("<keywords>" + typeName + "</keywords>");
                Envelope llEnvelope = (Envelope)params.get("ll_envelope");
                if (llEnvelope == null) {
                    llEnvelope = DEFAULT_ENVELOPE;
                }
                writer.write("<latLonBoundingBox dynamic=\"false\" minx=\"" + llEnvelope.getMinX() + "\" miny=\"" + llEnvelope.getMinY() + "\" maxx=\"" + llEnvelope.getMaxX() + "\" maxy=\"" + llEnvelope.getMaxY() + "\"/>");
                Envelope nativeEnvelope = (Envelope)params.get("native_envelope");
                if (nativeEnvelope != null) {
                    writer.write("<nativeBBox dynamic=\"false\" minx=\"" + nativeEnvelope.getMinX() + "\" miny=\"" + nativeEnvelope.getMinY() + "\" maxx=\"" + nativeEnvelope.getMaxX() + "\" maxy=\"" + nativeEnvelope.getMaxY() + "\"/>");
                }
                if ((style = (String)params.get("style")) == null) {
                    style = "Default";
                }
                writer.write("<styles default=\"" + style + "\"/>");
                writer.write("</featureType>");
                writer.flush();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String getDataStoreName(String namespacePrefix, String typeName) {
        return namespacePrefix + "_" + this.getLayerName(typeName);
    }

    public String getLayerNamePrefix() {
        return this.layerNamePrefix;
    }

    public void setLayerNamePrefix(String layerNamePrefix) {
        this.layerNamePrefix = layerNamePrefix;
    }
}

