/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import org.geoserver.test.AbstractAppSchemaMockData;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.BBox3DMockData;
import org.junit.Test;
import org.w3c.dom.Document;

public class BBox3DTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected AbstractAppSchemaMockData createTestData() {
        return new BBox3DMockData();
    }

    @Test
    public void testBbox1() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature&srsName=EPSG:4979&bbox=-200,-200,0,200,200,50");
        LOGGER.info("WFS GetFeature&typename=gsml:MappedFeature response:\n" + this.prettyString(doc));
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf4']", doc);
        this.assertXpathEvaluatesTo("167.9388 -29.0434 7", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gsml:shape/gml:Point/gml:pos", doc);
        this.assertXpathEvaluatesTo("3", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gsml:shape/gml:Point/@srsDimension", doc);
        this.assertXpathEvaluatesTo("http://www.opengis.net/gml/srs/epsg.xml#4979", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gsml:shape/gml:Point/@srsName", doc);
    }

    @Test
    public void testBbox2() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature&srsName=EPSG:4979&bbox=-200,-200,50,200,200,200");
        LOGGER.info("WFS GetFeature&typename=gsml:MappedFeature response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf4']", doc);
        this.assertXpathEvaluatesTo("133.8855 -23.6701 112", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:shape/gml:Point/gml:pos", doc);
        this.assertXpathEvaluatesTo("3", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:shape/gml:Point/@srsDimension", doc);
        this.assertXpathEvaluatesTo("http://www.opengis.net/gml/srs/epsg.xml#4979", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:shape/gml:Point/@srsName", doc);
    }

    @Test
    public void testBboxPost() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\">    <wfs:Query typeName=\"gsml:MappedFeature\">        <ogc:Filter>            <ogc:BBOX>              <gml:Envelope srsName=\"EPSG:4979\">  \t\t\t\t\t<gml:lowerCorner>-200 -200 0 </gml:lowerCorner> \t\t\t\t\t\t<gml:upperCorner> 200 200 50 </gml:upperCorner>               </gml:Envelope>            </ogc:BBOX>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS GetFeature&typename=gsml:MappedFeature response:\n" + this.prettyString(doc));
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf4']", doc);
    }
}

