/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.util.ArrayList;
import java.util.HashMap;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.IdFunctionMockData;
import org.geotools.data.complex.AppSchemaDataAccessRegistry;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class IdFunctionWfsTest
extends AbstractAppSchemaTestSupport {
    private String mf1 = "mf1";
    private String mf2 = "mf2";
    private String mf3 = "mf3";
    private String mf4 = "mf4";

    public IdFunctionWfsTest() {
        if (System.getProperty("testDatabase") != null) {
            String PREFIX = "MAPPEDFEATUREPROPERTYFILE.";
            this.mf1 = "MAPPEDFEATUREPROPERTYFILE." + this.mf1;
            this.mf2 = "MAPPEDFEATUREPROPERTYFILE." + this.mf2;
            this.mf3 = "MAPPEDFEATUREPROPERTYFILE." + this.mf3;
            this.mf4 = "MAPPEDFEATUREPROPERTYFILE." + this.mf4;
        }
    }

    @Override
    protected IdFunctionMockData createTestData() {
        return new IdFunctionMockData();
    }

    protected void setUpTestData(SystemTestData testData) throws Exception {
        AppSchemaDataAccessRegistry.getAppSchemaProperties().setProperty("app-schema.joining", "false");
        super.setUpTestData(testData);
    }

    @Test
    public void testGetFeature() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature");
        LOGGER.info("WFS GetFeature&typename=gsml:MappedFeature response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
    }

    @Test
    public void testGetFeatureContent() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature");
        LOGGER.info("WFS GetFeature&typename=gsml:MappedFeature response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("5", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(5, "//gsml:MappedFeature", doc);
        String id = this.mf1;
        this.assertXpathEvaluatesTo(id, "(//gsml:MappedFeature)[1]/@gml:id", doc);
        this.assertXpathEvaluatesTo("GUNTHORPE FORMATION", "//gsml:MappedFeature[@gml:id='" + id + "']/gml:name", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4326", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:shape/gml:Polygon/@srsName", doc);
        this.assertXpathEvaluatesTo("52.5 -1.2 52.6 -1.2 52.6 -1.1 52.5 -1.1 52.5 -1.2", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:shape//gml:posList", doc);
        this.assertXpathEvaluatesTo("gu.25699", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/@gml:id", doc);
        this.assertXpathEvaluatesTo("Olivine basalt, tuff, microgabbro, minor sedimentary rocks", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:description", doc);
        this.assertXpathCount(2, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name", doc);
        this.assertXpathEvaluatesTo("Yaugher Volcanic Group", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name[@codeSpace='urn:ietf:rfc:2141']", doc);
        Cloneable names = new ArrayList<String>();
        names.add("Yaugher Volcanic Group");
        names.add("-Py");
        String name = this.evaluate("//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name[1]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        name = this.evaluate("//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name[2]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        Assert.assertTrue((boolean)names.isEmpty());
        id = this.mf2;
        this.assertXpathEvaluatesTo(id, "(//gsml:MappedFeature)[2]/@gml:id", doc);
        this.assertXpathEvaluatesTo("MERCIA MUDSTONE GROUP", "//gsml:MappedFeature[@gml:id='" + id + "']/gml:name", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4326", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:shape/gml:Polygon/@srsName", doc);
        this.assertXpathEvaluatesTo("52.5 -1.3 52.6 -1.3 52.6 -1.2 52.5 -1.2 52.5 -1.3", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:shape//gml:posList", doc);
        this.assertXpathEvaluatesTo("gu.25678", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/@gml:id", doc);
        this.assertXpathCount(3, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name", doc);
        names = new HashMap();
        ((HashMap)names).put("Yaugher Volcanic Group 1", "urn:ietf:rfc:2141");
        ((HashMap)names).put("Yaugher Volcanic Group 2", "urn:ietf:rfc:2141");
        ((HashMap)names).put("-Py", "");
        name = this.evaluate("//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name[1]", doc);
        Assert.assertTrue((boolean)((HashMap)names).containsKey(name));
        this.assertXpathEvaluatesTo((String)((HashMap)names).get(name), "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name[1]/@codeSpace", doc);
        ((HashMap)names).remove(name);
        name = this.evaluate("//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name[2]", doc);
        Assert.assertTrue((boolean)((HashMap)names).containsKey(name));
        this.assertXpathEvaluatesTo((String)((HashMap)names).get(name), "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name[2]/@codeSpace", doc);
        ((HashMap)names).remove(name);
        name = this.evaluate("//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name[3]", doc);
        Assert.assertTrue((boolean)((HashMap)names).containsKey(name));
        this.assertXpathEvaluatesTo((String)((HashMap)names).get(name), "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name[3]/@codeSpace", doc);
        ((HashMap)names).remove(name);
        Assert.assertTrue((boolean)((HashMap)names).isEmpty());
        id = this.mf3;
        this.assertXpathEvaluatesTo(id, "(//gsml:MappedFeature)[3]/@gml:id", doc);
        this.assertXpathEvaluatesTo("CLIFTON FORMATION", "//gsml:MappedFeature[@gml:id='" + id + "']/gml:name", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4326", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:shape/gml:Polygon/@srsName", doc);
        this.assertXpathEvaluatesTo("52.5 -1.2 52.6 -1.2 52.6 -1.1 52.5 -1.1 52.5 -1.2", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:shape//gml:posList", doc);
        this.assertXpathEvaluatesTo("#gu.25678", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/@xlink:href", doc);
        id = this.mf4;
        this.assertXpathEvaluatesTo(id, "(//gsml:MappedFeature)[4]/@gml:id", doc);
        this.assertXpathEvaluatesTo("MURRADUC BASALT", "//gsml:MappedFeature[@gml:id='" + id + "']/gml:name", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4326", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:shape/gml:Polygon/@srsName", doc);
        this.assertXpathEvaluatesTo("52.5 -1.3 52.6 -1.3 52.6 -1.2 52.5 -1.2 52.5 -1.3", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:shape//gml:posList", doc);
        this.assertXpathEvaluatesTo("gu.25682", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/@gml:id", doc);
        this.assertXpathEvaluatesTo("Olivine basalt", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:description", doc);
        this.assertXpathCount(2, "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name", doc);
        this.assertXpathEvaluatesTo("New Group", "//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name[@codeSpace='urn:ietf:rfc:2141']", doc);
        names = new ArrayList();
        names.add("New Group");
        names.add("-Xy");
        name = this.evaluate("//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name[1]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        name = this.evaluate("//gsml:MappedFeature[@gml:id='" + id + "']/gsml:specification/gsml:GeologicUnit/gml:name[2]", doc);
        Assert.assertTrue((boolean)names.contains(name));
        names.remove(name);
        Assert.assertTrue((boolean)names.isEmpty());
    }
}

