/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import org.apache.commons.lang3.SystemUtils;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.test.XLink32MockData;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class LocalResolveTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected XLink32MockData createTestData() {
        return new XLink32MockData();
    }

    @Before
    public void skipOnGithubActions() {
        Assume.assumeFalse((boolean)GeoServerSystemTestSupport.isGitHubAction());
    }

    @Test
    public void testResolveDepth2() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=2.0.0&typename=gsml:MappedFeature&resolve=local&resolveDepth=2");
        LOGGER.info("WFS testResolveDepth2 response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("gu.25699", "//gsml:MappedFeature[@gml:id='mf1']/gsml:specification/gsml:GeologicUnit/@gml:id", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::unknown", "//gsml:MappedFeature[@gml:id='mf1']/gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:role/@xlink:href", doc);
        this.assertXpathCount(3, "//gsml:GeologicUnit", doc);
        this.assertXpathCount(3, "//gsml:CompositionPart", doc);
    }

    @Test
    public void testResolveDepth1() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=2.0.0&typename=gsml:MappedFeature&resolve=local&resolveDepth=1");
        LOGGER.info("WFS testResolveDepth1 response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("gu.25699", "//gsml:MappedFeature[@gml:id='mf1']/gsml:specification/gsml:GeologicUnit/@gml:id", doc);
        this.assertXpathEvaluatesTo("urn:x-test:CompositionPart:cp.167775491936278899", "//gsml:MappedFeature[@gml:id='mf1']/gsml:specification/gsml:GeologicUnit/gsml:composition/@xlink:href", doc);
        this.assertXpathCount(3, "//gsml:GeologicUnit", doc);
        this.assertXpathCount(0, "//gsml:CompositionPart", doc);
    }

    @Test
    public void testResolveDepth0() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=2.0.0&typename=gsml:MappedFeature&resolve=local&resolveDepth=0");
        LOGGER.info("WFS testResolveDepth0 response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("urn:x-test:GeologicUnit:gu.25699", "//gsml:MappedFeature[@gml:id='mf1']/gsml:specification/@xlink:href", doc);
        this.assertXpathCount(0, "//gsml:GeologicUnit", doc);
        this.assertXpathCount(0, "//gsml:CompositionPart", doc);
    }

    @Test
    public void testNoResolve() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=2.0.0&typename=gsml:MappedFeature&resolve=none");
        LOGGER.info("WFS testNoResolve response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("urn:x-test:GeologicUnit:gu.25699", "//gsml:MappedFeature[@gml:id='mf1']/gsml:specification/@xlink:href", doc);
        this.assertXpathCount(0, "//gsml:GeologicUnit", doc);
        this.assertXpathCount(0, "//gsml:CompositionPart", doc);
    }

    @Test
    public void testResolveTimeOut() {
        Document doc;
        if (!SystemUtils.IS_OS_MAC) {
            doc = this.getAsDOM("wfs?request=GetFeature&version=2.0.0&typename=gsml:MappedFeature&resolve=local&resolveDepth=2&resolveTimeOut=0");
            LOGGER.info("WFS testResolveTimeOut 0 response:\n" + this.prettyString(doc));
            this.assertXpathEvaluatesTo("urn:x-test:GeologicUnit:gu.25699", "//gsml:MappedFeature[@gml:id='mf1']/gsml:specification/@xlink:href", doc);
            this.assertXpathCount(0, "//gsml:GeologicUnit", doc);
            this.assertXpathCount(0, "//gsml:CompositionPart", doc);
        }
        doc = this.getAsDOM("wfs?request=GetFeature&version=2.0.0&typename=gsml:MappedFeature&resolve=local&resolveDepth=2&resolveTimeOut=100000");
        LOGGER.info("WFS testResolveTimeOut 100000 response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("gu.25699", "//gsml:MappedFeature[@gml:id='mf1']/gsml:specification/gsml:GeologicUnit/@gml:id", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::unknown", "//gsml:MappedFeature[@gml:id='mf1']/gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:role/@xlink:href", doc);
        this.assertXpathCount(3, "//gsml:GeologicUnit", doc);
        this.assertXpathCount(3, "//gsml:CompositionPart", doc);
    }

    @Test
    public void testRemoteResolve() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=2.0.0&typename=gsml:MappedFeature&resolve=remote");
        LOGGER.info("WFS testRemoteResolve response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//ows:ExceptionReport", doc);
    }
}

