/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.WmsSupportMockData;
import org.junit.Test;

public class WmsGetLegendGraphicTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected WmsSupportMockData createTestData() {
        WmsSupportMockData mockData = new WmsSupportMockData();
        mockData.addStyle("Default", "styles/Default.sld");
        mockData.addStyle("outcropcharacter", "styles/outcropcharacter.sld");
        return mockData;
    }

    @Test
    public void testGetLegendGraphicAll() throws Exception {
        try (InputStream is = this.getBinary("wms?request=GetLegendGraphic&SRS=EPSG:4326&layer=gsml:MappedFeature&style=outcropcharacter&X=0&Y=0&width=20&height=20&FORMAT=image/png");){
            BufferedImage imageBuffer = ImageIO.read(is);
            this.assertNotBlank("app-schema test getmap outcrop character", imageBuffer, Color.WHITE);
            this.assertPixel(imageBuffer, 10, 10, new Color(0, 0, 255));
            this.assertPixel(imageBuffer, 10, 30, new Color(255, 0, 0));
            this.assertPixel(imageBuffer, 10, 50, new Color(0, 255, 0));
        }
    }

    @Test
    public void testGetLegendGraphicBlueRule() throws Exception {
        try (InputStream is = this.getBinary("wms?request=GetLegendGraphic&rule=xrule&SRS=EPSG:4326&layer=gsml:MappedFeature&style=outcropcharacter&X=0&Y=0&width=20&height=20&FORMAT=image/png");){
            BufferedImage imageBuffer = ImageIO.read(is);
            this.assertNotBlank("app-schema test getmap outcrop character", imageBuffer, Color.WHITE);
            this.assertPixel(imageBuffer, 10, 10, new Color(0, 0, 255));
        }
    }

    @Test
    public void testGetLegendGraphicRedRule() throws Exception {
        try (InputStream is = this.getBinary("wms?request=GetLegendGraphic&rule=yrule&SRS=EPSG:4326&layer=gsml:MappedFeature&style=outcropcharacter&X=0&Y=0&width=20&height=20&FORMAT=image/png");){
            BufferedImage imageBuffer = ImageIO.read(is);
            this.assertNotBlank("app-schema test getmap outcrop character", imageBuffer, Color.WHITE);
            this.assertPixel(imageBuffer, 10, 10, new Color(255, 0, 0));
        }
    }

    @Test
    public void testGetLegendGraphicGreenRule() throws Exception {
        try (InputStream is = this.getBinary("wms?request=GetLegendGraphic&rule=zrule&SRS=EPSG:4326&layer=gsml:MappedFeature&style=outcropcharacter&X=0&Y=0&width=20&height=20&FORMAT=image/png");){
            BufferedImage imageBuffer = ImageIO.read(is);
            this.assertNotBlank("app-schema test getmap outcrop character", imageBuffer, Color.WHITE);
            this.assertPixel(imageBuffer, 10, 10, new Color(0, 255, 0));
        }
    }
}

