/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.FeatureGML32MockData;
import org.junit.Test;
import org.w3c.dom.Document;

public class XPathPredicateTest
extends AbstractAppSchemaTestSupport {
    public static final String GETFEATURE_ATTRIBUTES = "service=\"WFS\" version=\"2.0\" xmlns:wfs=\"http://www.opengis.net/wfs/2.0\" xmlns:gml=\"http://www.opengis.net/gml/3.2\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML-Core:3.0.0\" xmlns:fes=\"http://www.opengis.net/fes/2.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\"";

    @Override
    protected FeatureGML32MockData createTestData() {
        return new FeatureGML32MockData();
    }

    @Test
    public void testFiltering() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"2.0\" xmlns:wfs=\"http://www.opengis.net/wfs/2.0\" xmlns:gml=\"http://www.opengis.net/gml/3.2\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML-Core:3.0.0\" xmlns:fes=\"http://www.opengis.net/fes/2.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\">    <wfs:Query typeNames=\"gsml:MappedFeature\">        <fes:Filter>            <fes:PropertyIsEqualTo>                <fes:Literal>Olivine basalt, tuff, microgabbro, minor sedimentary rocks</fes:Literal>                <fes:ValueReference>gsml:specification/gsml:GeologicUnit[gml:name='Yaugher Volcanic Group 2']/gml:description</fes:ValueReference>            </fes:PropertyIsEqualTo>        </fes:Filter>    </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        this.assertXpathCount(2, "//gsml:MappedFeature", doc);
        this.assertXpathCount(1, "//wfs:member[1]/gsml:MappedFeature/gsml:specification/gsml:GeologicUnit[gml:name='Yaugher Volcanic Group 2']", doc);
        this.assertXpathEvaluatesTo("Olivine basalt, tuff, microgabbro, minor sedimentary rocks", "//wfs:member[1]/gsml:MappedFeature/gsml:specification/gsml:GeologicUnit/gml:description", doc);
    }

    @Test
    public void testGetPropertyValue() {
        Document doc = this.getAsDOM("wfs?request=GetPropertyValue&version=2.0.0&typename=gsml:MappedFeature&valueReference=gsml:specification/gsml:GeologicUnit[gml:name='Yaugher Volcanic Group 2']/gml:description");
        LOGGER.info("WFS GetPropertyValue response:\n" + this.prettyString(doc));
        this.assertXpathCount(2, "//wfs:member", doc);
    }
}

