/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test.onlineTest.setup;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.test.onlineTest.setup.ReferenceDataOracleSetup;
import org.geotools.api.feature.IllegalAttributeException;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.GeometryType;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.data.property.PropertyFeatureReader;
import org.geotools.util.Classes;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTWriter;

public class AppSchemaTestOracleSetup
extends ReferenceDataOracleSetup {
    public static String DB_PARAMS = "<parameters>\n<Parameter>\n<name>dbtype</name>\n<value>Oracle</value>\n</Parameter>\n<Parameter>\n<name>host</name>\n<value>${host}</value>\n</Parameter>\n<Parameter>\n<name>port</name>\n<value>${port}</value>\n</Parameter>\n<Parameter>\n<name>database</name>\n<value>${database}</value>\n</Parameter>\n<Parameter>\n<name>user</name>\n<value>${user}</value>\n</Parameter>\n<Parameter>\n<name>passwd</name>\n<value>${passwd}</value>\n</Parameter>\n<Parameter>\n<name>Expose primary keys</name><value>true</value>\n</Parameter>\n</parameters>";
    private static String DEFAULT_PARSER = "SDO_GEOMETRY";
    private String sql;

    public static AppSchemaTestOracleSetup getInstance(Map<String, File> propertyFiles) throws Exception {
        return new AppSchemaTestOracleSetup(propertyFiles, false);
    }

    public static AppSchemaTestOracleSetup get3DInstance(Map<String, File> propertyFiles) throws Exception {
        return new AppSchemaTestOracleSetup(propertyFiles, true);
    }

    public AppSchemaTestOracleSetup(Map<String, File> propertyFiles, boolean is3D) throws Exception {
        Object parser;
        this.configureFixture();
        if (is3D) {
            String user = System.getProperty("SC4OUser");
            if (user == null) {
                user = this.fixture.getProperty("user");
            }
            parser = user + ".SC4O.ST_GeomFromEWKT";
        } else {
            parser = DEFAULT_PARSER;
        }
        this.createTables(propertyFiles, (String)parser);
    }

    private void createTables(Map<String, File> propertyFiles, String parser) throws IllegalAttributeException, NoSuchElementException, IOException {
        StringBuffer buf = new StringBuffer();
        StringBuffer spatialIndex = new StringBuffer();
        buf.append("CREATE OR REPLACE PROCEDURE DROP_TABLE_OR_VIEW(TabName in Varchar2) IS ").append("temp number:=0;").append(" tes VARCHAR2 (200) := TabName;").append(" drp_stmt VARCHAR2 (200):=null;").append("BEGIN select count(*) into temp from user_tables where TABLE_NAME = tes;").append("if temp = 1 then drp_stmt := 'Drop Table '||tes;").append("EXECUTE IMMEDIATE drp_stmt;").append("else select count(*) into temp from user_views where VIEW_NAME = tes;").append("if temp = 1 then drp_stmt := 'Drop VIEW '||tes;").append("EXECUTE IMMEDIATE drp_stmt;end if;end if;").append("EXCEPTION WHEN OTHERS THEN ").append("raise_application_error(-20001,'An error was encountered - '||SQLCODE||' -ERROR- '||SQLERRM);").append("END DROP_TABLE_OR_VIEW;\n");
        for (String fileName : propertyFiles.keySet()) {
            File file = new File(propertyFiles.get(fileName), fileName);
            try (PropertyFeatureReader reader = new PropertyFeatureReader("test", file);){
                SimpleFeatureType schema = reader.getFeatureType();
                String tableName = schema.getName().getLocalPart().toUpperCase();
                buf.append("CALL DROP_TABLE_OR_VIEW('").append(tableName).append("')\n");
                buf.append("CREATE TABLE ").append(tableName).append("(");
                int size = schema.getAttributeCount() + 1;
                Object[] fieldNames = new String[size];
                ArrayList<CallSite> createParams = new ArrayList<CallSite>();
                int j = 0;
                int spatialIndexCounter = 0;
                for (PropertyDescriptor desc : schema.getDescriptors()) {
                    String type;
                    String field;
                    fieldNames[j] = field = desc.getName().toString().toUpperCase();
                    if (desc instanceof GeometryDescriptor) {
                        type = "SDO_GEOMETRY";
                        int srid = this.getSrid((GeometryType)desc.getType());
                        spatialIndex.append("DELETE FROM user_sdo_geom_metadata WHERE table_name = '").append(tableName).append("'\n");
                        spatialIndex.append("Insert into user_sdo_geom_metadata ").append("(TABLE_NAME,COLUMN_NAME,DIMINFO,SRID)").append("values ('").append(tableName).append("','").append(field).append("',MDSYS.SDO_DIM_ARRAY(MDSYS.SDO_DIM_ELEMENT('X',140.962,144.909,0.00001),").append("MDSYS.SDO_DIM_ELEMENT('Y',-38.858,-33.98,0.00001)").append(((GeometryDescriptor)desc).getCoordinateReferenceSystem() != null && ((GeometryDescriptor)desc).getCoordinateReferenceSystem().getCoordinateSystem().getDimension() == 3 ? ", MDSYS.SDO_DIM_ELEMENT('Z',-100000, 100000, 1) )," : "),").append(srid).append(")\n");
                        String indexName = (tableName.length() <= 26 ? tableName : tableName.substring(0, 26)) + "_IDX";
                        if (spatialIndexCounter > 0) {
                            indexName = indexName + spatialIndexCounter;
                        }
                        spatialIndex.append("CREATE INDEX \"").append(indexName).append("\" ON \"").append(tableName).append("\"(\"").append(field).append("\") ").append("INDEXTYPE IS \"MDSYS\".\"SPATIAL_INDEX\"\n");
                        ++spatialIndexCounter;
                    } else {
                        type = Classes.getShortName((Class)desc.getType().getBinding());
                        if (type.equalsIgnoreCase("String")) {
                            type = "NVARCHAR2(250)";
                        } else if (type.equalsIgnoreCase("Double")) {
                            type = "NUMBER";
                        }
                    }
                    createParams.add((CallSite)((Object)(field + " " + type)));
                    ++j;
                }
                String pkey = schema.getTypeName() + "_PKEY";
                fieldNames[j] = pkey;
                createParams.add((CallSite)((Object)(pkey + " VARCHAR2(30)")));
                buf.append(StringUtils.join(createParams.iterator(), (String)", "));
                buf.append(")\n");
                buf.append("ALTER TABLE " + tableName + " ADD CONSTRAINT " + tableName + " PRIMARY KEY (" + pkey + ")\n");
                while (reader.hasNext()) {
                    buf.append("INSERT INTO ").append(tableName).append("(");
                    SimpleFeature feature = reader.next();
                    buf.append(StringUtils.join((Object[])fieldNames, (String)", "));
                    buf.append(") ");
                    buf.append("VALUES (");
                    Collection properties = feature.getProperties();
                    Object[] values = new String[size];
                    int valueIndex = 0;
                    for (Property prop : properties) {
                        Object value = prop.getValue();
                        if (value instanceof Geometry) {
                            Geometry geom = (Geometry)value;
                            value = new WKTWriter(Double.isNaN(geom.getCoordinate().getZ()) ? 2 : 3).write(geom);
                        }
                        if (value == null || value.toString().equalsIgnoreCase("null")) {
                            values[valueIndex] = "null";
                        } else if (prop.getType() instanceof GeometryType) {
                            int srid = this.getSrid((GeometryType)prop.getType());
                            StringBuffer geomValue = new StringBuffer(parser + "('");
                            geomValue.append(value).append("'");
                            if (srid > -1) {
                                geomValue.append(", ").append(srid);
                            }
                            geomValue.append(")");
                            values[valueIndex] = geomValue.toString();
                        } else {
                            values[valueIndex] = prop.getType().getBinding().getSimpleName().equalsIgnoreCase("DATE") ? "TO_DATE('" + value + "', 'yyyy-MM-dd')" : "'" + value + "'";
                        }
                        ++valueIndex;
                    }
                    FeatureId id = feature.getIdentifier();
                    values[valueIndex] = "'" + id.toString() + "'";
                    buf.append(StringUtils.join((Object[])values, (String)","));
                    buf.append(")\n");
                }
            }
            buf.append(spatialIndex.toString());
            spatialIndex.delete(0, spatialIndex.length());
            if (buf.length() <= 0) continue;
            this.sql = buf.toString();
        }
    }

    @Override
    protected void runSqlInsertScript() throws Exception {
        this.run(this.sql, false);
    }
}

