/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test.onlineTest.setup;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.test.onlineTest.setup.ReferenceDataPostgisSetup;
import org.geotools.api.feature.IllegalAttributeException;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.GeometryType;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.data.property.PropertyFeatureReader;
import org.geotools.util.Classes;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTWriter;

public class AppSchemaTestPostgisSetup
extends ReferenceDataPostgisSetup {
    public static final String ONLINE_DB_SCHEMA = "appschematest";
    public static String DB_PARAMS = "<parameters>\n<Parameter>\n<name>dbtype</name>\n<value>postgis</value>\n</Parameter>\n<Parameter>\n<name>host</name>\n<value>${host}</value>\n</Parameter>\n<Parameter>\n<name>port</name>\n<value>${port}</value>\n</Parameter>\n<Parameter>\n<name>database</name>\n<value>${database}</value>\n</Parameter>\n<Parameter>\n<name>user</name>\n<value>${user}</value>\n</Parameter>\n<Parameter>\n<name>passwd</name>\n<value>${passwd}</value>\n</Parameter>\n<Parameter>\n<name>Expose primary keys</name><value>true</value>\n</Parameter>\n<Parameter>\n<name>schema</name>\n<value>appschematest</value>\n</Parameter>\n</parameters>";
    private String sql;

    public static AppSchemaTestPostgisSetup getInstance(Map<String, File> propertyFiles) throws Exception {
        return new AppSchemaTestPostgisSetup(propertyFiles, true);
    }

    public static AppSchemaTestPostgisSetup getInstance(Map<String, File> propertyFiles, boolean createPrimaryKey) throws Exception {
        return new AppSchemaTestPostgisSetup(propertyFiles, createPrimaryKey);
    }

    public AppSchemaTestPostgisSetup(Map<String, File> propertyFiles, boolean createPrimaryKey) throws Exception {
        this.configureFixture();
        this.createTables(propertyFiles, createPrimaryKey);
    }

    private void createTables(Map<String, File> propertyFiles, boolean createPrimaryKey) throws IllegalAttributeException, NoSuchElementException, IOException {
        StringBuffer buf = new StringBuffer();
        buf.append("DROP SCHEMA IF EXISTS ").append(ONLINE_DB_SCHEMA).append(" CASCADE;\n");
        buf.append("CREATE SCHEMA ").append(ONLINE_DB_SCHEMA).append(";\n");
        for (String fileName : propertyFiles.keySet()) {
            File file = new File(propertyFiles.get(fileName), fileName);
            try (PropertyFeatureReader reader = new PropertyFeatureReader("test", file);){
                Object desc2;
                SimpleFeatureType schema = reader.getFeatureType();
                String tableName = schema.getName().getLocalPart().toUpperCase();
                buf.append("CREATE TABLE ").append(ONLINE_DB_SCHEMA).append(".\"").append(tableName).append("\"(");
                ArrayList<GeometryDescriptor> geoms = new ArrayList<GeometryDescriptor>();
                int size = schema.getAttributeCount() + (createPrimaryKey ? 1 : 0);
                Object[] fieldNames = new String[size];
                ArrayList<CallSite> createParams = new ArrayList<CallSite>();
                int j = 0;
                for (Object desc2 : schema.getDescriptors()) {
                    if (desc2 instanceof GeometryDescriptor) {
                        geoms.add((GeometryDescriptor)desc2);
                    } else {
                        String field = "\"" + desc2.getName() + "\" ";
                        String type = Classes.getShortName((Class)desc2.getType().getBinding());
                        if (type.equalsIgnoreCase("String")) {
                            type = "TEXT";
                        } else if (type.equalsIgnoreCase("Double")) {
                            type = "DOUBLE PRECISION";
                        }
                        field = field + type;
                        createParams.add((CallSite)((Object)field));
                    }
                    fieldNames[j] = desc2.getName().toString();
                    ++j;
                }
                String pkFieldName = schema.getTypeName() + "_PKEY";
                if (createPrimaryKey) {
                    fieldNames[j] = pkFieldName;
                    createParams.add((CallSite)((Object)("\"" + pkFieldName + "\" TEXT")));
                }
                buf.append(StringUtils.join(createParams.iterator(), (String)", "));
                buf.append(");\n");
                if (createPrimaryKey) {
                    buf.append("ALTER TABLE appschematest.\"" + tableName + "\" ADD CONSTRAINT " + tableName + "_PK PRIMARY KEY (\"" + pkFieldName + "\")\n");
                }
                desc2 = geoms.iterator();
                while (desc2.hasNext()) {
                    GeometryDescriptor geom = (GeometryDescriptor)desc2.next();
                    buf.append("SELECT AddGeometryColumn ('").append(ONLINE_DB_SCHEMA).append("', ");
                    buf.append("'").append(tableName).append("', ");
                    buf.append("'").append(geom.getName().toString()).append("', ");
                    int srid = this.getSrid(geom.getType());
                    buf.append(srid).append(", ");
                    buf.append("'GEOMETRY'").append(", ");
                    buf.append(geom.getType().getCoordinateReferenceSystem() == null ? 2 : geom.getType().getCoordinateReferenceSystem().getCoordinateSystem().getDimension());
                    buf.append(");\n");
                }
                while (reader.hasNext()) {
                    buf.append("INSERT INTO ").append(ONLINE_DB_SCHEMA).append(".\"").append(tableName).append("\"(\"");
                    SimpleFeature feature = reader.next();
                    buf.append(StringUtils.join((Object[])fieldNames, (String)"\", \""));
                    buf.append("\") ");
                    buf.append("VALUES (");
                    Collection properties = feature.getProperties();
                    Object[] values = new String[size];
                    int valueIndex = 0;
                    for (Property prop : properties) {
                        int srid;
                        Object value = prop.getValue();
                        if (value instanceof Geometry) {
                            Geometry geom = (Geometry)value;
                            value = new WKTWriter(Double.isNaN(geom.getCoordinate().getZ()) ? 2 : 3).write(geom);
                        }
                        values[valueIndex] = value == null || value.toString().equalsIgnoreCase("null") ? "null" : (prop.getType() instanceof GeometryType ? ((srid = this.getSrid((GeometryType)prop.getType())) > -1 ? "ST_GeomFromText('" + value + "', " + srid + ")" : "ST_GeomFromText('" + value + "')") : "'" + value + "'");
                        ++valueIndex;
                    }
                    FeatureId id = feature.getIdentifier();
                    if (createPrimaryKey) {
                        values[valueIndex] = "'" + id.toString() + "'";
                    }
                    buf.append(StringUtils.join((Object[])values, (String)","));
                    buf.append(");\n");
                }
            }
            if (buf.length() <= 0) continue;
            this.sql = buf.toString();
        }
    }

    @Override
    protected void runSqlInsertScript() throws Exception {
        this.run(this.sql, false);
    }
}

