/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test.onlineTest.support;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.onlineTest.support.AbstractReferenceDataSetup;
import org.junit.Assume;

public abstract class AbstractDataReferenceWfsTest
extends AbstractAppSchemaTestSupport {
    protected AbstractReferenceDataSetup setup = this.getReferenceDataSetup();
    protected Properties fixture = null;
    protected boolean available = this.checkAvailable();
    public static final String SKIP_ON_FAILURE_KEY = "skip.on.failure";
    public static final String SKIP_ON_FAILURE_DEFAULT = "true";
    protected boolean skipOnFailure = true;
    protected static Map<String, Boolean> found = new HashMap<String, Boolean>();

    public AbstractDataReferenceWfsTest() throws Exception {
        Assume.assumeTrue((boolean)this.available);
        if (this.available) {
            this.initialiseTest();
        }
    }

    protected void setUpTestData(SystemTestData testData) throws Exception {
        this.setup.setUp();
        super.setUpTestData(testData);
    }

    public abstract AbstractReferenceDataSetup getReferenceDataSetup() throws Exception;

    public void connect() throws Exception {
        this.setup.initializeDatabase();
        this.setup.setUpData();
    }

    protected final void initialiseTest() throws Exception {
        this.skipOnFailure = Boolean.parseBoolean(this.fixture.getProperty(SKIP_ON_FAILURE_KEY, SKIP_ON_FAILURE_DEFAULT));
        try {
            this.connect();
        }
        catch (Exception e) {
            if (this.skipOnFailure) {
                this.fixture = null;
                LOGGER.log(Level.SEVERE, "", e);
            }
            throw e;
        }
    }

    protected boolean checkAvailable() throws Exception {
        this.setup.configureFixture();
        this.fixture = this.setup.getFixture();
        if (this.fixture == null) {
            return false;
        }
        String fixtureId = this.getFixtureId();
        this.setup.setFixture(this.fixture);
        Map<String, Boolean> online = this.setup.getOnlineMap();
        Boolean available = online.get(fixtureId);
        if (available == null || available.booleanValue()) {
            try {
                available = this.isOnline();
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Skipping " + fixtureId + " tests, resources not available.", t);
                available = Boolean.FALSE;
            }
            online.put(fixtureId, available);
        }
        return available;
    }

    private Boolean isOnline() {
        try {
            DataSource dataSource = this.setup.getDataSource();
            Connection cx = dataSource.getConnection();
            cx.close();
            return true;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected String getFixtureId() {
        return this.setup.getDatabaseID();
    }
}

