/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerEnvironment;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AuthenticationKeyFilterConfig;
import org.geoserver.security.AuthenticationKeyFilterConfigValidator;
import org.geoserver.security.FakeMapper;
import org.geoserver.security.GeoServerAuthenticationKeyFilter;
import org.geoserver.security.GeoServerAuthenticationKeyProvider;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.PropertyAuthenticationKeyMapper;
import org.geoserver.security.UserPropertyAuthenticationKeyMapper;
import org.geoserver.security.WebServiceAuthenticationKeyMapper;
import org.geoserver.security.WebServiceBodyResponseUserGroupService;
import org.geoserver.security.WebServiceBodyResponseUserGroupServiceConfig;
import org.geoserver.security.auth.AbstractAuthenticationProviderTest;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.SecurityUserGroupServiceConfig;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.validation.FilterConfigException;
import org.geoserver.security.xml.XMLUserGroupService;
import org.geoserver.test.http.AbstractHttpClient;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPResponse;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class AuthKeyAuthenticationTest
extends AbstractAuthenticationProviderTest {
    @BeforeClass
    public static void setupClass() {
        System.setProperty("ALLOW_ENV_PARAMETRIZATION", "true");
        GeoServerEnvironment.reloadAllowEnvParametrization();
    }

    @AfterClass
    public static void tearDownClass() {
        System.clearProperty("ALLOW_ENV_PARAMETRIZATION");
        GeoServerEnvironment.reloadAllowEnvParametrization();
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
    }

    @Test
    public void testMapperParameters() throws Exception {
        String authKeyUrlParam = "myAuthKeyParams";
        String filterName = "testAuthKeyParams1";
        AuthenticationKeyFilterConfig config = new AuthenticationKeyFilterConfig();
        config.setClassName(GeoServerAuthenticationKeyFilter.class.getName());
        config.setName(filterName);
        config.setUserGroupServiceName("ug1");
        config.setAuthKeyParamName(authKeyUrlParam);
        config.setAuthKeyMapperName("fakeMapper");
        HashMap<String, String> mapperParams = new HashMap<String, String>();
        mapperParams.put("param1", "value1");
        mapperParams.put("param2", "value2");
        config.setMapperParameters(mapperParams);
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        GeoServerAuthenticationKeyFilter filter = (GeoServerAuthenticationKeyFilter)this.getSecurityManager().loadFilter(filterName);
        Assert.assertTrue((boolean)(filter.getMapper() instanceof FakeMapper));
        FakeMapper fakeMapper = (FakeMapper)filter.getMapper();
        Assert.assertEquals((Object)"value1", (Object)fakeMapper.getMapperParameter("param1"));
        Assert.assertEquals((Object)"value2", (Object)fakeMapper.getMapperParameter("param2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMapperParametersFromEnv() throws Exception {
        String authKeyUrlParam = "myAuthKeyParams";
        String filterName = "testAuthKeyParams2";
        AuthenticationKeyFilterConfig config = new AuthenticationKeyFilterConfig();
        config.setClassName(GeoServerAuthenticationKeyFilter.class.getName());
        config.setName(filterName);
        config.setUserGroupServiceName("ug1");
        config.setAuthKeyParamName(authKeyUrlParam);
        config.setAuthKeyMapperName("fakeMapper");
        System.setProperty("authkey_param1", "value1");
        System.setProperty("authkey_param2", "value2");
        try {
            HashMap<String, String> mapperParams = new HashMap<String, String>();
            mapperParams.put("param1", "${authkey_param1}");
            mapperParams.put("param2", "${authkey_param2}");
            config.setMapperParameters(mapperParams);
            this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
            GeoServerAuthenticationKeyFilter filter = (GeoServerAuthenticationKeyFilter)this.getSecurityManager().loadFilter(filterName);
            Assert.assertTrue((boolean)(filter.getMapper() instanceof FakeMapper));
            FakeMapper fakeMapper = (FakeMapper)filter.getMapper();
            Assert.assertEquals((Object)"value1", (Object)fakeMapper.getMapperParameter("param1"));
            Assert.assertEquals((Object)"value2", (Object)fakeMapper.getMapperParameter("param2"));
        }
        finally {
            System.clearProperty("authkey_param1");
            System.clearProperty("authkey_param2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMapperParametersFromEnvWhenDisabled() throws Exception {
        String authKeyUrlParam = "myAuthKeyParams";
        String filterName = "testAuthKeyParams3";
        AuthenticationKeyFilterConfig config = new AuthenticationKeyFilterConfig();
        config.setClassName(GeoServerAuthenticationKeyFilter.class.getName());
        config.setName(filterName);
        config.setUserGroupServiceName("ug1");
        config.setAuthKeyParamName(authKeyUrlParam);
        config.setAuthKeyMapperName("fakeMapper");
        System.setProperty("authkey_param1", "value1");
        System.setProperty("authkey_param2", "value2");
        System.setProperty("ALLOW_ENV_PARAMETRIZATION", "false");
        GeoServerEnvironment.reloadAllowEnvParametrization();
        try {
            HashMap<String, String> mapperParams = new HashMap<String, String>();
            mapperParams.put("param1", "${authkey_param1}");
            mapperParams.put("param2", "${authkey_param2}");
            config.setMapperParameters(mapperParams);
            this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
            GeoServerAuthenticationKeyFilter filter = (GeoServerAuthenticationKeyFilter)this.getSecurityManager().loadFilter(filterName);
            Assert.assertTrue((boolean)(filter.getMapper() instanceof FakeMapper));
            FakeMapper fakeMapper = (FakeMapper)filter.getMapper();
            Assert.assertEquals((Object)"${authkey_param1}", (Object)fakeMapper.getMapperParameter("param1"));
            Assert.assertEquals((Object)"${authkey_param2}", (Object)fakeMapper.getMapperParameter("param2"));
        }
        finally {
            System.clearProperty("authkey_param1");
            System.clearProperty("authkey_param2");
            System.setProperty("ALLOW_ENV_PARAMETRIZATION", "true");
            GeoServerEnvironment.reloadAllowEnvParametrization();
        }
    }

    @Test
    public void testMapperParamsFilterConfigValidation() throws Exception {
        AuthenticationKeyFilterConfigValidator validator = new AuthenticationKeyFilterConfigValidator(this.getSecurityManager());
        AuthenticationKeyFilterConfig config = new AuthenticationKeyFilterConfig();
        config.setClassName(GeoServerAuthenticationKeyFilter.class.getName());
        config.setName("fakeFilter");
        config.setUserGroupServiceName(XMLUserGroupService.DEFAULT_NAME);
        config.setAuthKeyParamName("authkey");
        config.setAuthKeyMapperName("fakeMapper");
        HashMap<String, String> mapperParams = new HashMap<String, String>();
        mapperParams.put("param1", "value1");
        mapperParams.put("param2", "value2");
        config.setMapperParameters(mapperParams);
        boolean failed = false;
        try {
            validator.validateFilterConfig(config);
        }
        catch (FilterConfigException ex) {
            failed = true;
        }
        Assert.assertFalse((boolean)failed);
        mapperParams.put("param3", "value3");
        try {
            validator.validateFilterConfig(config);
        }
        catch (FilterConfigException ex) {
            Assert.assertEquals((Object)"INVALID_AUTH_KEY_MAPPER_PARAMETER", (Object)ex.getId());
            Assert.assertEquals((long)1L, (long)ex.getArgs().length);
            Assert.assertEquals((Object)"param3", (Object)ex.getArgs()[0]);
            LOGGER.info(ex.getMessage());
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
    }

    @Test
    public void testFileBasedWithSessionEnabled() throws Exception {
        String authKeyUrlParam = "myAuthKey";
        String filterName = "testAuthKeyFilter1Enabled";
        AuthenticationKeyFilterConfig config = new AuthenticationKeyFilterConfig();
        config.setClassName(GeoServerAuthenticationKeyFilter.class.getName());
        config.setName(filterName);
        config.setUserGroupServiceName("ug1");
        config.setAuthKeyParamName(authKeyUrlParam);
        config.setAuthKeyMapperName("propertyMapper");
        HashMap<String, String> mapperParams = new HashMap<String, String>();
        mapperParams.put("cacheTtlSeconds", "0");
        config.setMapperParameters(mapperParams);
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        GeoServerAuthenticationKeyFilter filter = (GeoServerAuthenticationKeyFilter)this.getSecurityManager().loadFilter(filterName);
        PropertyAuthenticationKeyMapper mapper = (PropertyAuthenticationKeyMapper)filter.getMapper();
        mapper.synchronize();
        this.prepareFilterChain(this.pattern, new String[]{filterName});
        this.modifyChain(this.pattern, false, true, null);
        SecurityContextHolder.getContext().setAuthentication(null);
        this.getSecurityManager().getAuthenticationCache().removeAll();
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        mapper.synchronize();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)403L, (long)response.getStatus());
        String authKey = null;
        for (Map.Entry<Object, Object> entry : mapper.authKeyProps.entrySet()) {
            if (!"user1".equals(entry.getValue())) continue;
            authKey = (String)entry.getKey();
            break;
        }
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.setQueryString(authKeyUrlParam + "=" + authKey);
        request.addParameter(authKeyUrlParam, authKey);
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertNotEquals((long)response.getStatus(), (long)302L);
        SecurityContext ctx = (SecurityContext)request.getSession(false).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNotNull((Object)ctx);
        Authentication auth = ctx.getAuthentication();
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.checkForAuthenticatedRole(auth);
        Assert.assertEquals((Object)"user1", (Object)auth.getPrincipal());
        this.password = this.username = "unknown";
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.setQueryString(authKeyUrlParam + "=abc");
        request.addParameter(authKeyUrlParam, "abc");
        mapper.synchronize();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)403L, (long)response.getStatus());
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    @Test
    public void testFileBasedWithSessionDisabled() throws Exception {
        String authKeyUrlParam = "myAuthKey";
        String filterName = "testAuthKeyFilter1Disabled";
        AuthenticationKeyFilterConfig config = new AuthenticationKeyFilterConfig();
        config.setClassName(GeoServerAuthenticationKeyFilter.class.getName());
        config.setName(filterName);
        config.setUserGroupServiceName("ug1");
        config.setAuthKeyParamName(authKeyUrlParam);
        config.setAuthKeyMapperName("propertyMapper");
        HashMap<String, String> mapperParams = new HashMap<String, String>();
        mapperParams.put("cacheTtlSeconds", "0");
        config.setMapperParameters(mapperParams);
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        GeoServerAuthenticationKeyFilter filter = (GeoServerAuthenticationKeyFilter)this.getSecurityManager().loadFilter(filterName);
        PropertyAuthenticationKeyMapper mapper = (PropertyAuthenticationKeyMapper)filter.getMapper();
        mapper.synchronize();
        this.prepareFilterChain(this.pattern, new String[]{filterName});
        this.modifyChain(this.pattern, false, true, null);
        SecurityContextHolder.getContext().setAuthentication(null);
        this.getSecurityManager().getAuthenticationCache().removeAll();
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        mapper.synchronize();
        String authKey = null;
        for (Map.Entry<Object, Object> entry : mapper.authKeyProps.entrySet()) {
            if (!"user1".equals(entry.getValue())) continue;
            authKey = (String)entry.getKey();
            break;
        }
        this.password = this.username = "user1";
        this.updateUser("ug1", this.username, false);
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.setQueryString(authKeyUrlParam + "=" + authKey);
        request.addParameter(authKeyUrlParam, authKey);
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)403L, (long)response.getStatus());
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.updateUser("ug1", this.username, true);
        mapper.synchronize();
        SecurityContextHolder.clearContext();
        this.getSecurityManager().getAuthenticationCache().removeAll();
        this.insertAnonymousFilter();
        request = this.createRequest("foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.removeAnonymousFilter();
    }

    @Test
    public void testUserPropertyWithCacheEnabled() throws Exception {
        String authKeyUrlParam = "myAuthKey";
        String filterName = "testAuthKeyFilter2Enabled";
        AuthenticationKeyFilterConfig config = new AuthenticationKeyFilterConfig();
        config.setClassName(GeoServerAuthenticationKeyFilter.class.getName());
        config.setName(filterName);
        config.setUserGroupServiceName("ug1");
        config.setAuthKeyParamName(authKeyUrlParam);
        config.setAuthKeyMapperName("userPropertyMapper");
        HashMap<String, String> mapperParams = new HashMap<String, String>();
        mapperParams.put("cacheTtlSeconds", "0");
        config.setMapperParameters(mapperParams);
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        GeoServerAuthenticationKeyFilter filter = (GeoServerAuthenticationKeyFilter)this.getSecurityManager().loadFilter(filterName);
        UserPropertyAuthenticationKeyMapper mapper = (UserPropertyAuthenticationKeyMapper)filter.getMapper();
        mapper.synchronize();
        this.prepareFilterChain(this.pattern, new String[]{filterName});
        this.modifyChain(this.pattern, false, false, null);
        SecurityContextHolder.getContext().setAuthentication(null);
        this.getSecurityManager().getAuthenticationCache().removeAll();
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)403L, (long)response.getStatus());
        GeoServerUser user = (GeoServerUser)this.getSecurityManager().loadUserGroupService("ug1").loadUserByUsername("user1");
        mapper.synchronize();
        mapper.resetUserCache();
        String authKey = user.getProperties().getProperty(mapper.getUserPropertyName());
        Assert.assertNotNull((Object)authKey);
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.setQueryString(authKeyUrlParam + "=" + authKey);
        request.addParameter(authKeyUrlParam, authKey);
        mapper.synchronize();
        SecurityContextHolder.clearContext();
        this.getSecurityManager().getAuthenticationCache().removeAll();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertNotEquals((long)302L, (long)response.getStatus());
        Assert.assertNull((Object)request.getSession(false));
        this.password = this.username = "unknown";
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.setQueryString(authKeyUrlParam + "=abc");
        request.addParameter(authKeyUrlParam, "abc");
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)403L, (long)response.getStatus());
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    @Test
    public void testUserPropertyWithCacheDisabled() throws Exception {
        String authKeyUrlParam = "myAuthKey";
        String filterName = "testAuthKeyFilter2Disabled";
        AuthenticationKeyFilterConfig config = new AuthenticationKeyFilterConfig();
        config.setClassName(GeoServerAuthenticationKeyFilter.class.getName());
        config.setName(filterName);
        config.setUserGroupServiceName("ug1");
        config.setAuthKeyParamName(authKeyUrlParam);
        config.setAuthKeyMapperName("userPropertyMapper");
        HashMap<String, String> mapperParams = new HashMap<String, String>();
        mapperParams.put("cacheTtlSeconds", "0");
        config.setMapperParameters(mapperParams);
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        GeoServerAuthenticationKeyFilter filter = (GeoServerAuthenticationKeyFilter)this.getSecurityManager().loadFilter(filterName);
        UserPropertyAuthenticationKeyMapper mapper = (UserPropertyAuthenticationKeyMapper)filter.getMapper();
        mapper.synchronize();
        this.prepareFilterChain(this.pattern, new String[]{filterName});
        this.modifyChain(this.pattern, false, false, null);
        SecurityContextHolder.getContext().setAuthentication(null);
        this.getSecurityManager().getAuthenticationCache().removeAll();
        this.password = this.username = "user1";
        this.updateUser("ug1", this.username, false);
        mapper.synchronize();
        mapper.resetUserCache();
        GeoServerUser user = (GeoServerUser)this.getSecurityManager().loadUserGroupService("ug1").loadUserByUsername("user1");
        String authKey = user.getProperties().getProperty(mapper.getUserPropertyName());
        Assert.assertNotNull((Object)authKey);
        SecurityContextHolder.clearContext();
        this.getSecurityManager().getAuthenticationCache().removeAll();
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        request.setQueryString(authKeyUrlParam + "=" + authKey);
        request.addParameter(authKeyUrlParam, authKey);
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)403L, (long)response.getStatus());
        Assert.assertNull((Object)this.getSecurityManager().getAuthenticationCache().get(filterName, authKey));
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.updateUser("ug1", this.username, true);
        this.insertAnonymousFilter();
        request = this.createRequest("foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.removeAnonymousFilter();
    }

    @Test
    public void testWebServiceAuthKeyMapper() throws Exception {
        GeoServerUserGroupService ugservice = this.createUserGroupService("testWebServiceAuthKey");
        GeoServerUserGroupStore ugstore = ugservice.createStore();
        GeoServerUser u1 = ugstore.createUserObject("user1", "passwd1", true);
        ugstore.addUser(u1);
        GeoServerUser u2 = ugstore.createUserObject("user2", "passwd2", true);
        ugstore.addUser(u2);
        ugstore.store();
        WebServiceAuthenticationKeyMapper propMapper = (WebServiceAuthenticationKeyMapper)GeoServerExtensions.extensions(WebServiceAuthenticationKeyMapper.class).iterator().next();
        propMapper.setUserGroupServiceName("testWebServiceAuthKey");
        propMapper.setSecurityManager(this.getSecurityManager());
        propMapper.setWebServiceUrl("http://service/{key}");
        propMapper.setHttpClient((HTTPClient)new TestHttpClient("testkey", "user1"));
        GeoServerUser user = propMapper.getUser("testkey");
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)user.getUsername(), (Object)"user1");
        boolean error = false;
        try {
            user = propMapper.getUser("wrongkey");
        }
        catch (UsernameNotFoundException e) {
            error = true;
        }
        Assert.assertTrue((boolean)error);
    }

    @Test
    public void testWebServiceAuthKeyMapperSearchUser() throws Exception {
        GeoServerUserGroupService ugservice = this.createUserGroupService("testWebServiceAuthKey2");
        GeoServerUserGroupStore ugstore = ugservice.createStore();
        GeoServerUser u1 = ugstore.createUserObject("user1", "passwd1", true);
        ugstore.addUser(u1);
        GeoServerUser u2 = ugstore.createUserObject("user2", "passwd2", true);
        ugstore.addUser(u2);
        ugstore.store();
        WebServiceAuthenticationKeyMapper propMapper = (WebServiceAuthenticationKeyMapper)GeoServerExtensions.extensions(WebServiceAuthenticationKeyMapper.class).iterator().next();
        propMapper.setUserGroupServiceName("testWebServiceAuthKey2");
        propMapper.setSecurityManager(this.getSecurityManager());
        propMapper.setWebServiceUrl("http://service/{key}");
        propMapper.setSearchUser("^.*?\"user\"\\s*:\\s*\"([^\"]+)\".*$");
        propMapper.setHttpClient((HTTPClient)new TestHttpClient("testkey", "{\n    \"user\": \"user1\", \"detail\": \"mydetail\"\n   }"));
        GeoServerUser user = propMapper.getUser("testkey");
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)user.getUsername(), (Object)"user1");
        propMapper.setSearchUser("^.*?<username>(.*?)</username>.*$");
        propMapper.setHttpClient((HTTPClient)new TestHttpClient("testkey", "<root>\n<userdetail>\n<username>user1</username>\n</userdetail>\n</root>"));
        user = propMapper.getUser("testkey");
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)user.getUsername(), (Object)"user1");
        user = propMapper.getUser("wrongkey");
        Assert.assertNull((Object)user);
    }

    @Test
    public void testWebServiceAuthKeyBodyResponseUGS() throws Exception {
        WebServiceBodyResponseUserGroupServiceConfig config = new WebServiceBodyResponseUserGroupServiceConfig();
        config.setName("testWebServiceAuthKey3");
        config.setClassName(WebServiceBodyResponseUserGroupService.class.getName());
        config.setPasswordEncoderName(this.getPBEPasswordEncoder().getName());
        config.setPasswordPolicyName("default");
        config.setSearchRoles("^.*?\"roles\"\\s*:\\s*\"([^\"]+)\".*$");
        config.setAvailableGroups("GROUP_MYROLE_1, GROUP_MYROLE_2");
        this.getSecurityManager().saveUserGroupService((SecurityUserGroupServiceConfig)config);
        GeoServerUserGroupService webServiceAuthKeyBodyResponseUGS = this.getSecurityManager().loadUserGroupService("testWebServiceAuthKey3");
        Assert.assertNotNull((Object)webServiceAuthKeyBodyResponseUGS);
        WebServiceAuthenticationKeyMapper propMapper = (WebServiceAuthenticationKeyMapper)GeoServerExtensions.extensions(WebServiceAuthenticationKeyMapper.class).iterator().next();
        propMapper.setUserGroupServiceName("testWebServiceAuthKey3");
        propMapper.setSecurityManager(this.getSecurityManager());
        propMapper.setWebServiceUrl("http://service/{key}");
        propMapper.setSearchUser("^.*?\"user\"\\s*:\\s*\"([^\"]+)\".*$");
        propMapper.setHttpClient((HTTPClient)new TestHttpClient("testkey", "{\n    \"user\": \"user1\", \"detail\": \"mydetail\", \"roles\": \"myrole_1, myrole_2\"\n   }"));
        GeoServerUser user = propMapper.getUser("testkey");
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)user.getUsername(), (Object)"user1");
        Assert.assertNotNull((Object)user.getAuthorities());
        Assert.assertEquals((long)2L, (long)user.getAuthorities().size());
        Assert.assertTrue((boolean)user.getAuthorities().contains(new GeoServerRole("ROLE_MYROLE_1")));
        Assert.assertTrue((boolean)user.getAuthorities().contains(new GeoServerRole("ROLE_MYROLE_2")));
        Assert.assertEquals((long)2L, (long)webServiceAuthKeyBodyResponseUGS.getGroupCount());
        Assert.assertEquals((long)2L, (long)webServiceAuthKeyBodyResponseUGS.getUserGroups().size());
        Assert.assertEquals((Object)webServiceAuthKeyBodyResponseUGS.getUserGroups(), (Object)webServiceAuthKeyBodyResponseUGS.getGroupsForUser(user));
    }

    @Test
    public void testAuthKeyMapperSynchronize() throws Exception {
        GeoServerUserGroupService ugservice = this.createUserGroupService("testAuthKey");
        GeoServerUserGroupStore ugstore = ugservice.createStore();
        GeoServerUser u1 = ugstore.createUserObject("user1", "passwd1", true);
        ugstore.addUser(u1);
        GeoServerUser u2 = ugstore.createUserObject("user2", "passwd2", true);
        ugstore.addUser(u2);
        ugstore.store();
        PropertyAuthenticationKeyMapper propMapper = (PropertyAuthenticationKeyMapper)GeoServerExtensions.extensions(PropertyAuthenticationKeyMapper.class).iterator().next();
        UserPropertyAuthenticationKeyMapper userpropMapper = (UserPropertyAuthenticationKeyMapper)GeoServerExtensions.extensions(UserPropertyAuthenticationKeyMapper.class).iterator().next();
        propMapper.setSecurityManager(this.getSecurityManager());
        propMapper.setUserGroupServiceName("testAuthKey");
        userpropMapper.setSecurityManager(this.getSecurityManager());
        userpropMapper.setUserGroupServiceName("testAuthKey");
        Assert.assertEquals((long)2L, (long)propMapper.synchronize());
        File authKeyFile = new File(this.getSecurityManager().userGroup().dir(), "testAuthKey");
        authKeyFile = new File(authKeyFile, "authkeys.properties");
        Assert.assertTrue((boolean)authKeyFile.exists());
        Properties props = new Properties();
        this.loadPropFile(authKeyFile, props);
        Assert.assertEquals((long)2L, (long)props.size());
        String user1KeyA = null;
        String user2KeyA = null;
        String user3KeyA = null;
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            if ("user1".equals(entry.getValue())) {
                user1KeyA = (String)entry.getKey();
            }
            if (!"user2".equals(entry.getValue())) continue;
            user2KeyA = (String)entry.getKey();
        }
        Assert.assertNotNull(user1KeyA);
        Assert.assertNotNull(user2KeyA);
        Assert.assertEquals((Object)u1, (Object)propMapper.getUser(user1KeyA));
        Assert.assertEquals((Object)u2, (Object)propMapper.getUser(user2KeyA));
        Assert.assertNull((Object)propMapper.getUser("blblal"));
        Assert.assertEquals((long)2L, (long)userpropMapper.synchronize());
        u1 = (GeoServerUser)ugservice.loadUserByUsername("user1");
        String user1KeyB = u1.getProperties().getProperty(userpropMapper.getUserPropertyName());
        u2 = (GeoServerUser)ugservice.loadUserByUsername("user2");
        String user2KeyB = u2.getProperties().getProperty(userpropMapper.getUserPropertyName());
        Assert.assertEquals((Object)u1, (Object)userpropMapper.getUser(user1KeyB));
        Assert.assertEquals((Object)u2, (Object)userpropMapper.getUser(user2KeyB));
        Assert.assertNull((Object)userpropMapper.getUser("blblal"));
        ugstore = ugservice.createStore();
        GeoServerUser u3 = ugstore.createUserObject("user3", "passwd3", true);
        ugstore.addUser(u3);
        ugstore.removeUser(u1);
        ugstore.store();
        Assert.assertEquals((long)1L, (long)propMapper.synchronize());
        props = new Properties();
        this.loadPropFile(authKeyFile, props);
        Assert.assertEquals((long)2L, (long)props.size());
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            if ("user2".equals(entry.getValue())) {
                Assert.assertEquals((Object)user2KeyA, (Object)entry.getKey());
            }
            if (!"user3".equals(entry.getValue())) continue;
            user3KeyA = (String)entry.getKey();
        }
        Assert.assertNotNull(user3KeyA);
        Assert.assertNull((Object)propMapper.getUser(user1KeyA));
        Assert.assertEquals((Object)u2, (Object)propMapper.getUser(user2KeyA));
        Assert.assertEquals((Object)u3, (Object)propMapper.getUser(user3KeyA));
        Assert.assertEquals((long)1L, (long)userpropMapper.synchronize());
        u2 = (GeoServerUser)ugservice.loadUserByUsername("user2");
        Assert.assertEquals((Object)user2KeyB, (Object)u2.getProperties().getProperty(userpropMapper.getUserPropertyName()));
        u3 = (GeoServerUser)ugservice.loadUserByUsername("user3");
        String user3KeyB = u3.getProperties().getProperty(userpropMapper.getUserPropertyName());
        Assert.assertNull((Object)userpropMapper.getUser(user1KeyB));
        Assert.assertEquals((Object)u2, (Object)userpropMapper.getUser(user2KeyB));
        Assert.assertEquals((Object)u3, (Object)userpropMapper.getUser(user3KeyB));
        ugstore = ugservice.createStore();
        u2 = (GeoServerUser)ugstore.loadUserByUsername("user2");
        u2.setEnabled(false);
        ugstore.updateUser(u2);
        ugstore.store();
        propMapper.resetUserCache();
        userpropMapper.resetUserCache();
        Assert.assertNull((Object)propMapper.getUser(user2KeyA));
        Assert.assertNull((Object)userpropMapper.getUser(user2KeyB));
    }

    @Test
    public void testAuthKeyMapperAutoSynchronize() throws Exception {
        String authKeyUrlParam = "myAuthKey";
        String filterName = "testAuthKeyFilterAuto1";
        AuthenticationKeyFilterConfig config = new AuthenticationKeyFilterConfig();
        config.setClassName(GeoServerAuthenticationKeyFilter.class.getName());
        config.setName(filterName);
        config.setAllowMapperKeysAutoSync(true);
        config.setUserGroupServiceName("ug1");
        config.setAuthKeyParamName(authKeyUrlParam);
        config.setAuthKeyMapperName("propertyMapper");
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        File authKeyFile = new File(this.getSecurityManager().userGroup().dir(), "testAuthKey");
        authKeyFile = new File(authKeyFile, "authkeys.properties");
        GeoServerAuthenticationKeyProvider geoServerAuthenticationKeyProvider = new GeoServerAuthenticationKeyProvider(this.getSecurityManager(), 2);
        Assert.assertNotNull((Object)geoServerAuthenticationKeyProvider.getScheduler());
        Assert.assertFalse((boolean)geoServerAuthenticationKeyProvider.getScheduler().isTerminated());
        Assert.assertFalse((boolean)geoServerAuthenticationKeyProvider.getScheduler().isShutdown());
        Assert.assertEquals((long)2L, (long)geoServerAuthenticationKeyProvider.getAutoSyncDelaySeconds());
        Properties props = new Properties();
        for (int i = 0; i < 400 && props.isEmpty(); ++i) {
            try {
                Thread.sleep(25L);
                this.loadPropFile(authKeyFile, props);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assert.assertTrue((boolean)authKeyFile.exists());
        Assert.assertFalse((boolean)props.isEmpty());
    }

    @Test
    public void testWebServiceAuthKeyBodyResponseNoRoleMatchingRegex() throws Exception {
        WebServiceBodyResponseUserGroupServiceConfig config = new WebServiceBodyResponseUserGroupServiceConfig();
        config.setName("testWebServiceAuthKey4");
        config.setClassName(WebServiceBodyResponseUserGroupService.class.getName());
        config.setPasswordEncoderName(this.getPBEPasswordEncoder().getName());
        config.setPasswordPolicyName("default");
        config.setSearchRoles("wrong_regex");
        config.setAvailableGroups("GROUP_MYROLE_1, GROUP_MYROLE_2");
        this.getSecurityManager().saveUserGroupService((SecurityUserGroupServiceConfig)config);
        GeoServerUserGroupService webServiceAuthKeyBodyResponseUGS = this.getSecurityManager().loadUserGroupService("testWebServiceAuthKey4");
        Assert.assertNotNull((Object)webServiceAuthKeyBodyResponseUGS);
        WebServiceAuthenticationKeyMapper propMapper = (WebServiceAuthenticationKeyMapper)GeoServerExtensions.extensions(WebServiceAuthenticationKeyMapper.class).iterator().next();
        propMapper.setUserGroupServiceName("testWebServiceAuthKey4");
        propMapper.setSecurityManager(this.getSecurityManager());
        propMapper.setWebServiceUrl("http://service/{key}");
        propMapper.setSearchUser("^.*?\"user\"\\s*:\\s*\"([^\"]+)\".*$");
        propMapper.setHttpClient((HTTPClient)new TestHttpClient("testkey", "{\n    \"user\": \"user1\", \"detail\": \"mydetail\", \"roles\": \"myrole_1, myrole_2\"\n   }"));
        GeoServerUser user = propMapper.getUser("testkey");
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)user.getUsername(), (Object)"user1");
        Assert.assertNotNull((Object)user.getAuthorities());
        Assert.assertEquals((long)1L, (long)user.getAuthorities().size());
        Assert.assertTrue((boolean)user.getAuthorities().contains(new GeoServerRole("ROLE_ANONYMOUS")));
    }

    @Test
    public void testAllowChallengeAnonymousSessionsBehavior() throws Exception {
        String authKeyUrlParam = "myAuthKey";
        String filterName = "testAllowChallengeAnonymousSessionsBehavior";
        AuthenticationKeyFilterConfig config = new AuthenticationKeyFilterConfig();
        config.setClassName(GeoServerAuthenticationKeyFilter.class.getName());
        config.setName(filterName);
        config.setUserGroupServiceName("ug1");
        config.setAuthKeyParamName(authKeyUrlParam);
        config.setAuthKeyMapperName("userPropertyMapper");
        config.setAllowChallengeAnonymousSessions(true);
        HashMap<String, String> mapperParams = new HashMap<String, String>();
        mapperParams.put("cacheTtlSeconds", "0");
        config.setMapperParameters(mapperParams);
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        GeoServerAuthenticationKeyFilter filter = (GeoServerAuthenticationKeyFilter)this.getSecurityManager().loadFilter(filterName);
        UserPropertyAuthenticationKeyMapper mapper = (UserPropertyAuthenticationKeyMapper)filter.getMapper();
        mapper.synchronize();
        this.prepareFilterChain(this.pattern, new String[]{filterName});
        this.modifyChain(this.pattern, false, false, null);
        GeoServerUser user = (GeoServerUser)this.getSecurityManager().loadUserGroupService("ug1").loadUserByUsername("user1");
        mapper.resetUserCache();
        String authKey = user.getProperties().getProperty(mapper.getUserPropertyName());
        Assert.assertNotNull((Object)authKey);
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        request.setQueryString(authKeyUrlParam + "=" + authKey);
        request.addParameter(authKeyUrlParam, authKey);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        List<SimpleGrantedAuthority> authorities = List.of(new SimpleGrantedAuthority("ROLE_ANONYMOUS"));
        SecurityContextHolder.getContext().setAuthentication((Authentication)new AnonymousAuthenticationToken("test", (Object)"anonymous", authorities));
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Authentication resultAuth = this.getSecurityManager().getAuthenticationCache().get(filterName, authKey);
        Authentication authentication = resultAuth = resultAuth != null ? resultAuth : SecurityContextHolder.getContext().getAuthentication();
        if (resultAuth != null) {
            Assert.assertEquals((Object)"user1", (Object)resultAuth.getPrincipal());
            config.setAllowChallengeAnonymousSessions(false);
            this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
            filter = (GeoServerAuthenticationKeyFilter)this.getSecurityManager().loadFilter(filterName);
            request = this.createRequest("/foo/bar");
            request.setQueryString(authKeyUrlParam + "=" + authKey);
            request.addParameter(authKeyUrlParam, authKey);
            response = new MockHttpServletResponse();
            chain = new MockFilterChain();
            this.getSecurityManager().getAuthenticationCache().removeAll();
            SecurityContextHolder.getContext().setAuthentication((Authentication)new AnonymousAuthenticationToken("test", (Object)"validUser", authorities));
            this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
            resultAuth = this.getSecurityManager().getAuthenticationCache().get(filterName, authKey);
            resultAuth = resultAuth != null ? resultAuth : SecurityContextHolder.getContext().getAuthentication();
            Assert.assertNotNull((Object)resultAuth);
            Assert.assertEquals((Object)"user1", (Object)resultAuth.getPrincipal());
        }
    }

    private void loadPropFile(File authKeyFile, Properties props) throws FileNotFoundException, IOException {
        try (FileInputStream propFile = new FileInputStream(authKeyFile);){
            props.load(propFile);
        }
    }

    protected GeoServerSecurityManager getSecurityManager() {
        return this.getProxy().securityManager;
    }

    class TestHttpClient
    extends AbstractHttpClient {
        private String authkey;
        private String response;

        public TestHttpClient(String authkey, String response) {
            this.authkey = authkey;
            this.response = response;
        }

        public HTTPResponse get(final URL url) throws IOException {
            return new HTTPResponse(){

                public InputStream getResponseStream() throws IOException {
                    if (url.getPath().substring(1).equals(TestHttpClient.this.authkey)) {
                        return new ByteArrayInputStream(TestHttpClient.this.response.getBytes());
                    }
                    return new ByteArrayInputStream("".getBytes());
                }

                public String getResponseHeader(String arg0) {
                    return null;
                }

                public String getResponseCharset() {
                    return null;
                }

                public String getContentType() {
                    return null;
                }

                public void dispose() {
                }
            };
        }

        public HTTPResponse post(URL url, InputStream in, String arg) throws IOException {
            return null;
        }
    }
}

